<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetStoreCustomPageRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Creates or updates a custom page on a user's eBay Store.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class SetStoreCustomPageRequestType extends AbstractRequestType
{
    /**
     * The CustomPage
     * Meta informations extracted from the WSDL
     * - documentation: The custom page being submitted.
     * - minOccurs: 0
     * @var \ebay\StructType\StoreCustomPageType
     */
    public $CustomPage;
    /**
     * Constructor method for SetStoreCustomPageRequestType
     * @uses SetStoreCustomPageRequestType::setCustomPage()
     * @param \ebay\StructType\StoreCustomPageType $customPage
     */
    public function __construct(\ebay\StructType\StoreCustomPageType $customPage = null)
    {
        $this
            ->setCustomPage($customPage);
    }
    /**
     * Get CustomPage value
     * @return \ebay\StructType\StoreCustomPageType|null
     */
    public function getCustomPage()
    {
        return $this->CustomPage;
    }
    /**
     * Set CustomPage value
     * @param \ebay\StructType\StoreCustomPageType $customPage
     * @return \ebay\StructType\SetStoreCustomPageRequestType
     */
    public function setCustomPage(\ebay\StructType\StoreCustomPageType $customPage = null)
    {
        $this->CustomPage = $customPage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\SetStoreCustomPageRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
