<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetShippingDiscountProfilesRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Enables a seller to define shipping cost discount profiles for things such as combined payments for shipping and handling costs.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class SetShippingDiscountProfilesRequestType extends AbstractRequestType
{
    /**
     * The CurrencyID
     * Meta informations extracted from the WSDL
     * - documentation: The three-digit code of the currency to be used for shipping cost discounts and insurance for Combined Invoice orders. A discount profile can only be associated with a listing if the <b>CurrencyID</b> value of the profile matches the
     * <b>Item.Currency</b> value specified in a listing. <br><br> Required if the user creates flat rate shipping discount profiles, a promotional discount, a packaging/handling cost profile based on a variable discount rule, or if the user defines
     * shipping insurance range/fee pairs. <br><br> Note: There is a currencyID attribute on many elements of SetShippingDiscountProfiles. To avoid an error, be sure to use the same <b>CurrencyID</b> value in each occurrence within the same request.
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyID;
    /**
     * The CombinedDuration
     * Meta informations extracted from the WSDL
     * - documentation: This field is used to specify the number of days after the sale of an item in which the buyer or seller can combine multiple and mutual order line items into one Combined Invoice order. In a Combined Invoice order, the buyer makes
     * one payment for all order line items, hence only unpaid order line items can be combined into a Combined Invoice order.
     * - minOccurs: 0
     * @var string
     */
    public $CombinedDuration;
    /**
     * The ModifyActionCode
     * Meta informations extracted from the WSDL
     * - documentation: Indicates what action to take on the specified flat shipping discount, calculated shipping discount or promotional discount. If the action is Delete and if a flat rate or calculated shipping discount profile is specified, the
     * discount profile identified by DiscountProfile.DiscountProfileID is deleted (see DiscountProfile.MappedDiscountProfileID for related details).
     * - minOccurs: 0
     * @var string
     */
    public $ModifyActionCode;
    /**
     * The FlatShippingDiscount
     * Meta informations extracted from the WSDL
     * - documentation: Details of a shipping cost discount profile for flat rate shipping. If this is provided, CalculatedShippingDiscount and PromotionalShippingDiscountDetails should be omitted.
     * - minOccurs: 0
     * @var \ebay\StructType\FlatShippingDiscountType
     */
    public $FlatShippingDiscount;
    /**
     * The CalculatedShippingDiscount
     * Meta informations extracted from the WSDL
     * - documentation: Details of a shipping cost discount profile for calculated shipping. If this is provided, FlatShippingDiscount and PromotionalShippingDiscountDetails should be omitted.
     * - minOccurs: 0
     * @var \ebay\StructType\CalculatedShippingDiscountType
     */
    public $CalculatedShippingDiscount;
    /**
     * The CalculatedHandlingDiscount
     * Meta informations extracted from the WSDL
     * - documentation: This container is used by the seller to specify/modify packaging and handling discounts that are applied for Combined Invoice orders.
     * - minOccurs: 0
     * @var \ebay\StructType\CalculatedHandlingDiscountType
     */
    public $CalculatedHandlingDiscount;
    /**
     * The PromotionalShippingDiscountDetails
     * Meta informations extracted from the WSDL
     * - documentation: The data for the promotional shipping discount. If this is provided, FlatShippingDiscount and CalculatedShippingDiscount should be omitted.
     * - minOccurs: 0
     * @var \ebay\StructType\PromotionalShippingDiscountDetailsType
     */
    public $PromotionalShippingDiscountDetails;
    /**
     * The ShippingInsurance
     * Meta informations extracted from the WSDL
     * - documentation: Information establishing what fee to apply for domestic shipping insurance for combined payment depending on which range the order item-total price falls into.
     * - minOccurs: 0
     * @var \ebay\StructType\ShippingInsuranceType
     */
    public $ShippingInsurance;
    /**
     * The InternationalShippingInsurance
     * Meta informations extracted from the WSDL
     * - documentation: Information establishing what fee to apply for international shipping insurance for combined payment depending on which range the order item-total price falls into.
     * - minOccurs: 0
     * @var \ebay\StructType\ShippingInsuranceType
     */
    public $InternationalShippingInsurance;
    /**
     * Constructor method for SetShippingDiscountProfilesRequestType
     * @uses SetShippingDiscountProfilesRequestType::setCurrencyID()
     * @uses SetShippingDiscountProfilesRequestType::setCombinedDuration()
     * @uses SetShippingDiscountProfilesRequestType::setModifyActionCode()
     * @uses SetShippingDiscountProfilesRequestType::setFlatShippingDiscount()
     * @uses SetShippingDiscountProfilesRequestType::setCalculatedShippingDiscount()
     * @uses SetShippingDiscountProfilesRequestType::setCalculatedHandlingDiscount()
     * @uses SetShippingDiscountProfilesRequestType::setPromotionalShippingDiscountDetails()
     * @uses SetShippingDiscountProfilesRequestType::setShippingInsurance()
     * @uses SetShippingDiscountProfilesRequestType::setInternationalShippingInsurance()
     * @param string $currencyID
     * @param string $combinedDuration
     * @param string $modifyActionCode
     * @param \ebay\StructType\FlatShippingDiscountType $flatShippingDiscount
     * @param \ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount
     * @param \ebay\StructType\CalculatedHandlingDiscountType $calculatedHandlingDiscount
     * @param \ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails
     * @param \ebay\StructType\ShippingInsuranceType $shippingInsurance
     * @param \ebay\StructType\ShippingInsuranceType $internationalShippingInsurance
     */
    public function __construct($currencyID = null, $combinedDuration = null, $modifyActionCode = null, \ebay\StructType\FlatShippingDiscountType $flatShippingDiscount = null, \ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount = null, \ebay\StructType\CalculatedHandlingDiscountType $calculatedHandlingDiscount = null, \ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails = null, \ebay\StructType\ShippingInsuranceType $shippingInsurance = null, \ebay\StructType\ShippingInsuranceType $internationalShippingInsurance = null)
    {
        $this
            ->setCurrencyID($currencyID)
            ->setCombinedDuration($combinedDuration)
            ->setModifyActionCode($modifyActionCode)
            ->setFlatShippingDiscount($flatShippingDiscount)
            ->setCalculatedShippingDiscount($calculatedShippingDiscount)
            ->setCalculatedHandlingDiscount($calculatedHandlingDiscount)
            ->setPromotionalShippingDiscountDetails($promotionalShippingDiscountDetails)
            ->setShippingInsurance($shippingInsurance)
            ->setInternationalShippingInsurance($internationalShippingInsurance);
    }
    /**
     * Get CurrencyID value
     * @return string|null
     */
    public function getCurrencyID()
    {
        return $this->CurrencyID;
    }
    /**
     * Set CurrencyID value
     * @uses \ebay\EnumType\CurrencyCodeType::valueIsValid()
     * @uses \ebay\EnumType\CurrencyCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currencyID
     * @return \ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public function setCurrencyID($currencyID = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\CurrencyCodeType::valueIsValid($currencyID)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $currencyID, implode(', ', \ebay\EnumType\CurrencyCodeType::getValidValues())), __LINE__);
        }
        $this->CurrencyID = $currencyID;
        return $this;
    }
    /**
     * Get CombinedDuration value
     * @return string|null
     */
    public function getCombinedDuration()
    {
        return $this->CombinedDuration;
    }
    /**
     * Set CombinedDuration value
     * @uses \ebay\EnumType\CombinedPaymentPeriodCodeType::valueIsValid()
     * @uses \ebay\EnumType\CombinedPaymentPeriodCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $combinedDuration
     * @return \ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public function setCombinedDuration($combinedDuration = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\CombinedPaymentPeriodCodeType::valueIsValid($combinedDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $combinedDuration, implode(', ', \ebay\EnumType\CombinedPaymentPeriodCodeType::getValidValues())), __LINE__);
        }
        $this->CombinedDuration = $combinedDuration;
        return $this;
    }
    /**
     * Get ModifyActionCode value
     * @return string|null
     */
    public function getModifyActionCode()
    {
        return $this->ModifyActionCode;
    }
    /**
     * Set ModifyActionCode value
     * @uses \ebay\EnumType\ModifyActionCodeType::valueIsValid()
     * @uses \ebay\EnumType\ModifyActionCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $modifyActionCode
     * @return \ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public function setModifyActionCode($modifyActionCode = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\ModifyActionCodeType::valueIsValid($modifyActionCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $modifyActionCode, implode(', ', \ebay\EnumType\ModifyActionCodeType::getValidValues())), __LINE__);
        }
        $this->ModifyActionCode = $modifyActionCode;
        return $this;
    }
    /**
     * Get FlatShippingDiscount value
     * @return \ebay\StructType\FlatShippingDiscountType|null
     */
    public function getFlatShippingDiscount()
    {
        return $this->FlatShippingDiscount;
    }
    /**
     * Set FlatShippingDiscount value
     * @param \ebay\StructType\FlatShippingDiscountType $flatShippingDiscount
     * @return \ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public function setFlatShippingDiscount(\ebay\StructType\FlatShippingDiscountType $flatShippingDiscount = null)
    {
        $this->FlatShippingDiscount = $flatShippingDiscount;
        return $this;
    }
    /**
     * Get CalculatedShippingDiscount value
     * @return \ebay\StructType\CalculatedShippingDiscountType|null
     */
    public function getCalculatedShippingDiscount()
    {
        return $this->CalculatedShippingDiscount;
    }
    /**
     * Set CalculatedShippingDiscount value
     * @param \ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount
     * @return \ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public function setCalculatedShippingDiscount(\ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount = null)
    {
        $this->CalculatedShippingDiscount = $calculatedShippingDiscount;
        return $this;
    }
    /**
     * Get CalculatedHandlingDiscount value
     * @return \ebay\StructType\CalculatedHandlingDiscountType|null
     */
    public function getCalculatedHandlingDiscount()
    {
        return $this->CalculatedHandlingDiscount;
    }
    /**
     * Set CalculatedHandlingDiscount value
     * @param \ebay\StructType\CalculatedHandlingDiscountType $calculatedHandlingDiscount
     * @return \ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public function setCalculatedHandlingDiscount(\ebay\StructType\CalculatedHandlingDiscountType $calculatedHandlingDiscount = null)
    {
        $this->CalculatedHandlingDiscount = $calculatedHandlingDiscount;
        return $this;
    }
    /**
     * Get PromotionalShippingDiscountDetails value
     * @return \ebay\StructType\PromotionalShippingDiscountDetailsType|null
     */
    public function getPromotionalShippingDiscountDetails()
    {
        return $this->PromotionalShippingDiscountDetails;
    }
    /**
     * Set PromotionalShippingDiscountDetails value
     * @param \ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails
     * @return \ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public function setPromotionalShippingDiscountDetails(\ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails = null)
    {
        $this->PromotionalShippingDiscountDetails = $promotionalShippingDiscountDetails;
        return $this;
    }
    /**
     * Get ShippingInsurance value
     * @return \ebay\StructType\ShippingInsuranceType|null
     */
    public function getShippingInsurance()
    {
        return $this->ShippingInsurance;
    }
    /**
     * Set ShippingInsurance value
     * @param \ebay\StructType\ShippingInsuranceType $shippingInsurance
     * @return \ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public function setShippingInsurance(\ebay\StructType\ShippingInsuranceType $shippingInsurance = null)
    {
        $this->ShippingInsurance = $shippingInsurance;
        return $this;
    }
    /**
     * Get InternationalShippingInsurance value
     * @return \ebay\StructType\ShippingInsuranceType|null
     */
    public function getInternationalShippingInsurance()
    {
        return $this->InternationalShippingInsurance;
    }
    /**
     * Set InternationalShippingInsurance value
     * @param \ebay\StructType\ShippingInsuranceType $internationalShippingInsurance
     * @return \ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public function setInternationalShippingInsurance(\ebay\StructType\ShippingInsuranceType $internationalShippingInsurance = null)
    {
        $this->InternationalShippingInsurance = $internationalShippingInsurance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\SetShippingDiscountProfilesRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
