<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSellingManagerItemAutomationRuleResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Contains the set of automation rules associated with the specified item.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class SetSellingManagerItemAutomationRuleResponseType extends AbstractResponseType
{
    /**
     * The AutomatedListingRule
     * Meta informations extracted from the WSDL
     * - documentation: Contains the automated listing rule associated with this item.
     * - minOccurs: 0
     * @var \ebay\StructType\SellingManagerAutoListType
     */
    public $AutomatedListingRule;
    /**
     * The AutomatedRelistingRule
     * Meta informations extracted from the WSDL
     * - documentation: Contains the automated relisting rule associated with this item.
     * - minOccurs: 0
     * @var \ebay\StructType\SellingManagerAutoRelistType
     */
    public $AutomatedRelistingRule;
    /**
     * The AutomatedSecondChanceOfferRule
     * Meta informations extracted from the WSDL
     * - documentation: Contains the automated Second Chance Offer rule associated with this item.
     * - minOccurs: 0
     * @var \ebay\StructType\SellingManagerAutoSecondChanceOfferType
     */
    public $AutomatedSecondChanceOfferRule;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - documentation: Contains fees that may be incurred when items are listed using the automation rules (e.g., a scheduled listing fee). Use of an automation rule does not in itself have a fee, but use can result in a fee.
     * - minOccurs: 0
     * @var \ebay\StructType\FeesType
     */
    public $Fees;
    /**
     * Constructor method for SetSellingManagerItemAutomationRuleResponseType
     * @uses SetSellingManagerItemAutomationRuleResponseType::setAutomatedListingRule()
     * @uses SetSellingManagerItemAutomationRuleResponseType::setAutomatedRelistingRule()
     * @uses SetSellingManagerItemAutomationRuleResponseType::setAutomatedSecondChanceOfferRule()
     * @uses SetSellingManagerItemAutomationRuleResponseType::setFees()
     * @param \ebay\StructType\SellingManagerAutoListType $automatedListingRule
     * @param \ebay\StructType\SellingManagerAutoRelistType $automatedRelistingRule
     * @param \ebay\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule
     * @param \ebay\StructType\FeesType $fees
     */
    public function __construct(\ebay\StructType\SellingManagerAutoListType $automatedListingRule = null, \ebay\StructType\SellingManagerAutoRelistType $automatedRelistingRule = null, \ebay\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule = null, \ebay\StructType\FeesType $fees = null)
    {
        $this
            ->setAutomatedListingRule($automatedListingRule)
            ->setAutomatedRelistingRule($automatedRelistingRule)
            ->setAutomatedSecondChanceOfferRule($automatedSecondChanceOfferRule)
            ->setFees($fees);
    }
    /**
     * Get AutomatedListingRule value
     * @return \ebay\StructType\SellingManagerAutoListType|null
     */
    public function getAutomatedListingRule()
    {
        return $this->AutomatedListingRule;
    }
    /**
     * Set AutomatedListingRule value
     * @param \ebay\StructType\SellingManagerAutoListType $automatedListingRule
     * @return \ebay\StructType\SetSellingManagerItemAutomationRuleResponseType
     */
    public function setAutomatedListingRule(\ebay\StructType\SellingManagerAutoListType $automatedListingRule = null)
    {
        $this->AutomatedListingRule = $automatedListingRule;
        return $this;
    }
    /**
     * Get AutomatedRelistingRule value
     * @return \ebay\StructType\SellingManagerAutoRelistType|null
     */
    public function getAutomatedRelistingRule()
    {
        return $this->AutomatedRelistingRule;
    }
    /**
     * Set AutomatedRelistingRule value
     * @param \ebay\StructType\SellingManagerAutoRelistType $automatedRelistingRule
     * @return \ebay\StructType\SetSellingManagerItemAutomationRuleResponseType
     */
    public function setAutomatedRelistingRule(\ebay\StructType\SellingManagerAutoRelistType $automatedRelistingRule = null)
    {
        $this->AutomatedRelistingRule = $automatedRelistingRule;
        return $this;
    }
    /**
     * Get AutomatedSecondChanceOfferRule value
     * @return \ebay\StructType\SellingManagerAutoSecondChanceOfferType|null
     */
    public function getAutomatedSecondChanceOfferRule()
    {
        return $this->AutomatedSecondChanceOfferRule;
    }
    /**
     * Set AutomatedSecondChanceOfferRule value
     * @param \ebay\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule
     * @return \ebay\StructType\SetSellingManagerItemAutomationRuleResponseType
     */
    public function setAutomatedSecondChanceOfferRule(\ebay\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule = null)
    {
        $this->AutomatedSecondChanceOfferRule = $automatedSecondChanceOfferRule;
        return $this;
    }
    /**
     * Get Fees value
     * @return \ebay\StructType\FeesType|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \ebay\StructType\FeesType $fees
     * @return \ebay\StructType\SetSellingManagerItemAutomationRuleResponseType
     */
    public function setFees(\ebay\StructType\FeesType $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\SetSellingManagerItemAutomationRuleResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
