<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReviseMyMessagesRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Sets the read state for messages, sets the flagged state of messages, and moves messages into and out of folders.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class ReviseMyMessagesRequestType extends AbstractRequestType
{
    /**
     * The MessageIDs
     * Meta informations extracted from the WSDL
     * - documentation: Contains a list of up to 10 <b>MessageIDs</b> <b>MessageIDs</b> values must be included in the request. Messages in the Sent box cannot be moved, marked as read, or flagged.
     * - minOccurs: 0
     * @var \ebay\ArrayType\MyMessagesMessageIDArrayType
     */
    public $MessageIDs;
    /**
     * The AlertIDs
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\ArrayType\MyMessagesAlertIDArrayType
     */
    public $AlertIDs;
    /**
     * The Read
     * Meta informations extracted from the WSDL
     * - documentation: Changes the read states of all messages specified in a request. At least one of the following must be specified in the request: Read, Flagged, or FolderID. Messages in the Sent box cannot be moved, marked as Read, or Flagged.
     * <br><br> Note that messages retrieved with the API are not automatically marked Read, and must be marked Read with this call.
     * - minOccurs: 0
     * @var bool
     */
    public $Read;
    /**
     * The Flagged
     * Meta informations extracted from the WSDL
     * - documentation: Changes the flagged states of all messages specified in a request by their MessageID values. At least one of Read, Flagged, or FolderID must be specified in the request. Messages in the Sent box cannot be moved, marked as Read, or
     * Flagged.
     * - minOccurs: 0
     * @var bool
     */
    public $Flagged;
    /**
     * The FolderID
     * Meta informations extracted from the WSDL
     * - documentation: An ID that uniquely identifies the My Messages folder to move messages into. At least one of the <b>Read</b>, <b>Flagged</b>, or <b>FolderID</b> fields must be specified in the request. Messages in the Sent box cannot be moved,
     * marked as read, or flagged.
     * - minOccurs: 0
     * @var int
     */
    public $FolderID;
    /**
     * Constructor method for ReviseMyMessagesRequestType
     * @uses ReviseMyMessagesRequestType::setMessageIDs()
     * @uses ReviseMyMessagesRequestType::setAlertIDs()
     * @uses ReviseMyMessagesRequestType::setRead()
     * @uses ReviseMyMessagesRequestType::setFlagged()
     * @uses ReviseMyMessagesRequestType::setFolderID()
     * @param \ebay\ArrayType\MyMessagesMessageIDArrayType $messageIDs
     * @param \ebay\ArrayType\MyMessagesAlertIDArrayType $alertIDs
     * @param bool $read
     * @param bool $flagged
     * @param int $folderID
     */
    public function __construct(\ebay\ArrayType\MyMessagesMessageIDArrayType $messageIDs = null, \ebay\ArrayType\MyMessagesAlertIDArrayType $alertIDs = null, $read = null, $flagged = null, $folderID = null)
    {
        $this
            ->setMessageIDs($messageIDs)
            ->setAlertIDs($alertIDs)
            ->setRead($read)
            ->setFlagged($flagged)
            ->setFolderID($folderID);
    }
    /**
     * Get MessageIDs value
     * @return \ebay\ArrayType\MyMessagesMessageIDArrayType|null
     */
    public function getMessageIDs()
    {
        return $this->MessageIDs;
    }
    /**
     * Set MessageIDs value
     * @param \ebay\ArrayType\MyMessagesMessageIDArrayType $messageIDs
     * @return \ebay\StructType\ReviseMyMessagesRequestType
     */
    public function setMessageIDs(\ebay\ArrayType\MyMessagesMessageIDArrayType $messageIDs = null)
    {
        $this->MessageIDs = $messageIDs;
        return $this;
    }
    /**
     * Get AlertIDs value
     * @return \ebay\ArrayType\MyMessagesAlertIDArrayType|null
     */
    public function getAlertIDs()
    {
        return $this->AlertIDs;
    }
    /**
     * Set AlertIDs value
     * @param \ebay\ArrayType\MyMessagesAlertIDArrayType $alertIDs
     * @return \ebay\StructType\ReviseMyMessagesRequestType
     */
    public function setAlertIDs(\ebay\ArrayType\MyMessagesAlertIDArrayType $alertIDs = null)
    {
        $this->AlertIDs = $alertIDs;
        return $this;
    }
    /**
     * Get Read value
     * @return bool|null
     */
    public function getRead()
    {
        return $this->Read;
    }
    /**
     * Set Read value
     * @param bool $read
     * @return \ebay\StructType\ReviseMyMessagesRequestType
     */
    public function setRead($read = null)
    {
        $this->Read = $read;
        return $this;
    }
    /**
     * Get Flagged value
     * @return bool|null
     */
    public function getFlagged()
    {
        return $this->Flagged;
    }
    /**
     * Set Flagged value
     * @param bool $flagged
     * @return \ebay\StructType\ReviseMyMessagesRequestType
     */
    public function setFlagged($flagged = null)
    {
        $this->Flagged = $flagged;
        return $this;
    }
    /**
     * Get FolderID value
     * @return int|null
     */
    public function getFolderID()
    {
        return $this->FolderID;
    }
    /**
     * Set FolderID value
     * @param int $folderID
     * @return \ebay\StructType\ReviseMyMessagesRequestType
     */
    public function setFolderID($folderID = null)
    {
        // validation for constraint: int
        if (!is_null($folderID) && !is_numeric($folderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($folderID)), __LINE__);
        }
        $this->FolderID = $folderID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\ReviseMyMessagesRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
