<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReviseFixedPriceItemRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Enables a seller to change the properties of a currently active fixed-price listing (including multi-variation listings).
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class ReviseFixedPriceItemRequestType extends AbstractRequestType
{
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - documentation: Child elements hold the values for item details that you want to change. The Item.ItemID must always be set to the ID of the listing being changed. Only specify Item fields for the details that are changing. Unless otherwise
     * specified in the field descriptions below, the listing retains its existing values for fields that you don't pass in the ReviseFixedPriceItem request. Use DeletedField to remove a field from the listing.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemType
     */
    public $Item;
    /**
     * The DeletedField
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the name of a field to delete from a listing. The request can contain zero, one, or many instances of DeletedField (one for each field to be deleted). See the relevant field descriptions to determine when to use
     * DeletedField (and potential consequences). <br><br> You cannot delete required fields from a listing. <br><br> Some fields are optional when you first list an item (e.g., SecondaryCategory), but once they are set they cannot be deleted when you
     * revise an item. Some optional fields cannot be deleted if the item has bids and/or ends within 12 hours. Some optional fields cannot be deleted if other fields depend on them. See the eBay Trading API guide for rules on removing values when revising
     * items. <br><br> Some data (such as Variation nodes within Variations) can't be deleted by using DeletedFields. See the relevant field descriptions for how to delete such data. <br><br> Use values that match the case of the schema element names
     * (Item.PictureDetails.GalleryURL) or make the initial letter of each field name lowercase (item.pictureDetails.galleryURL). However, do not change the case of letters in the middle of a field name. For example, item.picturedetails.galleryUrl is not
     * allowed. <br><br> To delete a listing enhancement like BoldTitle, specify the value you are deleting in square brackets ("[ ]"); for example, Item.ListingEnhancement[BoldTitle].
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DeletedField;
    /**
     * Constructor method for ReviseFixedPriceItemRequestType
     * @uses ReviseFixedPriceItemRequestType::setItem()
     * @uses ReviseFixedPriceItemRequestType::setDeletedField()
     * @param \ebay\StructType\ItemType $item
     * @param string[] $deletedField
     */
    public function __construct(\ebay\StructType\ItemType $item = null, array $deletedField = array())
    {
        $this
            ->setItem($item)
            ->setDeletedField($deletedField);
    }
    /**
     * Get Item value
     * @return \ebay\StructType\ItemType|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \ebay\StructType\ItemType $item
     * @return \ebay\StructType\ReviseFixedPriceItemRequestType
     */
    public function setItem(\ebay\StructType\ItemType $item = null)
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Get DeletedField value
     * @return string[]|null
     */
    public function getDeletedField()
    {
        return $this->DeletedField;
    }
    /**
     * Set DeletedField value
     * @throws \InvalidArgumentException
     * @param string[] $deletedField
     * @return \ebay\StructType\ReviseFixedPriceItemRequestType
     */
    public function setDeletedField(array $deletedField = array())
    {
        foreach ($deletedField as $reviseFixedPriceItemRequestTypeDeletedFieldItem) {
            // validation for constraint: itemType
            if (!is_string($reviseFixedPriceItemRequestTypeDeletedFieldItem)) {
                throw new \InvalidArgumentException(sprintf('The DeletedField property can only contain items of string, "%s" given', is_object($reviseFixedPriceItemRequestTypeDeletedFieldItem) ? get_class($reviseFixedPriceItemRequestTypeDeletedFieldItem) : gettype($reviseFixedPriceItemRequestTypeDeletedFieldItem)), __LINE__);
            }
        }
        $this->DeletedField = $deletedField;
        return $this;
    }
    /**
     * Add item to DeletedField value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ebay\StructType\ReviseFixedPriceItemRequestType
     */
    public function addToDeletedField($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DeletedField property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeletedField[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\ReviseFixedPriceItemRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
