<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductInfoType StructType
 * Meta informations extracted from the WSDL
 * - documentation: This type is deprecated.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class ProductInfoType extends AbstractStructBase
{
    /**
     * The AverageStartPrice
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $AverageStartPrice;
    /**
     * The AverageSoldPrice
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $AverageSoldPrice;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The ProductState
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $ProductState;
    /**
     * The productInfoID
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * @var string
     */
    public $productInfoID;
    /**
     * Constructor method for ProductInfoType
     * @uses ProductInfoType::setAverageStartPrice()
     * @uses ProductInfoType::setAverageSoldPrice()
     * @uses ProductInfoType::setTitle()
     * @uses ProductInfoType::setProductState()
     * @uses ProductInfoType::setProductInfoID()
     * @param \ebay\StructType\AmountType $averageStartPrice
     * @param \ebay\StructType\AmountType $averageSoldPrice
     * @param string $title
     * @param string $productState
     * @param string $productInfoID
     */
    public function __construct(\ebay\StructType\AmountType $averageStartPrice = null, \ebay\StructType\AmountType $averageSoldPrice = null, $title = null, $productState = null, $productInfoID = null)
    {
        $this
            ->setAverageStartPrice($averageStartPrice)
            ->setAverageSoldPrice($averageSoldPrice)
            ->setTitle($title)
            ->setProductState($productState)
            ->setProductInfoID($productInfoID);
    }
    /**
     * Get AverageStartPrice value
     * @return \ebay\StructType\AmountType|null
     */
    public function getAverageStartPrice()
    {
        return $this->AverageStartPrice;
    }
    /**
     * Set AverageStartPrice value
     * @param \ebay\StructType\AmountType $averageStartPrice
     * @return \ebay\StructType\ProductInfoType
     */
    public function setAverageStartPrice(\ebay\StructType\AmountType $averageStartPrice = null)
    {
        $this->AverageStartPrice = $averageStartPrice;
        return $this;
    }
    /**
     * Get AverageSoldPrice value
     * @return \ebay\StructType\AmountType|null
     */
    public function getAverageSoldPrice()
    {
        return $this->AverageSoldPrice;
    }
    /**
     * Set AverageSoldPrice value
     * @param \ebay\StructType\AmountType $averageSoldPrice
     * @return \ebay\StructType\ProductInfoType
     */
    public function setAverageSoldPrice(\ebay\StructType\AmountType $averageSoldPrice = null)
    {
        $this->AverageSoldPrice = $averageSoldPrice;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \ebay\StructType\ProductInfoType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get ProductState value
     * @return string|null
     */
    public function getProductState()
    {
        return $this->ProductState;
    }
    /**
     * Set ProductState value
     * @uses \ebay\EnumType\ProductStateCodeType::valueIsValid()
     * @uses \ebay\EnumType\ProductStateCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productState
     * @return \ebay\StructType\ProductInfoType
     */
    public function setProductState($productState = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\ProductStateCodeType::valueIsValid($productState)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $productState, implode(', ', \ebay\EnumType\ProductStateCodeType::getValidValues())), __LINE__);
        }
        $this->ProductState = $productState;
        return $this;
    }
    /**
     * Get productInfoID value
     * @return string|null
     */
    public function getProductInfoID()
    {
        return $this->productInfoID;
    }
    /**
     * Set productInfoID value
     * @param string $productInfoID
     * @return \ebay\StructType\ProductInfoType
     */
    public function setProductInfoID($productInfoID = null)
    {
        // validation for constraint: string
        if (!is_null($productInfoID) && !is_string($productInfoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productInfoID)), __LINE__);
        }
        $this->productInfoID = $productInfoID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\ProductInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
