<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaximumUnpaidItemStrikesInfoDetailsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Details of a buyer's maximum unpaid item strikes in a pre-defined time period. This is applicable only to sellers.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class MaximumUnpaidItemStrikesInfoDetailsType extends AbstractStructBase
{
    /**
     * The MaximumUnpaidItemStrikesCount
     * Meta informations extracted from the WSDL
     * - documentation: The number of the maximum unpaid item strikes. This is applicable only to sellers.
     * - minOccurs: 0
     * @var \ebay\StructType\MaximumUnpaidItemStrikesCountDetailsType
     */
    public $MaximumUnpaidItemStrikesCount;
    /**
     * The MaximumUnpaidItemStrikesDuration
     * Meta informations extracted from the WSDL
     * - documentation: Range of time used to determine maximum unpaid item count. This is applicable only to sellers.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\MaximumUnpaidItemStrikesDurationDetailsType[]
     */
    public $MaximumUnpaidItemStrikesDuration;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for MaximumUnpaidItemStrikesInfoDetailsType
     * @uses MaximumUnpaidItemStrikesInfoDetailsType::setMaximumUnpaidItemStrikesCount()
     * @uses MaximumUnpaidItemStrikesInfoDetailsType::setMaximumUnpaidItemStrikesDuration()
     * @uses MaximumUnpaidItemStrikesInfoDetailsType::setAny()
     * @param \ebay\StructType\MaximumUnpaidItemStrikesCountDetailsType $maximumUnpaidItemStrikesCount
     * @param \ebay\StructType\MaximumUnpaidItemStrikesDurationDetailsType[] $maximumUnpaidItemStrikesDuration
     * @param \DOMDocument $any
     */
    public function __construct(\ebay\StructType\MaximumUnpaidItemStrikesCountDetailsType $maximumUnpaidItemStrikesCount = null, array $maximumUnpaidItemStrikesDuration = array(), \DOMDocument $any = null)
    {
        $this
            ->setMaximumUnpaidItemStrikesCount($maximumUnpaidItemStrikesCount)
            ->setMaximumUnpaidItemStrikesDuration($maximumUnpaidItemStrikesDuration)
            ->setAny($any);
    }
    /**
     * Get MaximumUnpaidItemStrikesCount value
     * @return \ebay\StructType\MaximumUnpaidItemStrikesCountDetailsType|null
     */
    public function getMaximumUnpaidItemStrikesCount()
    {
        return $this->MaximumUnpaidItemStrikesCount;
    }
    /**
     * Set MaximumUnpaidItemStrikesCount value
     * @param \ebay\StructType\MaximumUnpaidItemStrikesCountDetailsType $maximumUnpaidItemStrikesCount
     * @return \ebay\StructType\MaximumUnpaidItemStrikesInfoDetailsType
     */
    public function setMaximumUnpaidItemStrikesCount(\ebay\StructType\MaximumUnpaidItemStrikesCountDetailsType $maximumUnpaidItemStrikesCount = null)
    {
        $this->MaximumUnpaidItemStrikesCount = $maximumUnpaidItemStrikesCount;
        return $this;
    }
    /**
     * Get MaximumUnpaidItemStrikesDuration value
     * @return \ebay\StructType\MaximumUnpaidItemStrikesDurationDetailsType[]|null
     */
    public function getMaximumUnpaidItemStrikesDuration()
    {
        return $this->MaximumUnpaidItemStrikesDuration;
    }
    /**
     * Set MaximumUnpaidItemStrikesDuration value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\MaximumUnpaidItemStrikesDurationDetailsType[] $maximumUnpaidItemStrikesDuration
     * @return \ebay\StructType\MaximumUnpaidItemStrikesInfoDetailsType
     */
    public function setMaximumUnpaidItemStrikesDuration(array $maximumUnpaidItemStrikesDuration = array())
    {
        foreach ($maximumUnpaidItemStrikesDuration as $maximumUnpaidItemStrikesInfoDetailsTypeMaximumUnpaidItemStrikesDurationItem) {
            // validation for constraint: itemType
            if (!$maximumUnpaidItemStrikesInfoDetailsTypeMaximumUnpaidItemStrikesDurationItem instanceof \ebay\StructType\MaximumUnpaidItemStrikesDurationDetailsType) {
                throw new \InvalidArgumentException(sprintf('The MaximumUnpaidItemStrikesDuration property can only contain items of \ebay\StructType\MaximumUnpaidItemStrikesDurationDetailsType, "%s" given', is_object($maximumUnpaidItemStrikesInfoDetailsTypeMaximumUnpaidItemStrikesDurationItem) ? get_class($maximumUnpaidItemStrikesInfoDetailsTypeMaximumUnpaidItemStrikesDurationItem) : gettype($maximumUnpaidItemStrikesInfoDetailsTypeMaximumUnpaidItemStrikesDurationItem)), __LINE__);
            }
        }
        $this->MaximumUnpaidItemStrikesDuration = $maximumUnpaidItemStrikesDuration;
        return $this;
    }
    /**
     * Add item to MaximumUnpaidItemStrikesDuration value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\MaximumUnpaidItemStrikesDurationDetailsType $item
     * @return \ebay\StructType\MaximumUnpaidItemStrikesInfoDetailsType
     */
    public function addToMaximumUnpaidItemStrikesDuration(\ebay\StructType\MaximumUnpaidItemStrikesDurationDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\MaximumUnpaidItemStrikesDurationDetailsType) {
            throw new \InvalidArgumentException(sprintf('The MaximumUnpaidItemStrikesDuration property can only contain items of \ebay\StructType\MaximumUnpaidItemStrikesDurationDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MaximumUnpaidItemStrikesDuration[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\MaximumUnpaidItemStrikesInfoDetailsType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\MaximumUnpaidItemStrikesInfoDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\MaximumUnpaidItemStrikesInfoDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
