<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListingDurationDefinitionsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: A container node for sets of durations, each set describing the durations allowed for one listing type.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class ListingDurationDefinitionsType extends AbstractStructBase
{
    /**
     * The ListingDuration
     * Meta informations extracted from the WSDL
     * - documentation: Contains the duration periods that apply to a certain listing type.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\ListingDurationDefinitionType[]
     */
    public $ListingDuration;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - documentation: The current version of the feature. Some features (for example, ShippingTermsRequired) do not have version numbers.
     * @var int
     */
    public $Version;
    /**
     * Constructor method for ListingDurationDefinitionsType
     * @uses ListingDurationDefinitionsType::setListingDuration()
     * @uses ListingDurationDefinitionsType::setVersion()
     * @param \ebay\StructType\ListingDurationDefinitionType[] $listingDuration
     * @param int $version
     */
    public function __construct(array $listingDuration = array(), $version = null)
    {
        $this
            ->setListingDuration($listingDuration)
            ->setVersion($version);
    }
    /**
     * Get ListingDuration value
     * @return \ebay\StructType\ListingDurationDefinitionType[]|null
     */
    public function getListingDuration()
    {
        return $this->ListingDuration;
    }
    /**
     * Set ListingDuration value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ListingDurationDefinitionType[] $listingDuration
     * @return \ebay\StructType\ListingDurationDefinitionsType
     */
    public function setListingDuration(array $listingDuration = array())
    {
        foreach ($listingDuration as $listingDurationDefinitionsTypeListingDurationItem) {
            // validation for constraint: itemType
            if (!$listingDurationDefinitionsTypeListingDurationItem instanceof \ebay\StructType\ListingDurationDefinitionType) {
                throw new \InvalidArgumentException(sprintf('The ListingDuration property can only contain items of \ebay\StructType\ListingDurationDefinitionType, "%s" given', is_object($listingDurationDefinitionsTypeListingDurationItem) ? get_class($listingDurationDefinitionsTypeListingDurationItem) : gettype($listingDurationDefinitionsTypeListingDurationItem)), __LINE__);
            }
        }
        $this->ListingDuration = $listingDuration;
        return $this;
    }
    /**
     * Add item to ListingDuration value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ListingDurationDefinitionType $item
     * @return \ebay\StructType\ListingDurationDefinitionsType
     */
    public function addToListingDuration(\ebay\StructType\ListingDurationDefinitionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\ListingDurationDefinitionType) {
            throw new \InvalidArgumentException(sprintf('The ListingDuration property can only contain items of \ebay\StructType\ListingDurationDefinitionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ListingDuration[] = $item;
        return $this;
    }
    /**
     * Get Version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param int $version
     * @return \ebay\StructType\ListingDurationDefinitionsType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !is_numeric($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\ListingDurationDefinitionsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
