<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUserResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Contains the data retrieved by the call. User data is returned in a User object.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetUserResponseType extends AbstractResponseType
{
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - documentation: Contains the returned user data for the specified eBay user.
     * - minOccurs: 0
     * @var \ebay\StructType\UserType
     */
    public $User;
    /**
     * Constructor method for GetUserResponseType
     * @uses GetUserResponseType::setUser()
     * @param \ebay\StructType\UserType $user
     */
    public function __construct(\ebay\StructType\UserType $user = null)
    {
        $this
            ->setUser($user);
    }
    /**
     * Get User value
     * @return \ebay\StructType\UserType|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param \ebay\StructType\UserType $user
     * @return \ebay\StructType\GetUserResponseType
     */
    public function setUser(\ebay\StructType\UserType $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetUserResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
