<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetShippingDiscountProfilesResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Response to call of GetShippingDiscountProfiles.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetShippingDiscountProfilesResponseType extends AbstractResponseType
{
    /**
     * The CurrencyID
     * Meta informations extracted from the WSDL
     * - documentation: The three-digit code of the currency to be used for shipping cost discounts and insurance for Combined Invoice orders. A discount profile can only be associated with a listing if the <b>CurrencyID</b> value of the profile matches the
     * <b>Item.Currency</b> value specified in a listing.
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyID;
    /**
     * The FlatShippingDiscount
     * Meta informations extracted from the WSDL
     * - documentation: Details of an individual discount profile defined by the user for flat rate shipping--one for each profile defined by the user. Empty if no shipping discount profiles were defined.
     * - minOccurs: 0
     * @var \ebay\StructType\FlatShippingDiscountType
     */
    public $FlatShippingDiscount;
    /**
     * The CalculatedShippingDiscount
     * Meta informations extracted from the WSDL
     * - documentation: Details of an individual discount profile defined by the user for calculated shipping--one for each profile defined by the user. Empty if no shipping discount profiles were defined.
     * - minOccurs: 0
     * @var \ebay\StructType\CalculatedShippingDiscountType
     */
    public $CalculatedShippingDiscount;
    /**
     * The PromotionalShippingDiscount
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the user defined a promotional discount (the discount is active as soon as it exists).
     * - minOccurs: 0
     * @var bool
     */
    public $PromotionalShippingDiscount;
    /**
     * The CalculatedHandlingDiscount
     * Meta informations extracted from the WSDL
     * - documentation: This container consists of details related to how the seller may have specified/modified packaging and handling discounts that are applied for Combined Invoice orders. This container is only returned if it is set for the Shipping
     * Discount Profile.
     * - minOccurs: 0
     * @var \ebay\StructType\CalculatedHandlingDiscountType
     */
    public $CalculatedHandlingDiscount;
    /**
     * The PromotionalShippingDiscountDetails
     * Meta informations extracted from the WSDL
     * - documentation: The data for the specific promotional shipping discount. Returned only if it has been defined.
     * - minOccurs: 0
     * @var \ebay\StructType\PromotionalShippingDiscountDetailsType
     */
    public $PromotionalShippingDiscountDetails;
    /**
     * The ShippingInsurance
     * Meta informations extracted from the WSDL
     * - documentation: The data for the domestic insurance for combined payment. Returned only if it has been defined.
     * - minOccurs: 0
     * @var \ebay\StructType\ShippingInsuranceType
     */
    public $ShippingInsurance;
    /**
     * The InternationalShippingInsurance
     * Meta informations extracted from the WSDL
     * - documentation: The data for the international insurance for combined payment. Returned only if it has been defined.
     * - minOccurs: 0
     * @var \ebay\StructType\ShippingInsuranceType
     */
    public $InternationalShippingInsurance;
    /**
     * The CombinedDuration
     * Meta informations extracted from the WSDL
     * - documentation: This field indicates the number of days after the sale of an item in which the buyer or seller can combine multiple and mutual order line items into one Combined Invoice order. In a Combined Invoice order, the buyer makes one payment
     * for all order line items, hence only unpaid order line items can be combined into a Combined Invoice order.
     * - minOccurs: 0
     * @var string
     */
    public $CombinedDuration;
    /**
     * Constructor method for GetShippingDiscountProfilesResponseType
     * @uses GetShippingDiscountProfilesResponseType::setCurrencyID()
     * @uses GetShippingDiscountProfilesResponseType::setFlatShippingDiscount()
     * @uses GetShippingDiscountProfilesResponseType::setCalculatedShippingDiscount()
     * @uses GetShippingDiscountProfilesResponseType::setPromotionalShippingDiscount()
     * @uses GetShippingDiscountProfilesResponseType::setCalculatedHandlingDiscount()
     * @uses GetShippingDiscountProfilesResponseType::setPromotionalShippingDiscountDetails()
     * @uses GetShippingDiscountProfilesResponseType::setShippingInsurance()
     * @uses GetShippingDiscountProfilesResponseType::setInternationalShippingInsurance()
     * @uses GetShippingDiscountProfilesResponseType::setCombinedDuration()
     * @param string $currencyID
     * @param \ebay\StructType\FlatShippingDiscountType $flatShippingDiscount
     * @param \ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount
     * @param bool $promotionalShippingDiscount
     * @param \ebay\StructType\CalculatedHandlingDiscountType $calculatedHandlingDiscount
     * @param \ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails
     * @param \ebay\StructType\ShippingInsuranceType $shippingInsurance
     * @param \ebay\StructType\ShippingInsuranceType $internationalShippingInsurance
     * @param string $combinedDuration
     */
    public function __construct($currencyID = null, \ebay\StructType\FlatShippingDiscountType $flatShippingDiscount = null, \ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount = null, $promotionalShippingDiscount = null, \ebay\StructType\CalculatedHandlingDiscountType $calculatedHandlingDiscount = null, \ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails = null, \ebay\StructType\ShippingInsuranceType $shippingInsurance = null, \ebay\StructType\ShippingInsuranceType $internationalShippingInsurance = null, $combinedDuration = null)
    {
        $this
            ->setCurrencyID($currencyID)
            ->setFlatShippingDiscount($flatShippingDiscount)
            ->setCalculatedShippingDiscount($calculatedShippingDiscount)
            ->setPromotionalShippingDiscount($promotionalShippingDiscount)
            ->setCalculatedHandlingDiscount($calculatedHandlingDiscount)
            ->setPromotionalShippingDiscountDetails($promotionalShippingDiscountDetails)
            ->setShippingInsurance($shippingInsurance)
            ->setInternationalShippingInsurance($internationalShippingInsurance)
            ->setCombinedDuration($combinedDuration);
    }
    /**
     * Get CurrencyID value
     * @return string|null
     */
    public function getCurrencyID()
    {
        return $this->CurrencyID;
    }
    /**
     * Set CurrencyID value
     * @uses \ebay\EnumType\CurrencyCodeType::valueIsValid()
     * @uses \ebay\EnumType\CurrencyCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currencyID
     * @return \ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public function setCurrencyID($currencyID = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\CurrencyCodeType::valueIsValid($currencyID)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $currencyID, implode(', ', \ebay\EnumType\CurrencyCodeType::getValidValues())), __LINE__);
        }
        $this->CurrencyID = $currencyID;
        return $this;
    }
    /**
     * Get FlatShippingDiscount value
     * @return \ebay\StructType\FlatShippingDiscountType|null
     */
    public function getFlatShippingDiscount()
    {
        return $this->FlatShippingDiscount;
    }
    /**
     * Set FlatShippingDiscount value
     * @param \ebay\StructType\FlatShippingDiscountType $flatShippingDiscount
     * @return \ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public function setFlatShippingDiscount(\ebay\StructType\FlatShippingDiscountType $flatShippingDiscount = null)
    {
        $this->FlatShippingDiscount = $flatShippingDiscount;
        return $this;
    }
    /**
     * Get CalculatedShippingDiscount value
     * @return \ebay\StructType\CalculatedShippingDiscountType|null
     */
    public function getCalculatedShippingDiscount()
    {
        return $this->CalculatedShippingDiscount;
    }
    /**
     * Set CalculatedShippingDiscount value
     * @param \ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount
     * @return \ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public function setCalculatedShippingDiscount(\ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount = null)
    {
        $this->CalculatedShippingDiscount = $calculatedShippingDiscount;
        return $this;
    }
    /**
     * Get PromotionalShippingDiscount value
     * @return bool|null
     */
    public function getPromotionalShippingDiscount()
    {
        return $this->PromotionalShippingDiscount;
    }
    /**
     * Set PromotionalShippingDiscount value
     * @param bool $promotionalShippingDiscount
     * @return \ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public function setPromotionalShippingDiscount($promotionalShippingDiscount = null)
    {
        $this->PromotionalShippingDiscount = $promotionalShippingDiscount;
        return $this;
    }
    /**
     * Get CalculatedHandlingDiscount value
     * @return \ebay\StructType\CalculatedHandlingDiscountType|null
     */
    public function getCalculatedHandlingDiscount()
    {
        return $this->CalculatedHandlingDiscount;
    }
    /**
     * Set CalculatedHandlingDiscount value
     * @param \ebay\StructType\CalculatedHandlingDiscountType $calculatedHandlingDiscount
     * @return \ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public function setCalculatedHandlingDiscount(\ebay\StructType\CalculatedHandlingDiscountType $calculatedHandlingDiscount = null)
    {
        $this->CalculatedHandlingDiscount = $calculatedHandlingDiscount;
        return $this;
    }
    /**
     * Get PromotionalShippingDiscountDetails value
     * @return \ebay\StructType\PromotionalShippingDiscountDetailsType|null
     */
    public function getPromotionalShippingDiscountDetails()
    {
        return $this->PromotionalShippingDiscountDetails;
    }
    /**
     * Set PromotionalShippingDiscountDetails value
     * @param \ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails
     * @return \ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public function setPromotionalShippingDiscountDetails(\ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails = null)
    {
        $this->PromotionalShippingDiscountDetails = $promotionalShippingDiscountDetails;
        return $this;
    }
    /**
     * Get ShippingInsurance value
     * @return \ebay\StructType\ShippingInsuranceType|null
     */
    public function getShippingInsurance()
    {
        return $this->ShippingInsurance;
    }
    /**
     * Set ShippingInsurance value
     * @param \ebay\StructType\ShippingInsuranceType $shippingInsurance
     * @return \ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public function setShippingInsurance(\ebay\StructType\ShippingInsuranceType $shippingInsurance = null)
    {
        $this->ShippingInsurance = $shippingInsurance;
        return $this;
    }
    /**
     * Get InternationalShippingInsurance value
     * @return \ebay\StructType\ShippingInsuranceType|null
     */
    public function getInternationalShippingInsurance()
    {
        return $this->InternationalShippingInsurance;
    }
    /**
     * Set InternationalShippingInsurance value
     * @param \ebay\StructType\ShippingInsuranceType $internationalShippingInsurance
     * @return \ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public function setInternationalShippingInsurance(\ebay\StructType\ShippingInsuranceType $internationalShippingInsurance = null)
    {
        $this->InternationalShippingInsurance = $internationalShippingInsurance;
        return $this;
    }
    /**
     * Get CombinedDuration value
     * @return string|null
     */
    public function getCombinedDuration()
    {
        return $this->CombinedDuration;
    }
    /**
     * Set CombinedDuration value
     * @uses \ebay\EnumType\CombinedPaymentPeriodCodeType::valueIsValid()
     * @uses \ebay\EnumType\CombinedPaymentPeriodCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $combinedDuration
     * @return \ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public function setCombinedDuration($combinedDuration = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\CombinedPaymentPeriodCodeType::valueIsValid($combinedDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $combinedDuration, implode(', ', \ebay\EnumType\CombinedPaymentPeriodCodeType::getValidValues())), __LINE__);
        }
        $this->CombinedDuration = $combinedDuration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetShippingDiscountProfilesResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
