<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSellingManagerSoldListingsResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Returns a Selling Manager user's sold listings. Response can be filtered by date, search values, and stores.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetSellingManagerSoldListingsResponseType extends AbstractResponseType
{
    /**
     * The SaleRecord
     * Meta informations extracted from the WSDL
     * - documentation: Returns a Selling Manager user's sold listings.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\SellingManagerSoldOrderType[]
     */
    public $SaleRecord;
    /**
     * The PaginationResult
     * Meta informations extracted from the WSDL
     * - documentation: Contains the total number of pages (TotalNumberOfPages) and the total number of products entries (TotalNumberOfEntries) that can be returned on repeated calls with the same format and report criteria.
     * - minOccurs: 0
     * @var \ebay\StructType\PaginationResultType
     */
    public $PaginationResult;
    /**
     * Constructor method for GetSellingManagerSoldListingsResponseType
     * @uses GetSellingManagerSoldListingsResponseType::setSaleRecord()
     * @uses GetSellingManagerSoldListingsResponseType::setPaginationResult()
     * @param \ebay\StructType\SellingManagerSoldOrderType[] $saleRecord
     * @param \ebay\StructType\PaginationResultType $paginationResult
     */
    public function __construct(array $saleRecord = array(), \ebay\StructType\PaginationResultType $paginationResult = null)
    {
        $this
            ->setSaleRecord($saleRecord)
            ->setPaginationResult($paginationResult);
    }
    /**
     * Get SaleRecord value
     * @return \ebay\StructType\SellingManagerSoldOrderType[]|null
     */
    public function getSaleRecord()
    {
        return $this->SaleRecord;
    }
    /**
     * Set SaleRecord value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\SellingManagerSoldOrderType[] $saleRecord
     * @return \ebay\StructType\GetSellingManagerSoldListingsResponseType
     */
    public function setSaleRecord(array $saleRecord = array())
    {
        foreach ($saleRecord as $getSellingManagerSoldListingsResponseTypeSaleRecordItem) {
            // validation for constraint: itemType
            if (!$getSellingManagerSoldListingsResponseTypeSaleRecordItem instanceof \ebay\StructType\SellingManagerSoldOrderType) {
                throw new \InvalidArgumentException(sprintf('The SaleRecord property can only contain items of \ebay\StructType\SellingManagerSoldOrderType, "%s" given', is_object($getSellingManagerSoldListingsResponseTypeSaleRecordItem) ? get_class($getSellingManagerSoldListingsResponseTypeSaleRecordItem) : gettype($getSellingManagerSoldListingsResponseTypeSaleRecordItem)), __LINE__);
            }
        }
        $this->SaleRecord = $saleRecord;
        return $this;
    }
    /**
     * Add item to SaleRecord value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\SellingManagerSoldOrderType $item
     * @return \ebay\StructType\GetSellingManagerSoldListingsResponseType
     */
    public function addToSaleRecord(\ebay\StructType\SellingManagerSoldOrderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\SellingManagerSoldOrderType) {
            throw new \InvalidArgumentException(sprintf('The SaleRecord property can only contain items of \ebay\StructType\SellingManagerSoldOrderType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SaleRecord[] = $item;
        return $this;
    }
    /**
     * Get PaginationResult value
     * @return \ebay\StructType\PaginationResultType|null
     */
    public function getPaginationResult()
    {
        return $this->PaginationResult;
    }
    /**
     * Set PaginationResult value
     * @param \ebay\StructType\PaginationResultType $paginationResult
     * @return \ebay\StructType\GetSellingManagerSoldListingsResponseType
     */
    public function setPaginationResult(\ebay\StructType\PaginationResultType $paginationResult = null)
    {
        $this->PaginationResult = $paginationResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetSellingManagerSoldListingsResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
