<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSellingManagerAlertsResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type defining the call-specific response fields for the <b>GetSellingManagerAlerts</b> call.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetSellingManagerAlertsResponseType extends AbstractResponseType
{
    /**
     * The Alert
     * Meta informations extracted from the WSDL
     * - documentation: Container consisting of details related to a Selling Manager alert. Alert types include listing automation, inventory, PaisaPay (India only), item sold, and a general alert.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\SellingManagerAlertType[]
     */
    public $Alert;
    /**
     * Constructor method for GetSellingManagerAlertsResponseType
     * @uses GetSellingManagerAlertsResponseType::setAlert()
     * @param \ebay\StructType\SellingManagerAlertType[] $alert
     */
    public function __construct(array $alert = array())
    {
        $this
            ->setAlert($alert);
    }
    /**
     * Get Alert value
     * @return \ebay\StructType\SellingManagerAlertType[]|null
     */
    public function getAlert()
    {
        return $this->Alert;
    }
    /**
     * Set Alert value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\SellingManagerAlertType[] $alert
     * @return \ebay\StructType\GetSellingManagerAlertsResponseType
     */
    public function setAlert(array $alert = array())
    {
        foreach ($alert as $getSellingManagerAlertsResponseTypeAlertItem) {
            // validation for constraint: itemType
            if (!$getSellingManagerAlertsResponseTypeAlertItem instanceof \ebay\StructType\SellingManagerAlertType) {
                throw new \InvalidArgumentException(sprintf('The Alert property can only contain items of \ebay\StructType\SellingManagerAlertType, "%s" given', is_object($getSellingManagerAlertsResponseTypeAlertItem) ? get_class($getSellingManagerAlertsResponseTypeAlertItem) : gettype($getSellingManagerAlertsResponseTypeAlertItem)), __LINE__);
            }
        }
        $this->Alert = $alert;
        return $this;
    }
    /**
     * Add item to Alert value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\SellingManagerAlertType $item
     * @return \ebay\StructType\GetSellingManagerAlertsResponseType
     */
    public function addToAlert(\ebay\StructType\SellingManagerAlertType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\SellingManagerAlertType) {
            throw new \InvalidArgumentException(sprintf('The Alert property can only contain items of \ebay\StructType\SellingManagerAlertType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Alert[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetSellingManagerAlertsResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
