<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyeBayRemindersRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: This is the base request type of the <b>GetMyeBayReminders</b> call. This call returns the total counts for My eBay Buying and/or My eBay Selling Reminders for a user.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetMyeBayRemindersRequestType extends AbstractRequestType
{
    /**
     * The BuyingReminders
     * Meta informations extracted from the WSDL
     * - documentation: This container should be included if the user wishes to retrieve the counts of My eBay Buying Reminders. Counts will only be retrieved for My eBay Buying Reminders that the user received.
     * - minOccurs: 0
     * @var \ebay\StructType\ReminderCustomizationType
     */
    public $BuyingReminders;
    /**
     * The SellingReminders
     * Meta informations extracted from the WSDL
     * - documentation: This container should be included if the user wishes to retrieve the counts of My eBay Selling Reminders. Counts will only be retrieved for My eBay Selling Reminders that the user received.
     * - minOccurs: 0
     * @var \ebay\StructType\ReminderCustomizationType
     */
    public $SellingReminders;
    /**
     * Constructor method for GetMyeBayRemindersRequestType
     * @uses GetMyeBayRemindersRequestType::setBuyingReminders()
     * @uses GetMyeBayRemindersRequestType::setSellingReminders()
     * @param \ebay\StructType\ReminderCustomizationType $buyingReminders
     * @param \ebay\StructType\ReminderCustomizationType $sellingReminders
     */
    public function __construct(\ebay\StructType\ReminderCustomizationType $buyingReminders = null, \ebay\StructType\ReminderCustomizationType $sellingReminders = null)
    {
        $this
            ->setBuyingReminders($buyingReminders)
            ->setSellingReminders($sellingReminders);
    }
    /**
     * Get BuyingReminders value
     * @return \ebay\StructType\ReminderCustomizationType|null
     */
    public function getBuyingReminders()
    {
        return $this->BuyingReminders;
    }
    /**
     * Set BuyingReminders value
     * @param \ebay\StructType\ReminderCustomizationType $buyingReminders
     * @return \ebay\StructType\GetMyeBayRemindersRequestType
     */
    public function setBuyingReminders(\ebay\StructType\ReminderCustomizationType $buyingReminders = null)
    {
        $this->BuyingReminders = $buyingReminders;
        return $this;
    }
    /**
     * Get SellingReminders value
     * @return \ebay\StructType\ReminderCustomizationType|null
     */
    public function getSellingReminders()
    {
        return $this->SellingReminders;
    }
    /**
     * Set SellingReminders value
     * @param \ebay\StructType\ReminderCustomizationType $sellingReminders
     * @return \ebay\StructType\GetMyeBayRemindersRequestType
     */
    public function setSellingReminders(\ebay\StructType\ReminderCustomizationType $sellingReminders = null)
    {
        $this->SellingReminders = $sellingReminders;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetMyeBayRemindersRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
