<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyeBayBuyingRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Retrieves information regarding a user's buying activity, such as items they are watching, bidding on, have won, did not win, and have made Best Offers on.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetMyeBayBuyingRequestType extends AbstractRequestType
{
    /**
     * The WatchList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items being watched by the user. <br><br> Set Include to true to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemListCustomizationType
     */
    public $WatchList;
    /**
     * The BidList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items on which the user has bid. <br><br> Set Include to true to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemListCustomizationType
     */
    public $BidList;
    /**
     * The BestOfferList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items on which the user has placed Best Offers. <br><br> Set Include to true to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemListCustomizationType
     */
    public $BestOfferList;
    /**
     * The WonList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items on which the use has bid. <br><br> Set Include to true to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemListCustomizationType
     */
    public $WonList;
    /**
     * The LostList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items on which the user has bid on and lost. <br><br> Set Include to true to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemListCustomizationType
     */
    public $LostList;
    /**
     * The FavoriteSearches
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of searches that the user has saved in My eBay. Returned only if the user has saved searches. <br><br> Set Include to true to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\MyeBaySelectionType
     */
    public $FavoriteSearches;
    /**
     * The FavoriteSellers
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of favorite sellers that the user has saved in My eBay. Returned only if the user has saved a list of favorite sellers. <br><br> Set Include to true to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\MyeBaySelectionType
     */
    public $FavoriteSellers;
    /**
     * The SecondChanceOffer
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of Second Chance Offers made by the user. Returned only if the user has made Second Chance Offers. <br><br> Set Include to true to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\MyeBaySelectionType
     */
    public $SecondChanceOffer;
    /**
     * The BidAssistantList
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\BidAssistantListType
     */
    public $BidAssistantList;
    /**
     * The DeletedFromWonList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items the user has won, and subsequently deleted from their My eBay page. <br><br> Set Include to true to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemListCustomizationType
     */
    public $DeletedFromWonList;
    /**
     * The DeletedFromLostList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items (auctions) the user did not win and were subsequently deleted from their My eBay page. <br><br> Set Include to true to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemListCustomizationType
     */
    public $DeletedFromLostList;
    /**
     * The BuyingSummary
     * Meta informations extracted from the WSDL
     * - documentation: Returns a summary of the user's buying activity. <br><br> <span class="tablenote"><b>Note:</b> The buying summary container is not included in the response by default. To include a <b>BuyingSummary</b> element, add an <b>Include</b>
     * field set to <code>true</code> to the request. </span>
     * - minOccurs: 0
     * @var \ebay\StructType\ItemListCustomizationType
     */
    public $BuyingSummary;
    /**
     * The UserDefinedLists
     * Meta informations extracted from the WSDL
     * - documentation: Returns the user defined lists, which are lists created by the user in the eBay UI and filled with items, or sellers, or searches using the "Add to List" feature. <br><br> Set Include to true to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\MyeBaySelectionType
     */
    public $UserDefinedLists;
    /**
     * The HideVariations
     * Meta informations extracted from the WSDL
     * - documentation: If true, the Variations node is omitted for all multi-variation listings in the response. If false, the Variations node is returned for all multi-variation listings in the response. <br> <br> Please note that if the seller includes a
     * large number of variations in many listings, retrieving variations (setting this flag to false) may degrade the call's performance. Therefore, when this is false, you may need to reduce the total number of items you're requesting at once (by using
     * other input fields, such as Pagination).
     * - minOccurs: 0
     * @var bool
     */
    public $HideVariations;
    /**
     * Constructor method for GetMyeBayBuyingRequestType
     * @uses GetMyeBayBuyingRequestType::setWatchList()
     * @uses GetMyeBayBuyingRequestType::setBidList()
     * @uses GetMyeBayBuyingRequestType::setBestOfferList()
     * @uses GetMyeBayBuyingRequestType::setWonList()
     * @uses GetMyeBayBuyingRequestType::setLostList()
     * @uses GetMyeBayBuyingRequestType::setFavoriteSearches()
     * @uses GetMyeBayBuyingRequestType::setFavoriteSellers()
     * @uses GetMyeBayBuyingRequestType::setSecondChanceOffer()
     * @uses GetMyeBayBuyingRequestType::setBidAssistantList()
     * @uses GetMyeBayBuyingRequestType::setDeletedFromWonList()
     * @uses GetMyeBayBuyingRequestType::setDeletedFromLostList()
     * @uses GetMyeBayBuyingRequestType::setBuyingSummary()
     * @uses GetMyeBayBuyingRequestType::setUserDefinedLists()
     * @uses GetMyeBayBuyingRequestType::setHideVariations()
     * @param \ebay\StructType\ItemListCustomizationType $watchList
     * @param \ebay\StructType\ItemListCustomizationType $bidList
     * @param \ebay\StructType\ItemListCustomizationType $bestOfferList
     * @param \ebay\StructType\ItemListCustomizationType $wonList
     * @param \ebay\StructType\ItemListCustomizationType $lostList
     * @param \ebay\StructType\MyeBaySelectionType $favoriteSearches
     * @param \ebay\StructType\MyeBaySelectionType $favoriteSellers
     * @param \ebay\StructType\MyeBaySelectionType $secondChanceOffer
     * @param \ebay\StructType\BidAssistantListType $bidAssistantList
     * @param \ebay\StructType\ItemListCustomizationType $deletedFromWonList
     * @param \ebay\StructType\ItemListCustomizationType $deletedFromLostList
     * @param \ebay\StructType\ItemListCustomizationType $buyingSummary
     * @param \ebay\StructType\MyeBaySelectionType $userDefinedLists
     * @param bool $hideVariations
     */
    public function __construct(\ebay\StructType\ItemListCustomizationType $watchList = null, \ebay\StructType\ItemListCustomizationType $bidList = null, \ebay\StructType\ItemListCustomizationType $bestOfferList = null, \ebay\StructType\ItemListCustomizationType $wonList = null, \ebay\StructType\ItemListCustomizationType $lostList = null, \ebay\StructType\MyeBaySelectionType $favoriteSearches = null, \ebay\StructType\MyeBaySelectionType $favoriteSellers = null, \ebay\StructType\MyeBaySelectionType $secondChanceOffer = null, \ebay\StructType\BidAssistantListType $bidAssistantList = null, \ebay\StructType\ItemListCustomizationType $deletedFromWonList = null, \ebay\StructType\ItemListCustomizationType $deletedFromLostList = null, \ebay\StructType\ItemListCustomizationType $buyingSummary = null, \ebay\StructType\MyeBaySelectionType $userDefinedLists = null, $hideVariations = null)
    {
        $this
            ->setWatchList($watchList)
            ->setBidList($bidList)
            ->setBestOfferList($bestOfferList)
            ->setWonList($wonList)
            ->setLostList($lostList)
            ->setFavoriteSearches($favoriteSearches)
            ->setFavoriteSellers($favoriteSellers)
            ->setSecondChanceOffer($secondChanceOffer)
            ->setBidAssistantList($bidAssistantList)
            ->setDeletedFromWonList($deletedFromWonList)
            ->setDeletedFromLostList($deletedFromLostList)
            ->setBuyingSummary($buyingSummary)
            ->setUserDefinedLists($userDefinedLists)
            ->setHideVariations($hideVariations);
    }
    /**
     * Get WatchList value
     * @return \ebay\StructType\ItemListCustomizationType|null
     */
    public function getWatchList()
    {
        return $this->WatchList;
    }
    /**
     * Set WatchList value
     * @param \ebay\StructType\ItemListCustomizationType $watchList
     * @return \ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setWatchList(\ebay\StructType\ItemListCustomizationType $watchList = null)
    {
        $this->WatchList = $watchList;
        return $this;
    }
    /**
     * Get BidList value
     * @return \ebay\StructType\ItemListCustomizationType|null
     */
    public function getBidList()
    {
        return $this->BidList;
    }
    /**
     * Set BidList value
     * @param \ebay\StructType\ItemListCustomizationType $bidList
     * @return \ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setBidList(\ebay\StructType\ItemListCustomizationType $bidList = null)
    {
        $this->BidList = $bidList;
        return $this;
    }
    /**
     * Get BestOfferList value
     * @return \ebay\StructType\ItemListCustomizationType|null
     */
    public function getBestOfferList()
    {
        return $this->BestOfferList;
    }
    /**
     * Set BestOfferList value
     * @param \ebay\StructType\ItemListCustomizationType $bestOfferList
     * @return \ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setBestOfferList(\ebay\StructType\ItemListCustomizationType $bestOfferList = null)
    {
        $this->BestOfferList = $bestOfferList;
        return $this;
    }
    /**
     * Get WonList value
     * @return \ebay\StructType\ItemListCustomizationType|null
     */
    public function getWonList()
    {
        return $this->WonList;
    }
    /**
     * Set WonList value
     * @param \ebay\StructType\ItemListCustomizationType $wonList
     * @return \ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setWonList(\ebay\StructType\ItemListCustomizationType $wonList = null)
    {
        $this->WonList = $wonList;
        return $this;
    }
    /**
     * Get LostList value
     * @return \ebay\StructType\ItemListCustomizationType|null
     */
    public function getLostList()
    {
        return $this->LostList;
    }
    /**
     * Set LostList value
     * @param \ebay\StructType\ItemListCustomizationType $lostList
     * @return \ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setLostList(\ebay\StructType\ItemListCustomizationType $lostList = null)
    {
        $this->LostList = $lostList;
        return $this;
    }
    /**
     * Get FavoriteSearches value
     * @return \ebay\StructType\MyeBaySelectionType|null
     */
    public function getFavoriteSearches()
    {
        return $this->FavoriteSearches;
    }
    /**
     * Set FavoriteSearches value
     * @param \ebay\StructType\MyeBaySelectionType $favoriteSearches
     * @return \ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setFavoriteSearches(\ebay\StructType\MyeBaySelectionType $favoriteSearches = null)
    {
        $this->FavoriteSearches = $favoriteSearches;
        return $this;
    }
    /**
     * Get FavoriteSellers value
     * @return \ebay\StructType\MyeBaySelectionType|null
     */
    public function getFavoriteSellers()
    {
        return $this->FavoriteSellers;
    }
    /**
     * Set FavoriteSellers value
     * @param \ebay\StructType\MyeBaySelectionType $favoriteSellers
     * @return \ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setFavoriteSellers(\ebay\StructType\MyeBaySelectionType $favoriteSellers = null)
    {
        $this->FavoriteSellers = $favoriteSellers;
        return $this;
    }
    /**
     * Get SecondChanceOffer value
     * @return \ebay\StructType\MyeBaySelectionType|null
     */
    public function getSecondChanceOffer()
    {
        return $this->SecondChanceOffer;
    }
    /**
     * Set SecondChanceOffer value
     * @param \ebay\StructType\MyeBaySelectionType $secondChanceOffer
     * @return \ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setSecondChanceOffer(\ebay\StructType\MyeBaySelectionType $secondChanceOffer = null)
    {
        $this->SecondChanceOffer = $secondChanceOffer;
        return $this;
    }
    /**
     * Get BidAssistantList value
     * @return \ebay\StructType\BidAssistantListType|null
     */
    public function getBidAssistantList()
    {
        return $this->BidAssistantList;
    }
    /**
     * Set BidAssistantList value
     * @param \ebay\StructType\BidAssistantListType $bidAssistantList
     * @return \ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setBidAssistantList(\ebay\StructType\BidAssistantListType $bidAssistantList = null)
    {
        $this->BidAssistantList = $bidAssistantList;
        return $this;
    }
    /**
     * Get DeletedFromWonList value
     * @return \ebay\StructType\ItemListCustomizationType|null
     */
    public function getDeletedFromWonList()
    {
        return $this->DeletedFromWonList;
    }
    /**
     * Set DeletedFromWonList value
     * @param \ebay\StructType\ItemListCustomizationType $deletedFromWonList
     * @return \ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setDeletedFromWonList(\ebay\StructType\ItemListCustomizationType $deletedFromWonList = null)
    {
        $this->DeletedFromWonList = $deletedFromWonList;
        return $this;
    }
    /**
     * Get DeletedFromLostList value
     * @return \ebay\StructType\ItemListCustomizationType|null
     */
    public function getDeletedFromLostList()
    {
        return $this->DeletedFromLostList;
    }
    /**
     * Set DeletedFromLostList value
     * @param \ebay\StructType\ItemListCustomizationType $deletedFromLostList
     * @return \ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setDeletedFromLostList(\ebay\StructType\ItemListCustomizationType $deletedFromLostList = null)
    {
        $this->DeletedFromLostList = $deletedFromLostList;
        return $this;
    }
    /**
     * Get BuyingSummary value
     * @return \ebay\StructType\ItemListCustomizationType|null
     */
    public function getBuyingSummary()
    {
        return $this->BuyingSummary;
    }
    /**
     * Set BuyingSummary value
     * @param \ebay\StructType\ItemListCustomizationType $buyingSummary
     * @return \ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setBuyingSummary(\ebay\StructType\ItemListCustomizationType $buyingSummary = null)
    {
        $this->BuyingSummary = $buyingSummary;
        return $this;
    }
    /**
     * Get UserDefinedLists value
     * @return \ebay\StructType\MyeBaySelectionType|null
     */
    public function getUserDefinedLists()
    {
        return $this->UserDefinedLists;
    }
    /**
     * Set UserDefinedLists value
     * @param \ebay\StructType\MyeBaySelectionType $userDefinedLists
     * @return \ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setUserDefinedLists(\ebay\StructType\MyeBaySelectionType $userDefinedLists = null)
    {
        $this->UserDefinedLists = $userDefinedLists;
        return $this;
    }
    /**
     * Get HideVariations value
     * @return bool|null
     */
    public function getHideVariations()
    {
        return $this->HideVariations;
    }
    /**
     * Set HideVariations value
     * @param bool $hideVariations
     * @return \ebay\StructType\GetMyeBayBuyingRequestType
     */
    public function setHideVariations($hideVariations = null)
    {
        $this->HideVariations = $hideVariations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetMyeBayBuyingRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
