<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyMessagesResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Conains information about the messages sent to a user. Depending on the detail level, this information can include message counts, resolution and flagged status, message headers, and message text.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetMyMessagesResponseType extends AbstractResponseType
{
    /**
     * The Summary
     * Meta informations extracted from the WSDL
     * - documentation: Summary data for a given user's messages. This includes the numbers of new messages, flagged messages, and total messages. The amount and type of data returned is the same whether or not the request includes specific MessageIDs.
     * Always/Conditionally returned logic assumes a detail level of ReturnMessages.
     * - minOccurs: 0
     * @var \ebay\StructType\MyMessagesSummaryType
     */
    public $Summary;
    /**
     * The Alerts
     * Meta informations extracted from the WSDL
     * - documentation: This container is deprecated.
     * - minOccurs: 0
     * @var \ebay\ArrayType\MyMessagesAlertArrayType
     */
    public $Alerts;
    /**
     * The Messages
     * Meta informations extracted from the WSDL
     * - documentation: Contains the message information for each message specified in MessageIDs. The amount and type of information returned varies based on the requested detail level. Contains one MyMessagesMessageType object per message. Returned as an
     * empty node if user has no messages.
     * - minOccurs: 0
     * @var \ebay\ArrayType\MyMessagesMessageArrayType
     */
    public $Messages;
    /**
     * Constructor method for GetMyMessagesResponseType
     * @uses GetMyMessagesResponseType::setSummary()
     * @uses GetMyMessagesResponseType::setAlerts()
     * @uses GetMyMessagesResponseType::setMessages()
     * @param \ebay\StructType\MyMessagesSummaryType $summary
     * @param \ebay\ArrayType\MyMessagesAlertArrayType $alerts
     * @param \ebay\ArrayType\MyMessagesMessageArrayType $messages
     */
    public function __construct(\ebay\StructType\MyMessagesSummaryType $summary = null, \ebay\ArrayType\MyMessagesAlertArrayType $alerts = null, \ebay\ArrayType\MyMessagesMessageArrayType $messages = null)
    {
        $this
            ->setSummary($summary)
            ->setAlerts($alerts)
            ->setMessages($messages);
    }
    /**
     * Get Summary value
     * @return \ebay\StructType\MyMessagesSummaryType|null
     */
    public function getSummary()
    {
        return $this->Summary;
    }
    /**
     * Set Summary value
     * @param \ebay\StructType\MyMessagesSummaryType $summary
     * @return \ebay\StructType\GetMyMessagesResponseType
     */
    public function setSummary(\ebay\StructType\MyMessagesSummaryType $summary = null)
    {
        $this->Summary = $summary;
        return $this;
    }
    /**
     * Get Alerts value
     * @return \ebay\ArrayType\MyMessagesAlertArrayType|null
     */
    public function getAlerts()
    {
        return $this->Alerts;
    }
    /**
     * Set Alerts value
     * @param \ebay\ArrayType\MyMessagesAlertArrayType $alerts
     * @return \ebay\StructType\GetMyMessagesResponseType
     */
    public function setAlerts(\ebay\ArrayType\MyMessagesAlertArrayType $alerts = null)
    {
        $this->Alerts = $alerts;
        return $this;
    }
    /**
     * Get Messages value
     * @return \ebay\ArrayType\MyMessagesMessageArrayType|null
     */
    public function getMessages()
    {
        return $this->Messages;
    }
    /**
     * Set Messages value
     * @param \ebay\ArrayType\MyMessagesMessageArrayType $messages
     * @return \ebay\StructType\GetMyMessagesResponseType
     */
    public function setMessages(\ebay\ArrayType\MyMessagesMessageArrayType $messages = null)
    {
        $this->Messages = $messages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetMyMessagesResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
