<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetItemRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Returns item data such as title, description, price information, seller information, and so on, for the specified <b>ItemID</b>. &nbsp;<b>Also for Half.com</b>.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetItemRequestType extends AbstractRequestType
{
    /**
     * The ItemID
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the <b>ItemID</b> that uniquely identifies the item listing for which to retrieve the data. <br><br> <b>ItemID</b> is a required input in most cases. <b>SKU</b> can be used instead in certain cases (see the description of
     * SKU). If both <b>ItemID</b> and <b>SKU</b> are specified for items where the inventory tracking method is <b>ItemID</b>, <b>ItemID</b> takes precedence. | Type that represents the unique identifier for a single item listing.
     * - minOccurs: 0
     * @var string
     */
    public $ItemID;
    /**
     * The IncludeWatchCount
     * Meta informations extracted from the WSDL
     * - documentation: Indicates if the caller wants to include watch count for that item in the response. You must be the seller of the item to retrieve the watch count.
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeWatchCount;
    /**
     * The IncludeCrossPromotion
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeCrossPromotion;
    /**
     * The IncludeItemSpecifics
     * Meta informations extracted from the WSDL
     * - documentation: If <code>true</code>, the response returns the <b>ItemSpecifics</b> node (if the listing has custom Item Specifics).<br> <br> Item Specifics are well-known aspects of items in a given category. For example, items in a washer and
     * dryer category might have an aspect like Type=Top-Loading; whereas items in a jewelry category might have an aspect like Gemstone=Amber.<br> <br> Including this field set to <code>true</code> also returns the <strong>UnitInfo</strong> node, which
     * enables European Union sellers to provide the required price-per-unit information so buyers can accurately compare prices for certain types of products.
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeItemSpecifics;
    /**
     * The IncludeTaxTable
     * Meta informations extracted from the WSDL
     * - documentation: If true, an associated tax table is returned in the response. If no tax table is associated with the item, then no tax table is returned, even if <b>IncludeTaxTable</b> is set to true.
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeTaxTable;
    /**
     * The SKU
     * Meta informations extracted from the WSDL
     * - documentation: Retrieves an item that was listed by the user identified in AuthToken and that is being tracked by this SKU.<br> <br> A SKU (stock keeping unit) is an identifier defined by a seller. Some sellers use SKUs to track complex flows of
     * products and information on the client side. eBay preserves the SKU on the item, enabling you to obtain it before and after an order line item is created. (SKU is recommended as an alternative to ApplicationData.)<br> <br> In <b>GetItem</b>,
     * <b>SKU</b> can only be used to retrieve one of your own items, where you listed the item by using <b>AddFixedPriceItem</b> or <b>RelistFixedPriceItem</b>, and you set <b>Item.InventoryTrackingMethod</b> to <b>SKU</b> at the time the item was listed.
     * (These criteria are necessary to uniquely identify the listing by a SKU.)<br> <br> Either <b>ItemID</b> or <b>SKU</b> is required in the request. If both are passed, they must refer to the same item, and that item must have
     * <b>InventoryTrackingMethod</b> set to <b>/SKU<b>. | Primitive type that represents a stock-keeping unit (SKU). The usage of this string may vary in different contexts. For usage information and rules, see the fields that reference this type.
     * - minOccurs: 0
     * @var string
     */
    public $SKU;
    /**
     * The VariationSKU
     * Meta informations extracted from the WSDL
     * - documentation: Variation-level SKU that uniquely identifes a Variation within the listing identified by <b>ItemID</b>. Only applicable when the seller listed the item with Variation-level SKU (<b>Variation.SKU</b>) values. Retrieves all the usual
     * <b>Item</b> fields, but limits the <b>Variations</b> content to the specified Variation. If not specified, the response includes all Variations. | Primitive type that represents a stock-keeping unit (SKU). The usage of this string may vary in
     * different contexts. For usage information and rules, see the fields that reference this type.
     * - minOccurs: 0
     * @var string
     */
    public $VariationSKU;
    /**
     * The VariationSpecifics
     * Meta informations extracted from the WSDL
     * - documentation: Name-value pairs that identify one or more Variations within the listing identified by <b>ItemID</b>. Only applicable when the seller listed the item with Variations. Retrieves all the usual <b>Item</b> fields, but limits the
     * Variations content to the specified Variation(s). If the specified pairs do not match any Variation, eBay returns all Variations.<br> <br> To retrieve only one variation, specify the full set of name/value pairs that match all the name-value pairs of
     * one Variation. <br> <br> To retrieve multiple variations (using a wildcard), specify one or more name/value pairs that partially match the desired variations. For example, if the listing contains Variations for shirts in different colors and sizes,
     * specify Color as Red (and no other name/value pairs) to retrieve all the red shirts in all sizes (but no other colors).
     * - minOccurs: 0
     * @var \ebay\ArrayType\NameValueListArrayType
     */
    public $VariationSpecifics;
    /**
     * The TransactionID
     * Meta informations extracted from the WSDL
     * - documentation: A unique identifier for an order line item (transaction). An order line item is created when a buyer commits to purchasing an item. <br><br> Since you can change active multiple-quantity fixed-price listings even after one of the
     * items has been purchased, the <b>TransactionID</b> is associated with a snapshot of the item data at the time of the purchase. <br><br> After one item in a multi-quantity listing has been sold, sellers can not change the values in the Title, Primary
     * Category, Secondary Category, Listing Duration, and Listing Type fields. However, all other fields are editable. <br><br> Specifying a <b>TransactionID</b> in the <b>GetItem</b> request allows you to retrieve a snapshot of the listing as it was when
     * the order line item was created.
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The IncludeItemCompatibilityList
     * Meta informations extracted from the WSDL
     * - documentation: This field is used to specify whether or not to retrieve Parts Compatiblity information. If true, any compatible applications associated with the item will be returned in the response (<b class="con"> Item.ItemCompatibilityList</b>).
     * If no compatible applications have been specified for the item, no item compatibilities will be returned. <br><br> If false or not specified, the response will return a compatibility count (<b class="con">ItemCompatibilityCoun</b>t) when parts
     * compatibilities have been specified for the item. <br><br> Parts Compatibility is supported in limited Parts & Accessories categories for the eBay Motors (US) site (site ID 100) only.
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeItemCompatibilityList;
    /**
     * Constructor method for GetItemRequestType
     * @uses GetItemRequestType::setItemID()
     * @uses GetItemRequestType::setIncludeWatchCount()
     * @uses GetItemRequestType::setIncludeCrossPromotion()
     * @uses GetItemRequestType::setIncludeItemSpecifics()
     * @uses GetItemRequestType::setIncludeTaxTable()
     * @uses GetItemRequestType::setSKU()
     * @uses GetItemRequestType::setVariationSKU()
     * @uses GetItemRequestType::setVariationSpecifics()
     * @uses GetItemRequestType::setTransactionID()
     * @uses GetItemRequestType::setIncludeItemCompatibilityList()
     * @param string $itemID
     * @param bool $includeWatchCount
     * @param bool $includeCrossPromotion
     * @param bool $includeItemSpecifics
     * @param bool $includeTaxTable
     * @param string $sKU
     * @param string $variationSKU
     * @param \ebay\ArrayType\NameValueListArrayType $variationSpecifics
     * @param string $transactionID
     * @param bool $includeItemCompatibilityList
     */
    public function __construct($itemID = null, $includeWatchCount = null, $includeCrossPromotion = null, $includeItemSpecifics = null, $includeTaxTable = null, $sKU = null, $variationSKU = null, \ebay\ArrayType\NameValueListArrayType $variationSpecifics = null, $transactionID = null, $includeItemCompatibilityList = null)
    {
        $this
            ->setItemID($itemID)
            ->setIncludeWatchCount($includeWatchCount)
            ->setIncludeCrossPromotion($includeCrossPromotion)
            ->setIncludeItemSpecifics($includeItemSpecifics)
            ->setIncludeTaxTable($includeTaxTable)
            ->setSKU($sKU)
            ->setVariationSKU($variationSKU)
            ->setVariationSpecifics($variationSpecifics)
            ->setTransactionID($transactionID)
            ->setIncludeItemCompatibilityList($includeItemCompatibilityList);
    }
    /**
     * Get ItemID value
     * @return string|null
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param string $itemID
     * @return \ebay\StructType\GetItemRequestType
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: string
        if (!is_null($itemID) && !is_string($itemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get IncludeWatchCount value
     * @return bool|null
     */
    public function getIncludeWatchCount()
    {
        return $this->IncludeWatchCount;
    }
    /**
     * Set IncludeWatchCount value
     * @param bool $includeWatchCount
     * @return \ebay\StructType\GetItemRequestType
     */
    public function setIncludeWatchCount($includeWatchCount = null)
    {
        $this->IncludeWatchCount = $includeWatchCount;
        return $this;
    }
    /**
     * Get IncludeCrossPromotion value
     * @return bool|null
     */
    public function getIncludeCrossPromotion()
    {
        return $this->IncludeCrossPromotion;
    }
    /**
     * Set IncludeCrossPromotion value
     * @param bool $includeCrossPromotion
     * @return \ebay\StructType\GetItemRequestType
     */
    public function setIncludeCrossPromotion($includeCrossPromotion = null)
    {
        $this->IncludeCrossPromotion = $includeCrossPromotion;
        return $this;
    }
    /**
     * Get IncludeItemSpecifics value
     * @return bool|null
     */
    public function getIncludeItemSpecifics()
    {
        return $this->IncludeItemSpecifics;
    }
    /**
     * Set IncludeItemSpecifics value
     * @param bool $includeItemSpecifics
     * @return \ebay\StructType\GetItemRequestType
     */
    public function setIncludeItemSpecifics($includeItemSpecifics = null)
    {
        $this->IncludeItemSpecifics = $includeItemSpecifics;
        return $this;
    }
    /**
     * Get IncludeTaxTable value
     * @return bool|null
     */
    public function getIncludeTaxTable()
    {
        return $this->IncludeTaxTable;
    }
    /**
     * Set IncludeTaxTable value
     * @param bool $includeTaxTable
     * @return \ebay\StructType\GetItemRequestType
     */
    public function setIncludeTaxTable($includeTaxTable = null)
    {
        $this->IncludeTaxTable = $includeTaxTable;
        return $this;
    }
    /**
     * Get SKU value
     * @return string|null
     */
    public function getSKU()
    {
        return $this->SKU;
    }
    /**
     * Set SKU value
     * @param string $sKU
     * @return \ebay\StructType\GetItemRequestType
     */
    public function setSKU($sKU = null)
    {
        // validation for constraint: string
        if (!is_null($sKU) && !is_string($sKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sKU)), __LINE__);
        }
        $this->SKU = $sKU;
        return $this;
    }
    /**
     * Get VariationSKU value
     * @return string|null
     */
    public function getVariationSKU()
    {
        return $this->VariationSKU;
    }
    /**
     * Set VariationSKU value
     * @param string $variationSKU
     * @return \ebay\StructType\GetItemRequestType
     */
    public function setVariationSKU($variationSKU = null)
    {
        // validation for constraint: string
        if (!is_null($variationSKU) && !is_string($variationSKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($variationSKU)), __LINE__);
        }
        $this->VariationSKU = $variationSKU;
        return $this;
    }
    /**
     * Get VariationSpecifics value
     * @return \ebay\ArrayType\NameValueListArrayType|null
     */
    public function getVariationSpecifics()
    {
        return $this->VariationSpecifics;
    }
    /**
     * Set VariationSpecifics value
     * @param \ebay\ArrayType\NameValueListArrayType $variationSpecifics
     * @return \ebay\StructType\GetItemRequestType
     */
    public function setVariationSpecifics(\ebay\ArrayType\NameValueListArrayType $variationSpecifics = null)
    {
        $this->VariationSpecifics = $variationSpecifics;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \ebay\StructType\GetItemRequestType
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get IncludeItemCompatibilityList value
     * @return bool|null
     */
    public function getIncludeItemCompatibilityList()
    {
        return $this->IncludeItemCompatibilityList;
    }
    /**
     * Set IncludeItemCompatibilityList value
     * @param bool $includeItemCompatibilityList
     * @return \ebay\StructType\GetItemRequestType
     */
    public function setIncludeItemCompatibilityList($includeItemCompatibilityList = null)
    {
        $this->IncludeItemCompatibilityList = $includeItemCompatibilityList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetItemRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
