<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlatRateInsuranceRangeCostType StructType
 * Meta informations extracted from the WSDL
 * - documentation: This type is used by the <b>FlatRateInsuranceRangeCost</b> container to specify the shipping insurance cost and price range for domestic and international flat-rate shipping.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class FlatRateInsuranceRangeCostType extends AbstractStructBase
{
    /**
     * The FlatRateInsuranceRange
     * Meta informations extracted from the WSDL
     * - documentation: The enumeration value in this field indicates the cost range that will be used if a seller is offering flat-rate shipping insurance to buyers.
     * - minOccurs: 0
     * @var string
     */
    public $FlatRateInsuranceRange;
    /**
     * The InsuranceCost
     * Meta informations extracted from the WSDL
     * - documentation: This field indicates the actual cost to buyers for flat-rate shipping insurance. This cost should fall into the price range specified in the <b>FlatRateInsuranceRange</b> field.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $InsuranceCost;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for FlatRateInsuranceRangeCostType
     * @uses FlatRateInsuranceRangeCostType::setFlatRateInsuranceRange()
     * @uses FlatRateInsuranceRangeCostType::setInsuranceCost()
     * @uses FlatRateInsuranceRangeCostType::setAny()
     * @param string $flatRateInsuranceRange
     * @param \ebay\StructType\AmountType $insuranceCost
     * @param \DOMDocument $any
     */
    public function __construct($flatRateInsuranceRange = null, \ebay\StructType\AmountType $insuranceCost = null, \DOMDocument $any = null)
    {
        $this
            ->setFlatRateInsuranceRange($flatRateInsuranceRange)
            ->setInsuranceCost($insuranceCost)
            ->setAny($any);
    }
    /**
     * Get FlatRateInsuranceRange value
     * @return string|null
     */
    public function getFlatRateInsuranceRange()
    {
        return $this->FlatRateInsuranceRange;
    }
    /**
     * Set FlatRateInsuranceRange value
     * @uses \ebay\EnumType\FlatRateInsuranceRangeCodeType::valueIsValid()
     * @uses \ebay\EnumType\FlatRateInsuranceRangeCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flatRateInsuranceRange
     * @return \ebay\StructType\FlatRateInsuranceRangeCostType
     */
    public function setFlatRateInsuranceRange($flatRateInsuranceRange = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\FlatRateInsuranceRangeCodeType::valueIsValid($flatRateInsuranceRange)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $flatRateInsuranceRange, implode(', ', \ebay\EnumType\FlatRateInsuranceRangeCodeType::getValidValues())), __LINE__);
        }
        $this->FlatRateInsuranceRange = $flatRateInsuranceRange;
        return $this;
    }
    /**
     * Get InsuranceCost value
     * @return \ebay\StructType\AmountType|null
     */
    public function getInsuranceCost()
    {
        return $this->InsuranceCost;
    }
    /**
     * Set InsuranceCost value
     * @param \ebay\StructType\AmountType $insuranceCost
     * @return \ebay\StructType\FlatRateInsuranceRangeCostType
     */
    public function setInsuranceCost(\ebay\StructType\AmountType $insuranceCost = null)
    {
        $this->InsuranceCost = $insuranceCost;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\FlatRateInsuranceRangeCostType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\FlatRateInsuranceRangeCostType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\FlatRateInsuranceRangeCostType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
