<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryDetailsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: This type is used by the <b>DeliveryDetails</b> container that is returned by <b>GetOrders</b> and other order management calls. The <b>DeliveryDetails</b> container is only applicable and returned if the buyer purchased a digital
 * gift card, and is either keeping the gift card or giving that gift card to another person.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class DeliveryDetailsType extends AbstractStructBase
{
    /**
     * The Recipient
     * Meta informations extracted from the WSDL
     * - documentation: This container consists of the name and email of the person who is receiving the digital gift card. If the buyer has purchased the gift card for themselves, the buyer's name and email will appear in this container. If the buyer is
     * giving the gift card to another individual, that individual's name and email will appear in this container. This container is always returned for a digital gift card line item.
     * - minOccurs: 0
     * @var \ebay\StructType\DigitalDeliveryUserType
     */
    public $Recipient;
    /**
     * The Sender
     * Meta informations extracted from the WSDL
     * - documentation: This container consists of the name and email of the person who purchased the digital gift card. This container is only returned if the purchaser of the digital gift card is giving the gift card to someone else, and that individual's
     * name and email will appear in the <strong>Recipient</strong> container.
     * - minOccurs: 0
     * @var \ebay\StructType\DigitalDeliveryUserType
     */
    public $Sender;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for DeliveryDetailsType
     * @uses DeliveryDetailsType::setRecipient()
     * @uses DeliveryDetailsType::setSender()
     * @uses DeliveryDetailsType::setAny()
     * @param \ebay\StructType\DigitalDeliveryUserType $recipient
     * @param \ebay\StructType\DigitalDeliveryUserType $sender
     * @param \DOMDocument $any
     */
    public function __construct(\ebay\StructType\DigitalDeliveryUserType $recipient = null, \ebay\StructType\DigitalDeliveryUserType $sender = null, \DOMDocument $any = null)
    {
        $this
            ->setRecipient($recipient)
            ->setSender($sender)
            ->setAny($any);
    }
    /**
     * Get Recipient value
     * @return \ebay\StructType\DigitalDeliveryUserType|null
     */
    public function getRecipient()
    {
        return $this->Recipient;
    }
    /**
     * Set Recipient value
     * @param \ebay\StructType\DigitalDeliveryUserType $recipient
     * @return \ebay\StructType\DeliveryDetailsType
     */
    public function setRecipient(\ebay\StructType\DigitalDeliveryUserType $recipient = null)
    {
        $this->Recipient = $recipient;
        return $this;
    }
    /**
     * Get Sender value
     * @return \ebay\StructType\DigitalDeliveryUserType|null
     */
    public function getSender()
    {
        return $this->Sender;
    }
    /**
     * Set Sender value
     * @param \ebay\StructType\DigitalDeliveryUserType $sender
     * @return \ebay\StructType\DeliveryDetailsType
     */
    public function setSender(\ebay\StructType\DigitalDeliveryUserType $sender = null)
    {
        $this->Sender = $sender;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\DeliveryDetailsType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\DeliveryDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\DeliveryDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
