<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BidGroupItemType StructType
 * Meta informations extracted from the WSDL
 * - documentation: This type is deprecated.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class BidGroupItemType extends AbstractStructBase
{
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemType
     */
    public $Item;
    /**
     * The BidGroupItemStatus
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $BidGroupItemStatus;
    /**
     * The MaxBidAmount
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $MaxBidAmount;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for BidGroupItemType
     * @uses BidGroupItemType::setItem()
     * @uses BidGroupItemType::setBidGroupItemStatus()
     * @uses BidGroupItemType::setMaxBidAmount()
     * @uses BidGroupItemType::setAny()
     * @param \ebay\StructType\ItemType $item
     * @param string $bidGroupItemStatus
     * @param \ebay\StructType\AmountType $maxBidAmount
     * @param \DOMDocument $any
     */
    public function __construct(\ebay\StructType\ItemType $item = null, $bidGroupItemStatus = null, \ebay\StructType\AmountType $maxBidAmount = null, \DOMDocument $any = null)
    {
        $this
            ->setItem($item)
            ->setBidGroupItemStatus($bidGroupItemStatus)
            ->setMaxBidAmount($maxBidAmount)
            ->setAny($any);
    }
    /**
     * Get Item value
     * @return \ebay\StructType\ItemType|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \ebay\StructType\ItemType $item
     * @return \ebay\StructType\BidGroupItemType
     */
    public function setItem(\ebay\StructType\ItemType $item = null)
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Get BidGroupItemStatus value
     * @return string|null
     */
    public function getBidGroupItemStatus()
    {
        return $this->BidGroupItemStatus;
    }
    /**
     * Set BidGroupItemStatus value
     * @uses \ebay\EnumType\BidGroupItemStatusCodeType::valueIsValid()
     * @uses \ebay\EnumType\BidGroupItemStatusCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bidGroupItemStatus
     * @return \ebay\StructType\BidGroupItemType
     */
    public function setBidGroupItemStatus($bidGroupItemStatus = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\BidGroupItemStatusCodeType::valueIsValid($bidGroupItemStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bidGroupItemStatus, implode(', ', \ebay\EnumType\BidGroupItemStatusCodeType::getValidValues())), __LINE__);
        }
        $this->BidGroupItemStatus = $bidGroupItemStatus;
        return $this;
    }
    /**
     * Get MaxBidAmount value
     * @return \ebay\StructType\AmountType|null
     */
    public function getMaxBidAmount()
    {
        return $this->MaxBidAmount;
    }
    /**
     * Set MaxBidAmount value
     * @param \ebay\StructType\AmountType $maxBidAmount
     * @return \ebay\StructType\BidGroupItemType
     */
    public function setMaxBidAmount(\ebay\StructType\AmountType $maxBidAmount = null)
    {
        $this->MaxBidAmount = $maxBidAmount;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\BidGroupItemType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\BidGroupItemType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\BidGroupItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
