<?php

namespace ebay\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ve ServiceType
 * @subpackage Services
 * @date 2017-04-07 16
 */
class Ve extends AbstractSoapClientBase
{
    /**
     * Sets the RequesterCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \ebay\StructType\CustomSecurityHeaderType $requesterCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequesterCredentials(\ebay\StructType\CustomSecurityHeaderType $requesterCredentials, $nameSpace = 'urn:ebay:apis:eBLBaseComponents', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequesterCredentials', $requesterCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named VeROReportItems
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\VeROReportItemsRequestType $veROReportItemsRequest
     * @return \ebay\StructType\VeROReportItemsResponseType|bool
     */
    public function VeROReportItems(\ebay\StructType\VeROReportItemsRequestType $veROReportItemsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->VeROReportItems($veROReportItemsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ebay\StructType\VeROReportItemsResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
