<?php

namespace ebay\EnumType;

/**
 * This class stands for ClassifiedAdBestOfferEnabledCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumerated type that defines the values used to indicate whether Best Offers for the Classified Ad listing format are enabled/disabled for all/most of a site's categories (<b>SiteDefaults.ClassifiedAdBestOfferEnabled</b>), or
 * enabled/required/disabled for a specific eBay category (<b>Category.ClassifiedAdBestOfferEnabled</b>).
 * @subpackage Enumerations
 * @date 2017-04-07 16
 */
class ClassifiedAdBestOfferEnabledCodeType
{
    /**
     * Constant for value 'Disabled'
     * @return string 'Disabled'
     */
    const VALUE_DISABLED = 'Disabled';
    /**
     * Constant for value 'Enabled'
     * @return string 'Enabled'
     */
    const VALUE_ENABLED = 'Enabled';
    /**
     * Constant for value 'Required'
     * @return string 'Required'
     */
    const VALUE_REQUIRED = 'Required';
    /**
     * Constant for value 'CustomCode'
     * @return string 'CustomCode'
     */
    const VALUE_CUSTOM_CODE = 'CustomCode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DISABLED
     * @uses self::VALUE_ENABLED
     * @uses self::VALUE_REQUIRED
     * @uses self::VALUE_CUSTOM_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISABLED,
            self::VALUE_ENABLED,
            self::VALUE_REQUIRED,
            self::VALUE_CUSTOM_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
