<?php

namespace ebay\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for OfferArrayType ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: Container for a list of offers. May contain zero, one, or multiple OfferType objects, each of which represents one offer extended by a user on a listing.
 * @subpackage Arrays
 * @date 2017-04-07 16
 */
class OfferArrayType extends AbstractStructArrayBase
{
    /**
     * The Offer
     * Meta informations extracted from the WSDL
     * - documentation: Contains the data for one offer. This includes: data for the user making the offer, the amount of the offer, the quantity of items being bought from the listing, the type of offer being made, and more.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\OfferType[]
     */
    public $Offer;
    /**
     * Constructor method for OfferArrayType
     * @uses OfferArrayType::setOffer()
     * @param \ebay\StructType\OfferType[] $offer
     */
    public function __construct(array $offer = array())
    {
        $this
            ->setOffer($offer);
    }
    /**
     * Get Offer value
     * @return \ebay\StructType\OfferType[]|null
     */
    public function getOffer()
    {
        return $this->Offer;
    }
    /**
     * Set Offer value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\OfferType[] $offer
     * @return \ebay\ArrayType\OfferArrayType
     */
    public function setOffer(array $offer = array())
    {
        foreach ($offer as $offerArrayTypeOfferItem) {
            // validation for constraint: itemType
            if (!$offerArrayTypeOfferItem instanceof \ebay\StructType\OfferType) {
                throw new \InvalidArgumentException(sprintf('The Offer property can only contain items of \ebay\StructType\OfferType, "%s" given', is_object($offerArrayTypeOfferItem) ? get_class($offerArrayTypeOfferItem) : gettype($offerArrayTypeOfferItem)), __LINE__);
            }
        }
        $this->Offer = $offer;
        return $this;
    }
    /**
     * Add item to Offer value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\OfferType $item
     * @return \ebay\ArrayType\OfferArrayType
     */
    public function addToOffer(\ebay\StructType\OfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\OfferType) {
            throw new \InvalidArgumentException(sprintf('The Offer property can only contain items of \ebay\StructType\OfferType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Offer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ebay\StructType\OfferType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ebay\StructType\OfferType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ebay\StructType\OfferType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ebay\StructType\OfferType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ebay\StructType\OfferType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Offer
     */
    public function getAttributeName()
    {
        return 'Offer';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\ArrayType\OfferArrayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
