<?php

namespace ebay\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for NotificationDetailsArrayType ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: Returns information about notifications sent to the given application for the given ItemID. It will only be returned if ItemID was specified in the input parameters.
 * @subpackage Arrays
 * @date 2017-04-07 16
 */
class NotificationDetailsArrayType extends AbstractStructArrayBase
{
    /**
     * The NotificationDetails
     * Meta informations extracted from the WSDL
     * - documentation: List of notifications, if there are any, for the given ItemID and given time period.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\NotificationDetailsType[]
     */
    public $NotificationDetails;
    /**
     * Constructor method for NotificationDetailsArrayType
     * @uses NotificationDetailsArrayType::setNotificationDetails()
     * @param \ebay\StructType\NotificationDetailsType[] $notificationDetails
     */
    public function __construct(array $notificationDetails = array())
    {
        $this
            ->setNotificationDetails($notificationDetails);
    }
    /**
     * Get NotificationDetails value
     * @return \ebay\StructType\NotificationDetailsType[]|null
     */
    public function getNotificationDetails()
    {
        return $this->NotificationDetails;
    }
    /**
     * Set NotificationDetails value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\NotificationDetailsType[] $notificationDetails
     * @return \ebay\ArrayType\NotificationDetailsArrayType
     */
    public function setNotificationDetails(array $notificationDetails = array())
    {
        foreach ($notificationDetails as $notificationDetailsArrayTypeNotificationDetailsItem) {
            // validation for constraint: itemType
            if (!$notificationDetailsArrayTypeNotificationDetailsItem instanceof \ebay\StructType\NotificationDetailsType) {
                throw new \InvalidArgumentException(sprintf('The NotificationDetails property can only contain items of \ebay\StructType\NotificationDetailsType, "%s" given', is_object($notificationDetailsArrayTypeNotificationDetailsItem) ? get_class($notificationDetailsArrayTypeNotificationDetailsItem) : gettype($notificationDetailsArrayTypeNotificationDetailsItem)), __LINE__);
            }
        }
        $this->NotificationDetails = $notificationDetails;
        return $this;
    }
    /**
     * Add item to NotificationDetails value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\NotificationDetailsType $item
     * @return \ebay\ArrayType\NotificationDetailsArrayType
     */
    public function addToNotificationDetails(\ebay\StructType\NotificationDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\NotificationDetailsType) {
            throw new \InvalidArgumentException(sprintf('The NotificationDetails property can only contain items of \ebay\StructType\NotificationDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NotificationDetails[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ebay\StructType\NotificationDetailsType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ebay\StructType\NotificationDetailsType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ebay\StructType\NotificationDetailsType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ebay\StructType\NotificationDetailsType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ebay\StructType\NotificationDetailsType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NotificationDetails
     */
    public function getAttributeName()
    {
        return 'NotificationDetails';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\ArrayType\NotificationDetailsArrayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
