<?php

namespace ebay\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ItemRatingDetailArrayType ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: Container for a set of detailed seller ratings about an order line item. If a seller has detailed ratings, they are displayed in the Feedback Profile of the seller.
 * @subpackage Arrays
 * @date 2017-04-07 16
 */
class ItemRatingDetailArrayType extends AbstractStructArrayBase
{
    /**
     * The ItemRatingDetails
     * Meta informations extracted from the WSDL
     * - documentation: The ItemRatingDetails container is for detailed seller ratings about an order line item. When buyers leave an overall Feedback rating (positive, neutral, or negative) for a seller, they also can leave ratings in four areas: item as
     * described, communication, shipping time, and charges for shipping and handling. Users retrieve detailed ratings as averages of the ratings left by buyers. <br><br> Applicable to sites that support the Detailed Seller Ratings feature.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\ItemRatingDetailsType[]
     */
    public $ItemRatingDetails;
    /**
     * Constructor method for ItemRatingDetailArrayType
     * @uses ItemRatingDetailArrayType::setItemRatingDetails()
     * @param \ebay\StructType\ItemRatingDetailsType[] $itemRatingDetails
     */
    public function __construct(array $itemRatingDetails = array())
    {
        $this
            ->setItemRatingDetails($itemRatingDetails);
    }
    /**
     * Get ItemRatingDetails value
     * @return \ebay\StructType\ItemRatingDetailsType[]|null
     */
    public function getItemRatingDetails()
    {
        return $this->ItemRatingDetails;
    }
    /**
     * Set ItemRatingDetails value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ItemRatingDetailsType[] $itemRatingDetails
     * @return \ebay\ArrayType\ItemRatingDetailArrayType
     */
    public function setItemRatingDetails(array $itemRatingDetails = array())
    {
        foreach ($itemRatingDetails as $itemRatingDetailArrayTypeItemRatingDetailsItem) {
            // validation for constraint: itemType
            if (!$itemRatingDetailArrayTypeItemRatingDetailsItem instanceof \ebay\StructType\ItemRatingDetailsType) {
                throw new \InvalidArgumentException(sprintf('The ItemRatingDetails property can only contain items of \ebay\StructType\ItemRatingDetailsType, "%s" given', is_object($itemRatingDetailArrayTypeItemRatingDetailsItem) ? get_class($itemRatingDetailArrayTypeItemRatingDetailsItem) : gettype($itemRatingDetailArrayTypeItemRatingDetailsItem)), __LINE__);
            }
        }
        $this->ItemRatingDetails = $itemRatingDetails;
        return $this;
    }
    /**
     * Add item to ItemRatingDetails value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ItemRatingDetailsType $item
     * @return \ebay\ArrayType\ItemRatingDetailArrayType
     */
    public function addToItemRatingDetails(\ebay\StructType\ItemRatingDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\ItemRatingDetailsType) {
            throw new \InvalidArgumentException(sprintf('The ItemRatingDetails property can only contain items of \ebay\StructType\ItemRatingDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemRatingDetails[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ebay\StructType\ItemRatingDetailsType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ebay\StructType\ItemRatingDetailsType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ebay\StructType\ItemRatingDetailsType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ebay\StructType\ItemRatingDetailsType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ebay\StructType\ItemRatingDetailsType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItemRatingDetails
     */
    public function getAttributeName()
    {
        return 'ItemRatingDetails';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\ArrayType\ItemRatingDetailArrayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
