<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingDetailsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type defining the <b>ShippingDetails</b> container, which contains the shipping-related details for an item (pre-checkout) or order (post-checkout). <br/><br/> <span class="tablenote"> <strong>IMPORTANT:</strong> To avoid loss of
 * shipping details when revising a listing, you must include all <strong>ShippingDetails</strong> fields that were originally provided. Do not omit any tag, even if its value does not change. Omitting a shipping field when revising an item will remove
 * that detail from the listing. </span>
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class ShippingDetailsType extends AbstractStructBase
{
    /**
     * The AllowPaymentEdit
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated and has been replaced by the <b>ShippingDetails.PaymentEdited</b> field. <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var bool
     */
    public $AllowPaymentEdit;
    /**
     * The ApplyShippingDiscount
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var bool
     */
    public $ApplyShippingDiscount;
    /**
     * The GlobalShipping
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether eBay's Global Shipping Program is offered for the listing. If the value of <strong>GlobalShipping</strong> is True, the Global Shipping Program is the default international shipping option for the listing, and eBay
     * sets the international shipping service to International Priority Shipping. If the value of <strong>GlobalShipping</strong> is <code>false</code>, the seller is responsible for specifying an international shipping service for the listing if desired.
     * <br/><br/> When calling <strong>RelistFixedPriceItem</strong>, <strong>RelistItem</strong>, <strong>ReviseFixedPriceItem</strong> or <strong>ReviseItem</strong>, you can omit this field if its value doesn't need to change. <br/><br/> Before using
     * this field for a listing, ensure that the seller and the item being listed are eligible for the Global Shipping Program.
     * - minOccurs: 0
     * @var bool
     */
    public $GlobalShipping;
    /**
     * The CalculatedShippingRate
     * Meta informations extracted from the WSDL
     * - documentation: Details pertinent to one or more items for which calculated shipping has been offered by the seller, such as package dimension and weight and packaging/handling costs. If your call specifies a large-dimension item listed with UPS,
     * see <a href= "https://ebaydts.com/eBayKBDetails?KBid=1159" >Dimensional Weight limit on UPS shipping services results in failure of shipping calculator</a>. <br><br> Not applicable to Half.com. <br><br> <span class="tablenote"><strong>Note:</strong>
     * The <strong>CalculatedShippingRate</strong> container should only be used to specify values for the <strong>InternationalPackagingHandlingCosts</strong>, <strong>OriginatingPostalCode</strong>, and/or <strong>PackagingHandlingCosts</strong> fields.
     * The rest of the fields in the <strong>CalculatedShippingRate</strong> container are used to specify package dimensions and package weight, and these values should now be specified in the <strong>ShippingPackageDetails</strong> container instead.
     * </span>
     * - minOccurs: 0
     * @var \ebay\StructType\CalculatedShippingRateType
     */
    public $CalculatedShippingRate;
    /**
     * The ChangePaymentInstructions
     * Meta informations extracted from the WSDL
     * - documentation: Whether the seller specified payment and shipping instructions during checkout (for example, to update the details of an order). Valid for flat and calculated shipping. <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var bool
     */
    public $ChangePaymentInstructions;
    /**
     * The InsuranceWanted
     * Meta informations extracted from the WSDL
     * - documentation: Whether or not the buyer selected to pay for insurance as an option offered by the seller. This only has a value after the buyer has gone through checkout and selected the insurance preference. <br><br> Valid only on the following
     * sites: FR and IT <br> Applicable to Half.com for <b>GetOrders</b>.
     * - minOccurs: 0
     * @var bool
     */
    public $InsuranceWanted;
    /**
     * The PaymentEdited
     * Meta informations extracted from the WSDL
     * - documentation: Whether the seller allows the buyer to edit the payment amount for the order. (Sellers enable this property in their My eBay user preferences on the eBay site.) <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var bool
     */
    public $PaymentEdited;
    /**
     * The PaymentInstructions
     * Meta informations extracted from the WSDL
     * - documentation: Payment instructions (or message) from the seller to the buyer. These instructions appear on eBay's View Item page and on eBay's checkout page when the buyer pays for the item. <br><br> Sellers usually use this field to specify
     * payment instructions, how soon the item will shipped, feedback instructions, and other reminders that the buyer should be aware of when they bid on or buy an item. <br/><br/> This field can be specified regardless of the shipping type eBay only
     * allows 500 characters as input, but due to the way the eBay Web site UI treats characters, this field can return more than 500 characters in the response. Characters like & and ' (apostrophe/single quote) count as 5 characters each. Use
     * <b>DeletedField</b> to remove this value when revising or relisting an item. <br><br> Applicable to eBay Motors (usually used to elaborate on the return policy). <br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var string
     */
    public $PaymentInstructions;
    /**
     * The SalesTax
     * Meta informations extracted from the WSDL
     * - documentation: Sales tax details. US and US Motors (site 0) sites only, excluding vehicle listings. Flat and calculated shipping. <br><br> Applicable to Half.com (for <b>GetOrders</b>).
     * - minOccurs: 0
     * @var \ebay\StructType\SalesTaxType
     */
    public $SalesTax;
    /**
     * The ShippingRateErrorMessage
     * Meta informations extracted from the WSDL
     * - documentation: For most applicable calls, returns the words No Error or returns an error message related to an attempt to calculate shipping rates. For calculated shipping only. <br><br> The message text explains that a postal code is needed to
     * calculate shipping. Only returned when <b>ItemDetails</b> is set to <code>Fine</code>. <br><br> Not applicable to Half.com or eBay Motors vehicle listings.
     * - minOccurs: 0
     * @var string
     */
    public $ShippingRateErrorMessage;
    /**
     * The ShippingRateType
     * Meta informations extracted from the WSDL
     * - documentation: A shipping rate scale for shipping through USPS that affects the shipping cost calculated for USPS (lower if <strong>ShippingRateType</strong> is <code>DailyPickup</code>). <strong>ShippingRateType</strong> is returned only if the
     * value of <strong>ShippingService</strong> is one of the USPS shipping services. For calculated shipping only. <br><br> Not applicable to Half.com or eBay Motors vehicle listings.
     * - minOccurs: 0
     * @var string
     */
    public $ShippingRateType;
    /**
     * The ShippingServiceOptions
     * Meta informations extracted from the WSDL
     * - documentation: Shipping costs and options related to domestic shipping services offered by the seller. Flat and calculated shipping. Required if <b>InternationalShippingServiceOption</b> is specified. <br><br> For flat shipping, a maximum shipping
     * cost may apply when listing. See Shipping documentation for details about Maximum Flat Rate Shipping Costs. <br><br> If you specify multiple <b>ShippingServiceOptions</b> nodes, the repeating nodes must be contiguous. For example, you can insert
     * <b>InternationalShippingServiceOption</b> nodes after a list of repeating <b>ShippingServiceOptions</b> nodes, but not between them: <br><br> <code> &lt;ShippingServiceOptions&gt;...&lt;/ShippingServiceOptions&gt;<br>
     * &lt;ShippingServiceOptions&gt;...&lt;/ShippingServiceOptions&gt;<br> &lt;ShippingServiceOptions&gt;...&lt;/ShippingServiceOptions&gt;<br> &lt;InternationalShippingServiceOption&gt;...&lt;/InternationalShippingServiceOption&gt;<br>
     * &lt;InternationalShippingServiceOption&gt;...&lt;/InternationalShippingServiceOption&gt; </code> <br><br> If you specify <b>ShippingDetails</b> when you revise or relist an item but you omit <b>ShippingServiceOptions</b>, eBay will drop the domestic
     * shipping services from the listing. This may also have unintended side effects, as other fields that depend on this data may be dropped as well. <br/><br/> To retain the shipping services and dependent fields when you modify other shipping details,
     * it may be simplest to specify all <b>ShippingDetails</b> that you still want to include in the listing. <br><br> A seller can offer up to four domestic shipping services and up to five international shipping services. All specified domestic and
     * international shipping services must be the same shipping type (for example, Flat versus Calculated). <br><br> For <b>GetItemShipping</b>, results are filtered: if any service is not available in the buyer's region, it is removed. If no services
     * remain after this filtering, a warning is returned. <br><br> Not applicable to Half.com or eBay Motors vehicle listings.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\ShippingServiceOptionsType[]
     */
    public $ShippingServiceOptions;
    /**
     * The InternationalShippingServiceOption
     * Meta informations extracted from the WSDL
     * - documentation: Shipping costs and options related to an international shipping service. If used, at least one domestic shipping service must also be provided in <b>ShippingServiceOptions</b>. <br><br> If you specify multiple
     * <b>InternationalShippingServiceOption</b> nodes, the repeating nodes must be contiguous. That is, you cannot insert other nodes between <b>InternationalShippingServiceOption</b> nodes. <br><br> All specified domestic and international shipping
     * services must be the same shipping type (for example, Flat versus Calculated). <br><br> A seller can offer up to four domestic shipping services and up to five international shipping services. However, if the seller is opted in to the Global Shipping
     * Program, only four other international shipping services may be offered (regardless of whether or not Global Shipping is offered for the listing). <br><br> If you specify <b>ShippingDetails</b> when you revise or relist an item but you omit
     * <b>InternationalShippingServiceOption</b>, eBay will drop the international shipping services (except the Global Shipping Program) from the listing. This may also have unintended side effects, as other fields that depend on this data may be dropped
     * as well. To retain the shipping services and dependent fields when you modify other shipping details, it may be simplest to specify all <b>ShippingDetails</b> that you still want to include in the listing. <br><br> For <b>GetItemShipping</b>, results
     * are filtered: if any service is not available in the buyer's region, it is removed. If no services remain after this filtering, a warning is returned. <br><br> Not applicable to Half.com or eBay Motors vehicle listings.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\InternationalShippingServiceOptionsType[]
     */
    public $InternationalShippingServiceOption;
    /**
     * The ShippingType
     * Meta informations extracted from the WSDL
     * - documentation: The shipping cost model offered by the seller. This is not returned for various calls since shipping type can be deduced: if a <b>CalculatedShippingRate</b> structure is returned by the call, the shipping type is Calculated.
     * Otherwise, it is one of the other non-Calculated shipping types. <br><br> <b>GetItemShipping and GetItemTransactions</b>: If the type was a mix of flat and calculated services, this is set simply to Flat or Calculated because it is the buyer's
     * selection that results in one of these. <br><br> <b>GetMyeBayBuying</b>: If the seller has set the <b>ShipToLocation</b> to <code>Worldwide</code> for an item, but has not specified any international shipping service options,
     * <code>NotSpecified</code> is returned as the <b>ShippingType</b> value. <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var string
     */
    public $ShippingType;
    /**
     * The SellingManagerSalesRecordNumber
     * Meta informations extracted from the WSDL
     * - documentation: The sale record ID. Applicable to Selling Manager users. When an item is sold, Selling Manager generates a sale record. A sale record contains buyer information, shipping, and other information. A sale record is displayed in the Sold
     * view in Selling Manager. Each sale record has a sale record ID. <br/><br/> In the following calls, the value for the sale record ID is in the <b>SellingManagerSalesRecordNumber</b> field: <b>GetItemTransactions</b>, <b>GetSellerTransactions</b>,
     * <b>GetOrders</b>, <b>GetOrderTransactions</b>. In the Selling Manager calls, the value for the sale record ID is in the <b>SaleRecordID</b> field. <br/><br/> The sale record ID can be for a single or a multiple line item order. <br> Applicable to
     * Half.com (for <b>GetOrders</b>).
     * - minOccurs: 0
     * @var int
     */
    public $SellingManagerSalesRecordNumber;
    /**
     * The ThirdPartyCheckout
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var bool
     */
    public $ThirdPartyCheckout;
    /**
     * The TaxTable
     * Meta informations extracted from the WSDL
     * - documentation: Tax details for a jurisdiction, such as a state or province. If no tax table is associated with the item, a tax table is not returned. <br><br> For <b>GetItem</b>, a tax table is returned if it exists when: <ul>
     * <li><b>DetailLevel</b> is set to <code>ReturnAll</code> or <b>ItemReturnDescription</b> (in this case, the value of <b>IncludeTaxTable</b> does not matter)</li> <li><b>IncludeTaxTable</b> is set to <code>true</code> and <b>DetailLevel</b> is not set
     * or it is set to <code>ItemReturnAttributes</code></li> </ul> Not applicable to Half.com.
     * - minOccurs: 0
     * @var \ebay\StructType\TaxTableType
     */
    public $TaxTable;
    /**
     * The GetItFast
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var bool
     */
    public $GetItFast;
    /**
     * The ShippingServiceUsed
     * Meta informations extracted from the WSDL
     * - documentation: The shipping service actually used by the seller to ship the item(s) to the buyer. <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var string
     */
    public $ShippingServiceUsed;
    /**
     * The DefaultShippingCost
     * Meta informations extracted from the WSDL
     * - documentation: The field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $DefaultShippingCost;
    /**
     * The InsuranceDetails
     * Meta informations extracted from the WSDL
     * - documentation: Container for domestic insurance information. <br/><br/> <span class="tablenote"><b>Note: </b> There are fields named <b>InsuranceFee</b> and <b>InsuranceOption</b> at the same level as this container. These were once used for
     * representing both domestic and international insurance details. If this (newer) container is provided in the request and if <b>ShippingDetails.InsuranceFee</b> or <b>ShippingDetails.InsuranceOption</b> are also provided, the two (older fields) are
     * ignored. If this container is omitted on in the request, its <b>InsuranceFee</b> and <b>InsuranceOption</b> subfields are set to match whatever (the older fields) <b>ShippingDetails.InsuranceFee</b> and <b>ShippingDetails.InsuranceOption</b> are set
     * to. For flat and calculated shipping, depending on which subfields are used. </span> <br> Valid only on the following sites: FR and IT
     * - minOccurs: 0
     * @var \ebay\StructType\InsuranceDetailsType
     */
    public $InsuranceDetails;
    /**
     * The InternationalInsuranceDetails
     * Meta informations extracted from the WSDL
     * - documentation: Container for international insurance information. <br/><br/> <span class="tablenote"><b>Note: </b> There are fields named <b>InsuranceFee</b> and <b>InsuranceOption</b> at the same level as this container. These were once used for
     * representing both domestic and international insurance details. If this (newer) container is provided on input and if <b>ShippingDetails.InsuranceFee</b> or <b>ShippingDetails.InsuranceOption</b> are also provided, those two (older fields) are
     * ignored. If this container is omitted on input, its <b>InsuranceFee</b> and <b>InsuranceOption</b> subfields are set to match whatever (the older fields) are set to for flat and calculated shipping, depending on which subfields are used. </span>
     * <br><br> Valid only on the following sites: FR and IT
     * - minOccurs: 0
     * @var \ebay\StructType\InsuranceDetailsType
     */
    public $InternationalInsuranceDetails;
    /**
     * The ShippingDiscountProfileID
     * Meta informations extracted from the WSDL
     * - documentation: On input, this is the ID of the shipping discount to offer for the domestic shipping services (where the shipping discount is either of type <b>FlatShippingDiscount</b> or <b>CalculatedShippingDiscount</b>). <br/><br/> On output,
     * this is the ID of the shipping discount offered and corresponds to whichever is returned: <b>FlatShippingDiscount</b> or <b>CalculatedShippingDiscount</b>. Only returned if the calling user is the seller. <br/><br/> If the user created a shipping
     * discount profile, use the <b>ShippingDiscountProfileID</b>. <br><br> In the <b>RelistItem</b> and <b>ReviseItem</b> family of calls, you can remove the existing <b>ShippingDiscountProfileID</b> associated with the item by supplying a value of 0
     * (zero). <br><br> Only returned if the calling user is the seller.
     * - minOccurs: 0
     * @var string
     */
    public $ShippingDiscountProfileID;
    /**
     * The FlatShippingDiscount
     * Meta informations extracted from the WSDL
     * - documentation: If a flat rate shipping discount was offered for the domestic shipping services, this contains the details of the flat rate shipping discount. Otherwise, it is not returned. Only returned if the calling user is the seller.
     * - minOccurs: 0
     * @var \ebay\StructType\FlatShippingDiscountType
     */
    public $FlatShippingDiscount;
    /**
     * The CalculatedShippingDiscount
     * Meta informations extracted from the WSDL
     * - documentation: If a calculated shipping discount was offered for the domestic shipping services, this contains the details of the calculated shipping discount. Otherwise, it is not returned. Only returned if the calling user is the seller.
     * - minOccurs: 0
     * @var \ebay\StructType\CalculatedShippingDiscountType
     */
    public $CalculatedShippingDiscount;
    /**
     * The PromotionalShippingDiscount
     * Meta informations extracted from the WSDL
     * - documentation: On input, this specifies whether to offer the promotional shipping discount for the domestic shipping services of this listing (only applicable if the seller has a promotional shipping discount in effect at the moment). <br><br>
     * Returned on output only if the seller is making the call. This indicates whether the promotional shipping discount is being offered for the domestic shipping services of this listing (if the listing is still active&#8212;this is only possible if the
     * seller has a promotional shipping discount in effect at the moment) or whether the discount was offered at the time the listing ended.
     * - minOccurs: 0
     * @var bool
     */
    public $PromotionalShippingDiscount;
    /**
     * The InternationalShippingDiscountProfileID
     * Meta informations extracted from the WSDL
     * - documentation: On input, this is the ID of the shipping discount to offer for the international shipping services (where the shipping discount is either of type <b>FlatShippingDiscount</b> or <b>CalculatedShippingDiscount</b>). <br><br> In the
     * <b>RelistItem</b> and <b>ReviseItem</b> family of calls, you can remove the existing <b>InternationalShippingDiscountProfileID</b> associated with the item by supplying a value of 0 (zero). <br><br> Returned on output only if the seller is making the
     * call. The value is the ID of the shipping discount offered and corresponds to whichever is returned: <b>FlatShippingDiscount</b> or <b>CalculatedShippingDiscount</b>. <br><br> If the user created a shipping discount profile, use
     * <b>InternationalShippingDiscountProfileID</b>.
     * - minOccurs: 0
     * @var string
     */
    public $InternationalShippingDiscountProfileID;
    /**
     * The InternationalFlatShippingDiscount
     * Meta informations extracted from the WSDL
     * - documentation: This value is returned only if the seller is making the call. If a flat rate shipping discount was offered for the international shipping services, this contains the details of the flat rate shipping discount. Otherwise, it is not
     * returned.
     * - minOccurs: 0
     * @var \ebay\StructType\FlatShippingDiscountType
     */
    public $InternationalFlatShippingDiscount;
    /**
     * The InternationalCalculatedShippingDiscount
     * Meta informations extracted from the WSDL
     * - documentation: This value is returned only if the seller is making the call. If a calculated shipping discount was offered for the international shipping services, this contains the details of the calculated shipping discount. Otherwise, it is not
     * returned.
     * - minOccurs: 0
     * @var \ebay\StructType\CalculatedShippingDiscountType
     */
    public $InternationalCalculatedShippingDiscount;
    /**
     * The InternationalPromotionalShippingDiscount
     * Meta informations extracted from the WSDL
     * - documentation: On input, this specifies whether to offer the promotional shipping discount for the listing's international shipping services (only applicable if the seller has a promotional shipping discount in effect at the moment). <br><br>
     * Returned on output only if the seller is making the call. This value indicates whether the promotional shipping discount is being offered for the international shipping services of this listing (if the listing is still active&#8212;this is only
     * possible if the seller has a promotional shipping discount in effect at the moment) or whether the discount was offered at the time the listing ended.
     * - minOccurs: 0
     * @var bool
     */
    public $InternationalPromotionalShippingDiscount;
    /**
     * The PromotionalShippingDiscountDetails
     * Meta informations extracted from the WSDL
     * - documentation: This value is returned only if the seller is making the call. Contains details of the promotional shipping discount, if such is being offered while the listing is active or if it was offered at the time the listing ended.
     * - minOccurs: 0
     * @var \ebay\StructType\PromotionalShippingDiscountDetailsType
     */
    public $PromotionalShippingDiscountDetails;
    /**
     * The CODCost
     * Meta informations extracted from the WSDL
     * - documentation: This dollar value indicates the money due from the buyer upon delivery of the item. <br><br> This field should only be specified in the request if 'COD' (cash-on-delivery) is a valid payment method for the site and it is included as
     * a <b>PaymentMethods</b> value in the same request. <br><br> This field is only returned if set for the listing. <br><br> To see if 'COD' is a supported payment method for a site, call <b>GetCategoryFeatures</b>, specifying the listing category ID,
     * and including the <b>FeatureID</b> field set to <b>PaymentMethods</b>. Look for a value of 'CashOnPickup' in one of the <b>Category.PaymentMethod</b> fields in the response.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $CODCost;
    /**
     * The ExcludeShipToLocation
     * Meta informations extracted from the WSDL
     * - documentation: Use this field to specify an international country or region, or a special domestic location, such as 'PO Box' (in US) or 'Packstation' (in DE), to where you will not ship the associated item. Repeat this element in the call request
     * for each location that you want to exclude as a shipping destination for your item. <br><br> Set <b>ShipToRegistrationCountry</b> to <code>true</code> to have your <b>ExcludeShipToLocation</b> settings applied to your listing. The locations you have
     * excluded display in the Shipping and Handling section of your item listing. <br><br> If a buyer's primary ship-to location is a location that you have listed as an excluded ship-to location (or if the buyer does not have a primary ship-to location),
     * they will receive an error message if they attempt to buy or place a bid on your item. <br><br> The exclude ship-to location values are eBay regions and countries. To see the valid exclude ship-to locations for a specified site, call
     * <b>GeteBayDetails</b> with <b>DetailName</b> set to <b>ExcludeShippingLocationDetails</b>, and then look for the <b>ExcludeShippingLocationDetails.Location</b> fields in the response. Repeat <b>GeteBayDetails</b> for each site on which you list.
     * <br><br> This field works in conjunction with <b>Item.ShipToLocation</b>s to create a set of international countries and regions to where you will, and will not, ship. You can list a region in the <b>ShipToLocations</b> field, then exclude specific
     * countries within that region with this field (for example, you can specify Africa in <b>ShipToLocations</b>, yet exclude Chad with a <b>ExcludeShipToLocation</b> setting). In addition, if your <b>ShipToLocations</b> is <code>Worldwide</code>, you can
     * use this field to specify both regions and countries that you want to exclude from your shipping destinations. <br><br> You can specify a default set of locations to where you will not ship in My eBay. If you create an Exclude Ship-To List, it is, by
     * default, in effect when you list items. However, if you specify any value in this field on input, it nullifies the default settings in your Exclude Ship-To List. (If you use <b>ExcludeShipToLocation</b> when you list an item, you will need to list
     * all the locations to where you will not ship the associated item, regardless of the default settings in your Exclude Ship-To List.) <br><br> Specify <code>none</code> in this field to override the default Exclude Ship-To List you might have set up in
     * My eBay and indicate that you do not want to exclude any shipping locations from the respective item listing. <br><br> <span class="tablenote"><strong>Note:</strong> To enable your default Exclude Ship-To List, you must enable Exclude Shipping
     * Locations and Buyer Requirements in your My eBay Site Preferences. For details, see the KnowledgeBase Article <a href= "https://ebaydts.com/eBayKBDetails?KBid=1495" >HowTo: ExcludeShipToLocation</a>. </span>
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ExcludeShipToLocation;
    /**
     * The SellerExcludeShipToLocationsPreference
     * Meta informations extracted from the WSDL
     * - documentation: Sellers can set up a global Exclude Ship-To List through their My eBay account. The Exclude Ship-To List defines the countries to where the seller does not ship, by default. <br><br> This flag returns true if the Exclude Ship-To List
     * is enabled by the seller for the associated item. If <code>false</code>, the seller's Exclude Ship-To List is either not set up, or it has been overridden by the seller when they listed the item with ExcludeShipToLocation fields. <br><br> In the
     * response, <b>ExcludeShipToLocation</b> fields detail the locations to where the seller will not ship the item, regardless of the value returned in this field.
     * - minOccurs: 0
     * @var bool
     */
    public $SellerExcludeShipToLocationsPreference;
    /**
     * The ShipmentTrackingDetails
     * Meta informations extracted from the WSDL
     * - documentation: Container for the shipping carrier and tracking information associated with the shipment of an order. <br><br> As each package has a unique tracking number, this container should be repeated for each package in the order. <br> <br>
     * <span class="tablenote"><b>Note:</b> Top-rated sellers must have a record of uploading shipment tracking information (through site or through API) for at least 90 percent of their order line items (purchased by U.S. buyers) to keep their status as
     * Top-rated sellers. For more information on eBay's Top-rated seller program, see the <a href="http://pages.ebay.com/help/sell/top-rated.html">Becoming a Top Rated Seller and qualifying for Top Rated Plus</a> page. </span> <br>
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\ShipmentTrackingDetailsType[]
     */
    public $ShipmentTrackingDetails;
    /**
     * The RateTableDetails
     * Meta informations extracted from the WSDL
     * - documentation: This container specifies the shipping rate tables that are to be applied to this listing. Shipping rate tables enable sellers to tailor the flat shipping rates offered for an item to fit the shipping destination. They can specify a
     * shipping rate for a large <em>base</em> region, then define alternative rates or surcharges for shipping to other <em>extended</em> regions within the base region. <br><br> Prerequisites for applying shipping rate tables: <ul> <li>The shipping type
     * for the listing must be Flat. </li> <li>The seller must have previously configured a shipping rate table in My eBay site preferences. </li> </ul> In a domestic shipping rate table, sellers can specify an alternative shipping rate for each shipping
     * service category, for each of several extended domestic regions within their country. For example, in the US the shipping categories are Economy, Standard, Expedited and One-day. The extended regions are Alaska and Hawaii, US Protectorates, and
     * Army/Fleet Post Offices. <br><br> In an international shipping rate table, sellers can specify an alternative shipping rate for each shipping service category, for each country in a given base region. The international rate table has nine base
     * regions: Africa, Asia, Central America and Caribbean, Europe, Middle East, North America, Oceania, Southeast Asia, and South America. You can use the <b>GetUser</b> call to determine if the seller has configured a shipping rate table. If the domestic
     * shipping rate table is available for this seller, the <strong>User.SellerInfo.DomesticRateTable</strong> field will be <code>true</code>. <br/><br/> If the international shipping rate table is available for this seller, the
     * <strong>User.SellerInfo.InternationalTable</strong> field will be <code>true</code>. <br><br> <span class="tablenote"> <strong>Note:</strong> You can use <strong>RateTableDetails</strong> to apply a shipping rate table to a listing or remove it from
     * a listing. However, the details of a shipping rate table configuration can only be viewed and modified on the eBay website, not by using the API. </span> Sellers use a dropdown list to specify the alternative shipping rate applied by the rate table
     * as one of the following: <ul> <li>A flat amount per item </li> <li>A flat surcharge (domestic rate tables only) </li> <li>A surcharge by weight </li> </ul> This selection applies to the entire table; there is no mixing and matching by region or
     * shipping category. <br><br> If you are applying a shipping rate table that specifies a surcharge by weight, you must specify the item weight in the <strong>ShippingDetails.CalculatedShippingRate</strong> container's <strong>WeightMajor</strong> and
     * <strong>WeightMinor</strong> fields, even though this is a flat rate listing. Do not use any other fields in the <strong>CalculatedShippingRate</strong> container because those are not supported in this scenario. <br><br> <span class="tablenote">
     * <strong>Note:</strong> There is currently no way to determine through the API whether a seller's rate table specifies a surcharge by weight, so your application must make it clear to the seller that item weight must be supplied if the seller has
     * specified a surcharge by weight. If the required weight values are not supplied, a default weight of one unit (1 lb or 1 kg, depending on locale) is used as the basis for the surcharge. </span> This container is returned from the <b>GetItem</b>
     * family of calls only for the seller who listed the item. <br><br> You can find more information about using shipping rate tables in the Shipping chapter of the eBay Features Guide.
     * - minOccurs: 0
     * @var \ebay\StructType\RateTableDetailsType
     */
    public $RateTableDetails;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for ShippingDetailsType
     * @uses ShippingDetailsType::setAllowPaymentEdit()
     * @uses ShippingDetailsType::setApplyShippingDiscount()
     * @uses ShippingDetailsType::setGlobalShipping()
     * @uses ShippingDetailsType::setCalculatedShippingRate()
     * @uses ShippingDetailsType::setChangePaymentInstructions()
     * @uses ShippingDetailsType::setInsuranceWanted()
     * @uses ShippingDetailsType::setPaymentEdited()
     * @uses ShippingDetailsType::setPaymentInstructions()
     * @uses ShippingDetailsType::setSalesTax()
     * @uses ShippingDetailsType::setShippingRateErrorMessage()
     * @uses ShippingDetailsType::setShippingRateType()
     * @uses ShippingDetailsType::setShippingServiceOptions()
     * @uses ShippingDetailsType::setInternationalShippingServiceOption()
     * @uses ShippingDetailsType::setShippingType()
     * @uses ShippingDetailsType::setSellingManagerSalesRecordNumber()
     * @uses ShippingDetailsType::setThirdPartyCheckout()
     * @uses ShippingDetailsType::setTaxTable()
     * @uses ShippingDetailsType::setGetItFast()
     * @uses ShippingDetailsType::setShippingServiceUsed()
     * @uses ShippingDetailsType::setDefaultShippingCost()
     * @uses ShippingDetailsType::setInsuranceDetails()
     * @uses ShippingDetailsType::setInternationalInsuranceDetails()
     * @uses ShippingDetailsType::setShippingDiscountProfileID()
     * @uses ShippingDetailsType::setFlatShippingDiscount()
     * @uses ShippingDetailsType::setCalculatedShippingDiscount()
     * @uses ShippingDetailsType::setPromotionalShippingDiscount()
     * @uses ShippingDetailsType::setInternationalShippingDiscountProfileID()
     * @uses ShippingDetailsType::setInternationalFlatShippingDiscount()
     * @uses ShippingDetailsType::setInternationalCalculatedShippingDiscount()
     * @uses ShippingDetailsType::setInternationalPromotionalShippingDiscount()
     * @uses ShippingDetailsType::setPromotionalShippingDiscountDetails()
     * @uses ShippingDetailsType::setCODCost()
     * @uses ShippingDetailsType::setExcludeShipToLocation()
     * @uses ShippingDetailsType::setSellerExcludeShipToLocationsPreference()
     * @uses ShippingDetailsType::setShipmentTrackingDetails()
     * @uses ShippingDetailsType::setRateTableDetails()
     * @uses ShippingDetailsType::setAny()
     * @param bool $allowPaymentEdit
     * @param bool $applyShippingDiscount
     * @param bool $globalShipping
     * @param \ebay\StructType\CalculatedShippingRateType $calculatedShippingRate
     * @param bool $changePaymentInstructions
     * @param bool $insuranceWanted
     * @param bool $paymentEdited
     * @param string $paymentInstructions
     * @param \ebay\StructType\SalesTaxType $salesTax
     * @param string $shippingRateErrorMessage
     * @param string $shippingRateType
     * @param \ebay\StructType\ShippingServiceOptionsType[] $shippingServiceOptions
     * @param \ebay\StructType\InternationalShippingServiceOptionsType[] $internationalShippingServiceOption
     * @param string $shippingType
     * @param int $sellingManagerSalesRecordNumber
     * @param bool $thirdPartyCheckout
     * @param \ebay\StructType\TaxTableType $taxTable
     * @param bool $getItFast
     * @param string $shippingServiceUsed
     * @param \ebay\StructType\AmountType $defaultShippingCost
     * @param \ebay\StructType\InsuranceDetailsType $insuranceDetails
     * @param \ebay\StructType\InsuranceDetailsType $internationalInsuranceDetails
     * @param string $shippingDiscountProfileID
     * @param \ebay\StructType\FlatShippingDiscountType $flatShippingDiscount
     * @param \ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount
     * @param bool $promotionalShippingDiscount
     * @param string $internationalShippingDiscountProfileID
     * @param \ebay\StructType\FlatShippingDiscountType $internationalFlatShippingDiscount
     * @param \ebay\StructType\CalculatedShippingDiscountType $internationalCalculatedShippingDiscount
     * @param bool $internationalPromotionalShippingDiscount
     * @param \ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails
     * @param \ebay\StructType\AmountType $cODCost
     * @param string[] $excludeShipToLocation
     * @param bool $sellerExcludeShipToLocationsPreference
     * @param \ebay\StructType\ShipmentTrackingDetailsType[] $shipmentTrackingDetails
     * @param \ebay\StructType\RateTableDetailsType $rateTableDetails
     * @param \DOMDocument $any
     */
    public function __construct($allowPaymentEdit = null, $applyShippingDiscount = null, $globalShipping = null, \ebay\StructType\CalculatedShippingRateType $calculatedShippingRate = null, $changePaymentInstructions = null, $insuranceWanted = null, $paymentEdited = null, $paymentInstructions = null, \ebay\StructType\SalesTaxType $salesTax = null, $shippingRateErrorMessage = null, $shippingRateType = null, array $shippingServiceOptions = array(), array $internationalShippingServiceOption = array(), $shippingType = null, $sellingManagerSalesRecordNumber = null, $thirdPartyCheckout = null, \ebay\StructType\TaxTableType $taxTable = null, $getItFast = null, $shippingServiceUsed = null, \ebay\StructType\AmountType $defaultShippingCost = null, \ebay\StructType\InsuranceDetailsType $insuranceDetails = null, \ebay\StructType\InsuranceDetailsType $internationalInsuranceDetails = null, $shippingDiscountProfileID = null, \ebay\StructType\FlatShippingDiscountType $flatShippingDiscount = null, \ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount = null, $promotionalShippingDiscount = null, $internationalShippingDiscountProfileID = null, \ebay\StructType\FlatShippingDiscountType $internationalFlatShippingDiscount = null, \ebay\StructType\CalculatedShippingDiscountType $internationalCalculatedShippingDiscount = null, $internationalPromotionalShippingDiscount = null, \ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails = null, \ebay\StructType\AmountType $cODCost = null, array $excludeShipToLocation = array(), $sellerExcludeShipToLocationsPreference = null, array $shipmentTrackingDetails = array(), \ebay\StructType\RateTableDetailsType $rateTableDetails = null, \DOMDocument $any = null)
    {
        $this
            ->setAllowPaymentEdit($allowPaymentEdit)
            ->setApplyShippingDiscount($applyShippingDiscount)
            ->setGlobalShipping($globalShipping)
            ->setCalculatedShippingRate($calculatedShippingRate)
            ->setChangePaymentInstructions($changePaymentInstructions)
            ->setInsuranceWanted($insuranceWanted)
            ->setPaymentEdited($paymentEdited)
            ->setPaymentInstructions($paymentInstructions)
            ->setSalesTax($salesTax)
            ->setShippingRateErrorMessage($shippingRateErrorMessage)
            ->setShippingRateType($shippingRateType)
            ->setShippingServiceOptions($shippingServiceOptions)
            ->setInternationalShippingServiceOption($internationalShippingServiceOption)
            ->setShippingType($shippingType)
            ->setSellingManagerSalesRecordNumber($sellingManagerSalesRecordNumber)
            ->setThirdPartyCheckout($thirdPartyCheckout)
            ->setTaxTable($taxTable)
            ->setGetItFast($getItFast)
            ->setShippingServiceUsed($shippingServiceUsed)
            ->setDefaultShippingCost($defaultShippingCost)
            ->setInsuranceDetails($insuranceDetails)
            ->setInternationalInsuranceDetails($internationalInsuranceDetails)
            ->setShippingDiscountProfileID($shippingDiscountProfileID)
            ->setFlatShippingDiscount($flatShippingDiscount)
            ->setCalculatedShippingDiscount($calculatedShippingDiscount)
            ->setPromotionalShippingDiscount($promotionalShippingDiscount)
            ->setInternationalShippingDiscountProfileID($internationalShippingDiscountProfileID)
            ->setInternationalFlatShippingDiscount($internationalFlatShippingDiscount)
            ->setInternationalCalculatedShippingDiscount($internationalCalculatedShippingDiscount)
            ->setInternationalPromotionalShippingDiscount($internationalPromotionalShippingDiscount)
            ->setPromotionalShippingDiscountDetails($promotionalShippingDiscountDetails)
            ->setCODCost($cODCost)
            ->setExcludeShipToLocation($excludeShipToLocation)
            ->setSellerExcludeShipToLocationsPreference($sellerExcludeShipToLocationsPreference)
            ->setShipmentTrackingDetails($shipmentTrackingDetails)
            ->setRateTableDetails($rateTableDetails)
            ->setAny($any);
    }
    /**
     * Get AllowPaymentEdit value
     * @return bool|null
     */
    public function getAllowPaymentEdit()
    {
        return $this->AllowPaymentEdit;
    }
    /**
     * Set AllowPaymentEdit value
     * @param bool $allowPaymentEdit
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setAllowPaymentEdit($allowPaymentEdit = null)
    {
        $this->AllowPaymentEdit = $allowPaymentEdit;
        return $this;
    }
    /**
     * Get ApplyShippingDiscount value
     * @return bool|null
     */
    public function getApplyShippingDiscount()
    {
        return $this->ApplyShippingDiscount;
    }
    /**
     * Set ApplyShippingDiscount value
     * @param bool $applyShippingDiscount
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setApplyShippingDiscount($applyShippingDiscount = null)
    {
        $this->ApplyShippingDiscount = $applyShippingDiscount;
        return $this;
    }
    /**
     * Get GlobalShipping value
     * @return bool|null
     */
    public function getGlobalShipping()
    {
        return $this->GlobalShipping;
    }
    /**
     * Set GlobalShipping value
     * @param bool $globalShipping
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setGlobalShipping($globalShipping = null)
    {
        $this->GlobalShipping = $globalShipping;
        return $this;
    }
    /**
     * Get CalculatedShippingRate value
     * @return \ebay\StructType\CalculatedShippingRateType|null
     */
    public function getCalculatedShippingRate()
    {
        return $this->CalculatedShippingRate;
    }
    /**
     * Set CalculatedShippingRate value
     * @param \ebay\StructType\CalculatedShippingRateType $calculatedShippingRate
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setCalculatedShippingRate(\ebay\StructType\CalculatedShippingRateType $calculatedShippingRate = null)
    {
        $this->CalculatedShippingRate = $calculatedShippingRate;
        return $this;
    }
    /**
     * Get ChangePaymentInstructions value
     * @return bool|null
     */
    public function getChangePaymentInstructions()
    {
        return $this->ChangePaymentInstructions;
    }
    /**
     * Set ChangePaymentInstructions value
     * @param bool $changePaymentInstructions
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setChangePaymentInstructions($changePaymentInstructions = null)
    {
        $this->ChangePaymentInstructions = $changePaymentInstructions;
        return $this;
    }
    /**
     * Get InsuranceWanted value
     * @return bool|null
     */
    public function getInsuranceWanted()
    {
        return $this->InsuranceWanted;
    }
    /**
     * Set InsuranceWanted value
     * @param bool $insuranceWanted
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setInsuranceWanted($insuranceWanted = null)
    {
        $this->InsuranceWanted = $insuranceWanted;
        return $this;
    }
    /**
     * Get PaymentEdited value
     * @return bool|null
     */
    public function getPaymentEdited()
    {
        return $this->PaymentEdited;
    }
    /**
     * Set PaymentEdited value
     * @param bool $paymentEdited
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setPaymentEdited($paymentEdited = null)
    {
        $this->PaymentEdited = $paymentEdited;
        return $this;
    }
    /**
     * Get PaymentInstructions value
     * @return string|null
     */
    public function getPaymentInstructions()
    {
        return $this->PaymentInstructions;
    }
    /**
     * Set PaymentInstructions value
     * @param string $paymentInstructions
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setPaymentInstructions($paymentInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInstructions) && !is_string($paymentInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentInstructions)), __LINE__);
        }
        $this->PaymentInstructions = $paymentInstructions;
        return $this;
    }
    /**
     * Get SalesTax value
     * @return \ebay\StructType\SalesTaxType|null
     */
    public function getSalesTax()
    {
        return $this->SalesTax;
    }
    /**
     * Set SalesTax value
     * @param \ebay\StructType\SalesTaxType $salesTax
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setSalesTax(\ebay\StructType\SalesTaxType $salesTax = null)
    {
        $this->SalesTax = $salesTax;
        return $this;
    }
    /**
     * Get ShippingRateErrorMessage value
     * @return string|null
     */
    public function getShippingRateErrorMessage()
    {
        return $this->ShippingRateErrorMessage;
    }
    /**
     * Set ShippingRateErrorMessage value
     * @param string $shippingRateErrorMessage
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setShippingRateErrorMessage($shippingRateErrorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($shippingRateErrorMessage) && !is_string($shippingRateErrorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingRateErrorMessage)), __LINE__);
        }
        $this->ShippingRateErrorMessage = $shippingRateErrorMessage;
        return $this;
    }
    /**
     * Get ShippingRateType value
     * @return string|null
     */
    public function getShippingRateType()
    {
        return $this->ShippingRateType;
    }
    /**
     * Set ShippingRateType value
     * @uses \ebay\EnumType\ShippingRateTypeCodeType::valueIsValid()
     * @uses \ebay\EnumType\ShippingRateTypeCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shippingRateType
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setShippingRateType($shippingRateType = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\ShippingRateTypeCodeType::valueIsValid($shippingRateType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $shippingRateType, implode(', ', \ebay\EnumType\ShippingRateTypeCodeType::getValidValues())), __LINE__);
        }
        $this->ShippingRateType = $shippingRateType;
        return $this;
    }
    /**
     * Get ShippingServiceOptions value
     * @return \ebay\StructType\ShippingServiceOptionsType[]|null
     */
    public function getShippingServiceOptions()
    {
        return $this->ShippingServiceOptions;
    }
    /**
     * Set ShippingServiceOptions value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ShippingServiceOptionsType[] $shippingServiceOptions
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setShippingServiceOptions(array $shippingServiceOptions = array())
    {
        foreach ($shippingServiceOptions as $shippingDetailsTypeShippingServiceOptionsItem) {
            // validation for constraint: itemType
            if (!$shippingDetailsTypeShippingServiceOptionsItem instanceof \ebay\StructType\ShippingServiceOptionsType) {
                throw new \InvalidArgumentException(sprintf('The ShippingServiceOptions property can only contain items of \ebay\StructType\ShippingServiceOptionsType, "%s" given', is_object($shippingDetailsTypeShippingServiceOptionsItem) ? get_class($shippingDetailsTypeShippingServiceOptionsItem) : gettype($shippingDetailsTypeShippingServiceOptionsItem)), __LINE__);
            }
        }
        $this->ShippingServiceOptions = $shippingServiceOptions;
        return $this;
    }
    /**
     * Add item to ShippingServiceOptions value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ShippingServiceOptionsType $item
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function addToShippingServiceOptions(\ebay\StructType\ShippingServiceOptionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\ShippingServiceOptionsType) {
            throw new \InvalidArgumentException(sprintf('The ShippingServiceOptions property can only contain items of \ebay\StructType\ShippingServiceOptionsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShippingServiceOptions[] = $item;
        return $this;
    }
    /**
     * Get InternationalShippingServiceOption value
     * @return \ebay\StructType\InternationalShippingServiceOptionsType[]|null
     */
    public function getInternationalShippingServiceOption()
    {
        return $this->InternationalShippingServiceOption;
    }
    /**
     * Set InternationalShippingServiceOption value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\InternationalShippingServiceOptionsType[] $internationalShippingServiceOption
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setInternationalShippingServiceOption(array $internationalShippingServiceOption = array())
    {
        foreach ($internationalShippingServiceOption as $shippingDetailsTypeInternationalShippingServiceOptionItem) {
            // validation for constraint: itemType
            if (!$shippingDetailsTypeInternationalShippingServiceOptionItem instanceof \ebay\StructType\InternationalShippingServiceOptionsType) {
                throw new \InvalidArgumentException(sprintf('The InternationalShippingServiceOption property can only contain items of \ebay\StructType\InternationalShippingServiceOptionsType, "%s" given', is_object($shippingDetailsTypeInternationalShippingServiceOptionItem) ? get_class($shippingDetailsTypeInternationalShippingServiceOptionItem) : gettype($shippingDetailsTypeInternationalShippingServiceOptionItem)), __LINE__);
            }
        }
        $this->InternationalShippingServiceOption = $internationalShippingServiceOption;
        return $this;
    }
    /**
     * Add item to InternationalShippingServiceOption value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\InternationalShippingServiceOptionsType $item
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function addToInternationalShippingServiceOption(\ebay\StructType\InternationalShippingServiceOptionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\InternationalShippingServiceOptionsType) {
            throw new \InvalidArgumentException(sprintf('The InternationalShippingServiceOption property can only contain items of \ebay\StructType\InternationalShippingServiceOptionsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InternationalShippingServiceOption[] = $item;
        return $this;
    }
    /**
     * Get ShippingType value
     * @return string|null
     */
    public function getShippingType()
    {
        return $this->ShippingType;
    }
    /**
     * Set ShippingType value
     * @uses \ebay\EnumType\ShippingTypeCodeType::valueIsValid()
     * @uses \ebay\EnumType\ShippingTypeCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shippingType
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setShippingType($shippingType = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\ShippingTypeCodeType::valueIsValid($shippingType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $shippingType, implode(', ', \ebay\EnumType\ShippingTypeCodeType::getValidValues())), __LINE__);
        }
        $this->ShippingType = $shippingType;
        return $this;
    }
    /**
     * Get SellingManagerSalesRecordNumber value
     * @return int|null
     */
    public function getSellingManagerSalesRecordNumber()
    {
        return $this->SellingManagerSalesRecordNumber;
    }
    /**
     * Set SellingManagerSalesRecordNumber value
     * @param int $sellingManagerSalesRecordNumber
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setSellingManagerSalesRecordNumber($sellingManagerSalesRecordNumber = null)
    {
        // validation for constraint: int
        if (!is_null($sellingManagerSalesRecordNumber) && !is_numeric($sellingManagerSalesRecordNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sellingManagerSalesRecordNumber)), __LINE__);
        }
        $this->SellingManagerSalesRecordNumber = $sellingManagerSalesRecordNumber;
        return $this;
    }
    /**
     * Get ThirdPartyCheckout value
     * @return bool|null
     */
    public function getThirdPartyCheckout()
    {
        return $this->ThirdPartyCheckout;
    }
    /**
     * Set ThirdPartyCheckout value
     * @param bool $thirdPartyCheckout
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setThirdPartyCheckout($thirdPartyCheckout = null)
    {
        $this->ThirdPartyCheckout = $thirdPartyCheckout;
        return $this;
    }
    /**
     * Get TaxTable value
     * @return \ebay\StructType\TaxTableType|null
     */
    public function getTaxTable()
    {
        return $this->TaxTable;
    }
    /**
     * Set TaxTable value
     * @param \ebay\StructType\TaxTableType $taxTable
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setTaxTable(\ebay\StructType\TaxTableType $taxTable = null)
    {
        $this->TaxTable = $taxTable;
        return $this;
    }
    /**
     * Get GetItFast value
     * @return bool|null
     */
    public function getGetItFast()
    {
        return $this->GetItFast;
    }
    /**
     * Set GetItFast value
     * @param bool $getItFast
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setGetItFast($getItFast = null)
    {
        $this->GetItFast = $getItFast;
        return $this;
    }
    /**
     * Get ShippingServiceUsed value
     * @return string|null
     */
    public function getShippingServiceUsed()
    {
        return $this->ShippingServiceUsed;
    }
    /**
     * Set ShippingServiceUsed value
     * @param string $shippingServiceUsed
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setShippingServiceUsed($shippingServiceUsed = null)
    {
        // validation for constraint: string
        if (!is_null($shippingServiceUsed) && !is_string($shippingServiceUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingServiceUsed)), __LINE__);
        }
        $this->ShippingServiceUsed = $shippingServiceUsed;
        return $this;
    }
    /**
     * Get DefaultShippingCost value
     * @return \ebay\StructType\AmountType|null
     */
    public function getDefaultShippingCost()
    {
        return $this->DefaultShippingCost;
    }
    /**
     * Set DefaultShippingCost value
     * @param \ebay\StructType\AmountType $defaultShippingCost
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setDefaultShippingCost(\ebay\StructType\AmountType $defaultShippingCost = null)
    {
        $this->DefaultShippingCost = $defaultShippingCost;
        return $this;
    }
    /**
     * Get InsuranceDetails value
     * @return \ebay\StructType\InsuranceDetailsType|null
     */
    public function getInsuranceDetails()
    {
        return $this->InsuranceDetails;
    }
    /**
     * Set InsuranceDetails value
     * @param \ebay\StructType\InsuranceDetailsType $insuranceDetails
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setInsuranceDetails(\ebay\StructType\InsuranceDetailsType $insuranceDetails = null)
    {
        $this->InsuranceDetails = $insuranceDetails;
        return $this;
    }
    /**
     * Get InternationalInsuranceDetails value
     * @return \ebay\StructType\InsuranceDetailsType|null
     */
    public function getInternationalInsuranceDetails()
    {
        return $this->InternationalInsuranceDetails;
    }
    /**
     * Set InternationalInsuranceDetails value
     * @param \ebay\StructType\InsuranceDetailsType $internationalInsuranceDetails
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setInternationalInsuranceDetails(\ebay\StructType\InsuranceDetailsType $internationalInsuranceDetails = null)
    {
        $this->InternationalInsuranceDetails = $internationalInsuranceDetails;
        return $this;
    }
    /**
     * Get ShippingDiscountProfileID value
     * @return string|null
     */
    public function getShippingDiscountProfileID()
    {
        return $this->ShippingDiscountProfileID;
    }
    /**
     * Set ShippingDiscountProfileID value
     * @param string $shippingDiscountProfileID
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setShippingDiscountProfileID($shippingDiscountProfileID = null)
    {
        // validation for constraint: string
        if (!is_null($shippingDiscountProfileID) && !is_string($shippingDiscountProfileID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingDiscountProfileID)), __LINE__);
        }
        $this->ShippingDiscountProfileID = $shippingDiscountProfileID;
        return $this;
    }
    /**
     * Get FlatShippingDiscount value
     * @return \ebay\StructType\FlatShippingDiscountType|null
     */
    public function getFlatShippingDiscount()
    {
        return $this->FlatShippingDiscount;
    }
    /**
     * Set FlatShippingDiscount value
     * @param \ebay\StructType\FlatShippingDiscountType $flatShippingDiscount
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setFlatShippingDiscount(\ebay\StructType\FlatShippingDiscountType $flatShippingDiscount = null)
    {
        $this->FlatShippingDiscount = $flatShippingDiscount;
        return $this;
    }
    /**
     * Get CalculatedShippingDiscount value
     * @return \ebay\StructType\CalculatedShippingDiscountType|null
     */
    public function getCalculatedShippingDiscount()
    {
        return $this->CalculatedShippingDiscount;
    }
    /**
     * Set CalculatedShippingDiscount value
     * @param \ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setCalculatedShippingDiscount(\ebay\StructType\CalculatedShippingDiscountType $calculatedShippingDiscount = null)
    {
        $this->CalculatedShippingDiscount = $calculatedShippingDiscount;
        return $this;
    }
    /**
     * Get PromotionalShippingDiscount value
     * @return bool|null
     */
    public function getPromotionalShippingDiscount()
    {
        return $this->PromotionalShippingDiscount;
    }
    /**
     * Set PromotionalShippingDiscount value
     * @param bool $promotionalShippingDiscount
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setPromotionalShippingDiscount($promotionalShippingDiscount = null)
    {
        $this->PromotionalShippingDiscount = $promotionalShippingDiscount;
        return $this;
    }
    /**
     * Get InternationalShippingDiscountProfileID value
     * @return string|null
     */
    public function getInternationalShippingDiscountProfileID()
    {
        return $this->InternationalShippingDiscountProfileID;
    }
    /**
     * Set InternationalShippingDiscountProfileID value
     * @param string $internationalShippingDiscountProfileID
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setInternationalShippingDiscountProfileID($internationalShippingDiscountProfileID = null)
    {
        // validation for constraint: string
        if (!is_null($internationalShippingDiscountProfileID) && !is_string($internationalShippingDiscountProfileID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internationalShippingDiscountProfileID)), __LINE__);
        }
        $this->InternationalShippingDiscountProfileID = $internationalShippingDiscountProfileID;
        return $this;
    }
    /**
     * Get InternationalFlatShippingDiscount value
     * @return \ebay\StructType\FlatShippingDiscountType|null
     */
    public function getInternationalFlatShippingDiscount()
    {
        return $this->InternationalFlatShippingDiscount;
    }
    /**
     * Set InternationalFlatShippingDiscount value
     * @param \ebay\StructType\FlatShippingDiscountType $internationalFlatShippingDiscount
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setInternationalFlatShippingDiscount(\ebay\StructType\FlatShippingDiscountType $internationalFlatShippingDiscount = null)
    {
        $this->InternationalFlatShippingDiscount = $internationalFlatShippingDiscount;
        return $this;
    }
    /**
     * Get InternationalCalculatedShippingDiscount value
     * @return \ebay\StructType\CalculatedShippingDiscountType|null
     */
    public function getInternationalCalculatedShippingDiscount()
    {
        return $this->InternationalCalculatedShippingDiscount;
    }
    /**
     * Set InternationalCalculatedShippingDiscount value
     * @param \ebay\StructType\CalculatedShippingDiscountType $internationalCalculatedShippingDiscount
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setInternationalCalculatedShippingDiscount(\ebay\StructType\CalculatedShippingDiscountType $internationalCalculatedShippingDiscount = null)
    {
        $this->InternationalCalculatedShippingDiscount = $internationalCalculatedShippingDiscount;
        return $this;
    }
    /**
     * Get InternationalPromotionalShippingDiscount value
     * @return bool|null
     */
    public function getInternationalPromotionalShippingDiscount()
    {
        return $this->InternationalPromotionalShippingDiscount;
    }
    /**
     * Set InternationalPromotionalShippingDiscount value
     * @param bool $internationalPromotionalShippingDiscount
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setInternationalPromotionalShippingDiscount($internationalPromotionalShippingDiscount = null)
    {
        $this->InternationalPromotionalShippingDiscount = $internationalPromotionalShippingDiscount;
        return $this;
    }
    /**
     * Get PromotionalShippingDiscountDetails value
     * @return \ebay\StructType\PromotionalShippingDiscountDetailsType|null
     */
    public function getPromotionalShippingDiscountDetails()
    {
        return $this->PromotionalShippingDiscountDetails;
    }
    /**
     * Set PromotionalShippingDiscountDetails value
     * @param \ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setPromotionalShippingDiscountDetails(\ebay\StructType\PromotionalShippingDiscountDetailsType $promotionalShippingDiscountDetails = null)
    {
        $this->PromotionalShippingDiscountDetails = $promotionalShippingDiscountDetails;
        return $this;
    }
    /**
     * Get CODCost value
     * @return \ebay\StructType\AmountType|null
     */
    public function getCODCost()
    {
        return $this->CODCost;
    }
    /**
     * Set CODCost value
     * @param \ebay\StructType\AmountType $cODCost
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setCODCost(\ebay\StructType\AmountType $cODCost = null)
    {
        $this->CODCost = $cODCost;
        return $this;
    }
    /**
     * Get ExcludeShipToLocation value
     * @return string[]|null
     */
    public function getExcludeShipToLocation()
    {
        return $this->ExcludeShipToLocation;
    }
    /**
     * Set ExcludeShipToLocation value
     * @throws \InvalidArgumentException
     * @param string[] $excludeShipToLocation
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setExcludeShipToLocation(array $excludeShipToLocation = array())
    {
        foreach ($excludeShipToLocation as $shippingDetailsTypeExcludeShipToLocationItem) {
            // validation for constraint: itemType
            if (!is_string($shippingDetailsTypeExcludeShipToLocationItem)) {
                throw new \InvalidArgumentException(sprintf('The ExcludeShipToLocation property can only contain items of string, "%s" given', is_object($shippingDetailsTypeExcludeShipToLocationItem) ? get_class($shippingDetailsTypeExcludeShipToLocationItem) : gettype($shippingDetailsTypeExcludeShipToLocationItem)), __LINE__);
            }
        }
        $this->ExcludeShipToLocation = $excludeShipToLocation;
        return $this;
    }
    /**
     * Add item to ExcludeShipToLocation value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function addToExcludeShipToLocation($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ExcludeShipToLocation property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ExcludeShipToLocation[] = $item;
        return $this;
    }
    /**
     * Get SellerExcludeShipToLocationsPreference value
     * @return bool|null
     */
    public function getSellerExcludeShipToLocationsPreference()
    {
        return $this->SellerExcludeShipToLocationsPreference;
    }
    /**
     * Set SellerExcludeShipToLocationsPreference value
     * @param bool $sellerExcludeShipToLocationsPreference
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setSellerExcludeShipToLocationsPreference($sellerExcludeShipToLocationsPreference = null)
    {
        $this->SellerExcludeShipToLocationsPreference = $sellerExcludeShipToLocationsPreference;
        return $this;
    }
    /**
     * Get ShipmentTrackingDetails value
     * @return \ebay\StructType\ShipmentTrackingDetailsType[]|null
     */
    public function getShipmentTrackingDetails()
    {
        return $this->ShipmentTrackingDetails;
    }
    /**
     * Set ShipmentTrackingDetails value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ShipmentTrackingDetailsType[] $shipmentTrackingDetails
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setShipmentTrackingDetails(array $shipmentTrackingDetails = array())
    {
        foreach ($shipmentTrackingDetails as $shippingDetailsTypeShipmentTrackingDetailsItem) {
            // validation for constraint: itemType
            if (!$shippingDetailsTypeShipmentTrackingDetailsItem instanceof \ebay\StructType\ShipmentTrackingDetailsType) {
                throw new \InvalidArgumentException(sprintf('The ShipmentTrackingDetails property can only contain items of \ebay\StructType\ShipmentTrackingDetailsType, "%s" given', is_object($shippingDetailsTypeShipmentTrackingDetailsItem) ? get_class($shippingDetailsTypeShipmentTrackingDetailsItem) : gettype($shippingDetailsTypeShipmentTrackingDetailsItem)), __LINE__);
            }
        }
        $this->ShipmentTrackingDetails = $shipmentTrackingDetails;
        return $this;
    }
    /**
     * Add item to ShipmentTrackingDetails value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ShipmentTrackingDetailsType $item
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function addToShipmentTrackingDetails(\ebay\StructType\ShipmentTrackingDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\ShipmentTrackingDetailsType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentTrackingDetails property can only contain items of \ebay\StructType\ShipmentTrackingDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShipmentTrackingDetails[] = $item;
        return $this;
    }
    /**
     * Get RateTableDetails value
     * @return \ebay\StructType\RateTableDetailsType|null
     */
    public function getRateTableDetails()
    {
        return $this->RateTableDetails;
    }
    /**
     * Set RateTableDetails value
     * @param \ebay\StructType\RateTableDetailsType $rateTableDetails
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setRateTableDetails(\ebay\StructType\RateTableDetailsType $rateTableDetails = null)
    {
        $this->RateTableDetails = $rateTableDetails;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\ShippingDetailsType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\ShippingDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\ShippingDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
