<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSellingManagerTemplateAutomationRuleRequestType
 * StructType
 * Meta informations extracted from the WSDL
 * - documentation: Revises, or adds to, the Selling Manager automation rules associated with a template. <br> <br> This call is subject to change without notice; the deprecation process is inapplicable to this call. <br> <br> Using this call, you can
 * add either an autorelist rule or an autolist rule, but not both. You also can add a second chance offer rule (restricted to auction items and auction templates). <br> <br> This call also enables you to specify particular information about automation
 * rules. <br> <br> If a node is not passed in the call, the setting for the corresponding automation rule remains unchanged. <br> <br> Although this call can revise (overwrite) an existing rule, this call cannot delete an automation rule. (Instead, use
 * DeleteSellingManagerTemplateAutomationRule.)
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class SetSellingManagerTemplateAutomationRuleRequestType extends AbstractRequestType
{
    /**
     * The SaleTemplateID
     * Meta informations extracted from the WSDL
     * - documentation: The ID of the Selling Manager template whose automation rules you want to change. You can obtain a SaleTemplateID by calling GetSellingManagerInventory.
     * - minOccurs: 0
     * @var int
     */
    public $SaleTemplateID;
    /**
     * The AutomatedListingRule
     * Meta informations extracted from the WSDL
     * - documentation: The information for the automated listing rule to be associated with the template.
     * - minOccurs: 0
     * @var \ebay\StructType\SellingManagerAutoListType
     */
    public $AutomatedListingRule;
    /**
     * The AutomatedRelistingRule
     * Meta informations extracted from the WSDL
     * - documentation: The information for the automated relisting rule to be associated with the template.
     * - minOccurs: 0
     * @var \ebay\StructType\SellingManagerAutoRelistType
     */
    public $AutomatedRelistingRule;
    /**
     * The AutomatedSecondChanceOfferRule
     * Meta informations extracted from the WSDL
     * - documentation: The information for the automated Second Chance Offer rule to be associated with the template.
     * - minOccurs: 0
     * @var \ebay\StructType\SellingManagerAutoSecondChanceOfferType
     */
    public $AutomatedSecondChanceOfferRule;
    /**
     * Constructor method for SetSellingManagerTemplateAutomationRuleRequestType
     * @uses SetSellingManagerTemplateAutomationRuleRequestType::setSaleTemplateID()
     * @uses SetSellingManagerTemplateAutomationRuleRequestType::setAutomatedListingRule()
     * @uses SetSellingManagerTemplateAutomationRuleRequestType::setAutomatedRelistingRule()
     * @uses SetSellingManagerTemplateAutomationRuleRequestType::setAutomatedSecondChanceOfferRule()
     * @param int $saleTemplateID
     * @param \ebay\StructType\SellingManagerAutoListType $automatedListingRule
     * @param \ebay\StructType\SellingManagerAutoRelistType $automatedRelistingRule
     * @param \ebay\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule
     */
    public function __construct($saleTemplateID = null, \ebay\StructType\SellingManagerAutoListType $automatedListingRule = null, \ebay\StructType\SellingManagerAutoRelistType $automatedRelistingRule = null, \ebay\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule = null)
    {
        $this
            ->setSaleTemplateID($saleTemplateID)
            ->setAutomatedListingRule($automatedListingRule)
            ->setAutomatedRelistingRule($automatedRelistingRule)
            ->setAutomatedSecondChanceOfferRule($automatedSecondChanceOfferRule);
    }
    /**
     * Get SaleTemplateID value
     * @return int|null
     */
    public function getSaleTemplateID()
    {
        return $this->SaleTemplateID;
    }
    /**
     * Set SaleTemplateID value
     * @param int $saleTemplateID
     * @return \ebay\StructType\SetSellingManagerTemplateAutomationRuleRequestType
     */
    public function setSaleTemplateID($saleTemplateID = null)
    {
        // validation for constraint: int
        if (!is_null($saleTemplateID) && !is_numeric($saleTemplateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($saleTemplateID)), __LINE__);
        }
        $this->SaleTemplateID = $saleTemplateID;
        return $this;
    }
    /**
     * Get AutomatedListingRule value
     * @return \ebay\StructType\SellingManagerAutoListType|null
     */
    public function getAutomatedListingRule()
    {
        return $this->AutomatedListingRule;
    }
    /**
     * Set AutomatedListingRule value
     * @param \ebay\StructType\SellingManagerAutoListType $automatedListingRule
     * @return \ebay\StructType\SetSellingManagerTemplateAutomationRuleRequestType
     */
    public function setAutomatedListingRule(\ebay\StructType\SellingManagerAutoListType $automatedListingRule = null)
    {
        $this->AutomatedListingRule = $automatedListingRule;
        return $this;
    }
    /**
     * Get AutomatedRelistingRule value
     * @return \ebay\StructType\SellingManagerAutoRelistType|null
     */
    public function getAutomatedRelistingRule()
    {
        return $this->AutomatedRelistingRule;
    }
    /**
     * Set AutomatedRelistingRule value
     * @param \ebay\StructType\SellingManagerAutoRelistType $automatedRelistingRule
     * @return \ebay\StructType\SetSellingManagerTemplateAutomationRuleRequestType
     */
    public function setAutomatedRelistingRule(\ebay\StructType\SellingManagerAutoRelistType $automatedRelistingRule = null)
    {
        $this->AutomatedRelistingRule = $automatedRelistingRule;
        return $this;
    }
    /**
     * Get AutomatedSecondChanceOfferRule value
     * @return \ebay\StructType\SellingManagerAutoSecondChanceOfferType|null
     */
    public function getAutomatedSecondChanceOfferRule()
    {
        return $this->AutomatedSecondChanceOfferRule;
    }
    /**
     * Set AutomatedSecondChanceOfferRule value
     * @param \ebay\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule
     * @return \ebay\StructType\SetSellingManagerTemplateAutomationRuleRequestType
     */
    public function setAutomatedSecondChanceOfferRule(\ebay\StructType\SellingManagerAutoSecondChanceOfferType $automatedSecondChanceOfferRule = null)
    {
        $this->AutomatedSecondChanceOfferRule = $automatedSecondChanceOfferRule;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\SetSellingManagerTemplateAutomationRuleRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
