<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReviseInventoryStatusResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Returns the Item ID or SKU with changed Price and Quantity for the revised listing.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class ReviseInventoryStatusResponseType extends AbstractResponseType
{
    /**
     * The InventoryStatus
     * Meta informations extracted from the WSDL
     * - documentation: Confirms the quantity and price associated with a listing or variation that was revised.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\InventoryStatusType[]
     */
    public $InventoryStatus;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - documentation: Child elements contain the estimated listing fees for a listing that was revised. Use the ItemID to correlate the Fees data with the InventoryStatus data in the response. The fees do not include the Final Value Fee (FVF), which can't
     * be determined until the listing has sales.<br> <br> If you revise a variation in a multi-variation listing, the fees are for the entire listing. The insertion fee and listing fee are affected by the highest priced variation in the listing (which is
     * not necessarily the variation that you passed in the request).<br> <br> Also note that the call returns only one Fees node per listing. For example, if you revise 4 variations from the same multi-variation listing, the response includes 4
     * InventoryStatus nodes and 1 Fees node.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\InventoryFeesType[]
     */
    public $Fees;
    /**
     * Constructor method for ReviseInventoryStatusResponseType
     * @uses ReviseInventoryStatusResponseType::setInventoryStatus()
     * @uses ReviseInventoryStatusResponseType::setFees()
     * @param \ebay\StructType\InventoryStatusType[] $inventoryStatus
     * @param \ebay\StructType\InventoryFeesType[] $fees
     */
    public function __construct(array $inventoryStatus = array(), array $fees = array())
    {
        $this
            ->setInventoryStatus($inventoryStatus)
            ->setFees($fees);
    }
    /**
     * Get InventoryStatus value
     * @return \ebay\StructType\InventoryStatusType[]|null
     */
    public function getInventoryStatus()
    {
        return $this->InventoryStatus;
    }
    /**
     * Set InventoryStatus value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\InventoryStatusType[] $inventoryStatus
     * @return \ebay\StructType\ReviseInventoryStatusResponseType
     */
    public function setInventoryStatus(array $inventoryStatus = array())
    {
        foreach ($inventoryStatus as $reviseInventoryStatusResponseTypeInventoryStatusItem) {
            // validation for constraint: itemType
            if (!$reviseInventoryStatusResponseTypeInventoryStatusItem instanceof \ebay\StructType\InventoryStatusType) {
                throw new \InvalidArgumentException(sprintf('The InventoryStatus property can only contain items of \ebay\StructType\InventoryStatusType, "%s" given', is_object($reviseInventoryStatusResponseTypeInventoryStatusItem) ? get_class($reviseInventoryStatusResponseTypeInventoryStatusItem) : gettype($reviseInventoryStatusResponseTypeInventoryStatusItem)), __LINE__);
            }
        }
        $this->InventoryStatus = $inventoryStatus;
        return $this;
    }
    /**
     * Add item to InventoryStatus value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\InventoryStatusType $item
     * @return \ebay\StructType\ReviseInventoryStatusResponseType
     */
    public function addToInventoryStatus(\ebay\StructType\InventoryStatusType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\InventoryStatusType) {
            throw new \InvalidArgumentException(sprintf('The InventoryStatus property can only contain items of \ebay\StructType\InventoryStatusType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InventoryStatus[] = $item;
        return $this;
    }
    /**
     * Get Fees value
     * @return \ebay\StructType\InventoryFeesType[]|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\InventoryFeesType[] $fees
     * @return \ebay\StructType\ReviseInventoryStatusResponseType
     */
    public function setFees(array $fees = array())
    {
        foreach ($fees as $reviseInventoryStatusResponseTypeFeesItem) {
            // validation for constraint: itemType
            if (!$reviseInventoryStatusResponseTypeFeesItem instanceof \ebay\StructType\InventoryFeesType) {
                throw new \InvalidArgumentException(sprintf('The Fees property can only contain items of \ebay\StructType\InventoryFeesType, "%s" given', is_object($reviseInventoryStatusResponseTypeFeesItem) ? get_class($reviseInventoryStatusResponseTypeFeesItem) : gettype($reviseInventoryStatusResponseTypeFeesItem)), __LINE__);
            }
        }
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Add item to Fees value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\InventoryFeesType $item
     * @return \ebay\StructType\ReviseInventoryStatusResponseType
     */
    public function addToFees(\ebay\StructType\InventoryFeesType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\InventoryFeesType) {
            throw new \InvalidArgumentException(sprintf('The Fees property can only contain items of \ebay\StructType\InventoryFeesType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Fees[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\ReviseInventoryStatusResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
