<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnPolicyDetailsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type defining the <b>ReturnPolicyDetails</b> container, which is returned in <b>GeteBayDetails</b>, and provides the seller with the Return Policy features (and applicable values) that are supported by the listing site. <br/><br/>
 * <span class="tablenote"><b>Note: </b> This container is only returned if <b>ReturnPolicyDetails</b> is included as a <b>DetailName</b> filter in the call request, or if no <b>DetailName</b> filters are used in the request. </span>
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class ReturnPolicyDetailsType extends AbstractStructBase
{
    /**
     * The Refund
     * Meta informations extracted from the WSDL
     * - documentation: This container consists of the supported refund/exchange/replacement item options that the seller may make available to the buyer in case the buyer wants to return the original item. Enumeration value(s) returned in
     * <b>RefundOption</b> field(s) can be used in the <b>ReturnPolicy.RefundOption</b> field in an Add/Revise/Relist API call.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\RefundDetailsType[]
     */
    public $Refund;
    /**
     * The ReturnsWithin
     * Meta informations extracted from the WSDL
     * - documentation: This container consists of the supported time periods within which the buyer can return the item, starting from the day they receive the item. Enumeration value(s) returned in <b>ReturnsWithinOption</b> field(s) can be used in the
     * <b>ReturnPolicy.ReturnsWithinOption</b> field in an Add/Revise/Relist API call.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\ReturnsWithinDetailsType[]
     */
    public $ReturnsWithin;
    /**
     * The ReturnsAccepted
     * Meta informations extracted from the WSDL
     * - documentation: This container consists of the enumeration values that can be passed into the <b>ReturnPolicy.ReturnsAcceptedOption</b> field when using an Add/Revise/Relist API call. This value will indicate whether or not the seller allows the
     * buyer to return the item.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\ReturnsAcceptedDetailsType[]
     */
    public $ReturnsAccepted;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: This field is returned with a value of <code>true</code> if the site supports a text description of the seller's Return Policy in listings. If the site does support a text description of the seller's Return Policy, it is set through
     * the <b>ReturnPolicy.Description</b> field in an Add/Revise/Relist API call.
     * - minOccurs: 0
     * @var bool
     */
    public $Description;
    /**
     * The WarrantyOffered
     * Meta informations extracted from the WSDL
     * - documentation: The enumeration value in this container will indicate whether a warranty may be offered as part of the seller's Return Policy for an item. The enumeration value(s) returned in <b>WarrantyOfferedOption</b> field(s) can be used in the
     * <b>ReturnPolicy.WarrantyOfferedOption</b> field in an Add/Revise/Relist API call.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\WarrantyOfferedDetailsType[]
     */
    public $WarrantyOffered;
    /**
     * The WarrantyType
     * Meta informations extracted from the WSDL
     * - documentation: This container will consist of the types of warranties that can be offered as part of the seller's Return Policy. This container is only applicable if the site allows warranties to be set as part of the seller's Return Policy (the
     * <b>WarrantyOffered.WarrantyOfferedOption</b> should be returned as <code>WarrantyOffered</code>. The enumeration value(s) returned in <b>WarrantyTypeOption</b> field(s) can be used in the <b>ReturnPolicy.WarrantyTypeOption</b> field in an
     * Add/Revise/Relist API call.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\WarrantyTypeDetailsType[]
     */
    public $WarrantyType;
    /**
     * The WarrantyDuration
     * Meta informations extracted from the WSDL
     * - documentation: This container will consist of the warranty durations that can be offered as part of the seller's Return Policy. This container is only applicable if the site allows warranties to be set as part of the seller's Return Policy (the
     * <b>WarrantyOffered.WarrantyOfferedOption</b> should be returned as <code>WarrantyOffered</code>. The enumeration value(s) returned in <b>WarrantyDurationOption</b> field(s) can be used in the <b>ReturnPolicy.WarrantyDurationOption</b> field in an
     * Add/Revise/Relist API call.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\WarrantyDurationDetailsType[]
     */
    public $WarrantyDuration;
    /**
     * The EAN
     * Meta informations extracted from the WSDL
     * - documentation: This field is returned as true if the site supports specifying a European Article Number (EAN) with the seller's Return Policy. The EAN is specified in the <b>ReturnPolicy.EAN</b> field in an Add/Revise/Relist API call.
     * - minOccurs: 0
     * @var bool
     */
    public $EAN;
    /**
     * The ShippingCostPaidBy
     * Meta informations extracted from the WSDL
     * - documentation: This container consists of the enumeration values that can be passed into the <b>ReturnPolicy.ShippingCostPaidByOption</b> field when using an Add/Revise/Relist API call. This value will indicate whether the buyer or seller is
     * responsible for return shipping cost. The enumeration value(s) returned in <b>ShippingCostPaidByOption</b> field(s) can be used in the <b>ReturnPolicy.ShippingCostPaidByOption</b> field in an
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\ShippingCostPaidByDetailsType[]
     */
    public $ShippingCostPaidBy;
    /**
     * The RestockingFeeValue
     * Meta informations extracted from the WSDL
     * - documentation: This container consists of the allowed values (and a text description of each value) that may be specified in the <b>RestockingFeeValueOption</b> field of an Add/Revise/Relist API call.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\RestockingFeeValueDetailsType[]
     */
    public $RestockingFeeValue;
    /**
     * The DetailVersion
     * Meta informations extracted from the WSDL
     * - documentation: Returns the latest version number for the Return Policy Details metadata set. The version can be used to determine if and when to refresh cached client data.
     * - minOccurs: 0
     * @var string
     */
    public $DetailVersion;
    /**
     * The UpdateTime
     * Meta informations extracted from the WSDL
     * - documentation: This timestamp in GMT indicate when the Return Policy Details metadata were last updated. This timestamp can be used to determine if and when to refresh cached client data.
     * - minOccurs: 0
     * @var string
     */
    public $UpdateTime;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for ReturnPolicyDetailsType
     * @uses ReturnPolicyDetailsType::setRefund()
     * @uses ReturnPolicyDetailsType::setReturnsWithin()
     * @uses ReturnPolicyDetailsType::setReturnsAccepted()
     * @uses ReturnPolicyDetailsType::setDescription()
     * @uses ReturnPolicyDetailsType::setWarrantyOffered()
     * @uses ReturnPolicyDetailsType::setWarrantyType()
     * @uses ReturnPolicyDetailsType::setWarrantyDuration()
     * @uses ReturnPolicyDetailsType::setEAN()
     * @uses ReturnPolicyDetailsType::setShippingCostPaidBy()
     * @uses ReturnPolicyDetailsType::setRestockingFeeValue()
     * @uses ReturnPolicyDetailsType::setDetailVersion()
     * @uses ReturnPolicyDetailsType::setUpdateTime()
     * @uses ReturnPolicyDetailsType::setAny()
     * @param \ebay\StructType\RefundDetailsType[] $refund
     * @param \ebay\StructType\ReturnsWithinDetailsType[] $returnsWithin
     * @param \ebay\StructType\ReturnsAcceptedDetailsType[] $returnsAccepted
     * @param bool $description
     * @param \ebay\StructType\WarrantyOfferedDetailsType[] $warrantyOffered
     * @param \ebay\StructType\WarrantyTypeDetailsType[] $warrantyType
     * @param \ebay\StructType\WarrantyDurationDetailsType[] $warrantyDuration
     * @param bool $eAN
     * @param \ebay\StructType\ShippingCostPaidByDetailsType[] $shippingCostPaidBy
     * @param \ebay\StructType\RestockingFeeValueDetailsType[] $restockingFeeValue
     * @param string $detailVersion
     * @param string $updateTime
     * @param \DOMDocument $any
     */
    public function __construct(array $refund = array(), array $returnsWithin = array(), array $returnsAccepted = array(), $description = null, array $warrantyOffered = array(), array $warrantyType = array(), array $warrantyDuration = array(), $eAN = null, array $shippingCostPaidBy = array(), array $restockingFeeValue = array(), $detailVersion = null, $updateTime = null, \DOMDocument $any = null)
    {
        $this
            ->setRefund($refund)
            ->setReturnsWithin($returnsWithin)
            ->setReturnsAccepted($returnsAccepted)
            ->setDescription($description)
            ->setWarrantyOffered($warrantyOffered)
            ->setWarrantyType($warrantyType)
            ->setWarrantyDuration($warrantyDuration)
            ->setEAN($eAN)
            ->setShippingCostPaidBy($shippingCostPaidBy)
            ->setRestockingFeeValue($restockingFeeValue)
            ->setDetailVersion($detailVersion)
            ->setUpdateTime($updateTime)
            ->setAny($any);
    }
    /**
     * Get Refund value
     * @return \ebay\StructType\RefundDetailsType[]|null
     */
    public function getRefund()
    {
        return $this->Refund;
    }
    /**
     * Set Refund value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\RefundDetailsType[] $refund
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function setRefund(array $refund = array())
    {
        foreach ($refund as $returnPolicyDetailsTypeRefundItem) {
            // validation for constraint: itemType
            if (!$returnPolicyDetailsTypeRefundItem instanceof \ebay\StructType\RefundDetailsType) {
                throw new \InvalidArgumentException(sprintf('The Refund property can only contain items of \ebay\StructType\RefundDetailsType, "%s" given', is_object($returnPolicyDetailsTypeRefundItem) ? get_class($returnPolicyDetailsTypeRefundItem) : gettype($returnPolicyDetailsTypeRefundItem)), __LINE__);
            }
        }
        $this->Refund = $refund;
        return $this;
    }
    /**
     * Add item to Refund value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\RefundDetailsType $item
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function addToRefund(\ebay\StructType\RefundDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\RefundDetailsType) {
            throw new \InvalidArgumentException(sprintf('The Refund property can only contain items of \ebay\StructType\RefundDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Refund[] = $item;
        return $this;
    }
    /**
     * Get ReturnsWithin value
     * @return \ebay\StructType\ReturnsWithinDetailsType[]|null
     */
    public function getReturnsWithin()
    {
        return $this->ReturnsWithin;
    }
    /**
     * Set ReturnsWithin value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ReturnsWithinDetailsType[] $returnsWithin
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function setReturnsWithin(array $returnsWithin = array())
    {
        foreach ($returnsWithin as $returnPolicyDetailsTypeReturnsWithinItem) {
            // validation for constraint: itemType
            if (!$returnPolicyDetailsTypeReturnsWithinItem instanceof \ebay\StructType\ReturnsWithinDetailsType) {
                throw new \InvalidArgumentException(sprintf('The ReturnsWithin property can only contain items of \ebay\StructType\ReturnsWithinDetailsType, "%s" given', is_object($returnPolicyDetailsTypeReturnsWithinItem) ? get_class($returnPolicyDetailsTypeReturnsWithinItem) : gettype($returnPolicyDetailsTypeReturnsWithinItem)), __LINE__);
            }
        }
        $this->ReturnsWithin = $returnsWithin;
        return $this;
    }
    /**
     * Add item to ReturnsWithin value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ReturnsWithinDetailsType $item
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function addToReturnsWithin(\ebay\StructType\ReturnsWithinDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\ReturnsWithinDetailsType) {
            throw new \InvalidArgumentException(sprintf('The ReturnsWithin property can only contain items of \ebay\StructType\ReturnsWithinDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReturnsWithin[] = $item;
        return $this;
    }
    /**
     * Get ReturnsAccepted value
     * @return \ebay\StructType\ReturnsAcceptedDetailsType[]|null
     */
    public function getReturnsAccepted()
    {
        return $this->ReturnsAccepted;
    }
    /**
     * Set ReturnsAccepted value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ReturnsAcceptedDetailsType[] $returnsAccepted
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function setReturnsAccepted(array $returnsAccepted = array())
    {
        foreach ($returnsAccepted as $returnPolicyDetailsTypeReturnsAcceptedItem) {
            // validation for constraint: itemType
            if (!$returnPolicyDetailsTypeReturnsAcceptedItem instanceof \ebay\StructType\ReturnsAcceptedDetailsType) {
                throw new \InvalidArgumentException(sprintf('The ReturnsAccepted property can only contain items of \ebay\StructType\ReturnsAcceptedDetailsType, "%s" given', is_object($returnPolicyDetailsTypeReturnsAcceptedItem) ? get_class($returnPolicyDetailsTypeReturnsAcceptedItem) : gettype($returnPolicyDetailsTypeReturnsAcceptedItem)), __LINE__);
            }
        }
        $this->ReturnsAccepted = $returnsAccepted;
        return $this;
    }
    /**
     * Add item to ReturnsAccepted value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ReturnsAcceptedDetailsType $item
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function addToReturnsAccepted(\ebay\StructType\ReturnsAcceptedDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\ReturnsAcceptedDetailsType) {
            throw new \InvalidArgumentException(sprintf('The ReturnsAccepted property can only contain items of \ebay\StructType\ReturnsAcceptedDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReturnsAccepted[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return bool|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param bool $description
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get WarrantyOffered value
     * @return \ebay\StructType\WarrantyOfferedDetailsType[]|null
     */
    public function getWarrantyOffered()
    {
        return $this->WarrantyOffered;
    }
    /**
     * Set WarrantyOffered value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\WarrantyOfferedDetailsType[] $warrantyOffered
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function setWarrantyOffered(array $warrantyOffered = array())
    {
        foreach ($warrantyOffered as $returnPolicyDetailsTypeWarrantyOfferedItem) {
            // validation for constraint: itemType
            if (!$returnPolicyDetailsTypeWarrantyOfferedItem instanceof \ebay\StructType\WarrantyOfferedDetailsType) {
                throw new \InvalidArgumentException(sprintf('The WarrantyOffered property can only contain items of \ebay\StructType\WarrantyOfferedDetailsType, "%s" given', is_object($returnPolicyDetailsTypeWarrantyOfferedItem) ? get_class($returnPolicyDetailsTypeWarrantyOfferedItem) : gettype($returnPolicyDetailsTypeWarrantyOfferedItem)), __LINE__);
            }
        }
        $this->WarrantyOffered = $warrantyOffered;
        return $this;
    }
    /**
     * Add item to WarrantyOffered value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\WarrantyOfferedDetailsType $item
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function addToWarrantyOffered(\ebay\StructType\WarrantyOfferedDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\WarrantyOfferedDetailsType) {
            throw new \InvalidArgumentException(sprintf('The WarrantyOffered property can only contain items of \ebay\StructType\WarrantyOfferedDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WarrantyOffered[] = $item;
        return $this;
    }
    /**
     * Get WarrantyType value
     * @return \ebay\StructType\WarrantyTypeDetailsType[]|null
     */
    public function getWarrantyType()
    {
        return $this->WarrantyType;
    }
    /**
     * Set WarrantyType value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\WarrantyTypeDetailsType[] $warrantyType
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function setWarrantyType(array $warrantyType = array())
    {
        foreach ($warrantyType as $returnPolicyDetailsTypeWarrantyTypeItem) {
            // validation for constraint: itemType
            if (!$returnPolicyDetailsTypeWarrantyTypeItem instanceof \ebay\StructType\WarrantyTypeDetailsType) {
                throw new \InvalidArgumentException(sprintf('The WarrantyType property can only contain items of \ebay\StructType\WarrantyTypeDetailsType, "%s" given', is_object($returnPolicyDetailsTypeWarrantyTypeItem) ? get_class($returnPolicyDetailsTypeWarrantyTypeItem) : gettype($returnPolicyDetailsTypeWarrantyTypeItem)), __LINE__);
            }
        }
        $this->WarrantyType = $warrantyType;
        return $this;
    }
    /**
     * Add item to WarrantyType value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\WarrantyTypeDetailsType $item
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function addToWarrantyType(\ebay\StructType\WarrantyTypeDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\WarrantyTypeDetailsType) {
            throw new \InvalidArgumentException(sprintf('The WarrantyType property can only contain items of \ebay\StructType\WarrantyTypeDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WarrantyType[] = $item;
        return $this;
    }
    /**
     * Get WarrantyDuration value
     * @return \ebay\StructType\WarrantyDurationDetailsType[]|null
     */
    public function getWarrantyDuration()
    {
        return $this->WarrantyDuration;
    }
    /**
     * Set WarrantyDuration value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\WarrantyDurationDetailsType[] $warrantyDuration
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function setWarrantyDuration(array $warrantyDuration = array())
    {
        foreach ($warrantyDuration as $returnPolicyDetailsTypeWarrantyDurationItem) {
            // validation for constraint: itemType
            if (!$returnPolicyDetailsTypeWarrantyDurationItem instanceof \ebay\StructType\WarrantyDurationDetailsType) {
                throw new \InvalidArgumentException(sprintf('The WarrantyDuration property can only contain items of \ebay\StructType\WarrantyDurationDetailsType, "%s" given', is_object($returnPolicyDetailsTypeWarrantyDurationItem) ? get_class($returnPolicyDetailsTypeWarrantyDurationItem) : gettype($returnPolicyDetailsTypeWarrantyDurationItem)), __LINE__);
            }
        }
        $this->WarrantyDuration = $warrantyDuration;
        return $this;
    }
    /**
     * Add item to WarrantyDuration value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\WarrantyDurationDetailsType $item
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function addToWarrantyDuration(\ebay\StructType\WarrantyDurationDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\WarrantyDurationDetailsType) {
            throw new \InvalidArgumentException(sprintf('The WarrantyDuration property can only contain items of \ebay\StructType\WarrantyDurationDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WarrantyDuration[] = $item;
        return $this;
    }
    /**
     * Get EAN value
     * @return bool|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param bool $eAN
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function setEAN($eAN = null)
    {
        $this->EAN = $eAN;
        return $this;
    }
    /**
     * Get ShippingCostPaidBy value
     * @return \ebay\StructType\ShippingCostPaidByDetailsType[]|null
     */
    public function getShippingCostPaidBy()
    {
        return $this->ShippingCostPaidBy;
    }
    /**
     * Set ShippingCostPaidBy value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ShippingCostPaidByDetailsType[] $shippingCostPaidBy
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function setShippingCostPaidBy(array $shippingCostPaidBy = array())
    {
        foreach ($shippingCostPaidBy as $returnPolicyDetailsTypeShippingCostPaidByItem) {
            // validation for constraint: itemType
            if (!$returnPolicyDetailsTypeShippingCostPaidByItem instanceof \ebay\StructType\ShippingCostPaidByDetailsType) {
                throw new \InvalidArgumentException(sprintf('The ShippingCostPaidBy property can only contain items of \ebay\StructType\ShippingCostPaidByDetailsType, "%s" given', is_object($returnPolicyDetailsTypeShippingCostPaidByItem) ? get_class($returnPolicyDetailsTypeShippingCostPaidByItem) : gettype($returnPolicyDetailsTypeShippingCostPaidByItem)), __LINE__);
            }
        }
        $this->ShippingCostPaidBy = $shippingCostPaidBy;
        return $this;
    }
    /**
     * Add item to ShippingCostPaidBy value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ShippingCostPaidByDetailsType $item
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function addToShippingCostPaidBy(\ebay\StructType\ShippingCostPaidByDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\ShippingCostPaidByDetailsType) {
            throw new \InvalidArgumentException(sprintf('The ShippingCostPaidBy property can only contain items of \ebay\StructType\ShippingCostPaidByDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShippingCostPaidBy[] = $item;
        return $this;
    }
    /**
     * Get RestockingFeeValue value
     * @return \ebay\StructType\RestockingFeeValueDetailsType[]|null
     */
    public function getRestockingFeeValue()
    {
        return $this->RestockingFeeValue;
    }
    /**
     * Set RestockingFeeValue value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\RestockingFeeValueDetailsType[] $restockingFeeValue
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function setRestockingFeeValue(array $restockingFeeValue = array())
    {
        foreach ($restockingFeeValue as $returnPolicyDetailsTypeRestockingFeeValueItem) {
            // validation for constraint: itemType
            if (!$returnPolicyDetailsTypeRestockingFeeValueItem instanceof \ebay\StructType\RestockingFeeValueDetailsType) {
                throw new \InvalidArgumentException(sprintf('The RestockingFeeValue property can only contain items of \ebay\StructType\RestockingFeeValueDetailsType, "%s" given', is_object($returnPolicyDetailsTypeRestockingFeeValueItem) ? get_class($returnPolicyDetailsTypeRestockingFeeValueItem) : gettype($returnPolicyDetailsTypeRestockingFeeValueItem)), __LINE__);
            }
        }
        $this->RestockingFeeValue = $restockingFeeValue;
        return $this;
    }
    /**
     * Add item to RestockingFeeValue value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\RestockingFeeValueDetailsType $item
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function addToRestockingFeeValue(\ebay\StructType\RestockingFeeValueDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\RestockingFeeValueDetailsType) {
            throw new \InvalidArgumentException(sprintf('The RestockingFeeValue property can only contain items of \ebay\StructType\RestockingFeeValueDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RestockingFeeValue[] = $item;
        return $this;
    }
    /**
     * Get DetailVersion value
     * @return string|null
     */
    public function getDetailVersion()
    {
        return $this->DetailVersion;
    }
    /**
     * Set DetailVersion value
     * @param string $detailVersion
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function setDetailVersion($detailVersion = null)
    {
        // validation for constraint: string
        if (!is_null($detailVersion) && !is_string($detailVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($detailVersion)), __LINE__);
        }
        $this->DetailVersion = $detailVersion;
        return $this;
    }
    /**
     * Get UpdateTime value
     * @return string|null
     */
    public function getUpdateTime()
    {
        return $this->UpdateTime;
    }
    /**
     * Set UpdateTime value
     * @param string $updateTime
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function setUpdateTime($updateTime = null)
    {
        // validation for constraint: string
        if (!is_null($updateTime) && !is_string($updateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateTime)), __LINE__);
        }
        $this->UpdateTime = $updateTime;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\ReturnPolicyDetailsType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\ReturnPolicyDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
