<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateTableDetailsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: This type contains fields to specify the shipping rate tables that are to be applied to a listing. Shipping rate tables enable sellers to tailor the flat shipping rates offered for an item to fit the shipping destination. They can
 * specify a base rate for a large region, then define alternative rates or surcharges for shipping to other (extended) regions within the larger region. <br><br> Prerequisites for applying shipping rate tables: <ul> <li>The shipping type for the
 * listing must be Flat. </li> <li>The seller must have previously configured a shipping rate table in My eBay site preferences. </li> </ul> This container is returned from the GetItem family of calls only for the seller who listed the item. <br><br>
 * You can find more information about using shipping rate tables in the Shipping chapter of the eBay Features Guide.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class RateTableDetailsType extends AbstractStructBase
{
    /**
     * The DomesticRateTable
     * Meta informations extracted from the WSDL
     * - documentation: On input, this field specifies which domestic shipping rate table to apply to a listing. Domestic rate tables can be used only for items listed on the eBay US, UK, DE, AU and Motors Parts and Accessories websites. <br><br> Currently,
     * sellers can configure only one domestic shipping rate table, so set <strong>DomesticRateTable</strong> = <code>Default</code> to apply that table. The rates assigned to the various domestic regions are applied depending on the location of the buyer.
     * If only one shipping service category and rate has been set for a given domestic region in the domestic rate table, buyers in that region will see only one shipping cost. If several service levels and rates are set up in the domestic shipping rate
     * table for a given domestic region, buyers in that region will see the different shipping levels and rates and can choose one of them. <br><br> If you are modifying or relisting an item (using the Revise or Relist family of calls), you can delete the
     * existing rate table setting applied to the listing by using the empty tag: <code>&lt;DomesticRateTable /&gt;</code> <br><br> This field is returned from the GetItem family of calls only for the seller who listed the item. <br><br> You can find more
     * information about using shipping rate tables in the Shipping chapter of the Trading API User's Guide.
     * - minOccurs: 0
     * @var string
     */
    public $DomesticRateTable;
    /**
     * The InternationalRateTable
     * Meta informations extracted from the WSDL
     * - documentation: On input, this field specifies which international shipping rate table to apply to a listing. International rate tables can be used only for items listed on the eBay US, UK and DE sites. <br><br> Currently, sellers can configure only
     * one international shipping rate table, so set <strong>InternationalRateTable</strong> = <code>Default</code> to apply that table. The rates assigned to the various countries are applied depending on the location of the buyer. If only one shipping
     * service category and rate has been set for a given country in the international rate table, buyers in that country will see only one shipping cost. If several service levels and rates are set up in the international shipping rate table for a given
     * country, buyers in that country will see the different shipping levels and rates and can choose one of them. <br><br> If you are modifying or relisting an item (using the Revise or Relist family of calls), you can delete the existing rate table
     * setting applied to the listing by using the empty tag: <code>&lt;InternationalRateTable /&gt;</code> <br><br> This field is returned from the GetItem family of calls only for the seller who listed the item. <br><br> You can find more information
     * about using shipping rate tables in the Shipping chapter of the Trading API User's Guide.
     * - minOccurs: 0
     * @var string
     */
    public $InternationalRateTable;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for RateTableDetailsType
     * @uses RateTableDetailsType::setDomesticRateTable()
     * @uses RateTableDetailsType::setInternationalRateTable()
     * @uses RateTableDetailsType::setAny()
     * @param string $domesticRateTable
     * @param string $internationalRateTable
     * @param \DOMDocument $any
     */
    public function __construct($domesticRateTable = null, $internationalRateTable = null, \DOMDocument $any = null)
    {
        $this
            ->setDomesticRateTable($domesticRateTable)
            ->setInternationalRateTable($internationalRateTable)
            ->setAny($any);
    }
    /**
     * Get DomesticRateTable value
     * @return string|null
     */
    public function getDomesticRateTable()
    {
        return $this->DomesticRateTable;
    }
    /**
     * Set DomesticRateTable value
     * @param string $domesticRateTable
     * @return \ebay\StructType\RateTableDetailsType
     */
    public function setDomesticRateTable($domesticRateTable = null)
    {
        // validation for constraint: string
        if (!is_null($domesticRateTable) && !is_string($domesticRateTable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domesticRateTable)), __LINE__);
        }
        $this->DomesticRateTable = $domesticRateTable;
        return $this;
    }
    /**
     * Get InternationalRateTable value
     * @return string|null
     */
    public function getInternationalRateTable()
    {
        return $this->InternationalRateTable;
    }
    /**
     * Set InternationalRateTable value
     * @param string $internationalRateTable
     * @return \ebay\StructType\RateTableDetailsType
     */
    public function setInternationalRateTable($internationalRateTable = null)
    {
        // validation for constraint: string
        if (!is_null($internationalRateTable) && !is_string($internationalRateTable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internationalRateTable)), __LINE__);
        }
        $this->InternationalRateTable = $internationalRateTable;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\RateTableDetailsType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\RateTableDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\RateTableDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
