<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductListingDetailsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type used by the <b>ProductListingDetails</b> container, which is used by a seller in an add/revise/relist call to identify a product through a Global Trade Item Number (EAN, ISBN, UPC, etc.) or EPID. If that product identifier is
 * matched to a product in the eBay catalog, some of the details for the product listing, such as item title, listing description, item specifics, and stock photo are prefilled. <br> <br> <span class="tablenote"><b>Note:</b> The <b>NameValueList</b>
 * container was added in Version 997, but it is not yet available for use in Sandbox or Production environments. Ultimately, specifying product identifiers through the <b>NameValueList</b> container will replace the process of specifying product
 * identifiers through the <b>BrandMPN</b> container, or through the <b>EAN</b>, <b>ISBN</b>, or <b>UPC</b> fields. See the documentation for the <b>NameValueList</b> container for more information on how product identifiers are specified through this
 * container. For more information on effective dates on this feature change and transition, see the <a href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandate">Required Product
 * Identifiers Mandate</a>. </span>
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class ProductListingDetailsType extends AbstractStructBase
{
    /**
     * The IncludeStockPhotoURL
     * Meta informations extracted from the WSDL
     * - documentation: If true, indicates that the item listing includes the stock photo. To use an eBay stock photo in an item listing, set <b>IncludeStockPhotoURL</b> to true. If a stock photo is available, it is used at the top of the View Item page and
     * in the Item Specifics section of the listing. If you also include <b>Item.PictureDetails.PictureURL</b>, the stock photo only appears in the Item Specifics section of the listing. Other pictures you specify by using
     * <b>Item.PictureDetails.PictureURL</b> appear in a separate section of the listing. In <b>GetItem</b>, the URL of the stock photo will be returned in <b>StockPhotoURL</b>. If you set <b>IncludeStockPhotoURL</b> to false, the stock photo does not
     * appear in the listing at all.<br> <br> <span class="tablenote"><b>Note:</b> The following sites offer free Gallery: US (site ID 0), the Parts & Accessories Category on US Motors (site ID 100), CA (site ID 2), CAFR (site ID 210), ES (site ID 186), FR
     * (site ID 71), IT (site ID 101),and NL (site ID 146). <br><br> On these sites, eBay selects a Gallery thumbnail from image URLs included in the request, using selection rules that consider which of these URLs has been specified and whether an eBay
     * stock photo exists for the item. A Gallery fee will only apply if you have set GalleryType to Plus or Featured (as basic Gallery is free).<br> <br> Along with these changes, <b>IncludeStockPhotoURL</b> will be used in the request. In some cases, if
     * <b>IncludeStockPhotoURL</b> is set to false, no image will be generated for the Gallery. A common example of this occurrence is when no <b>PictureURL</b> elements are defined in request. In this case, eBay will not use a stock photo, even if it is
     * available. </span> <br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeStockPhotoURL;
    /**
     * The UseStockPhotoURLAsGallery
     * Meta informations extracted from the WSDL
     * - documentation: If <code>true</code>, indicates that the stock photo for an item (if available) is used as the gallery thumbnail. When listing an item, <b>IncludeStockPhotoURL</b> must also be true and <b>Item.PictureDetails.GalleryType</b> must be
     * passed in with a value of Gallery or Gallery Featured (but not both). <br> <br> <span class="tablenote"><b>Note:</b> The following sites offer free Gallery: US (site ID 0), the Parts & Accessories Category on US Motors (site ID 100), CA (site ID 2),
     * CAFR (site ID 210), ES (site ID 186), FR (site ID 71), IT (site ID 101),and NL (site ID 146). <br><br> On these sites, eBay selects a Gallery thumbnail from image URLs included in the request, using selection rules that consider which of these URLs
     * has been specified and whether an eBay stock photo exists for the item. A Gallery fee will only apply if you have set <b>GalleryType</b> to Plus or Featured (as basic Gallery is free).<br> <br> Along with these changes,
     * <b>UseStockPhotoURLAsGallery</b> will be used in the request. In some cases, if <b>UseStockPhotoURLAsGallery</b> is set to false, no image will be generated for the Gallery. A common example of this occurrence is when no <b>PictureURL</b> elements
     * are defined in request. In this case, eBay will not use a stock photo, even if it is available. </span> <br>
     * - minOccurs: 0
     * @var bool
     */
    public $UseStockPhotoURLAsGallery;
    /**
     * The StockPhotoURL
     * Meta informations extracted from the WSDL
     * - documentation: Fully qualified URL for a standard image (if any) that is associated with the product. A seller includes the stock photo in the listing by setting <b>IncludeStockPhotoURL</b>.
     * - minOccurs: 0
     * @var string
     */
    public $StockPhotoURL;
    /**
     * The Copyright
     * Meta informations extracted from the WSDL
     * - documentation: Copyright statement indicating the source of the product information. This information will be included in the listing with Pre-filled Item Information. Your application should also display the copyright statement when rendering the
     * Pre-filled Item Information. If more than one copyright statement is applicable, they can be presented to the user in alphabetical order. Returned as HTML. Output only.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Copyright;
    /**
     * The ProductReferenceID
     * Meta informations extracted from the WSDL
     * - documentation: eBay's short global reference ID for a catalog product. On the eBay Web site, this is known as the "ePID" or "Product ID". This type of product ID is a fixed reference to a product (regardless of version). Multiple (versioned)
     * <b>ProductID</b> values can be associated with a single product reference ID. You can find product reference IDs for products by using <b>FindProducts</b> in the Shopping API. You can also find the product ID on eBay's Web site (a numeric value
     * prefixed with "EPID"). You can pass the value with or without the "EPID" prefix; for example "EPID228742" or "228742" (without quotes). <br><br> If the primary and secondary categories are both catalog-enabled, this ID should correspond to the
     * primary category (not the secondary category). <br><br> Some sites (such as eBay US, Germany, Austria, and Switzerland) are updating, replacing, deleting, or merging some products (as a result of migrating from one catalog data provider to another).
     * If you specify one of these products in a request, the call may return the product with a warning, or it may return an error if the product has been deleted.
     * - minOccurs: 0
     * @var string
     */
    public $ProductReferenceID;
    /**
     * The DetailsURL
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $DetailsURL;
    /**
     * The ProductDetailsURL
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $ProductDetailsURL;
    /**
     * The ReturnSearchResultOnDuplicates
     * Meta informations extracted from the WSDL
     * - documentation: Applicable for listing use cases only (not buy-side searching). Indicates what eBay should do if more than one product matches the external product ID (ISBN, UPC, EAN, Brand-MPN combination) or event specified through
     * <b>TicketListingDetails</b> . Also see <b>UseFirstProduct</b> as an alternative.<br> <br> If true and more than one match is found, the call fails and the response returns an error and all matching Product ID values. This lets you choose one of the
     * Product IDs to pass in instead. If false and more than one match is found, the call fails and the response includes an error but does not return the matching Product ID values. (This flag has no effect when only one match is found.)
     * - minOccurs: 0
     * @var bool
     */
    public $ReturnSearchResultOnDuplicates;
    /**
     * The ISBN
     * Meta informations extracted from the WSDL
     * - documentation: This field is used if the seller wishes to identify each product variation within a multi-variation listing by an ISBN (International Standard Book Number) value. An ISBN is a unique identifer for books. Both 10 and 13-character
     * ISBNs are supported. When specifying a 13-character ISBN, the value must begin with either '978' or '979'. Unlike single-variation listings where the ISBN is specified in the <b>ProductListingDetails</b> container, eBay will attempt to match this
     * ISBN value to a product in the eBay catalog, but the product's item title, item description, item specifics, and stock photos are not automatically picked up for multiple-variation listings. If a secondary category is used, and the primary and
     * secondary categories are both catalog-enabled, this ISBN value should correspond to the primary category (not the secondary category). <br/><br/> <span class="tablenote"><b>Note: </b> If the listing is being posted to a category that expects an ISBN
     * value, but one doesn't exist for the product, the seller must pass in the text that can be found in the <b>ProductDetails.ProductIdentifierUnavailableText</b> field of the <b>GeteBayDetails</b> response. To get the <b>ProductDetails</b> container to
     * return in the <b>GeteBayDetails</b> response, <code>ProductDetails</code> should be included as a <b>DetailName</b> value in the call request. </span> <br> <span class="tablenote"><b>Note:</b> Currently, the <b>BrandMPN</b> container, and/or the
     * <b>EAN</b>, <b>ISBN</b>, or <b>UPC</b> fields are used to specify a Global Trade Item Number (GTIN), and the <b>GetCategoryFeatures</b> call is used to see if particular product identifier types are supported/required. Starting later in 2017 ( dates
     * will be announced as we approach second half of year), the <b>NameValueList</b> container can start being used to specify any and all GTINs, and the <b>GetCategorySpecifics</b> call will be the better option of retrieving the product identifier types
     * that are supported/required. See the <a href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandateOld">Required Product Identifiers Mandate (Current Phase)</a> topic for more
     * information on how product identifiers are currently used/specified in the Trading API, and see the <a href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandate">Required Product
     * Identifiers Mandate (Future Phase)</a> topic for more information on how product identifiers will be used/specified in the Trading API beginning later in 2017. Note that the <b>BrandMPN</b> container, and the <b>EAN</b>, <b>ISBN</b>, and <b>UPC</b>
     * fields will still be supported well into 2018. </span>
     * - minOccurs: 0
     * @var string
     */
    public $ISBN;
    /**
     * The UPC
     * Meta informations extracted from the WSDL
     * - documentation: This field is used if the seller wishes to identify each product variation within a multi-variation listing by a UPC (Universal Product Code) value. A UPC is a commonly used identifer for many different products. Unlike
     * single-variation listings where the UPC is specified in the <b>ProductListingDetails</b> container, eBay will attempt to match this UPC value to a product in the eBay catalog, but the product's item title, item description, item specifics, and stock
     * photos are not automatically picked up for multiple-variation listings. If a secondary category is used, and the primary and secondary categories are both catalog-enabled, this UPC value should correspond to the primary category (not the secondary
     * category). <br/><br/> <span class="tablenote"><b>Note: </b> If the listing is being posted to a category that expects a UPC value, but one doesn't exist for the product, the seller must pass in the text that can be found in the
     * <b>ProductDetails.ProductIdentifierUnavailableText</b> field of the <b>GeteBayDetails</b> response. To get the <b>ProductDetails</b> container to return in the <b>GeteBayDetails</b> response, 'ProductDetails' should be included as a <b>DetailName</b>
     * value in the call request. </span> <br> <span class="tablenote"><b>Note:</b> Currently, the <b>BrandMPN</b> container, and/or the <b>EAN</b>, <b>ISBN</b>, or <b>UPC</b> fields are used to specify a Global Trade Item Number (GTIN), and the
     * <b>GetCategoryFeatures</b> call is used to see if particular product identifier types are supported/required. Starting later in 2017 ( dates will be announced as we approach second half of year), the <b>NameValueList</b> container can start being
     * used to specify any and all GTINs, and the <b>GetCategorySpecifics</b> call will be the better option of retrieving the product identifier types that are supported/required. See the <a
     * href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandateOld">Required Product Identifiers Mandate (Current Phase)</a> topic for more information on how product identifiers are
     * currently used/specified in the Trading API, and see the <a href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandate">Required Product Identifiers Mandate (Future Phase)</a> topic
     * for more information on how product identifiers will be used/specified in the Trading API beginning later in 2017. Note that the <b>BrandMPN</b> container, and the <b>EAN</b>, <b>ISBN</b>, and <b>UPC</b> fields will still be supported well into 2018.
     * </span>
     * - minOccurs: 0
     * @var string
     */
    public $UPC;
    /**
     * The EAN
     * Meta informations extracted from the WSDL
     * - documentation: This field is used if the seller wishes to identify each product variation within a multi-variation listing by an EAN (European Article Number) value. An EAN is a unique 8 or 13-digit identifier that many industries (such as book
     * publishers) use to identify products. Unlike single-variation listings where the EAN is specified in the <b>ProductListingDetails</b> container, eBay will attempt to match this EAN value to a product in the eBay catalog, but the product's item title,
     * item description, item specifics, and stock photos are not automatically picked up for multiple-variation listings. If a secondary category is used, and the primary and secondary categories are both catalog-enabled, this EAN value should correspond
     * to the primary category (not the secondary category). <br/><br/> <span class="tablenote"><b>Note: </b> If the listing is being posted to a category that expects an EAN value, but one doesn't exist for the product, the seller must pass in the text
     * that can be found in the <b>ProductDetails.ProductIdentifierUnavailableText</b> field of the <b>GeteBayDetails</b> response. To get the <b>ProductDetails</b> container to return in the <b>GeteBayDetails</b> response, 'ProductDetails' should be
     * included as a <b>DetailName</b> value in the call request. </span> <br> <span class="tablenote"><b>Note:</b> Currently, the <b>BrandMPN</b> container, and/or the <b>EAN</b>, <b>ISBN</b>, or <b>UPC</b> fields are used to specify a Global Trade Item
     * Number (GTIN), and the <b>GetCategoryFeatures</b> call is used to see if particular product identifier types are supported/required. Starting later in 2017 ( dates will be announced as we approach second half of year), the <b>NameValueList</b>
     * container can start being used to specify any and all GTINs, and the <b>GetCategorySpecifics</b> call will be the better option of retrieving the product identifier types that are supported/required. See the <a
     * href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandateOld">Required Product Identifiers Mandate (Current Phase)</a> topic for more information on how product identifiers are
     * currently used/specified in the Trading API, and see the <a href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandate">Required Product Identifiers Mandate (Future Phase)</a> topic
     * for more information on how product identifiers will be used/specified in the Trading API beginning later in 2017. Note that the <b>BrandMPN</b> container, and the <b>EAN</b>, <b>ISBN</b>, and <b>UPC</b> fields will still be supported well into 2018.
     * </span>
     * - minOccurs: 0
     * @var string
     */
    public $EAN;
    /**
     * The BrandMPN
     * Meta informations extracted from the WSDL
     * - documentation: The combination of Brand and MPN (manufacturer part number) can be used as a unique identifier for a product. If this container is used, both <b>Brand</b> and <b>MPN</b> must be specified. <br> <br> It is a best practice to also
     * specify the Brand/MPN values in two separate <b>ItemSpecifics.NameValueList</b> containers. The values in the <b>BrandMPN</b> container are used to look for an eBay catalog product match, but if a match is not found, these Brand and MPN values are
     * dropped from the listing. By also specifying these Brand and MPN values in Item Specifics, these values are retained in the listing. If the Brand and MPN values in the <b>BrandMPN</b> container and <b>ItemSpecifics.NameValueList</b> containers
     * differ, the values in the <b>ItemSpecifics.NameValueList</b> containers will overwrite the values of the <b>BrandMPN</b> container. <br> <br> <span class="tablenote"><b>Note:</b> The <b>BrandMPN</b> container (and eBay catalog product lookup) is not
     * supported for multiple-variation listings. For multiple-variation listings that use MPNs, the <b>Brand</b> value should be specified through an <b>ItemSpecifics.NameValueList</b> container, and the Manufacturer Part Numbers (MPNs) for each product
     * variation should be specified through a <b>VariationSpecifics.NameValueList</b> container. </span> <br> <span class="tablenote"><b>Note:</b> Currently, the <b>BrandMPN</b> container, and/or the <b>EAN</b>, <b>ISBN</b>, or <b>UPC</b> fields are used
     * to specify a Global Trade Item Number (GTIN), and the <b>GetCategoryFeatures</b> call is used to see if particular product identifier types are supported/required. Starting later in 2017 ( dates will be announced as we approach second half of year),
     * the <b>NameValueList</b> container can start being used to specify any and all GTINs, and the <b>GetCategorySpecifics</b> call will be the better option of retrieving the product identifier types that are supported/required. See the <a
     * href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandateOld">Required Product Identifiers Mandate (Current Phase)</a> topic for more information on how product identifiers are
     * currently used/specified in the Trading API, and see the <a href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandate">Required Product Identifiers Mandate (Future Phase)</a> topic
     * for more information on how product identifiers will be used/specified in the Trading API beginning later in 2017. Note that the <b>BrandMPN</b> container, and the <b>EAN</b>, <b>ISBN</b>, and <b>UPC</b> fields will still be supported well into 2018.
     * </span>
     * - minOccurs: 0
     * @var \ebay\StructType\BrandMPNType
     */
    public $BrandMPN;
    /**
     * The TicketListingDetails
     * Meta informations extracted from the WSDL
     * - documentation: Applicable for listing use cases only (not buy-side searching). Only applicable when you are listing event tickets. Please note that the US eBay site and other sites may also require you to specify additional Item Specifics by using
     * AttributeSetArray. This may depend on the location of the event. See the eBay Features Guide for more information about how to specify and troubleshoot these values.
     * - minOccurs: 0
     * @var \ebay\StructType\TicketListingDetailsType
     */
    public $TicketListingDetails;
    /**
     * The UseFirstProduct
     * Meta informations extracted from the WSDL
     * - documentation: Applicable for listing use cases only (not buy-side searching). Indicates what eBay should do if more than one product matches the external product ID (ISBN, UPC, EAN, <b>BrandMPN</b>, or <b>TicketListingDetails</b>). Also see
     * <b>ReturnSearchResultOnDuplicates</b> as an alternative. If more than one product match was found and <b>UseFirstProduct</b> is true, item will be listed with first product information. If false, the rules for ReturnSearchResultOnDuplicates are used.
     * - minOccurs: 0
     * @var bool
     */
    public $UseFirstProduct;
    /**
     * The IncludeeBayProductDetails
     * Meta informations extracted from the WSDL
     * - documentation: This boolean field controls whether or not an eBay catalog product is used to help create or revise an item listing. If a product identifier value is provided through the <b>ProductListingDetails</b> container when adding, revising,
     * or relisting an item, the default behavior is for eBay to try and find a match for the product in the eBay product catalog, and then automatically create the listing title, item specifics, item description, pictures (for "New" condition items), and
     * assign a category. <br><br> If the seller wants to use the eBay product catalog to help create or revise the listing, the seller can include this field and set its value to <code>true</code>, or just omit this field, as it default value is
     * <code>true</code>. If a seller doesn't want the eBay product catalog information in their listing, that seller would have to include this field and set its value to <code>false</code>. If the seller does this, they will also be required to pass in
     * their own listing title and description, item specifics, and pictures, and select a listing category. <br> <br>
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeeBayProductDetails;
    /**
     * The NameValueList
     * Meta informations extracted from the WSDL
     * - documentation: <span class="tablenote"><b>Note:</b> The <b>NameValueList</b> container was added in Version 997, but it is not yet available for use in Sandbox or Production environments. Currently, the <b>BrandMPN</b> container, and/or the
     * <b>EAN</b>, <b>ISBN</b>, or <b>UPC</b> fields are used to specify a Global Trade Item Number (GTIN), and the <b>GetCategoryFeatures</b> call is used to see if particular product identifier types are supported/required. Starting later in 2017 ( dates
     * will be announced as we approach second half of year), the <b>NameValueList</b> container can start being used to specify any and all GTINs, and the <b>GetCategorySpecifics</b> call will be the better option of retrieving the product identifier types
     * that are supported/required. See the <a href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandateOld">Required Product Identifiers Mandate (Current Phase)</a> topic for more
     * information on how product identifiers are currently used/specified in the Trading API, and see the <a href="https://developer.ebay.com/devzone/guides/ebayfeatures/Development/Listing-AnItem.html#RequiredProductIdentifiersMandate">Required Product
     * Identifiers Mandate (Future Phase)</a> topic for more information on how product identifiers will be used/specified in the Trading API beginning later in 2017. Note that the <b>BrandMPN</b> container, and the <b>EAN</b>, <b>ISBN</b>, and <b>UPC</b>
     * fields will still be supported well into 2018. </span> This container is used to pass in a name-value pair that will identify the type of product identifier being used and its value. This product identifier, such as EAN, ISBN, or UPC, is then used by
     * eBay to try and match the identifier to a product in the eBay catalog. If a Brand/MPN pair is going to be used to identify a product, the brand is specified in one <b>NameValueList</b> container, and its Manufacturer Part Number (MPN) is specified in
     * another <b>NameValueList</b> container. Also, if a product has more than one product identifier, each can be specified through separate <b>NameValueList</b> containers. <br> <br> The <b>GetCategorySpecifics</b> call can be used to see the product
     * identifier type(s) that are required/supported for a particular eBay category. Each required/supported product identifier type will be shown in a separate <b>ProductIdentifiers.NameRecommendation</b> container in the <b>GetCategorySpecifics</b> call
     * response. The product identifier type name will be shown in the <b>NameRecommendation.Name</b> field. By looking at the value in the corresponding <b>ProductIdentifiers.ValidationRules.MinRequired</b> field, the seller will know if one or more
     * product identifiers are required at listing time. If two product identifier types are returned, and the <b>MinRequired</b> value is '2', the seller will be required to use both product identifier types at listing time. If the <b>MinRequired</b> value
     * is '1', only one of the two product identifier types would be required, but the seller could use them both if they wanted. If the <b>MinRequired</b> value is 0, one or both of those product identifier types could be used, but they would not be
     * required. <br> <br> It is a best practice to also specify the Brand/MPN values in two separate <b>ItemSpecifics.NameValueList</b> containers. The values in the <b>BrandMPN</b> container are used to look for an eBay catalog product match, but if a
     * match is not found, these Brand and MPN values are dropped from the listing. By also specifying these Brand and MPN values in Item Specifics, these values are retained in the listing. If the Brand and MPN values in the <b>BrandMPN</b> container and
     * <b>ItemSpecifics.NameValueList</b> containers differ, the values in the <b>ItemSpecifics.NameValueList</b> containers will overwrite the values of the <b>BrandMPN</b> container.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\NameValueListType[]
     */
    public $NameValueList;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for ProductListingDetailsType
     * @uses ProductListingDetailsType::setIncludeStockPhotoURL()
     * @uses ProductListingDetailsType::setUseStockPhotoURLAsGallery()
     * @uses ProductListingDetailsType::setStockPhotoURL()
     * @uses ProductListingDetailsType::setCopyright()
     * @uses ProductListingDetailsType::setProductReferenceID()
     * @uses ProductListingDetailsType::setDetailsURL()
     * @uses ProductListingDetailsType::setProductDetailsURL()
     * @uses ProductListingDetailsType::setReturnSearchResultOnDuplicates()
     * @uses ProductListingDetailsType::setISBN()
     * @uses ProductListingDetailsType::setUPC()
     * @uses ProductListingDetailsType::setEAN()
     * @uses ProductListingDetailsType::setBrandMPN()
     * @uses ProductListingDetailsType::setTicketListingDetails()
     * @uses ProductListingDetailsType::setUseFirstProduct()
     * @uses ProductListingDetailsType::setIncludeeBayProductDetails()
     * @uses ProductListingDetailsType::setNameValueList()
     * @uses ProductListingDetailsType::setAny()
     * @param bool $includeStockPhotoURL
     * @param bool $useStockPhotoURLAsGallery
     * @param string $stockPhotoURL
     * @param string[] $copyright
     * @param string $productReferenceID
     * @param string $detailsURL
     * @param string $productDetailsURL
     * @param bool $returnSearchResultOnDuplicates
     * @param string $iSBN
     * @param string $uPC
     * @param string $eAN
     * @param \ebay\StructType\BrandMPNType $brandMPN
     * @param \ebay\StructType\TicketListingDetailsType $ticketListingDetails
     * @param bool $useFirstProduct
     * @param bool $includeeBayProductDetails
     * @param \ebay\StructType\NameValueListType[] $nameValueList
     * @param \DOMDocument $any
     */
    public function __construct($includeStockPhotoURL = null, $useStockPhotoURLAsGallery = null, $stockPhotoURL = null, array $copyright = array(), $productReferenceID = null, $detailsURL = null, $productDetailsURL = null, $returnSearchResultOnDuplicates = null, $iSBN = null, $uPC = null, $eAN = null, \ebay\StructType\BrandMPNType $brandMPN = null, \ebay\StructType\TicketListingDetailsType $ticketListingDetails = null, $useFirstProduct = null, $includeeBayProductDetails = null, array $nameValueList = array(), \DOMDocument $any = null)
    {
        $this
            ->setIncludeStockPhotoURL($includeStockPhotoURL)
            ->setUseStockPhotoURLAsGallery($useStockPhotoURLAsGallery)
            ->setStockPhotoURL($stockPhotoURL)
            ->setCopyright($copyright)
            ->setProductReferenceID($productReferenceID)
            ->setDetailsURL($detailsURL)
            ->setProductDetailsURL($productDetailsURL)
            ->setReturnSearchResultOnDuplicates($returnSearchResultOnDuplicates)
            ->setISBN($iSBN)
            ->setUPC($uPC)
            ->setEAN($eAN)
            ->setBrandMPN($brandMPN)
            ->setTicketListingDetails($ticketListingDetails)
            ->setUseFirstProduct($useFirstProduct)
            ->setIncludeeBayProductDetails($includeeBayProductDetails)
            ->setNameValueList($nameValueList)
            ->setAny($any);
    }
    /**
     * Get IncludeStockPhotoURL value
     * @return bool|null
     */
    public function getIncludeStockPhotoURL()
    {
        return $this->IncludeStockPhotoURL;
    }
    /**
     * Set IncludeStockPhotoURL value
     * @param bool $includeStockPhotoURL
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setIncludeStockPhotoURL($includeStockPhotoURL = null)
    {
        $this->IncludeStockPhotoURL = $includeStockPhotoURL;
        return $this;
    }
    /**
     * Get UseStockPhotoURLAsGallery value
     * @return bool|null
     */
    public function getUseStockPhotoURLAsGallery()
    {
        return $this->UseStockPhotoURLAsGallery;
    }
    /**
     * Set UseStockPhotoURLAsGallery value
     * @param bool $useStockPhotoURLAsGallery
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setUseStockPhotoURLAsGallery($useStockPhotoURLAsGallery = null)
    {
        $this->UseStockPhotoURLAsGallery = $useStockPhotoURLAsGallery;
        return $this;
    }
    /**
     * Get StockPhotoURL value
     * @return string|null
     */
    public function getStockPhotoURL()
    {
        return $this->StockPhotoURL;
    }
    /**
     * Set StockPhotoURL value
     * @param string $stockPhotoURL
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setStockPhotoURL($stockPhotoURL = null)
    {
        // validation for constraint: string
        if (!is_null($stockPhotoURL) && !is_string($stockPhotoURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stockPhotoURL)), __LINE__);
        }
        $this->StockPhotoURL = $stockPhotoURL;
        return $this;
    }
    /**
     * Get Copyright value
     * @return string[]|null
     */
    public function getCopyright()
    {
        return $this->Copyright;
    }
    /**
     * Set Copyright value
     * @throws \InvalidArgumentException
     * @param string[] $copyright
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setCopyright(array $copyright = array())
    {
        foreach ($copyright as $productListingDetailsTypeCopyrightItem) {
            // validation for constraint: itemType
            if (!is_string($productListingDetailsTypeCopyrightItem)) {
                throw new \InvalidArgumentException(sprintf('The Copyright property can only contain items of string, "%s" given', is_object($productListingDetailsTypeCopyrightItem) ? get_class($productListingDetailsTypeCopyrightItem) : gettype($productListingDetailsTypeCopyrightItem)), __LINE__);
            }
        }
        $this->Copyright = $copyright;
        return $this;
    }
    /**
     * Add item to Copyright value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function addToCopyright($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Copyright property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Copyright[] = $item;
        return $this;
    }
    /**
     * Get ProductReferenceID value
     * @return string|null
     */
    public function getProductReferenceID()
    {
        return $this->ProductReferenceID;
    }
    /**
     * Set ProductReferenceID value
     * @param string $productReferenceID
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setProductReferenceID($productReferenceID = null)
    {
        // validation for constraint: string
        if (!is_null($productReferenceID) && !is_string($productReferenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productReferenceID)), __LINE__);
        }
        $this->ProductReferenceID = $productReferenceID;
        return $this;
    }
    /**
     * Get DetailsURL value
     * @return string|null
     */
    public function getDetailsURL()
    {
        return $this->DetailsURL;
    }
    /**
     * Set DetailsURL value
     * @param string $detailsURL
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setDetailsURL($detailsURL = null)
    {
        // validation for constraint: string
        if (!is_null($detailsURL) && !is_string($detailsURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($detailsURL)), __LINE__);
        }
        $this->DetailsURL = $detailsURL;
        return $this;
    }
    /**
     * Get ProductDetailsURL value
     * @return string|null
     */
    public function getProductDetailsURL()
    {
        return $this->ProductDetailsURL;
    }
    /**
     * Set ProductDetailsURL value
     * @param string $productDetailsURL
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setProductDetailsURL($productDetailsURL = null)
    {
        // validation for constraint: string
        if (!is_null($productDetailsURL) && !is_string($productDetailsURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDetailsURL)), __LINE__);
        }
        $this->ProductDetailsURL = $productDetailsURL;
        return $this;
    }
    /**
     * Get ReturnSearchResultOnDuplicates value
     * @return bool|null
     */
    public function getReturnSearchResultOnDuplicates()
    {
        return $this->ReturnSearchResultOnDuplicates;
    }
    /**
     * Set ReturnSearchResultOnDuplicates value
     * @param bool $returnSearchResultOnDuplicates
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setReturnSearchResultOnDuplicates($returnSearchResultOnDuplicates = null)
    {
        $this->ReturnSearchResultOnDuplicates = $returnSearchResultOnDuplicates;
        return $this;
    }
    /**
     * Get ISBN value
     * @return string|null
     */
    public function getISBN()
    {
        return $this->ISBN;
    }
    /**
     * Set ISBN value
     * @param string $iSBN
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setISBN($iSBN = null)
    {
        // validation for constraint: string
        if (!is_null($iSBN) && !is_string($iSBN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iSBN)), __LINE__);
        }
        $this->ISBN = $iSBN;
        return $this;
    }
    /**
     * Get UPC value
     * @return string|null
     */
    public function getUPC()
    {
        return $this->UPC;
    }
    /**
     * Set UPC value
     * @param string $uPC
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setUPC($uPC = null)
    {
        // validation for constraint: string
        if (!is_null($uPC) && !is_string($uPC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uPC)), __LINE__);
        }
        $this->UPC = $uPC;
        return $this;
    }
    /**
     * Get EAN value
     * @return string|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param string $eAN
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setEAN($eAN = null)
    {
        // validation for constraint: string
        if (!is_null($eAN) && !is_string($eAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eAN)), __LINE__);
        }
        $this->EAN = $eAN;
        return $this;
    }
    /**
     * Get BrandMPN value
     * @return \ebay\StructType\BrandMPNType|null
     */
    public function getBrandMPN()
    {
        return $this->BrandMPN;
    }
    /**
     * Set BrandMPN value
     * @param \ebay\StructType\BrandMPNType $brandMPN
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setBrandMPN(\ebay\StructType\BrandMPNType $brandMPN = null)
    {
        $this->BrandMPN = $brandMPN;
        return $this;
    }
    /**
     * Get TicketListingDetails value
     * @return \ebay\StructType\TicketListingDetailsType|null
     */
    public function getTicketListingDetails()
    {
        return $this->TicketListingDetails;
    }
    /**
     * Set TicketListingDetails value
     * @param \ebay\StructType\TicketListingDetailsType $ticketListingDetails
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setTicketListingDetails(\ebay\StructType\TicketListingDetailsType $ticketListingDetails = null)
    {
        $this->TicketListingDetails = $ticketListingDetails;
        return $this;
    }
    /**
     * Get UseFirstProduct value
     * @return bool|null
     */
    public function getUseFirstProduct()
    {
        return $this->UseFirstProduct;
    }
    /**
     * Set UseFirstProduct value
     * @param bool $useFirstProduct
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setUseFirstProduct($useFirstProduct = null)
    {
        $this->UseFirstProduct = $useFirstProduct;
        return $this;
    }
    /**
     * Get IncludeeBayProductDetails value
     * @return bool|null
     */
    public function getIncludeeBayProductDetails()
    {
        return $this->IncludeeBayProductDetails;
    }
    /**
     * Set IncludeeBayProductDetails value
     * @param bool $includeeBayProductDetails
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setIncludeeBayProductDetails($includeeBayProductDetails = null)
    {
        $this->IncludeeBayProductDetails = $includeeBayProductDetails;
        return $this;
    }
    /**
     * Get NameValueList value
     * @return \ebay\StructType\NameValueListType[]|null
     */
    public function getNameValueList()
    {
        return $this->NameValueList;
    }
    /**
     * Set NameValueList value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\NameValueListType[] $nameValueList
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setNameValueList(array $nameValueList = array())
    {
        foreach ($nameValueList as $productListingDetailsTypeNameValueListItem) {
            // validation for constraint: itemType
            if (!$productListingDetailsTypeNameValueListItem instanceof \ebay\StructType\NameValueListType) {
                throw new \InvalidArgumentException(sprintf('The NameValueList property can only contain items of \ebay\StructType\NameValueListType, "%s" given', is_object($productListingDetailsTypeNameValueListItem) ? get_class($productListingDetailsTypeNameValueListItem) : gettype($productListingDetailsTypeNameValueListItem)), __LINE__);
            }
        }
        $this->NameValueList = $nameValueList;
        return $this;
    }
    /**
     * Add item to NameValueList value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\NameValueListType $item
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function addToNameValueList(\ebay\StructType\NameValueListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\NameValueListType) {
            throw new \InvalidArgumentException(sprintf('The NameValueList property can only contain items of \ebay\StructType\NameValueListType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NameValueList[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\ProductListingDetailsType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\ProductListingDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
