<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaginatedTransactionArrayType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Contains a paginated list of order line items.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class PaginatedTransactionArrayType extends AbstractStructBase
{
    /**
     * The TransactionArray
     * Meta informations extracted from the WSDL
     * - documentation: Contains a list of Transaction objects. Returned as an empty tag if no applicable order line items exist.
     * - minOccurs: 0
     * @var \ebay\ArrayType\TransactionArrayType
     */
    public $TransactionArray;
    /**
     * The PaginationResult
     * Meta informations extracted from the WSDL
     * - documentation: Provides information about the list of order line items, including number of pages and number of entries.
     * - minOccurs: 0
     * @var \ebay\StructType\PaginationResultType
     */
    public $PaginationResult;
    /**
     * Constructor method for PaginatedTransactionArrayType
     * @uses PaginatedTransactionArrayType::setTransactionArray()
     * @uses PaginatedTransactionArrayType::setPaginationResult()
     * @param \ebay\ArrayType\TransactionArrayType $transactionArray
     * @param \ebay\StructType\PaginationResultType $paginationResult
     */
    public function __construct(\ebay\ArrayType\TransactionArrayType $transactionArray = null, \ebay\StructType\PaginationResultType $paginationResult = null)
    {
        $this
            ->setTransactionArray($transactionArray)
            ->setPaginationResult($paginationResult);
    }
    /**
     * Get TransactionArray value
     * @return \ebay\ArrayType\TransactionArrayType|null
     */
    public function getTransactionArray()
    {
        return $this->TransactionArray;
    }
    /**
     * Set TransactionArray value
     * @param \ebay\ArrayType\TransactionArrayType $transactionArray
     * @return \ebay\StructType\PaginatedTransactionArrayType
     */
    public function setTransactionArray(\ebay\ArrayType\TransactionArrayType $transactionArray = null)
    {
        $this->TransactionArray = $transactionArray;
        return $this;
    }
    /**
     * Get PaginationResult value
     * @return \ebay\StructType\PaginationResultType|null
     */
    public function getPaginationResult()
    {
        return $this->PaginationResult;
    }
    /**
     * Set PaginationResult value
     * @param \ebay\StructType\PaginationResultType $paginationResult
     * @return \ebay\StructType\PaginatedTransactionArrayType
     */
    public function setPaginationResult(\ebay\StructType\PaginationResultType $paginationResult = null)
    {
        $this->PaginationResult = $paginationResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\PaginatedTransactionArrayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
