<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaximumUnpaidItemStrikesInfoType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type defining the <b>MaximumUnpaidItemStrikesInfo</b> container, which is used by the seller as a mechanism to block prospective buyers who have unpaid item strikes on their account exceeding the value set in the <b>Count</b> field
 * during a specified time period (set in the <b>Period</b> field).
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class MaximumUnpaidItemStrikesInfoType extends AbstractStructBase
{
    /**
     * The Count
     * Meta informations extracted from the WSDL
     * - documentation: This integer value sets the maximum number of unpaid item strikes that a prospective buyer is allowed to have during a specified time period (<b>MaximumUnpaidItemStrikesInfo.Period</b>) before being blocked from buying/bidding on the
     * item. <br><br> To retrieve a list of allowed values for this field, the seller should call <b>GeteBayDetails</b>, including <b>BuyerRequirementDetails</b> in the <b>DetailName</b> field of the request, and then look for the
     * <b>BuyerRequirementDetails.MaximumUnpaidItemStrikesInfo.MaximumUnpaidItemStrikesCount.Count</b> fields in the response.
     * - minOccurs: 0
     * @var int
     */
    public $Count;
    /**
     * The Period
     * Meta informations extracted from the WSDL
     * - documentation: This enumerated value defines the length of time over which a prospective buyer's unpaid item strikes will be counted. If the prospective buyer's number of unpaid item strikes during this defined period exceeds the value set in the
     * <b>Count</b> field, that prospective buyer is blocked from buying/bidding on the item. <br/><br/> If the <b>Count</b> value is 2, and the specified <b>Period</b> is 'Days_30' (counting back 30 days from the present day), any prospective buyer that
     * has had three or more unpaid item strikes is blocked from buying/bidding on the item.
     * - minOccurs: 0
     * @var string
     */
    public $Period;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for MaximumUnpaidItemStrikesInfoType
     * @uses MaximumUnpaidItemStrikesInfoType::setCount()
     * @uses MaximumUnpaidItemStrikesInfoType::setPeriod()
     * @uses MaximumUnpaidItemStrikesInfoType::setAny()
     * @param int $count
     * @param string $period
     * @param \DOMDocument $any
     */
    public function __construct($count = null, $period = null, \DOMDocument $any = null)
    {
        $this
            ->setCount($count)
            ->setPeriod($period)
            ->setAny($any);
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \ebay\StructType\MaximumUnpaidItemStrikesInfoType
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get Period value
     * @return string|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @uses \ebay\EnumType\PeriodCodeType::valueIsValid()
     * @uses \ebay\EnumType\PeriodCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $period
     * @return \ebay\StructType\MaximumUnpaidItemStrikesInfoType
     */
    public function setPeriod($period = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\PeriodCodeType::valueIsValid($period)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $period, implode(', ', \ebay\EnumType\PeriodCodeType::getValidValues())), __LINE__);
        }
        $this->Period = $period;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\MaximumUnpaidItemStrikesInfoType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\MaximumUnpaidItemStrikesInfoType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\MaximumUnpaidItemStrikesInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
