<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryStatusType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lightweight type for updating basic inventory status details. Primarily intended for bulk use cases.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class InventoryStatusType extends AbstractStructBase
{
    /**
     * The SKU
     * Meta informations extracted from the WSDL
     * - documentation: The unique SKU of the item being revised. A SKU (stock keeping unit) is an identifier defined by a seller. SKU can only be used to revise an item if you listed the item by using AddFixedPriceItem or RelistFixedPriceItem, and:<br> 1)
     * You set Item.InventoryTrackingMethod to SKU at the time the item was listed; or <br> 2) You are modifying a multi-variation listing, and the SKU identifies one of the variations. (In this case, if InventoryTrackingMethod was set to ItemID, then you
     * also need to specify ItemID in the request.)<br> (These criteria are necessary to uniquely identify the listing or variation by a SKU.)<br> <br> In the ReviseInventoryStatus request, if the listing has InventoryTrackingMethod set to SKU, then either
     * ItemID or SKU is required. If both are passed in and they don't refer to the same listing, eBay ignores SKU and considers only the ItemID.<br> <br> If the listing has variations and InventoryTrackingMethod is set to ItemID, then ItemID and SKU are
     * both required.<br> <br> In the response, SKU may be returned as an empty element if it was not defined on the listing. | Primitive type that represents a stock-keeping unit (SKU). The usage of this string may vary in different contexts. For usage
     * information and rules, see the fields that reference this type.
     * - minOccurs: 0
     * @var string
     */
    public $SKU;
    /**
     * The ItemID
     * Meta informations extracted from the WSDL
     * - documentation: The ItemID of a listing being changed. <br> <br> In the ReviseInventoryStatus request, either ItemID or SKU is required. If both are passed in and the SKU does not match, eBay ignores SKU and considers only the ItemID.<br> <br>
     * Please note that the same ItemID can be returned multiple times in the same response if you revise several variations from the same multi-variation listing. | Type that represents the unique identifier for a single item listing.
     * - minOccurs: 0
     * @var string
     */
    public $ItemID;
    /**
     * The StartPrice
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the revised fixed price of the listing (or of a variation within a multi-variation listing). If you raise the price of a listing, the recent sales score of the listing is reset. (Best Match search ranking is based on buyer
     * activity, and one of the factors affecting search ranking for fixed-price listings is the recent sales score.)<br> <br> Raising a listing's price may also affect the insertion fee (and therefore the overall listing fee).<br> <br>
     * ReviseInventoryStatus requires either StartPrice or Quantity (or both) for each InventoryStatus node in the request.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $StartPrice;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the latest quantity of the listing (or of a variation within a multi-variation listing).<br> <br> <b>For the ReviseInventoryStatus request:</b> Specify the entire quantity that is currently available for sale. (Typically,
     * you only pass this in when you need to update the quantity.)<br> <br> ReviseInventoryStatus requires either StartPrice or Quantity (or you can specify both) for each InventoryStatus node in the request.<br> <br> <b>For the ReviseInventoryStatus
     * response:</b> This returns a total of the quantity available for sale plus the quantity already sold. For example, suppose the listing originally had Quantity=10, and then 8 sold. Now you restock your inventory, and you pass Quantity=10 in the
     * ReviseInventoryStatus request. In this case, ReviseInventoryStatus returns Quantity=18 (10 available + 8 sold). To determine the quantity available, use GetItem or GetSellerList, and subtract SellingStatus.QuantitySold from Quantity. Or see
     * QuantityAvailable in GetMyeBaySelling.<br> <br> It is a good idea to maintain an adequate quantity available for fixed-price GTC listings to prevent the search rankings from dropping. Best Match search ranking is based on buyer activity, and one of
     * the factors affecting search ranking for fixed-price listings is the recent sales score. Fixed-price items that are selling the fastest are given a relative lift in search results. Recent Sales history is tracked with a moving window to ensure it
     * reflects the most recent activity. Due to he moving window, it is advantageous to maintain item availability (Quantity-QuantitySold) for a GTC listing.
     * - minOccurs: 0
     * @var int
     */
    public $Quantity;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for InventoryStatusType
     * @uses InventoryStatusType::setSKU()
     * @uses InventoryStatusType::setItemID()
     * @uses InventoryStatusType::setStartPrice()
     * @uses InventoryStatusType::setQuantity()
     * @uses InventoryStatusType::setAny()
     * @param string $sKU
     * @param string $itemID
     * @param \ebay\StructType\AmountType $startPrice
     * @param int $quantity
     * @param \DOMDocument $any
     */
    public function __construct($sKU = null, $itemID = null, \ebay\StructType\AmountType $startPrice = null, $quantity = null, \DOMDocument $any = null)
    {
        $this
            ->setSKU($sKU)
            ->setItemID($itemID)
            ->setStartPrice($startPrice)
            ->setQuantity($quantity)
            ->setAny($any);
    }
    /**
     * Get SKU value
     * @return string|null
     */
    public function getSKU()
    {
        return $this->SKU;
    }
    /**
     * Set SKU value
     * @param string $sKU
     * @return \ebay\StructType\InventoryStatusType
     */
    public function setSKU($sKU = null)
    {
        // validation for constraint: string
        if (!is_null($sKU) && !is_string($sKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sKU)), __LINE__);
        }
        $this->SKU = $sKU;
        return $this;
    }
    /**
     * Get ItemID value
     * @return string|null
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param string $itemID
     * @return \ebay\StructType\InventoryStatusType
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: string
        if (!is_null($itemID) && !is_string($itemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get StartPrice value
     * @return \ebay\StructType\AmountType|null
     */
    public function getStartPrice()
    {
        return $this->StartPrice;
    }
    /**
     * Set StartPrice value
     * @param \ebay\StructType\AmountType $startPrice
     * @return \ebay\StructType\InventoryStatusType
     */
    public function setStartPrice(\ebay\StructType\AmountType $startPrice = null)
    {
        $this->StartPrice = $startPrice;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \ebay\StructType\InventoryStatusType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\InventoryStatusType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\InventoryStatusType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\InventoryStatusType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
