<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStoreRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Retrieves configuration information for the eBay store owned by the specified UserID, or by the caller.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetStoreRequestType extends AbstractRequestType
{
    /**
     * The CategoryStructureOnly
     * Meta informations extracted from the WSDL
     * - documentation: If this is set to True, only the category structure of the store is returned. If this is not specified or set to False, the complete store configuration is returned.
     * - minOccurs: 0
     * @var bool
     */
    public $CategoryStructureOnly;
    /**
     * The RootCategoryID
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the category ID for the topmost category to return (along with the subcategories under it, the value of the LevelLimit property determining how deep). This tag is optional. If RootCategoryID is not specified, then the
     * category tree starting at that root Category is returned.
     * - minOccurs: 0
     * @var int
     */
    public $RootCategoryID;
    /**
     * The LevelLimit
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the limit for the number of levels of the category hierarchy to return, where the given root category is level 1 and its children are level 2. Only categories at or above the level specified are returned. This tag is
     * optional. If LevelLimit is not set, the complete category hierarchy is returned. Stores support category hierarchies up to 3 levels only.
     * - minOccurs: 0
     * @var int
     */
    public $LevelLimit;
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the user whose store data is to be returned. If not specified, then the store returned is that for the requesting user. | This is a string wrapper for the eBay ID that uniquely identifies a user. This is used by several
     * other types to identify a specific eBay user, such as DisputeType.xsd, FeedbackInfoType.xsd, GetAllBidders, OrderType, and so on. <br><br>For GetAllBidders, some bidder information is anonymous, to protect bidders from fraud. If the seller makes this
     * API call, the actual IDs of all bidders on the seller's item will be returned. If a bidder makes this API call, the bidder's actual ID will be returned, but information for all competing bidders or outside watchers will be returned as anonymized
     * userIDs.
     * - minOccurs: 0
     * @var string
     */
    public $UserID;
    /**
     * Constructor method for GetStoreRequestType
     * @uses GetStoreRequestType::setCategoryStructureOnly()
     * @uses GetStoreRequestType::setRootCategoryID()
     * @uses GetStoreRequestType::setLevelLimit()
     * @uses GetStoreRequestType::setUserID()
     * @param bool $categoryStructureOnly
     * @param int $rootCategoryID
     * @param int $levelLimit
     * @param string $userID
     */
    public function __construct($categoryStructureOnly = null, $rootCategoryID = null, $levelLimit = null, $userID = null)
    {
        $this
            ->setCategoryStructureOnly($categoryStructureOnly)
            ->setRootCategoryID($rootCategoryID)
            ->setLevelLimit($levelLimit)
            ->setUserID($userID);
    }
    /**
     * Get CategoryStructureOnly value
     * @return bool|null
     */
    public function getCategoryStructureOnly()
    {
        return $this->CategoryStructureOnly;
    }
    /**
     * Set CategoryStructureOnly value
     * @param bool $categoryStructureOnly
     * @return \ebay\StructType\GetStoreRequestType
     */
    public function setCategoryStructureOnly($categoryStructureOnly = null)
    {
        $this->CategoryStructureOnly = $categoryStructureOnly;
        return $this;
    }
    /**
     * Get RootCategoryID value
     * @return int|null
     */
    public function getRootCategoryID()
    {
        return $this->RootCategoryID;
    }
    /**
     * Set RootCategoryID value
     * @param int $rootCategoryID
     * @return \ebay\StructType\GetStoreRequestType
     */
    public function setRootCategoryID($rootCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($rootCategoryID) && !is_numeric($rootCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rootCategoryID)), __LINE__);
        }
        $this->RootCategoryID = $rootCategoryID;
        return $this;
    }
    /**
     * Get LevelLimit value
     * @return int|null
     */
    public function getLevelLimit()
    {
        return $this->LevelLimit;
    }
    /**
     * Set LevelLimit value
     * @param int $levelLimit
     * @return \ebay\StructType\GetStoreRequestType
     */
    public function setLevelLimit($levelLimit = null)
    {
        // validation for constraint: int
        if (!is_null($levelLimit) && !is_numeric($levelLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($levelLimit)), __LINE__);
        }
        $this->LevelLimit = $levelLimit;
        return $this;
    }
    /**
     * Get UserID value
     * @return string|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \ebay\StructType\GetStoreRequestType
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetStoreRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
