<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStoreCategoryUpdateStatusRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Returns the status of the processing for category-structure changes specified with a call to SetStoreCategories.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetStoreCategoryUpdateStatusRequestType extends AbstractRequestType
{
    /**
     * The TaskID
     * Meta informations extracted from the WSDL
     * - documentation: The task ID returned by the SetStoreCategories call. If the SetStoreCategories call was processed asynchronously, the TaskID will be a positive number. If SetStoreCategories returned a TaskID with a value of 0, the change was
     * completed at the time the call was made (and there is no need to check status).
     * - minOccurs: 0
     * @var int
     */
    public $TaskID;
    /**
     * Constructor method for GetStoreCategoryUpdateStatusRequestType
     * @uses GetStoreCategoryUpdateStatusRequestType::setTaskID()
     * @param int $taskID
     */
    public function __construct($taskID = null)
    {
        $this
            ->setTaskID($taskID);
    }
    /**
     * Get TaskID value
     * @return int|null
     */
    public function getTaskID()
    {
        return $this->TaskID;
    }
    /**
     * Set TaskID value
     * @param int $taskID
     * @return \ebay\StructType\GetStoreCategoryUpdateStatusRequestType
     */
    public function setTaskID($taskID = null)
    {
        // validation for constraint: int
        if (!is_null($taskID) && !is_numeric($taskID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($taskID)), __LINE__);
        }
        $this->TaskID = $taskID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetStoreCategoryUpdateStatusRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
