<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyeBayBuyingResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Returns information regarding a user's buying activity, such as items they are watching, bidding on, have won, did not win, and have made Best Offers on.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetMyeBayBuyingResponseType extends AbstractResponseType
{
    /**
     * The BuyingSummary
     * Meta informations extracted from the WSDL
     * - documentation: Contains a summary of the items the user has bid on. Returned at all detail levels.
     * - minOccurs: 0
     * @var \ebay\StructType\BuyingSummaryType
     */
    public $BuyingSummary;
    /**
     * The WatchList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the user is watching. Only returned if items exist that meet the request criteria.
     * - minOccurs: 0
     * @var \ebay\StructType\PaginatedItemArrayType
     */
    public $WatchList;
    /**
     * The BidList
     * Meta informations extracted from the WSDL
     * - documentation: Contains all the items the buyer has bid on. Only returned if items exist that meet the request criteria.
     * - minOccurs: 0
     * @var \ebay\StructType\PaginatedItemArrayType
     */
    public $BidList;
    /**
     * The BestOfferList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the user has placed Best Offers on. Only returned if items exist that meet the request criteria.
     * - minOccurs: 0
     * @var \ebay\StructType\PaginatedItemArrayType
     */
    public $BestOfferList;
    /**
     * The WonList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the user has bid on and won. Only returned if items exist that meet the request criteria.
     * - minOccurs: 0
     * @var \ebay\StructType\PaginatedOrderTransactionArrayType
     */
    public $WonList;
    /**
     * The LostList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the user has bid on and lost. Only returned if items exist that meet the request criteria.
     * - minOccurs: 0
     * @var \ebay\StructType\PaginatedItemArrayType
     */
    public $LostList;
    /**
     * The FavoriteSearches
     * Meta informations extracted from the WSDL
     * - documentation: Contains a list of the user's favorite searches. Only returned if the user has Favorite Searches. The search name, search query, and search elements, such as QueryKeywords, SortOrder, and Condition are returned. <br><br> You can
     * paste the Search Query response, that comes back as a URL, into a browser to re-play the Favorite Search. <br><br> The search elements that are returned by this call can be used as input for the Shopping Web Service FindItemsAdvanced request.
     * - minOccurs: 0
     * @var \ebay\StructType\MyeBayFavoriteSearchListType
     */
    public $FavoriteSearches;
    /**
     * The FavoriteSellers
     * Meta informations extracted from the WSDL
     * - documentation: Contains a list of the user's favorite sellers. Only returned if items exist that meet the request criteria.
     * - minOccurs: 0
     * @var \ebay\StructType\MyeBayFavoriteSellerListType
     */
    public $FavoriteSellers;
    /**
     * The SecondChanceOffer
     * Meta informations extracted from the WSDL
     * - documentation: Contains the list of Second Chance Offers the user has received. Only returned if items exist that meet the request criteria.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\ItemType[]
     */
    public $SecondChanceOffer;
    /**
     * The BidAssistantList
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\ArrayType\BidGroupArrayType
     */
    public $BidAssistantList;
    /**
     * The DeletedFromWonList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the buyer has bid on, won, and deleted from My eBay. Only returned if items exist that meet the request criteria.
     * - minOccurs: 0
     * @var \ebay\StructType\PaginatedOrderTransactionArrayType
     */
    public $DeletedFromWonList;
    /**
     * The DeletedFromLostList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the buyer has bid on, lost, and deleted from My eBay. Only returned if items exist that meet the request criteria.
     * - minOccurs: 0
     * @var \ebay\StructType\PaginatedItemArrayType
     */
    public $DeletedFromLostList;
    /**
     * The UserDefinedList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items, searches, or sellers that the user has saved to this list using the "Add to list" feature. The name of the list is given by the "Name" element. Returned only if UserDefineLists is specified in the request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\UserDefinedListType[]
     */
    public $UserDefinedList;
    /**
     * Constructor method for GetMyeBayBuyingResponseType
     * @uses GetMyeBayBuyingResponseType::setBuyingSummary()
     * @uses GetMyeBayBuyingResponseType::setWatchList()
     * @uses GetMyeBayBuyingResponseType::setBidList()
     * @uses GetMyeBayBuyingResponseType::setBestOfferList()
     * @uses GetMyeBayBuyingResponseType::setWonList()
     * @uses GetMyeBayBuyingResponseType::setLostList()
     * @uses GetMyeBayBuyingResponseType::setFavoriteSearches()
     * @uses GetMyeBayBuyingResponseType::setFavoriteSellers()
     * @uses GetMyeBayBuyingResponseType::setSecondChanceOffer()
     * @uses GetMyeBayBuyingResponseType::setBidAssistantList()
     * @uses GetMyeBayBuyingResponseType::setDeletedFromWonList()
     * @uses GetMyeBayBuyingResponseType::setDeletedFromLostList()
     * @uses GetMyeBayBuyingResponseType::setUserDefinedList()
     * @param \ebay\StructType\BuyingSummaryType $buyingSummary
     * @param \ebay\StructType\PaginatedItemArrayType $watchList
     * @param \ebay\StructType\PaginatedItemArrayType $bidList
     * @param \ebay\StructType\PaginatedItemArrayType $bestOfferList
     * @param \ebay\StructType\PaginatedOrderTransactionArrayType $wonList
     * @param \ebay\StructType\PaginatedItemArrayType $lostList
     * @param \ebay\StructType\MyeBayFavoriteSearchListType $favoriteSearches
     * @param \ebay\StructType\MyeBayFavoriteSellerListType $favoriteSellers
     * @param \ebay\StructType\ItemType[] $secondChanceOffer
     * @param \ebay\ArrayType\BidGroupArrayType $bidAssistantList
     * @param \ebay\StructType\PaginatedOrderTransactionArrayType $deletedFromWonList
     * @param \ebay\StructType\PaginatedItemArrayType $deletedFromLostList
     * @param \ebay\StructType\UserDefinedListType[] $userDefinedList
     */
    public function __construct(\ebay\StructType\BuyingSummaryType $buyingSummary = null, \ebay\StructType\PaginatedItemArrayType $watchList = null, \ebay\StructType\PaginatedItemArrayType $bidList = null, \ebay\StructType\PaginatedItemArrayType $bestOfferList = null, \ebay\StructType\PaginatedOrderTransactionArrayType $wonList = null, \ebay\StructType\PaginatedItemArrayType $lostList = null, \ebay\StructType\MyeBayFavoriteSearchListType $favoriteSearches = null, \ebay\StructType\MyeBayFavoriteSellerListType $favoriteSellers = null, array $secondChanceOffer = array(), \ebay\ArrayType\BidGroupArrayType $bidAssistantList = null, \ebay\StructType\PaginatedOrderTransactionArrayType $deletedFromWonList = null, \ebay\StructType\PaginatedItemArrayType $deletedFromLostList = null, array $userDefinedList = array())
    {
        $this
            ->setBuyingSummary($buyingSummary)
            ->setWatchList($watchList)
            ->setBidList($bidList)
            ->setBestOfferList($bestOfferList)
            ->setWonList($wonList)
            ->setLostList($lostList)
            ->setFavoriteSearches($favoriteSearches)
            ->setFavoriteSellers($favoriteSellers)
            ->setSecondChanceOffer($secondChanceOffer)
            ->setBidAssistantList($bidAssistantList)
            ->setDeletedFromWonList($deletedFromWonList)
            ->setDeletedFromLostList($deletedFromLostList)
            ->setUserDefinedList($userDefinedList);
    }
    /**
     * Get BuyingSummary value
     * @return \ebay\StructType\BuyingSummaryType|null
     */
    public function getBuyingSummary()
    {
        return $this->BuyingSummary;
    }
    /**
     * Set BuyingSummary value
     * @param \ebay\StructType\BuyingSummaryType $buyingSummary
     * @return \ebay\StructType\GetMyeBayBuyingResponseType
     */
    public function setBuyingSummary(\ebay\StructType\BuyingSummaryType $buyingSummary = null)
    {
        $this->BuyingSummary = $buyingSummary;
        return $this;
    }
    /**
     * Get WatchList value
     * @return \ebay\StructType\PaginatedItemArrayType|null
     */
    public function getWatchList()
    {
        return $this->WatchList;
    }
    /**
     * Set WatchList value
     * @param \ebay\StructType\PaginatedItemArrayType $watchList
     * @return \ebay\StructType\GetMyeBayBuyingResponseType
     */
    public function setWatchList(\ebay\StructType\PaginatedItemArrayType $watchList = null)
    {
        $this->WatchList = $watchList;
        return $this;
    }
    /**
     * Get BidList value
     * @return \ebay\StructType\PaginatedItemArrayType|null
     */
    public function getBidList()
    {
        return $this->BidList;
    }
    /**
     * Set BidList value
     * @param \ebay\StructType\PaginatedItemArrayType $bidList
     * @return \ebay\StructType\GetMyeBayBuyingResponseType
     */
    public function setBidList(\ebay\StructType\PaginatedItemArrayType $bidList = null)
    {
        $this->BidList = $bidList;
        return $this;
    }
    /**
     * Get BestOfferList value
     * @return \ebay\StructType\PaginatedItemArrayType|null
     */
    public function getBestOfferList()
    {
        return $this->BestOfferList;
    }
    /**
     * Set BestOfferList value
     * @param \ebay\StructType\PaginatedItemArrayType $bestOfferList
     * @return \ebay\StructType\GetMyeBayBuyingResponseType
     */
    public function setBestOfferList(\ebay\StructType\PaginatedItemArrayType $bestOfferList = null)
    {
        $this->BestOfferList = $bestOfferList;
        return $this;
    }
    /**
     * Get WonList value
     * @return \ebay\StructType\PaginatedOrderTransactionArrayType|null
     */
    public function getWonList()
    {
        return $this->WonList;
    }
    /**
     * Set WonList value
     * @param \ebay\StructType\PaginatedOrderTransactionArrayType $wonList
     * @return \ebay\StructType\GetMyeBayBuyingResponseType
     */
    public function setWonList(\ebay\StructType\PaginatedOrderTransactionArrayType $wonList = null)
    {
        $this->WonList = $wonList;
        return $this;
    }
    /**
     * Get LostList value
     * @return \ebay\StructType\PaginatedItemArrayType|null
     */
    public function getLostList()
    {
        return $this->LostList;
    }
    /**
     * Set LostList value
     * @param \ebay\StructType\PaginatedItemArrayType $lostList
     * @return \ebay\StructType\GetMyeBayBuyingResponseType
     */
    public function setLostList(\ebay\StructType\PaginatedItemArrayType $lostList = null)
    {
        $this->LostList = $lostList;
        return $this;
    }
    /**
     * Get FavoriteSearches value
     * @return \ebay\StructType\MyeBayFavoriteSearchListType|null
     */
    public function getFavoriteSearches()
    {
        return $this->FavoriteSearches;
    }
    /**
     * Set FavoriteSearches value
     * @param \ebay\StructType\MyeBayFavoriteSearchListType $favoriteSearches
     * @return \ebay\StructType\GetMyeBayBuyingResponseType
     */
    public function setFavoriteSearches(\ebay\StructType\MyeBayFavoriteSearchListType $favoriteSearches = null)
    {
        $this->FavoriteSearches = $favoriteSearches;
        return $this;
    }
    /**
     * Get FavoriteSellers value
     * @return \ebay\StructType\MyeBayFavoriteSellerListType|null
     */
    public function getFavoriteSellers()
    {
        return $this->FavoriteSellers;
    }
    /**
     * Set FavoriteSellers value
     * @param \ebay\StructType\MyeBayFavoriteSellerListType $favoriteSellers
     * @return \ebay\StructType\GetMyeBayBuyingResponseType
     */
    public function setFavoriteSellers(\ebay\StructType\MyeBayFavoriteSellerListType $favoriteSellers = null)
    {
        $this->FavoriteSellers = $favoriteSellers;
        return $this;
    }
    /**
     * Get SecondChanceOffer value
     * @return \ebay\StructType\ItemType[]|null
     */
    public function getSecondChanceOffer()
    {
        return $this->SecondChanceOffer;
    }
    /**
     * Set SecondChanceOffer value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ItemType[] $secondChanceOffer
     * @return \ebay\StructType\GetMyeBayBuyingResponseType
     */
    public function setSecondChanceOffer(array $secondChanceOffer = array())
    {
        foreach ($secondChanceOffer as $getMyeBayBuyingResponseTypeSecondChanceOfferItem) {
            // validation for constraint: itemType
            if (!$getMyeBayBuyingResponseTypeSecondChanceOfferItem instanceof \ebay\StructType\ItemType) {
                throw new \InvalidArgumentException(sprintf('The SecondChanceOffer property can only contain items of \ebay\StructType\ItemType, "%s" given', is_object($getMyeBayBuyingResponseTypeSecondChanceOfferItem) ? get_class($getMyeBayBuyingResponseTypeSecondChanceOfferItem) : gettype($getMyeBayBuyingResponseTypeSecondChanceOfferItem)), __LINE__);
            }
        }
        $this->SecondChanceOffer = $secondChanceOffer;
        return $this;
    }
    /**
     * Add item to SecondChanceOffer value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ItemType $item
     * @return \ebay\StructType\GetMyeBayBuyingResponseType
     */
    public function addToSecondChanceOffer(\ebay\StructType\ItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\ItemType) {
            throw new \InvalidArgumentException(sprintf('The SecondChanceOffer property can only contain items of \ebay\StructType\ItemType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SecondChanceOffer[] = $item;
        return $this;
    }
    /**
     * Get BidAssistantList value
     * @return \ebay\ArrayType\BidGroupArrayType|null
     */
    public function getBidAssistantList()
    {
        return $this->BidAssistantList;
    }
    /**
     * Set BidAssistantList value
     * @param \ebay\ArrayType\BidGroupArrayType $bidAssistantList
     * @return \ebay\StructType\GetMyeBayBuyingResponseType
     */
    public function setBidAssistantList(\ebay\ArrayType\BidGroupArrayType $bidAssistantList = null)
    {
        $this->BidAssistantList = $bidAssistantList;
        return $this;
    }
    /**
     * Get DeletedFromWonList value
     * @return \ebay\StructType\PaginatedOrderTransactionArrayType|null
     */
    public function getDeletedFromWonList()
    {
        return $this->DeletedFromWonList;
    }
    /**
     * Set DeletedFromWonList value
     * @param \ebay\StructType\PaginatedOrderTransactionArrayType $deletedFromWonList
     * @return \ebay\StructType\GetMyeBayBuyingResponseType
     */
    public function setDeletedFromWonList(\ebay\StructType\PaginatedOrderTransactionArrayType $deletedFromWonList = null)
    {
        $this->DeletedFromWonList = $deletedFromWonList;
        return $this;
    }
    /**
     * Get DeletedFromLostList value
     * @return \ebay\StructType\PaginatedItemArrayType|null
     */
    public function getDeletedFromLostList()
    {
        return $this->DeletedFromLostList;
    }
    /**
     * Set DeletedFromLostList value
     * @param \ebay\StructType\PaginatedItemArrayType $deletedFromLostList
     * @return \ebay\StructType\GetMyeBayBuyingResponseType
     */
    public function setDeletedFromLostList(\ebay\StructType\PaginatedItemArrayType $deletedFromLostList = null)
    {
        $this->DeletedFromLostList = $deletedFromLostList;
        return $this;
    }
    /**
     * Get UserDefinedList value
     * @return \ebay\StructType\UserDefinedListType[]|null
     */
    public function getUserDefinedList()
    {
        return $this->UserDefinedList;
    }
    /**
     * Set UserDefinedList value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\UserDefinedListType[] $userDefinedList
     * @return \ebay\StructType\GetMyeBayBuyingResponseType
     */
    public function setUserDefinedList(array $userDefinedList = array())
    {
        foreach ($userDefinedList as $getMyeBayBuyingResponseTypeUserDefinedListItem) {
            // validation for constraint: itemType
            if (!$getMyeBayBuyingResponseTypeUserDefinedListItem instanceof \ebay\StructType\UserDefinedListType) {
                throw new \InvalidArgumentException(sprintf('The UserDefinedList property can only contain items of \ebay\StructType\UserDefinedListType, "%s" given', is_object($getMyeBayBuyingResponseTypeUserDefinedListItem) ? get_class($getMyeBayBuyingResponseTypeUserDefinedListItem) : gettype($getMyeBayBuyingResponseTypeUserDefinedListItem)), __LINE__);
            }
        }
        $this->UserDefinedList = $userDefinedList;
        return $this;
    }
    /**
     * Add item to UserDefinedList value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\UserDefinedListType $item
     * @return \ebay\StructType\GetMyeBayBuyingResponseType
     */
    public function addToUserDefinedList(\ebay\StructType\UserDefinedListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\UserDefinedListType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedList property can only contain items of \ebay\StructType\UserDefinedListType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserDefinedList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetMyeBayBuyingResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
