<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllBiddersResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Includes the list of bidders for the requested item as part of the general item listing data. Some bidder information is anonymous to protect bidders from fraud. If the seller makes this API call, the actual ids of all bidders on the
 * seller's item are returned. If a bidder makes this API call, the bidder's actual id will be returned. Information for all competing bidders or outside watchers are returned as anonymized userIDs.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetAllBiddersResponseType extends AbstractResponseType
{
    /**
     * The BidArray
     * Meta informations extracted from the WSDL
     * - documentation: Contains a list of OfferType objects. Each OfferType object represents the data for one bidder and bid.
     * - minOccurs: 0
     * @var \ebay\ArrayType\OfferArrayType
     */
    public $BidArray;
    /**
     * The HighBidder
     * Meta informations extracted from the WSDL
     * - documentation: eBay user ID for the user with the highest bid (or the earliest timestamp, in the event of a tie); a Second Chance Offer candidate. | This is a string wrapper for the eBay ID that uniquely identifies a user. This is used by several
     * other types to identify a specific eBay user, such as DisputeType.xsd, FeedbackInfoType.xsd, GetAllBidders, OrderType, and so on. <br><br>For GetAllBidders, some bidder information is anonymous, to protect bidders from fraud. If the seller makes this
     * API call, the actual IDs of all bidders on the seller's item will be returned. If a bidder makes this API call, the bidder's actual ID will be returned, but information for all competing bidders or outside watchers will be returned as anonymized
     * userIDs.
     * - minOccurs: 0
     * @var string
     */
    public $HighBidder;
    /**
     * The HighestBid
     * Meta informations extracted from the WSDL
     * - documentation: Bid amount offered by the HighBidder.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $HighestBid;
    /**
     * The ListingStatus
     * Meta informations extracted from the WSDL
     * - documentation: Specifies an active or ended listing's status in eBay's processing workflow. If a listing ends with a sale (or sales), eBay needs to update the sale details (e.g., winning bidder) and other information. This processing can take
     * several minutes. If you retrieve a sold item, use this listing status information to determine whether eBay has finished processing the listing so that you can be sure the winning bidder and other details are correct and complete.
     * - minOccurs: 0
     * @var string
     */
    public $ListingStatus;
    /**
     * Constructor method for GetAllBiddersResponseType
     * @uses GetAllBiddersResponseType::setBidArray()
     * @uses GetAllBiddersResponseType::setHighBidder()
     * @uses GetAllBiddersResponseType::setHighestBid()
     * @uses GetAllBiddersResponseType::setListingStatus()
     * @param \ebay\ArrayType\OfferArrayType $bidArray
     * @param string $highBidder
     * @param \ebay\StructType\AmountType $highestBid
     * @param string $listingStatus
     */
    public function __construct(\ebay\ArrayType\OfferArrayType $bidArray = null, $highBidder = null, \ebay\StructType\AmountType $highestBid = null, $listingStatus = null)
    {
        $this
            ->setBidArray($bidArray)
            ->setHighBidder($highBidder)
            ->setHighestBid($highestBid)
            ->setListingStatus($listingStatus);
    }
    /**
     * Get BidArray value
     * @return \ebay\ArrayType\OfferArrayType|null
     */
    public function getBidArray()
    {
        return $this->BidArray;
    }
    /**
     * Set BidArray value
     * @param \ebay\ArrayType\OfferArrayType $bidArray
     * @return \ebay\StructType\GetAllBiddersResponseType
     */
    public function setBidArray(\ebay\ArrayType\OfferArrayType $bidArray = null)
    {
        $this->BidArray = $bidArray;
        return $this;
    }
    /**
     * Get HighBidder value
     * @return string|null
     */
    public function getHighBidder()
    {
        return $this->HighBidder;
    }
    /**
     * Set HighBidder value
     * @param string $highBidder
     * @return \ebay\StructType\GetAllBiddersResponseType
     */
    public function setHighBidder($highBidder = null)
    {
        // validation for constraint: string
        if (!is_null($highBidder) && !is_string($highBidder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($highBidder)), __LINE__);
        }
        $this->HighBidder = $highBidder;
        return $this;
    }
    /**
     * Get HighestBid value
     * @return \ebay\StructType\AmountType|null
     */
    public function getHighestBid()
    {
        return $this->HighestBid;
    }
    /**
     * Set HighestBid value
     * @param \ebay\StructType\AmountType $highestBid
     * @return \ebay\StructType\GetAllBiddersResponseType
     */
    public function setHighestBid(\ebay\StructType\AmountType $highestBid = null)
    {
        $this->HighestBid = $highestBid;
        return $this;
    }
    /**
     * Get ListingStatus value
     * @return string|null
     */
    public function getListingStatus()
    {
        return $this->ListingStatus;
    }
    /**
     * Set ListingStatus value
     * @uses \ebay\EnumType\ListingStatusCodeType::valueIsValid()
     * @uses \ebay\EnumType\ListingStatusCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $listingStatus
     * @return \ebay\StructType\GetAllBiddersResponseType
     */
    public function setListingStatus($listingStatus = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\ListingStatusCodeType::valueIsValid($listingStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $listingStatus, implode(', ', \ebay\EnumType\ListingStatusCodeType::getValidValues())), __LINE__);
        }
        $this->ListingStatus = $listingStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetAllBiddersResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
