<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeesType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Identifies a set of one or more fees that a member pays to eBay (or an eBay company). Instances of this type can hold one or more fees.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class FeesType extends AbstractStructBase
{
    /**
     * The Fee
     * Meta informations extracted from the WSDL
     * - documentation: Contains the name, fee, and possible discount amount for an item listing feature. A Fee container is returned for each listing feature, even if the associated cost (Fee value) is 0.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\FeeType[]
     */
    public $Fee;
    /**
     * Constructor method for FeesType
     * @uses FeesType::setFee()
     * @param \ebay\StructType\FeeType[] $fee
     */
    public function __construct(array $fee = array())
    {
        $this
            ->setFee($fee);
    }
    /**
     * Get Fee value
     * @return \ebay\StructType\FeeType[]|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * Set Fee value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\FeeType[] $fee
     * @return \ebay\StructType\FeesType
     */
    public function setFee(array $fee = array())
    {
        foreach ($fee as $feesTypeFeeItem) {
            // validation for constraint: itemType
            if (!$feesTypeFeeItem instanceof \ebay\StructType\FeeType) {
                throw new \InvalidArgumentException(sprintf('The Fee property can only contain items of \ebay\StructType\FeeType, "%s" given', is_object($feesTypeFeeItem) ? get_class($feesTypeFeeItem) : gettype($feesTypeFeeItem)), __LINE__);
            }
        }
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Add item to Fee value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\FeeType $item
     * @return \ebay\StructType\FeesType
     */
    public function addToFee(\ebay\StructType\FeeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\FeeType) {
            throw new \InvalidArgumentException(sprintf('The Fee property can only contain items of \ebay\StructType\FeeType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Fee[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\FeesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
