<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeatureDefinitionsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: This type is used by the <b>FeatureDefinitions</b> container that is returned in the <b>GetCategoryFeatures</b> response to indicate which eBay features are available for the corresponding eBay site that is passed in the request
 * header. If no <b>FeatureID</b> field is included in the call request, all eBay features available for the eBay site are returned. If one or more <b>FeatureID</b> fields are included in the call request, only those eBay features specified in each
 * <b>FeatureID</b> field is returned in the response.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class FeatureDefinitionsType extends AbstractStructBase
{
    /**
     * The ListingDurations
     * Meta informations extracted from the WSDL
     * - documentation: The return of this field in the response indicates that listing durations are supported on the corresponding eBay site. Listing durations will vary based on the selling format (auction, fixed-price, or classified ad) and the eBay
     * category. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ListingDurations</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ListingDurationDefinitionsType
     */
    public $ListingDurations;
    /**
     * The ShippingTermsRequired
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that some categories on the corresponding eBay site may require shipping terms at listing time, including at least one domestic shipping service option and its associated
     * costs. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ShippingTermsRequired</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ShippingTermRequiredDefinitionType
     */
    public $ShippingTermsRequired;
    /**
     * The BestOfferEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the Best Offer feature is supported on the corresponding eBay site. The Best Offer feature allows buyers and sellers to negotiate the price of the item. Best Offer is not
     * applicable to auction listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>BestOfferEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\BestOfferEnabledDefinitionType
     */
    public $BestOfferEnabled;
    /**
     * The DutchBINEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\DutchBINEnabledDefinitionType
     */
    public $DutchBINEnabled;
    /**
     * The UserConsentRequired
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\UserConsentRequiredDefinitionType
     */
    public $UserConsentRequired;
    /**
     * The HomePageFeaturedEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the temporary display of a seller's listing on a section of the eBay Home Page. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>HomePageFeaturedEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\HomePageFeaturedEnabledDefinitionType
     */
    public $HomePageFeaturedEnabled;
    /**
     * The ProPackEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the Pro Pack listing upgrade bundle. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call
     * request and <code>ProPackEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ProPackEnabledDefinitionType
     */
    public $ProPackEnabled;
    /**
     * The BasicUpgradePackEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\BasicUpgradePackEnabledDefinitionType
     */
    public $BasicUpgradePackEnabled;
    /**
     * The ValuePackEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the Value Pack listing upgrade bundle. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call
     * request and <code>ValuePackEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ValuePackEnabledDefinitionType
     */
    public $ValuePackEnabled;
    /**
     * The ProPackPlusEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the Pro Pack Plus listing upgrade bundle. This field will not be returned if one or more <b>FeatureID</b> fields are included in the
     * call request and <code>ProPackPlusEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ProPackPlusEnabledDefinitionType
     */
    public $ProPackPlusEnabled;
    /**
     * The AdFormatEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports Classified Ad listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and
     * <code>AdFormatEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\AdFormatEnabledDefinitionType
     */
    public $AdFormatEnabled;
    /**
     * The BestOfferCounterEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that counter offers to Best Offers are supported on the corresponding eBay site. The Best Offer feature allows buyers and sellers to negotiate the price of the item, and once a
     * Best Offer price is proposed, the seller can send the buyer a counter offer, and a buyer may even send another counter offer to the seller's counter offer. The Best Offer feature is not applicable to auction listings. This field will not be returned
     * if one or more <b>FeatureID</b> fields are included in the call request and <code>BestOfferCounterEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\BestOfferCounterEnabledDefinitionType
     */
    public $BestOfferCounterEnabled;
    /**
     * The BestOfferAutoDeclineEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the Best Offer Auto-Decline feature is supported on the corresponding eBay site. The Best Offer Auto-Decline feature allows a seller to set a lower threshold dollar value
     * on a listing, and any Best Offer amount below this amount is automatically declined by the eBay system. The Best Offer feature is not applicable to auction listings. This field will not be returned if one or more <b>FeatureID</b> fields are included
     * in the call request and <code>BestOfferAutoDeclineEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\BestOfferAutoDeclineEnabledDefinitionType
     */
    public $BestOfferAutoDeclineEnabled;
    /**
     * The LocalMarketSpecialitySubscription
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports Motors Local Market listings for dealership subscribers with a specialty subscription. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>LocalMarketSpecialitySubscription</code> is not one of the values passed into those <b>FeatureID</b> fields. <br><br> See the <a href="
     * http://pages.ebay.com/help/sell/formats.html#market" target="_blank">Motors Local Market listing help topic</a> for more information.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketSpecialitySubscriptionDefinitionType
     */
    public $LocalMarketSpecialitySubscription;
    /**
     * The LocalMarketRegularSubscription
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports Motors Local Market listings for dealership subscribers with a regular subscription. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>LocalMarketRegularSubscription</code> is not one of the values passed into those <b>FeatureID</b> fields. <br><br> See the <a href="
     * http://pages.ebay.com/help/sell/formats.html#market" target="_blank">Motors Local Market listing help topic</a> for more information.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketRegularSubscriptionDefinitionType
     */
    public $LocalMarketRegularSubscription;
    /**
     * The LocalMarketPremiumSubscription
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports Motors Local Market listings for dealership subscribers with a premium subscription. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>LocalMarketPremiumSubscription</code> is not one of the values passed into those <b>FeatureID</b> fields. <br><br> See the <a href="
     * http://pages.ebay.com/help/sell/formats.html#market" target="_blank">Motors Local Market listing help topic</a> for more information.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketPremiumSubscriptionDefinitionType
     */
    public $LocalMarketPremiumSubscription;
    /**
     * The LocalMarketNonSubscription
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports Motors Local Market listings for dealerships without a subscription. This field will not be returned if one or more <b>FeatureID</b>
     * fields are included in the call request and <code>LocalMarketNonSubscription</code> is not one of the values passed into those <b>FeatureID</b> fields. <br><br> See the <a href=" http://pages.ebay.com/help/sell/formats.html#market"
     * target="_blank">Motors Local Market listing help topic</a> for more information.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketNonSubscriptionDefinitionType
     */
    public $LocalMarketNonSubscription;
    /**
     * The ExpressEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\ExpressEnabledDefinitionType
     */
    public $ExpressEnabled;
    /**
     * The ExpressPicturesRequired
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\ExpressPicturesRequiredDefinitionType
     */
    public $ExpressPicturesRequired;
    /**
     * The ExpressConditionRequired
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\ExpressConditionRequiredDefinitionType
     */
    public $ExpressConditionRequired;
    /**
     * The MinimumReservePrice
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that one or more categories on the corresponding eBay site requires a minimum reserve price for an auction item. This feature is only applicable to auction listings. This field
     * will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>MinimumReservePrice</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\MinimumReservePriceDefinitionType
     */
    public $MinimumReservePrice;
    /**
     * The TransactionConfirmationRequestEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\TCREnabledDefinitionType
     */
    public $TransactionConfirmationRequestEnabled;
    /**
     * The SellerContactDetailsEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that one or more categories on the corresponding eBay site allows the seller to provide contact information at listing time for a classified ad listing. This feature is only
     * applicable to classified ad listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>SellerContactDetailsEnabled</code> is not one of the values passed into those <b>FeatureID</b>
     * fields.
     * - minOccurs: 0
     * @var \ebay\StructType\SellerContactDetailsEnabledDefinitionType
     */
    public $SellerContactDetailsEnabled;
    /**
     * The StoreInventoryEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\StoreInventoryEnabledDefinitionType
     */
    public $StoreInventoryEnabled;
    /**
     * The SkypeMeTransactionalEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows Skype communication between the seller and the buyer regarding a common order line item. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>SkypeMeTransactionalEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\SkypeMeTransactionalEnabledDefinitionType
     */
    public $SkypeMeTransactionalEnabled;
    /**
     * The SkypeMeNonTransactionalEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows Skype communication between the seller and any potential buyer regarding an active order line item. This field will not be returned if
     * one or more <b>FeatureID</b> fields are included in the call request and <code>SkypeMeNonTransactionalEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\SkypeMeNonTransactionalEnabledDefinitionType
     */
    public $SkypeMeNonTransactionalEnabled;
    /**
     * The LocalListingDistancesRegular
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows dealership subscribers with a regular subscription to specify local market radius for Motors Local Market listings. This field will not
     * be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalListingDistancesRegular</code> is not one of the values passed into those <b>FeatureID</b> fields. <br><br> See the <a href="
     * http://pages.ebay.com/help/sell/formats.html#market" target="_blank">Motors Local Market listing help topic</a> for more information.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalListingDistancesRegularDefinitionType
     */
    public $LocalListingDistancesRegular;
    /**
     * The LocalListingDistancesSpecialty
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows dealership subscribers with a specialty subscription to specify local market radius for Motors Local Market listings. This field will
     * not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalListingDistancesSpecialty</code> is not one of the values passed into those <b>FeatureID</b> fields. <br><br> See the <a href="
     * http://pages.ebay.com/help/sell/formats.html#market" target="_blank">Motors Local Market listing help topic</a> for more information.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalListingDistancesSpecialtyDefinitionType
     */
    public $LocalListingDistancesSpecialty;
    /**
     * The LocalListingDistancesNonSubscription
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows dealership subscribers without a subscription to specify local market radius for Motors Local Market listings. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalListingDistancesNonSubscription</code> is not one of the values passed into those <b>FeatureID</b> fields. <br><br> See the <a href="
     * http://pages.ebay.com/help/sell/formats.html#market" target="_blank">Motors Local Market listing help topic</a> for more information.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalListingDistancesNonSubscriptionDefinitionType
     */
    public $LocalListingDistancesNonSubscription;
    /**
     * The ClassifiedAdPaymentMethodEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows for the display of acceptable payment methods for classified ad listings. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdPaymentMethodEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ClassifiedAdPaymentMethodEnabledDefinitionType
     */
    public $ClassifiedAdPaymentMethodEnabled;
    /**
     * The ClassifiedAdShippingMethodEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows for the display of shipping service options for classified ad listings. This field will not be returned if one or more <b>FeatureID</b>
     * fields are included in the call request and <code>ClassifiedAdShippingMethodEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ClassifiedAdShippingMethodEnabledDefinitionType
     */
    public $ClassifiedAdShippingMethodEnabled;
    /**
     * The ClassifiedAdBestOfferEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the Best Offer feature is supported on the corresponding eBay site for classified ad listings. The Best Offer feature allows buyers and sellers to negotiate the price of
     * the item. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdBestOfferEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ClassifiedAdBestOfferEnabledDefinitionType
     */
    public $ClassifiedAdBestOfferEnabled;
    /**
     * The ClassifiedAdCounterOfferEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that counter offers to Best Offers are supported on the corresponding eBay site for classified ad listings. The Best Offer feature allows buyers and sellers to negotiate the
     * price of the item, and once a Best Offer price is proposed, the seller can send the buyer a counter offer, and a buyer may even send another counter offer to the seller's counter offer. This field will not be returned if one or more <b>FeatureID</b>
     * fields are included in the call request and <code>ClassifiedAdCounterOfferEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ClassifiedAdCounterOfferEnabledDefinitionType
     */
    public $ClassifiedAdCounterOfferEnabled;
    /**
     * The ClassifiedAdAutoDeclineEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the Best Offer Auto-Decline feature is supported on the corresponding eBay site for classified ad listings. The Best Offer Auto-Decline feature allows a seller to set a
     * lower threshold dollar value on a listing, and any Best Offer amount below this amount is automatically declined by the eBay system. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and
     * <code>ClassifiedAdAutoDeclineEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ClassifiedAdAutoDeclineEnabledDefinitionType
     */
    public $ClassifiedAdAutoDeclineEnabled;
    /**
     * The ClassifiedAdContactByPhoneEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of a phone number when contacting the seller about a classified ad listing. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdContactByPhoneEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ClassifiedAdContactByPhoneEnabledDefinitionType
     */
    public $ClassifiedAdContactByPhoneEnabled;
    /**
     * The ClassifiedAdContactByEmailEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of an email address when contacting the seller about a classified ad listing. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdContactByEmailEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ClassifiedAdContactByEmailEnabledDefintionType
     */
    public $ClassifiedAdContactByEmailEnabled;
    /**
     * The SafePaymentRequired
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that one or more categories on the corresponding eBay site requires at least one form of safe payment. This field will not be returned if one or more <b>FeatureID</b> fields
     * are included in the call request and <code>SafePaymentRequired</code> is not one of the values passed into those <b>FeatureID</b> fields. <br><br> For the US, Canada and Australia sites, users registered after January 17, 2007 are required to offer
     * at least one safe payment method (i.e. PayPal/PaisaPay, or one of the credit cards specified in <b>Item.PaymentMethods</b>). <br><br> If a seller has a <code>SafePaymentExempt</code> status, they are exempt from the requirement to offer at least one
     * safe payment method when listing an item on a site that has the safe payment requirement. <br> The safe payment requirement also applies to two-category listings that have one ship-to or available-to location in the US, Canada, or Australia. The
     * French Canadian (CAFR) site is a special case, because listings on the CAFR site with ship-to or available-to locations in Canada do not require a Safe Payment method, yet listings on the CAFR site with ship-to or available-to locations in the US or
     * Australia do require a Safe Payment method. <br><br> The Business and Industrial, Motors, Real Estate, and Mature Audiences categories, and all listings that don't support the <b>Item.PaymentMethods</b> field are exempt from this requirement.
     * Therefore, listings in those categories do not require a safe payment method.
     * - minOccurs: 0
     * @var \ebay\StructType\SafePaymentRequiredDefinitionType
     */
    public $SafePaymentRequired;
    /**
     * The ClassifiedAdPayPerLeadEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\ClassifiedAdPayPerLeadEnabledDefinitionType
     */
    public $ClassifiedAdPayPerLeadEnabled;
    /**
     * The ItemSpecificsEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of customized Item Specifics in listings. Item Specifics are typical aspects of items in the same category. They enable users
     * to classify items by presenting descriptive details in a structured way. For example, in a jewelry category, sellers might describe lockets with specifics like "Chain Length=18 in." and "Main Shape=Heart", but in a Washers & Dryers category, sellers
     * might include "Type=Top-Loading" instead of "Main Shape=Heart". This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ItemSpecificsEnabled</code> is not one of the values passed into those
     * <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemSpecificsEnabledDefinitionType
     */
    public $ItemSpecificsEnabled;
    /**
     * The PaisaPayFullEscrowEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of PaisaPay Full Escrow as a payment method. This field will not be returned if one or more <b>FeatureID</b> fields are
     * included in the call request and <code>PaisaPayFullEscrowEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\PaisaPayFullEscrowEnabledDefinitionType
     */
    public $PaisaPayFullEscrowEnabled;
    /**
     * The ISBNIdentifierEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\ISBNIdentifierEnabledDefinitionType
     */
    public $ISBNIdentifierEnabled;
    /**
     * The UPCIdentifierEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\UPCIdentifierEnabledDefinitionType
     */
    public $UPCIdentifierEnabled;
    /**
     * The EANIdentifierEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\EANIdentifierEnabledDefinitionType
     */
    public $EANIdentifierEnabled;
    /**
     * The BrandMPNIdentifierEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of Brand and MPN (Manufacturer Part Number) to identify a motor vehicle part or accessory. This field will not be returned if
     * one or more <b>FeatureID</b> fields are included in the call request and <code>BrandMPNIdentifierEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\BrandMPNIdentifierEnabledDefinitionType
     */
    public $BrandMPNIdentifierEnabled;
    /**
     * The BestOfferAutoAcceptEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the Best Offer Auto-Accept feature is supported on the corresponding eBay site. The Best Offer Auto-Accept feature allows a seller to set a threshold dollar value on a
     * listing, and any Best Offer amount at or above this amount is automatically accepted by the eBay system. The Best Offer feature is not applicable to auction listings. This field will not be returned if one or more <b>FeatureID</b> fields are included
     * in the call request and <code>BestOfferAutoAcceptEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\BestOfferAutoAcceptEnabledDefinitionType
     */
    public $BestOfferAutoAcceptEnabled;
    /**
     * The ClassifiedAdAutoAcceptEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the Best Offer Auto-Accept feature for classified ad listings is supported on the corresponding eBay site. The Best Offer Auto-Accept feature allows a seller to set a
     * threshold dollar value on a listing, and any Best Offer amount at or above this amount is automatically accepted by the eBay system. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and
     * <code>ClassifiedAdAutoAcceptEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ClassifiedAdAutoAcceptEnabledDefinitionType
     */
    public $ClassifiedAdAutoAcceptEnabled;
    /**
     * The CrossBorderTradeNorthAmericaEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports cross-border trading on fellow North American sites. In cross-border trading, also referred to as International site visibility, a
     * seller is able to post a listing to an additional eBay site for an additional small fee. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>CrossBorderTradeNorthAmericaEnabled</code> is
     * not one of the values passed into those <b>FeatureID</b> fields. <br/><br/> See the <a href=" http://pages.ebay.com/help/sell/globalexposure.html" target="_blank">Getting exposure on international sites</a> help page for more information on
     * cross-border trade.
     * - minOccurs: 0
     * @var \ebay\StructType\CrossBorderTradeNorthAmericaEnabledDefinitionType
     */
    public $CrossBorderTradeNorthAmericaEnabled;
    /**
     * The CrossBorderTradeGBEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports cross-border trading on fellow UK sites. In cross-border trading, also referred to as International site visibility, a seller is able
     * to post a listing to an additional eBay site for an additional small fee. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>CrossBorderTradeGBEnabled</code> is not one of the values
     * passed into those <b>FeatureID</b> fields. <br/><br/> See the <a href=" http://pages.ebay.com/help/sell/globalexposure.html" target="_blank">Getting exposure on international sites</a> help page for more information on cross-border trade.
     * - minOccurs: 0
     * @var \ebay\StructType\CrossBorderTradeGBEnabledDefinitionType
     */
    public $CrossBorderTradeGBEnabled;
    /**
     * The CrossBorderTradeAustraliaEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is for future use, as cross-border trading (aka International site visibility) is not currently supported for Australia.
     * - minOccurs: 0
     * @var \ebay\StructType\CrossBorderTradeAustraliaEnabledDefinitionType
     */
    public $CrossBorderTradeAustraliaEnabled;
    /**
     * The PayPalBuyerProtectionEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that one or more categories on the corresponding eBay site supports PayPal Purchase Protection. This field will not be returned if one or more <b>FeatureID</b> fields are
     * included in the call request and <code>PayPalBuyerProtectionEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\PayPalBuyerProtectionEnabledDefinitionType
     */
    public $PayPalBuyerProtectionEnabled;
    /**
     * The BuyerGuaranteeEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\BuyerGuaranteeEnabledDefinitionType
     */
    public $BuyerGuaranteeEnabled;
    /**
     * The CombinedFixedPriceTreatmentEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\CombinedFixedPriceTreatmentEnabledDefinitionType
     */
    public $CombinedFixedPriceTreatmentEnabled;
    /**
     * The GalleryFeaturedDurations
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\ListingEnhancementDurationDefinitionType
     */
    public $GalleryFeaturedDurations;
    /**
     * The INEscrowWorkflowTimeline
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that one or more categories on the corresponding eBay site supports PaisaPay Full Escrow workflow timeline.This field will not be returned if one or more <b>FeatureID</b>
     * fields are included in the call request and <code>INEscrowWorkflowTimeline</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\INEscrowWorkflowTimelineDefinitionType
     */
    public $INEscrowWorkflowTimeline;
    /**
     * The PayPalRequired
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that one or more categories on the corresponding eBay site requires that PayPal is included as an accepted payment method. This is not applicable to classified ad listings, as
     * payment is handled by the buyer and seller, and not eBay. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>PayPalRequired</code> is not one of the values passed into those
     * <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\PayPalRequiredDefinitionType
     */
    public $PayPalRequired;
    /**
     * The eBayMotorsProAdFormatEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports motor vehicle classified ad listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call
     * request and <code>eBayMotorsProAdFormatEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\EBayMotorsProAdFormatEnabledDefinitionType
     */
    public $eBayMotorsProAdFormatEnabled;
    /**
     * The eBayMotorsProContactByPhoneEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of a phone number when contacting the seller about a motor vehicle classified ad listing. This field will not be returned if
     * one or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProContactByPhoneEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\EBayMotorsProContactByPhoneEnabledDefinitionType
     */
    public $eBayMotorsProContactByPhoneEnabled;
    /**
     * The eBayMotorsProPhoneCount
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of multiple phone numbers for the seller for a motor vehicle classified ad listing. This field will not be returned if one or
     * more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProPhoneCount</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\EBayMotorsProPhoneCountDefinitionType
     */
    public $eBayMotorsProPhoneCount;
    /**
     * The eBayMotorsProContactByAddressEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of an address when contacting the seller about a motor vehicle classified ad listing. This field will not be returned if one
     * or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProContactByAddressEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\EBayMotorsProContactByAddressEnabledDefinitionType
     */
    public $eBayMotorsProContactByAddressEnabled;
    /**
     * The eBayMotorsProStreetCount
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of multiple street address for the seller for a motor vehicle classified ad listing. This field will not be returned if one or
     * more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProStreetCount</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\EBayMotorsProStreetCountDefinitionType
     */
    public $eBayMotorsProStreetCount;
    /**
     * The eBayMotorsProCompanyNameEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of a company name when contacting the seller about a motor vehicle classified ad listing. This field will not be returned if
     * one or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProCompanyNameEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\EBayMotorsProCompanyNameEnabledDefinitionType
     */
    public $eBayMotorsProCompanyNameEnabled;
    /**
     * The eBayMotorsProContactByEmailEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of an email address when contacting the seller about a motor vehicle classified ad listing. This field will not be returned if
     * one or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProContactByEmailEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\EBayMotorsProContactByEmailEnabledDefinitionType
     */
    public $eBayMotorsProContactByEmailEnabled;
    /**
     * The eBayMotorsProBestOfferEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the Best Offer feature is supported on the corresponding eBay site for motor vehicle classified ad listings. The Best Offer feature allows buyers and sellers to negotiate
     * the price of the item. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProBestOfferEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\EBayMotorsProBestOfferEnabledDefinitionType
     */
    public $eBayMotorsProBestOfferEnabled;
    /**
     * The eBayMotorsProAutoAcceptEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the Best Offer Auto-Accept feature for motor vehicle classified ad listings is supported on the corresponding eBay site. The Best Offer Auto-Accept feature allows a seller
     * to set a threshold dollar value on a listing, and any Best Offer amount at or above this amount is automatically accepted by the eBay system. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and
     * <code>eBayMotorsProAutoAcceptEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\EBayMotorsProAutoAcceptEnabledDefinitionType
     */
    public $eBayMotorsProAutoAcceptEnabled;
    /**
     * The eBayMotorsProAutoDeclineEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the Best Offer Auto-Decline feature is supported on the corresponding eBay site for motor vehicle classified ad listings. The Best Offer Auto-Decline feature allows a
     * seller to set a lower threshold dollar value on a listing, and any Best Offer amount below this amount is automatically declined by the eBay system. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call
     * request and <code>eBayMotorsProAutoDeclineEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\EBayMotorsProAutoDeclineEnabledDefinitionType
     */
    public $eBayMotorsProAutoDeclineEnabled;
    /**
     * The eBayMotorsProPaymentMethodCheckOutEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows for the display of acceptable payment methods for motor vehicle classified ad listings. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProPaymentMethodCheckOutEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\EBayMotorsProPaymentMethodCheckOutEnabledDefinitionType
     */
    public $eBayMotorsProPaymentMethodCheckOutEnabled;
    /**
     * The eBayMotorsProShippingMethodEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows for the display of shipping service options for motor vehicle classified ad listings. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProShippingMethodEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\EBayMotorsProShippingMethodEnabledDefinitionType
     */
    public $eBayMotorsProShippingMethodEnabled;
    /**
     * The eBayMotorsProCounterOfferEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that counter offers to Best Offers are supported on the corresponding eBay site for motor vehicle classified ad listings. The Best Offer feature allows buyers and sellers to
     * negotiate the price of the item, and once a Best Offer price is proposed, the seller can send the buyer a counter offer, and a buyer may even send another counter offer to the seller's counter offer. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProCounterOfferEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\EBayMotorsProCounterOfferEnabledDefinitionType
     */
    public $eBayMotorsProCounterOfferEnabled;
    /**
     * The eBayMotorsProSellerContactDetailsEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that one or more categories on the corresponding eBay site allows the seller to provide contact information at listing time for a motor vehicle classified ad listing. This
     * feature is only applicable to motor vehicle classified ad listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>eBayMotorsProSellerContactDetailsEnabled</code> is not one of the
     * values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\EBayMotorsProSellerContactDetailsEnabledDefinitionType
     */
    public $eBayMotorsProSellerContactDetailsEnabled;
    /**
     * The LocalMarketAdFormatEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports Motors Local Market listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request
     * and <code>LocalMarketAdFormatEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketAdFormatEnabledDefinitionType
     */
    public $LocalMarketAdFormatEnabled;
    /**
     * The LocalMarketContactByPhoneEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of a phone number when contacting the seller about a Motors Local Market listing. This field will not be returned if one or
     * more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketContactByPhoneEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketContactByPhoneEnabledDefinitionType
     */
    public $LocalMarketContactByPhoneEnabled;
    /**
     * The LocalMarketPhoneCount
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of multiple phone numbers for the seller for a Motors Local Market listing. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>LocalMarketPhoneCount</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketPhoneCountDefinitionType
     */
    public $LocalMarketPhoneCount;
    /**
     * The LocalMarketContactByAddressEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of an address when contacting the seller about a Motors Local Market listing. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>LocalMarketContactByAddressEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketContactByAddressEnabledDefinitionType
     */
    public $LocalMarketContactByAddressEnabled;
    /**
     * The LocalMarketStreetCount
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of multiple street address for the seller for a Motors Local Market listing. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>LocalMarketStreetCount</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketStreetCountDefinitionType
     */
    public $LocalMarketStreetCount;
    /**
     * The LocalMarketCompanyNameEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of a company name when contacting the seller about a Motors Local Market listing. This field will not be returned if one or
     * more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketCompanyNameEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketCompanyNameEnabledDefinitionType
     */
    public $LocalMarketCompanyNameEnabled;
    /**
     * The LocalMarketContactByEmailEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of an email address when contacting the seller about a Motors Local Market listing. This field will not be returned if one or
     * more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketContactByEmailEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketContactByEmailEnabledDefinitionType
     */
    public $LocalMarketContactByEmailEnabled;
    /**
     * The LocalMarketBestOfferEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the Best Offer feature is supported on the corresponding eBay site for Motors Local Market listings. The Best Offer feature allows buyers and sellers to negotiate the
     * price of the item. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketBestOfferEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketBestOfferEnabledDefinitionType
     */
    public $LocalMarketBestOfferEnabled;
    /**
     * The LocalMarketAutoAcceptEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the Best Offer Auto-Accept feature for Motors Local Market listings is supported on the corresponding eBay site. The Best Offer Auto-Accept feature allows a seller to set
     * a threshold dollar value on a listing, and any Best Offer amount at or above this amount is automatically accepted by the eBay system. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and
     * <code>LocalMarketAutoAcceptEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketAutoAcceptEnabledDefinitionType
     */
    public $LocalMarketAutoAcceptEnabled;
    /**
     * The LocalMarketAutoDeclineEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the Best Offer Auto-Decline feature for Motors Local Market listings is supported on the corresponding eBay site. The Best Offer Auto-Accept feature allows a seller to set
     * a threshold dollar value on a listing, and any Best Offer amount at or above this amount is automatically accepted by the eBay system. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and
     * <code>LocalMarketAutoDeclineEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketAutoDeclineEnabledDefinitionType
     */
    public $LocalMarketAutoDeclineEnabled;
    /**
     * The LocalMarketPaymentMethodCheckOutEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows for the display of acceptable payment methods for Motors Local Market listings. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>LocalMarketPaymentMethodCheckOutEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketPaymentMethodCheckOutEnabledDefinitionType
     */
    public $LocalMarketPaymentMethodCheckOutEnabled;
    /**
     * The LocalMarketShippingMethodEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows for the display of shipping service options for Motors Local Market listings. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>LocalMarketShippingMethodEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketShippingMethodEnabledDefinitionType
     */
    public $LocalMarketShippingMethodEnabled;
    /**
     * The LocalMarketCounterOfferEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that counter offers to Best Offers are supported on the corresponding eBay site for Motors Local Market listings. The Best Offer feature allows buyers and sellers to negotiate
     * the price of the item, and once a Best Offer price is proposed, the seller can send the buyer a counter offer, and a buyer may even send another counter offer to the seller's counter offer. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>LocalMarketCounterOfferEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketCounterOfferEnabledDefinitionType
     */
    public $LocalMarketCounterOfferEnabled;
    /**
     * The LocalMarketSellerContactDetailsEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that one or more categories on the corresponding eBay site allows the seller to provide contact information at listing time for Motors Local Market listings. This feature is
     * only applicable to motor vehicle classified ad listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>LocalMarketSellerContactDetailsEnabled</code> is not one of the values passed
     * into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\LocalMarketSellerContactDetailsEnabledDefinitionType
     */
    public $LocalMarketSellerContactDetailsEnabled;
    /**
     * The ClassifiedAdPhoneCount
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of multiple phone numbers for the seller for a classified ad listing. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdPhoneCount</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ClassifiedAdPhoneCountDefinitionType
     */
    public $ClassifiedAdPhoneCount;
    /**
     * The ClassifiedAdContactByAddressEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of an address when contacting the seller about a classified ad listing. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdContactByAddressEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ClassifiedAdContactByAddressEnabledDefinitionType
     */
    public $ClassifiedAdContactByAddressEnabled;
    /**
     * The ClassifiedAdStreetCount
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of multiple street address for the seller for a classified ad listing. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdStreetCount</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ClassifiedAdStreetCountDefinitionType
     */
    public $ClassifiedAdStreetCount;
    /**
     * The ClassifiedAdCompanyNameEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of a company name when contacting the seller about a classified ad listing. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>ClassifiedAdCompanyNameEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ClassifiedAdCompanyNameEnabledDefinitionType
     */
    public $ClassifiedAdCompanyNameEnabled;
    /**
     * The SpecialitySubscription
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\SpecialitySubscriptionDefinitionType
     */
    public $SpecialitySubscription;
    /**
     * The RegularSubscription
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\RegularSubscriptionDefinitionType
     */
    public $RegularSubscription;
    /**
     * The PremiumSubscription
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\PremiumSubscriptionDefinitionType
     */
    public $PremiumSubscription;
    /**
     * The NonSubscription
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\NonSubscriptionDefinitionType
     */
    public $NonSubscription;
    /**
     * The ReturnPolicyEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of return policies in listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the
     * call request and <code>ReturnPolicyEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ReturnPolicyEnabledDefinitionType
     */
    public $ReturnPolicyEnabled;
    /**
     * The HandlingTimeEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports the use of a stated handling time in listings. The handling time is the maximum number of business days the seller commits to for
     * preparing an item to be shipped after receiving a cleared payment. The seller's handling time does not include the shipping time (the carrier's transit time). This field will not be returned if one or more <b>FeatureID</b> fields are included in the
     * call request and <code>HandlingTimeEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\HandlingTimeEnabledDefinitionType
     */
    public $HandlingTimeEnabled;
    /**
     * The PayPalRequiredForStoreOwner
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\PayPalRequiredForStoreOwnerDefinitionType
     */
    public $PayPalRequiredForStoreOwner;
    /**
     * The ReviseQuantityAllowed
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows the quantity of a listing to be revised during the life of the listing. This feature is not applicable to auction listings. This field
     * will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ReviseQuantityAllowed</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ReviseQuantityAllowedDefinitionType
     */
    public $ReviseQuantityAllowed;
    /**
     * The RevisePriceAllowed
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows the price of a listing to be revised during the life of the listing. This feature is not applicable to auction listings. This field will
     * not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>RevisePriceAllowed</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\RevisePriceAllowedDefinitionType
     */
    public $RevisePriceAllowed;
    /**
     * The StoreOwnerExtendedListingDurationsEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site supports extended listing durations for eBay Business Sellers with eBay Stores. This field will not be returned if one or more <b>FeatureID</b>
     * fields are included in the call request and <code>RevisePriceAllowed</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\StoreOwnerExtendedListingDurationsEnabledDefinitionType
     */
    public $StoreOwnerExtendedListingDurationsEnabled;
    /**
     * The StoreOwnerExtendedListingDurations
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\StoreOwnerExtendedListingDurationsDefinitionType
     */
    public $StoreOwnerExtendedListingDurations;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows for the display of acceptable payment methods in listings. This field will not be returned if one or more <b>FeatureID</b> fields are
     * included in the call request and <code>PaymentMethod</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\PaymentMethodDefinitionType
     */
    public $PaymentMethod;
    /**
     * The Group1MaxFlatShippingCost
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows for the applicable max cap per shipping cost for shipping service group1. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>Group1MaxFlatShippingCost</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\Group1MaxFlatShippingCostDefinitionType
     */
    public $Group1MaxFlatShippingCost;
    /**
     * The Group2MaxFlatShippingCost
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows for the applicable max cap per shipping cost for shipping service group2. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>Group2MaxFlatShippingCost</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\Group2MaxFlatShippingCostDefinitionType
     */
    public $Group2MaxFlatShippingCost;
    /**
     * The Group3MaxFlatShippingCost
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that the corresponding eBay site allows for the applicable max cap per shipping cost for shipping service group3. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>Group3MaxFlatShippingCost</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\Group3MaxFlatShippingCostDefinitionType
     */
    public $Group3MaxFlatShippingCost;
    /**
     * The MaxFlatShippingCostCBTExempt
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that a maximum flat-rate shipping cost is not imposed by the corresponding eBay site if the item is being shipped internationally. This field will not be returned if one or
     * more <b>FeatureID</b> fields are included in the call request and <code>MaxFlatShippingCostCBTExempt</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\MaxFlatShippingCostCBTExemptDefinitionType
     */
    public $MaxFlatShippingCostCBTExempt;
    /**
     * The MaxFlatShippingCost
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that a maximum flat-rate shipping cost is imposed by some categories on the corresponding eBay site. This field will not be returned if one or more <b>FeatureID</b> fields are
     * included in the call request and <code>MaxFlatShippingCost</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\MaxFlatShippingCostDefinitionType
     */
    public $MaxFlatShippingCost;
    /**
     * The VariationsEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that multiple-variation listings are supported on the corresponding eBay site for some categories. Multiple-variation listings contain items that are logically the same
     * product, but that vary in their manufacturing details or packaging. For example, a particular brand and style of shirt could be available in different sizes and colors, such as "large blue" and "medium black" variations. This feature is only
     * applicable to fixed-price listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>VariationsEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\VariationsEnabledDefinitionType
     */
    public $VariationsEnabled;
    /**
     * The AttributeConversionEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\AttributeConversionEnabledFeatureDefinitionType
     */
    public $AttributeConversionEnabled;
    /**
     * The FreeGalleryPlusEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that free, automatic upgrades for Gallery Plus are supported on the corresponding eBay site for some categories. This field will not be returned if one or more <b>FeatureID</b>
     * fields are included in the call request and <code>FreeGalleryPlusEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\FreeGalleryPlusEnabledDefinitionType
     */
    public $FreeGalleryPlusEnabled;
    /**
     * The FreePicturePackEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that a free Picture Pack upgrade is supported on the corresponding eBay site for some categories. This field will not be returned if one or more <b>FeatureID</b> fields are
     * included in the call request and <code>FreePicturePackEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\FreePicturePackEnabledDefinitionType
     */
    public $FreePicturePackEnabled;
    /**
     * The ItemCompatibilityEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates that Parts Compatibility is supported on the corresponding eBay site for some Parts & Accessories categories. Parts compatibility allows a seller to show a list of all the
     * vehicles that a part or accessory is compatible with in a listing. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ItemCompatibilityEnabled</code> is not one of the values passed into
     * those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemCompatibilityEnabledDefinitionType
     */
    public $ItemCompatibilityEnabled;
    /**
     * The MaxItemCompatibility
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates whether or not the corresponding site defines a maximum limit for the number of compatible applications for items listed with parts compatibilities by application. Parts
     * compatibility allows a seller to show a list of all the vehicles that a part or accessory is compatible with in a listing. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and
     * <code>MaxItemCompatibility</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\MaxItemCompatibilityDefinitionType
     */
    public $MaxItemCompatibility;
    /**
     * The MinItemCompatibility
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates whether or not the corresponding site defines a minimum amount for the number of compatible applications for items listed with parts compatibilities by application. Parts
     * compatibility allows a seller to show a list of all the vehicles that a part or accessory is compatible with in a listing. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and
     * <code>MinItemCompatibility</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\MinItemCompatibilityDefinitionType
     */
    public $MinItemCompatibility;
    /**
     * The ConditionEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates whether or not the corresponding site supports the textual description of an item's condition at listing time. This field will not be returned if one or more <b>FeatureID</b>
     * fields are included in the call request and <code>ConditionEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ConditionEnabledDefinitionType
     */
    public $ConditionEnabled;
    /**
     * The ConditionValues
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates whether or not the corresponding site supports Condition IDs to specify an item's condition at listing time. This field will not be returned if one or more <b>FeatureID</b>
     * fields are included in the call request and <code>ConditionValues</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ConditionValuesDefinitionType
     */
    public $ConditionValues;
    /**
     * The ValueCategory
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates whether or not the corresponding site supports value categories. A Value category will typically have lower listing fees or another eBay promotion. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ValueCategory</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ValueCategoryDefinitionType
     */
    public $ValueCategory;
    /**
     * The ProductCreationEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates whether or not one or more categories on the corresponding site supports the creation of listings through the specification of Global Trade Identification Numbers (GTINs) like
     * UPC, ISBN, EAN, or Brand/MPN combination. If a GTIN is matched to a product in eBay product catalog, a listing will automatically be created using the eBay catalog product's images, item specifics, description, and title. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>ProductCreationEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ProductCreationEnabledDefinitionType
     */
    public $ProductCreationEnabled;
    /**
     * The EANEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the EAN product identifying feature. This field will be returned as long as <b>EANEnabled</b> is included as a
     * <b>FeatureID</b> value in the call request or no <b>FeatureID</b> values are passed into the call request. <br> <br> To verify if a specific eBay site supports the EAN product identifying feature (for most categories), look for a <code>true</code>
     * value in the <b>SiteDefaults.EANEnabled</b> field. <br> <br> To verify if a specific category on a specific eBay site supports the EAN product identifying feature, pass in a <b>CategoryID</b> value in the request, and then look for a
     * <code>true</code> value in the <b>EANEnabled</b> field of the corresponding <b>Category</b> node (match up the <b>CategoryID</b> values if more than one Category IDs were passed in the request).
     * - minOccurs: 0
     * @var \ebay\StructType\EANEnabledDefinitionType
     */
    public $EANEnabled;
    /**
     * The ISBNEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the ISBN product identifying feature. This field will be returned as long as <b>ISBNEnabled</b> is included as
     * a <b>FeatureID</b> value in the call request or no <b>FeatureID</b> values are passed into the call request. <br> <br> To verify if a specific eBay site supports the ISBN product identifying feature (for most categories), look for a <code>true</code>
     * value in the <b>SiteDefaults.ISBNEnabled</b> field. <br> <br> To verify if a specific category on a specific eBay site supports the ISBN product identifying feature, pass in a <b>CategoryID</b> value in the request, and then look for a
     * <code>true</code> value in the <b>ISBNEnabled</b> field of the corresponding <b>Category</b> node (match up the <b>CategoryID</b> values if more than one Category IDs were passed in the request).
     * - minOccurs: 0
     * @var \ebay\StructType\ISBNEnabledDefinitionType
     */
    public $ISBNEnabled;
    /**
     * The UPCEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the UPC product identifying feature. This field will be returned as long as <b>UPCEnabled</b> is included as a
     * <b>FeatureID</b> value in the call request or no <b>FeatureID</b> values are passed into the call request. <br> <br> To verify if a specific eBay site supports the UPC product identifying feature (for most categories), look for a <code>true</code>
     * value in the <b>SiteDefaults.UPCEnabled</b> field. <br> <br> To verify if a specific category on a specific eBay site supports the UPC product identifying feature, pass in a <b>CategoryID</b> value in the request, and then look for a
     * <code>true</code> value in the <b>UPCEnabled</b> field of the corresponding <b>Category</b> node (match up the <b>CategoryID</b> values if more than one Category IDs were passed in the request).
     * - minOccurs: 0
     * @var \ebay\StructType\UPCEnabledDefinitionType
     */
    public $UPCEnabled;
    /**
     * The CompatibleVehicleType
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates whether or not one or more categories on the corresponding site supports the Parts Compatibility feature for motor vehicles. This field will not be returned if one or more
     * <b>FeatureID</b> fields are included in the call request and <code>CompatibleVehicleType</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\CompatibleVehicleTypeDefinitionType
     */
    public $CompatibleVehicleType;
    /**
     * The MaxGranularFitmentCount
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates whether or not the corresponding site defines a maximum limit for the number of fine-grained item compatibilities that can be applied to a listing. This field will not be
     * returned if one or more <b>FeatureID</b> fields are included in the call request and <code>MaxGranularFitmentCount</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\MaxGranularFitmentCountDefinitionType
     */
    public $MaxGranularFitmentCount;
    /**
     * The PaymentOptionsGroup
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\PaymentOptionsGroupEnabledDefinitionType
     */
    public $PaymentOptionsGroup;
    /**
     * The ShippingProfileCategoryGroup
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates whether or not the corresponding site supports the use of shipping business policies. This field will not be returned if one or more <b>FeatureID</b> fields are included in the
     * call request and <code>ShippingProfileCategoryGroup</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ProfileCategoryGroupDefinitionType
     */
    public $ShippingProfileCategoryGroup;
    /**
     * The PaymentProfileCategoryGroup
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates whether or not the corresponding site supports the use of payment business policies. This field will not be returned if one or more <b>FeatureID</b> fields are included in the
     * call request and <code>PaymentProfileCategoryGroup</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ProfileCategoryGroupDefinitionType
     */
    public $PaymentProfileCategoryGroup;
    /**
     * The ReturnPolicyProfileCategoryGroup
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates whether or not the corresponding site supports the use of return business policies. This field will not be returned if one or more <b>FeatureID</b> fields are included in the
     * call request and <code>ReturnPolicyProfileCategoryGroup</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\ProfileCategoryGroupDefinitionType
     */
    public $ReturnPolicyProfileCategoryGroup;
    /**
     * The VINSupported
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates whether or not the corresponding site supports the use of the VIN (Vehicle Identification Number) field to identify a motor vehicle and create a listing is supported. VINs are
     * supported on the US, Canada, Canada-French, and Australia sites. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>VINSupported</code> is not one of the values passed into those
     * <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\VINSupportedDefinitionType
     */
    public $VINSupported;
    /**
     * The VRMSupported
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates whether or not the corresponding site supports the use of the VRM (Vehicle Registration Mark) field to identify a motor vehicle and create a listing is supported. VRMs are only
     * supported on the UK site. This field will not be returned if one or more <b>FeatureID</b> fields are included in the call request and <code>VRMSupported</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\VRMSupportedDefinitionType
     */
    public $VRMSupported;
    /**
     * The SellerProvidedTitleSupported
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates whether or not the corresponding site supports seller-provided titles in listings. This field will not be returned if one or more <b>FeatureID</b> fields are included in the
     * call request and <code>SellerProvidedTitleSupported</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\SellerProvidedTitleSupportedDefinitionType
     */
    public $SellerProvidedTitleSupported;
    /**
     * The DepositSupported
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates whether or not the corresponding site supports deposits/down payments for motor vehicle listings. This field will not be returned if one or more <b>FeatureID</b> fields are
     * included in the call request and <code>DepositSupported</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\DepositSupportedDefinitionType
     */
    public $DepositSupported;
    /**
     * The GlobalShippingEnabled
     * Meta informations extracted from the WSDL
     * - documentation: The return of this empty field in the response indicates whether or not the corresponding site supports the Global Shipping Program (GSP) as the method for shipping orders internationally. This field will not be returned if one or
     * more <b>FeatureID</b> fields are included in the call request and <code>GlobalShippingEnabled</code> is not one of the values passed into those <b>FeatureID</b> fields.
     * - minOccurs: 0
     * @var \ebay\StructType\GlobalShippingEnabledDefinitionType
     */
    public $GlobalShippingEnabled;
    /**
     * The AdditionalCompatibilityEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Boat and Motorcycle Parts Compatibility feature. This field will be returned as long as
     * <b>AdditionalCompatibilityEnabled</b> is included as a <b>FeatureID</b> value in the call request or no <b>FeatureID</b> values are passed into the call request. <br> <br> To verify if a specific eBay site supports Boat or Motorcycle Parts
     * Compatibility (for most categories), look for a <code>true</code> value in the <b>SiteDefaults.AdditionalCompatibilityEnabled</b> field. <br> <br> To verify if a specific category on a specific eBay site supports Boat and Motorcycle Parts
     * Compatibility, pass in a <b>CategoryID</b> value in the request, and then look for a <code>true</code> <br> value in the <b>AdditionalCompatibilityEnabled</b> field of the corresponding <b>Category</b> node (match up the <b>CategoryID</b> values if
     * more than one Category IDs were passed in the request).
     * - minOccurs: 0
     * @var \ebay\StructType\AdditionalCompatibilityEnabledDefinitionType
     */
    public $AdditionalCompatibilityEnabled;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The PickupDropOffEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support the Click and Collect feature. This field will be returned as long as <b>PickupDropOffEnabled</b> is included
     * as a <b>FeatureID</b> value in the call request or no <b>FeatureID</b> values are passed into the call request. <br> <br> To verify if a specific eBay site supports the Click and Collect feature (for most categories), look for a <code>true</code>
     * value in the <b>SiteDefaults.PickupDropOffEnabled</b> field. <br> <br> To verify if a specific category on a specific eBay site supports the Click and Collect feature, pass in a <b>CategoryID</b> value in the request, and then look for a
     * <code>true</code> value in the <b>PickupDropOffEnabled</b> field of the corresponding <b>Category</b> node (match up the <b>CategoryID</b> values if more than one Category IDs were passed in the request).
     * - minOccurs: 0
     * @var \ebay\StructType\PickupDropOffEnabledDefinitionType
     */
    public $PickupDropOffEnabled;
    /**
     * The DigitalGoodDeliveryEnabled
     * Meta informations extracted from the WSDL
     * - documentation: This field is returned as an empty element (a boolean value is not returned) if one or more eBay API-enabled sites support digital gift card listings. This field will be returned as long as <b>DigitalGoodDeliveryEnabled</b> is
     * included as a <b>FeatureID</b> value in the call request or no <b>FeatureID</b> values are passed into the call request. <br> <br> To verify if a specific eBay site supports digital gift card listings (for most categories), look for a
     * <code>true</code> value in the <b>SiteDefaults.DigitalGoodDeliveryEnabled</b> field. <br> <br> To verify if a specific category on a specific eBay site supports digital gift card listings, pass in a <b>CategoryID</b> value in the request, and then
     * look for a <code>true</code> value in the <b>DigitalGoodDeliveryEnabled</b> field of the corresponding <b>Category</b> node (match up the <b>CategoryID</b> values if more than one Category IDs were passed in the request). <br> <br> Digital gift cards
     * are currently only supported on the US site. There are some restrictions when it comes to selling gift cards, including the following: <ul> <li>Each seller can only have one gift card listing at any given time </li> <li>The maximum dollar value of
     * the gift card may not exceed 500.00</li> <li>Prepaid credit cards from American Express, Discover, MasterCard, or Visa are not allowed</li> </ul> For more information on eBay's Gift Card policy, see the <a href="
     * http://pages.ebay.com/help/policies/gift.html" target="_blank">Gift cards policy Help page</a>.
     * - minOccurs: 0
     * @var \ebay\StructType\DigitalGoodDeliveryEnabledDefinitionType
     */
    public $DigitalGoodDeliveryEnabled;
    /**
     * The EpidSupported
     * Meta informations extracted from the WSDL
     * - documentation: This field is returned as an empty element if the use of an eBay Product ID (e.g. ePID) in an Add/Revise/Relist API call to identify which motorcycles and/or scooters are compatible with a motor vehicle part or accessory is
     * supported. ePIDs can only be used to identify motorcycles and scooters on the Germany and UK sites. This field will be returned as long as <b>EpidSupported</b> is included as a <b>FeatureID</b> value in the call request or no <b>FeatureID</b> values
     * are passed into the call request. <br/><br/> For more information on using an ePID to identify a compatible motorcycle or scooter through an Add/Revise/Relist API call on the Germany or UK site, see the documentation for the <a href="
     * http://developer.ebay.com/Devzone/XML/docs/Reference/eBay/AddItem.html#Request.Item.ItemCompatibilityList.Compatibility.NameValueList">Compatibility.NameValueList</a> container.
     * - minOccurs: 0
     * @var \ebay\StructType\EpidSupportedDefinitionType
     */
    public $EpidSupported;
    /**
     * The KTypeSupported
     * Meta informations extracted from the WSDL
     * - documentation: This field is returned as an empty element if the use of a K Type vehicle number in an Add/Revise/Relist API call to identify which cars and/or trucks are compatible with a motor vehicle part or accessory is supported. K type vehicle
     * numbers can only be used to identify cars and trucks on the Germany site. This field will be returned as long as <b>KTypeSupported</b> is included as a <b>FeatureID</b> value in the call request or no <b>FeatureID</b> values are passed into the call
     * request. <br/><br/> For more information on using a K Type vehicle number to identify a compatible car or truck through an Add/Revise/Relist API call on the Germany site, see the documentation for the <a href="
     * http://developer.ebay.com/Devzone/XML/docs/Reference/eBay/AddItem.html#Request.Item.ItemCompatibilityList.Compatibility.NameValueList">Compatibility.NameValueList</a> container.
     * - minOccurs: 0
     * @var \ebay\StructType\KTypeSupportedDefinitionType
     */
    public $KTypeSupported;
    /**
     * Constructor method for FeatureDefinitionsType
     * @uses FeatureDefinitionsType::setListingDurations()
     * @uses FeatureDefinitionsType::setShippingTermsRequired()
     * @uses FeatureDefinitionsType::setBestOfferEnabled()
     * @uses FeatureDefinitionsType::setDutchBINEnabled()
     * @uses FeatureDefinitionsType::setUserConsentRequired()
     * @uses FeatureDefinitionsType::setHomePageFeaturedEnabled()
     * @uses FeatureDefinitionsType::setProPackEnabled()
     * @uses FeatureDefinitionsType::setBasicUpgradePackEnabled()
     * @uses FeatureDefinitionsType::setValuePackEnabled()
     * @uses FeatureDefinitionsType::setProPackPlusEnabled()
     * @uses FeatureDefinitionsType::setAdFormatEnabled()
     * @uses FeatureDefinitionsType::setBestOfferCounterEnabled()
     * @uses FeatureDefinitionsType::setBestOfferAutoDeclineEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketSpecialitySubscription()
     * @uses FeatureDefinitionsType::setLocalMarketRegularSubscription()
     * @uses FeatureDefinitionsType::setLocalMarketPremiumSubscription()
     * @uses FeatureDefinitionsType::setLocalMarketNonSubscription()
     * @uses FeatureDefinitionsType::setExpressEnabled()
     * @uses FeatureDefinitionsType::setExpressPicturesRequired()
     * @uses FeatureDefinitionsType::setExpressConditionRequired()
     * @uses FeatureDefinitionsType::setMinimumReservePrice()
     * @uses FeatureDefinitionsType::setTransactionConfirmationRequestEnabled()
     * @uses FeatureDefinitionsType::setSellerContactDetailsEnabled()
     * @uses FeatureDefinitionsType::setStoreInventoryEnabled()
     * @uses FeatureDefinitionsType::setSkypeMeTransactionalEnabled()
     * @uses FeatureDefinitionsType::setSkypeMeNonTransactionalEnabled()
     * @uses FeatureDefinitionsType::setLocalListingDistancesRegular()
     * @uses FeatureDefinitionsType::setLocalListingDistancesSpecialty()
     * @uses FeatureDefinitionsType::setLocalListingDistancesNonSubscription()
     * @uses FeatureDefinitionsType::setClassifiedAdPaymentMethodEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdShippingMethodEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdBestOfferEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdCounterOfferEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdAutoDeclineEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdContactByPhoneEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdContactByEmailEnabled()
     * @uses FeatureDefinitionsType::setSafePaymentRequired()
     * @uses FeatureDefinitionsType::setClassifiedAdPayPerLeadEnabled()
     * @uses FeatureDefinitionsType::setItemSpecificsEnabled()
     * @uses FeatureDefinitionsType::setPaisaPayFullEscrowEnabled()
     * @uses FeatureDefinitionsType::setISBNIdentifierEnabled()
     * @uses FeatureDefinitionsType::setUPCIdentifierEnabled()
     * @uses FeatureDefinitionsType::setEANIdentifierEnabled()
     * @uses FeatureDefinitionsType::setBrandMPNIdentifierEnabled()
     * @uses FeatureDefinitionsType::setBestOfferAutoAcceptEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdAutoAcceptEnabled()
     * @uses FeatureDefinitionsType::setCrossBorderTradeNorthAmericaEnabled()
     * @uses FeatureDefinitionsType::setCrossBorderTradeGBEnabled()
     * @uses FeatureDefinitionsType::setCrossBorderTradeAustraliaEnabled()
     * @uses FeatureDefinitionsType::setPayPalBuyerProtectionEnabled()
     * @uses FeatureDefinitionsType::setBuyerGuaranteeEnabled()
     * @uses FeatureDefinitionsType::setCombinedFixedPriceTreatmentEnabled()
     * @uses FeatureDefinitionsType::setGalleryFeaturedDurations()
     * @uses FeatureDefinitionsType::setINEscrowWorkflowTimeline()
     * @uses FeatureDefinitionsType::setPayPalRequired()
     * @uses FeatureDefinitionsType::setEBayMotorsProAdFormatEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProContactByPhoneEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProPhoneCount()
     * @uses FeatureDefinitionsType::setEBayMotorsProContactByAddressEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProStreetCount()
     * @uses FeatureDefinitionsType::setEBayMotorsProCompanyNameEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProContactByEmailEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProBestOfferEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProAutoAcceptEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProAutoDeclineEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProPaymentMethodCheckOutEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProShippingMethodEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProCounterOfferEnabled()
     * @uses FeatureDefinitionsType::setEBayMotorsProSellerContactDetailsEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketAdFormatEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketContactByPhoneEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketPhoneCount()
     * @uses FeatureDefinitionsType::setLocalMarketContactByAddressEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketStreetCount()
     * @uses FeatureDefinitionsType::setLocalMarketCompanyNameEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketContactByEmailEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketBestOfferEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketAutoAcceptEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketAutoDeclineEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketPaymentMethodCheckOutEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketShippingMethodEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketCounterOfferEnabled()
     * @uses FeatureDefinitionsType::setLocalMarketSellerContactDetailsEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdPhoneCount()
     * @uses FeatureDefinitionsType::setClassifiedAdContactByAddressEnabled()
     * @uses FeatureDefinitionsType::setClassifiedAdStreetCount()
     * @uses FeatureDefinitionsType::setClassifiedAdCompanyNameEnabled()
     * @uses FeatureDefinitionsType::setSpecialitySubscription()
     * @uses FeatureDefinitionsType::setRegularSubscription()
     * @uses FeatureDefinitionsType::setPremiumSubscription()
     * @uses FeatureDefinitionsType::setNonSubscription()
     * @uses FeatureDefinitionsType::setReturnPolicyEnabled()
     * @uses FeatureDefinitionsType::setHandlingTimeEnabled()
     * @uses FeatureDefinitionsType::setPayPalRequiredForStoreOwner()
     * @uses FeatureDefinitionsType::setReviseQuantityAllowed()
     * @uses FeatureDefinitionsType::setRevisePriceAllowed()
     * @uses FeatureDefinitionsType::setStoreOwnerExtendedListingDurationsEnabled()
     * @uses FeatureDefinitionsType::setStoreOwnerExtendedListingDurations()
     * @uses FeatureDefinitionsType::setPaymentMethod()
     * @uses FeatureDefinitionsType::setGroup1MaxFlatShippingCost()
     * @uses FeatureDefinitionsType::setGroup2MaxFlatShippingCost()
     * @uses FeatureDefinitionsType::setGroup3MaxFlatShippingCost()
     * @uses FeatureDefinitionsType::setMaxFlatShippingCostCBTExempt()
     * @uses FeatureDefinitionsType::setMaxFlatShippingCost()
     * @uses FeatureDefinitionsType::setVariationsEnabled()
     * @uses FeatureDefinitionsType::setAttributeConversionEnabled()
     * @uses FeatureDefinitionsType::setFreeGalleryPlusEnabled()
     * @uses FeatureDefinitionsType::setFreePicturePackEnabled()
     * @uses FeatureDefinitionsType::setItemCompatibilityEnabled()
     * @uses FeatureDefinitionsType::setMaxItemCompatibility()
     * @uses FeatureDefinitionsType::setMinItemCompatibility()
     * @uses FeatureDefinitionsType::setConditionEnabled()
     * @uses FeatureDefinitionsType::setConditionValues()
     * @uses FeatureDefinitionsType::setValueCategory()
     * @uses FeatureDefinitionsType::setProductCreationEnabled()
     * @uses FeatureDefinitionsType::setEANEnabled()
     * @uses FeatureDefinitionsType::setISBNEnabled()
     * @uses FeatureDefinitionsType::setUPCEnabled()
     * @uses FeatureDefinitionsType::setCompatibleVehicleType()
     * @uses FeatureDefinitionsType::setMaxGranularFitmentCount()
     * @uses FeatureDefinitionsType::setPaymentOptionsGroup()
     * @uses FeatureDefinitionsType::setShippingProfileCategoryGroup()
     * @uses FeatureDefinitionsType::setPaymentProfileCategoryGroup()
     * @uses FeatureDefinitionsType::setReturnPolicyProfileCategoryGroup()
     * @uses FeatureDefinitionsType::setVINSupported()
     * @uses FeatureDefinitionsType::setVRMSupported()
     * @uses FeatureDefinitionsType::setSellerProvidedTitleSupported()
     * @uses FeatureDefinitionsType::setDepositSupported()
     * @uses FeatureDefinitionsType::setGlobalShippingEnabled()
     * @uses FeatureDefinitionsType::setAdditionalCompatibilityEnabled()
     * @uses FeatureDefinitionsType::setAny()
     * @uses FeatureDefinitionsType::setPickupDropOffEnabled()
     * @uses FeatureDefinitionsType::setDigitalGoodDeliveryEnabled()
     * @uses FeatureDefinitionsType::setEpidSupported()
     * @uses FeatureDefinitionsType::setKTypeSupported()
     * @param \ebay\StructType\ListingDurationDefinitionsType $listingDurations
     * @param \ebay\StructType\ShippingTermRequiredDefinitionType $shippingTermsRequired
     * @param \ebay\StructType\BestOfferEnabledDefinitionType $bestOfferEnabled
     * @param \ebay\StructType\DutchBINEnabledDefinitionType $dutchBINEnabled
     * @param \ebay\StructType\UserConsentRequiredDefinitionType $userConsentRequired
     * @param \ebay\StructType\HomePageFeaturedEnabledDefinitionType $homePageFeaturedEnabled
     * @param \ebay\StructType\ProPackEnabledDefinitionType $proPackEnabled
     * @param \ebay\StructType\BasicUpgradePackEnabledDefinitionType $basicUpgradePackEnabled
     * @param \ebay\StructType\ValuePackEnabledDefinitionType $valuePackEnabled
     * @param \ebay\StructType\ProPackPlusEnabledDefinitionType $proPackPlusEnabled
     * @param \ebay\StructType\AdFormatEnabledDefinitionType $adFormatEnabled
     * @param \ebay\StructType\BestOfferCounterEnabledDefinitionType $bestOfferCounterEnabled
     * @param \ebay\StructType\BestOfferAutoDeclineEnabledDefinitionType $bestOfferAutoDeclineEnabled
     * @param \ebay\StructType\LocalMarketSpecialitySubscriptionDefinitionType $localMarketSpecialitySubscription
     * @param \ebay\StructType\LocalMarketRegularSubscriptionDefinitionType $localMarketRegularSubscription
     * @param \ebay\StructType\LocalMarketPremiumSubscriptionDefinitionType $localMarketPremiumSubscription
     * @param \ebay\StructType\LocalMarketNonSubscriptionDefinitionType $localMarketNonSubscription
     * @param \ebay\StructType\ExpressEnabledDefinitionType $expressEnabled
     * @param \ebay\StructType\ExpressPicturesRequiredDefinitionType $expressPicturesRequired
     * @param \ebay\StructType\ExpressConditionRequiredDefinitionType $expressConditionRequired
     * @param \ebay\StructType\MinimumReservePriceDefinitionType $minimumReservePrice
     * @param \ebay\StructType\TCREnabledDefinitionType $transactionConfirmationRequestEnabled
     * @param \ebay\StructType\SellerContactDetailsEnabledDefinitionType $sellerContactDetailsEnabled
     * @param \ebay\StructType\StoreInventoryEnabledDefinitionType $storeInventoryEnabled
     * @param \ebay\StructType\SkypeMeTransactionalEnabledDefinitionType $skypeMeTransactionalEnabled
     * @param \ebay\StructType\SkypeMeNonTransactionalEnabledDefinitionType $skypeMeNonTransactionalEnabled
     * @param \ebay\StructType\LocalListingDistancesRegularDefinitionType $localListingDistancesRegular
     * @param \ebay\StructType\LocalListingDistancesSpecialtyDefinitionType $localListingDistancesSpecialty
     * @param \ebay\StructType\LocalListingDistancesNonSubscriptionDefinitionType $localListingDistancesNonSubscription
     * @param \ebay\StructType\ClassifiedAdPaymentMethodEnabledDefinitionType $classifiedAdPaymentMethodEnabled
     * @param \ebay\StructType\ClassifiedAdShippingMethodEnabledDefinitionType $classifiedAdShippingMethodEnabled
     * @param \ebay\StructType\ClassifiedAdBestOfferEnabledDefinitionType $classifiedAdBestOfferEnabled
     * @param \ebay\StructType\ClassifiedAdCounterOfferEnabledDefinitionType $classifiedAdCounterOfferEnabled
     * @param \ebay\StructType\ClassifiedAdAutoDeclineEnabledDefinitionType $classifiedAdAutoDeclineEnabled
     * @param \ebay\StructType\ClassifiedAdContactByPhoneEnabledDefinitionType $classifiedAdContactByPhoneEnabled
     * @param \ebay\StructType\ClassifiedAdContactByEmailEnabledDefintionType $classifiedAdContactByEmailEnabled
     * @param \ebay\StructType\SafePaymentRequiredDefinitionType $safePaymentRequired
     * @param \ebay\StructType\ClassifiedAdPayPerLeadEnabledDefinitionType $classifiedAdPayPerLeadEnabled
     * @param \ebay\StructType\ItemSpecificsEnabledDefinitionType $itemSpecificsEnabled
     * @param \ebay\StructType\PaisaPayFullEscrowEnabledDefinitionType $paisaPayFullEscrowEnabled
     * @param \ebay\StructType\ISBNIdentifierEnabledDefinitionType $iSBNIdentifierEnabled
     * @param \ebay\StructType\UPCIdentifierEnabledDefinitionType $uPCIdentifierEnabled
     * @param \ebay\StructType\EANIdentifierEnabledDefinitionType $eANIdentifierEnabled
     * @param \ebay\StructType\BrandMPNIdentifierEnabledDefinitionType $brandMPNIdentifierEnabled
     * @param \ebay\StructType\BestOfferAutoAcceptEnabledDefinitionType $bestOfferAutoAcceptEnabled
     * @param \ebay\StructType\ClassifiedAdAutoAcceptEnabledDefinitionType $classifiedAdAutoAcceptEnabled
     * @param \ebay\StructType\CrossBorderTradeNorthAmericaEnabledDefinitionType $crossBorderTradeNorthAmericaEnabled
     * @param \ebay\StructType\CrossBorderTradeGBEnabledDefinitionType $crossBorderTradeGBEnabled
     * @param \ebay\StructType\CrossBorderTradeAustraliaEnabledDefinitionType $crossBorderTradeAustraliaEnabled
     * @param \ebay\StructType\PayPalBuyerProtectionEnabledDefinitionType $payPalBuyerProtectionEnabled
     * @param \ebay\StructType\BuyerGuaranteeEnabledDefinitionType $buyerGuaranteeEnabled
     * @param \ebay\StructType\CombinedFixedPriceTreatmentEnabledDefinitionType $combinedFixedPriceTreatmentEnabled
     * @param \ebay\StructType\ListingEnhancementDurationDefinitionType $galleryFeaturedDurations
     * @param \ebay\StructType\INEscrowWorkflowTimelineDefinitionType $iNEscrowWorkflowTimeline
     * @param \ebay\StructType\PayPalRequiredDefinitionType $payPalRequired
     * @param \ebay\StructType\EBayMotorsProAdFormatEnabledDefinitionType $eBayMotorsProAdFormatEnabled
     * @param \ebay\StructType\EBayMotorsProContactByPhoneEnabledDefinitionType $eBayMotorsProContactByPhoneEnabled
     * @param \ebay\StructType\EBayMotorsProPhoneCountDefinitionType $eBayMotorsProPhoneCount
     * @param \ebay\StructType\EBayMotorsProContactByAddressEnabledDefinitionType $eBayMotorsProContactByAddressEnabled
     * @param \ebay\StructType\EBayMotorsProStreetCountDefinitionType $eBayMotorsProStreetCount
     * @param \ebay\StructType\EBayMotorsProCompanyNameEnabledDefinitionType $eBayMotorsProCompanyNameEnabled
     * @param \ebay\StructType\EBayMotorsProContactByEmailEnabledDefinitionType $eBayMotorsProContactByEmailEnabled
     * @param \ebay\StructType\EBayMotorsProBestOfferEnabledDefinitionType $eBayMotorsProBestOfferEnabled
     * @param \ebay\StructType\EBayMotorsProAutoAcceptEnabledDefinitionType $eBayMotorsProAutoAcceptEnabled
     * @param \ebay\StructType\EBayMotorsProAutoDeclineEnabledDefinitionType $eBayMotorsProAutoDeclineEnabled
     * @param \ebay\StructType\EBayMotorsProPaymentMethodCheckOutEnabledDefinitionType $eBayMotorsProPaymentMethodCheckOutEnabled
     * @param \ebay\StructType\EBayMotorsProShippingMethodEnabledDefinitionType $eBayMotorsProShippingMethodEnabled
     * @param \ebay\StructType\EBayMotorsProCounterOfferEnabledDefinitionType $eBayMotorsProCounterOfferEnabled
     * @param \ebay\StructType\EBayMotorsProSellerContactDetailsEnabledDefinitionType $eBayMotorsProSellerContactDetailsEnabled
     * @param \ebay\StructType\LocalMarketAdFormatEnabledDefinitionType $localMarketAdFormatEnabled
     * @param \ebay\StructType\LocalMarketContactByPhoneEnabledDefinitionType $localMarketContactByPhoneEnabled
     * @param \ebay\StructType\LocalMarketPhoneCountDefinitionType $localMarketPhoneCount
     * @param \ebay\StructType\LocalMarketContactByAddressEnabledDefinitionType $localMarketContactByAddressEnabled
     * @param \ebay\StructType\LocalMarketStreetCountDefinitionType $localMarketStreetCount
     * @param \ebay\StructType\LocalMarketCompanyNameEnabledDefinitionType $localMarketCompanyNameEnabled
     * @param \ebay\StructType\LocalMarketContactByEmailEnabledDefinitionType $localMarketContactByEmailEnabled
     * @param \ebay\StructType\LocalMarketBestOfferEnabledDefinitionType $localMarketBestOfferEnabled
     * @param \ebay\StructType\LocalMarketAutoAcceptEnabledDefinitionType $localMarketAutoAcceptEnabled
     * @param \ebay\StructType\LocalMarketAutoDeclineEnabledDefinitionType $localMarketAutoDeclineEnabled
     * @param \ebay\StructType\LocalMarketPaymentMethodCheckOutEnabledDefinitionType $localMarketPaymentMethodCheckOutEnabled
     * @param \ebay\StructType\LocalMarketShippingMethodEnabledDefinitionType $localMarketShippingMethodEnabled
     * @param \ebay\StructType\LocalMarketCounterOfferEnabledDefinitionType $localMarketCounterOfferEnabled
     * @param \ebay\StructType\LocalMarketSellerContactDetailsEnabledDefinitionType $localMarketSellerContactDetailsEnabled
     * @param \ebay\StructType\ClassifiedAdPhoneCountDefinitionType $classifiedAdPhoneCount
     * @param \ebay\StructType\ClassifiedAdContactByAddressEnabledDefinitionType $classifiedAdContactByAddressEnabled
     * @param \ebay\StructType\ClassifiedAdStreetCountDefinitionType $classifiedAdStreetCount
     * @param \ebay\StructType\ClassifiedAdCompanyNameEnabledDefinitionType $classifiedAdCompanyNameEnabled
     * @param \ebay\StructType\SpecialitySubscriptionDefinitionType $specialitySubscription
     * @param \ebay\StructType\RegularSubscriptionDefinitionType $regularSubscription
     * @param \ebay\StructType\PremiumSubscriptionDefinitionType $premiumSubscription
     * @param \ebay\StructType\NonSubscriptionDefinitionType $nonSubscription
     * @param \ebay\StructType\ReturnPolicyEnabledDefinitionType $returnPolicyEnabled
     * @param \ebay\StructType\HandlingTimeEnabledDefinitionType $handlingTimeEnabled
     * @param \ebay\StructType\PayPalRequiredForStoreOwnerDefinitionType $payPalRequiredForStoreOwner
     * @param \ebay\StructType\ReviseQuantityAllowedDefinitionType $reviseQuantityAllowed
     * @param \ebay\StructType\RevisePriceAllowedDefinitionType $revisePriceAllowed
     * @param \ebay\StructType\StoreOwnerExtendedListingDurationsEnabledDefinitionType $storeOwnerExtendedListingDurationsEnabled
     * @param \ebay\StructType\StoreOwnerExtendedListingDurationsDefinitionType $storeOwnerExtendedListingDurations
     * @param \ebay\StructType\PaymentMethodDefinitionType $paymentMethod
     * @param \ebay\StructType\Group1MaxFlatShippingCostDefinitionType $group1MaxFlatShippingCost
     * @param \ebay\StructType\Group2MaxFlatShippingCostDefinitionType $group2MaxFlatShippingCost
     * @param \ebay\StructType\Group3MaxFlatShippingCostDefinitionType $group3MaxFlatShippingCost
     * @param \ebay\StructType\MaxFlatShippingCostCBTExemptDefinitionType $maxFlatShippingCostCBTExempt
     * @param \ebay\StructType\MaxFlatShippingCostDefinitionType $maxFlatShippingCost
     * @param \ebay\StructType\VariationsEnabledDefinitionType $variationsEnabled
     * @param \ebay\StructType\AttributeConversionEnabledFeatureDefinitionType $attributeConversionEnabled
     * @param \ebay\StructType\FreeGalleryPlusEnabledDefinitionType $freeGalleryPlusEnabled
     * @param \ebay\StructType\FreePicturePackEnabledDefinitionType $freePicturePackEnabled
     * @param \ebay\StructType\ItemCompatibilityEnabledDefinitionType $itemCompatibilityEnabled
     * @param \ebay\StructType\MaxItemCompatibilityDefinitionType $maxItemCompatibility
     * @param \ebay\StructType\MinItemCompatibilityDefinitionType $minItemCompatibility
     * @param \ebay\StructType\ConditionEnabledDefinitionType $conditionEnabled
     * @param \ebay\StructType\ConditionValuesDefinitionType $conditionValues
     * @param \ebay\StructType\ValueCategoryDefinitionType $valueCategory
     * @param \ebay\StructType\ProductCreationEnabledDefinitionType $productCreationEnabled
     * @param \ebay\StructType\EANEnabledDefinitionType $eANEnabled
     * @param \ebay\StructType\ISBNEnabledDefinitionType $iSBNEnabled
     * @param \ebay\StructType\UPCEnabledDefinitionType $uPCEnabled
     * @param \ebay\StructType\CompatibleVehicleTypeDefinitionType $compatibleVehicleType
     * @param \ebay\StructType\MaxGranularFitmentCountDefinitionType $maxGranularFitmentCount
     * @param \ebay\StructType\PaymentOptionsGroupEnabledDefinitionType $paymentOptionsGroup
     * @param \ebay\StructType\ProfileCategoryGroupDefinitionType $shippingProfileCategoryGroup
     * @param \ebay\StructType\ProfileCategoryGroupDefinitionType $paymentProfileCategoryGroup
     * @param \ebay\StructType\ProfileCategoryGroupDefinitionType $returnPolicyProfileCategoryGroup
     * @param \ebay\StructType\VINSupportedDefinitionType $vINSupported
     * @param \ebay\StructType\VRMSupportedDefinitionType $vRMSupported
     * @param \ebay\StructType\SellerProvidedTitleSupportedDefinitionType $sellerProvidedTitleSupported
     * @param \ebay\StructType\DepositSupportedDefinitionType $depositSupported
     * @param \ebay\StructType\GlobalShippingEnabledDefinitionType $globalShippingEnabled
     * @param \ebay\StructType\AdditionalCompatibilityEnabledDefinitionType $additionalCompatibilityEnabled
     * @param \DOMDocument $any
     * @param \ebay\StructType\PickupDropOffEnabledDefinitionType $pickupDropOffEnabled
     * @param \ebay\StructType\DigitalGoodDeliveryEnabledDefinitionType $digitalGoodDeliveryEnabled
     * @param \ebay\StructType\EpidSupportedDefinitionType $epidSupported
     * @param \ebay\StructType\KTypeSupportedDefinitionType $kTypeSupported
     */
    public function __construct(\ebay\StructType\ListingDurationDefinitionsType $listingDurations = null, \ebay\StructType\ShippingTermRequiredDefinitionType $shippingTermsRequired = null, \ebay\StructType\BestOfferEnabledDefinitionType $bestOfferEnabled = null, \ebay\StructType\DutchBINEnabledDefinitionType $dutchBINEnabled = null, \ebay\StructType\UserConsentRequiredDefinitionType $userConsentRequired = null, \ebay\StructType\HomePageFeaturedEnabledDefinitionType $homePageFeaturedEnabled = null, \ebay\StructType\ProPackEnabledDefinitionType $proPackEnabled = null, \ebay\StructType\BasicUpgradePackEnabledDefinitionType $basicUpgradePackEnabled = null, \ebay\StructType\ValuePackEnabledDefinitionType $valuePackEnabled = null, \ebay\StructType\ProPackPlusEnabledDefinitionType $proPackPlusEnabled = null, \ebay\StructType\AdFormatEnabledDefinitionType $adFormatEnabled = null, \ebay\StructType\BestOfferCounterEnabledDefinitionType $bestOfferCounterEnabled = null, \ebay\StructType\BestOfferAutoDeclineEnabledDefinitionType $bestOfferAutoDeclineEnabled = null, \ebay\StructType\LocalMarketSpecialitySubscriptionDefinitionType $localMarketSpecialitySubscription = null, \ebay\StructType\LocalMarketRegularSubscriptionDefinitionType $localMarketRegularSubscription = null, \ebay\StructType\LocalMarketPremiumSubscriptionDefinitionType $localMarketPremiumSubscription = null, \ebay\StructType\LocalMarketNonSubscriptionDefinitionType $localMarketNonSubscription = null, \ebay\StructType\ExpressEnabledDefinitionType $expressEnabled = null, \ebay\StructType\ExpressPicturesRequiredDefinitionType $expressPicturesRequired = null, \ebay\StructType\ExpressConditionRequiredDefinitionType $expressConditionRequired = null, \ebay\StructType\MinimumReservePriceDefinitionType $minimumReservePrice = null, \ebay\StructType\TCREnabledDefinitionType $transactionConfirmationRequestEnabled = null, \ebay\StructType\SellerContactDetailsEnabledDefinitionType $sellerContactDetailsEnabled = null, \ebay\StructType\StoreInventoryEnabledDefinitionType $storeInventoryEnabled = null, \ebay\StructType\SkypeMeTransactionalEnabledDefinitionType $skypeMeTransactionalEnabled = null, \ebay\StructType\SkypeMeNonTransactionalEnabledDefinitionType $skypeMeNonTransactionalEnabled = null, \ebay\StructType\LocalListingDistancesRegularDefinitionType $localListingDistancesRegular = null, \ebay\StructType\LocalListingDistancesSpecialtyDefinitionType $localListingDistancesSpecialty = null, \ebay\StructType\LocalListingDistancesNonSubscriptionDefinitionType $localListingDistancesNonSubscription = null, \ebay\StructType\ClassifiedAdPaymentMethodEnabledDefinitionType $classifiedAdPaymentMethodEnabled = null, \ebay\StructType\ClassifiedAdShippingMethodEnabledDefinitionType $classifiedAdShippingMethodEnabled = null, \ebay\StructType\ClassifiedAdBestOfferEnabledDefinitionType $classifiedAdBestOfferEnabled = null, \ebay\StructType\ClassifiedAdCounterOfferEnabledDefinitionType $classifiedAdCounterOfferEnabled = null, \ebay\StructType\ClassifiedAdAutoDeclineEnabledDefinitionType $classifiedAdAutoDeclineEnabled = null, \ebay\StructType\ClassifiedAdContactByPhoneEnabledDefinitionType $classifiedAdContactByPhoneEnabled = null, \ebay\StructType\ClassifiedAdContactByEmailEnabledDefintionType $classifiedAdContactByEmailEnabled = null, \ebay\StructType\SafePaymentRequiredDefinitionType $safePaymentRequired = null, \ebay\StructType\ClassifiedAdPayPerLeadEnabledDefinitionType $classifiedAdPayPerLeadEnabled = null, \ebay\StructType\ItemSpecificsEnabledDefinitionType $itemSpecificsEnabled = null, \ebay\StructType\PaisaPayFullEscrowEnabledDefinitionType $paisaPayFullEscrowEnabled = null, \ebay\StructType\ISBNIdentifierEnabledDefinitionType $iSBNIdentifierEnabled = null, \ebay\StructType\UPCIdentifierEnabledDefinitionType $uPCIdentifierEnabled = null, \ebay\StructType\EANIdentifierEnabledDefinitionType $eANIdentifierEnabled = null, \ebay\StructType\BrandMPNIdentifierEnabledDefinitionType $brandMPNIdentifierEnabled = null, \ebay\StructType\BestOfferAutoAcceptEnabledDefinitionType $bestOfferAutoAcceptEnabled = null, \ebay\StructType\ClassifiedAdAutoAcceptEnabledDefinitionType $classifiedAdAutoAcceptEnabled = null, \ebay\StructType\CrossBorderTradeNorthAmericaEnabledDefinitionType $crossBorderTradeNorthAmericaEnabled = null, \ebay\StructType\CrossBorderTradeGBEnabledDefinitionType $crossBorderTradeGBEnabled = null, \ebay\StructType\CrossBorderTradeAustraliaEnabledDefinitionType $crossBorderTradeAustraliaEnabled = null, \ebay\StructType\PayPalBuyerProtectionEnabledDefinitionType $payPalBuyerProtectionEnabled = null, \ebay\StructType\BuyerGuaranteeEnabledDefinitionType $buyerGuaranteeEnabled = null, \ebay\StructType\CombinedFixedPriceTreatmentEnabledDefinitionType $combinedFixedPriceTreatmentEnabled = null, \ebay\StructType\ListingEnhancementDurationDefinitionType $galleryFeaturedDurations = null, \ebay\StructType\INEscrowWorkflowTimelineDefinitionType $iNEscrowWorkflowTimeline = null, \ebay\StructType\PayPalRequiredDefinitionType $payPalRequired = null, \ebay\StructType\EBayMotorsProAdFormatEnabledDefinitionType $eBayMotorsProAdFormatEnabled = null, \ebay\StructType\EBayMotorsProContactByPhoneEnabledDefinitionType $eBayMotorsProContactByPhoneEnabled = null, \ebay\StructType\EBayMotorsProPhoneCountDefinitionType $eBayMotorsProPhoneCount = null, \ebay\StructType\EBayMotorsProContactByAddressEnabledDefinitionType $eBayMotorsProContactByAddressEnabled = null, \ebay\StructType\EBayMotorsProStreetCountDefinitionType $eBayMotorsProStreetCount = null, \ebay\StructType\EBayMotorsProCompanyNameEnabledDefinitionType $eBayMotorsProCompanyNameEnabled = null, \ebay\StructType\EBayMotorsProContactByEmailEnabledDefinitionType $eBayMotorsProContactByEmailEnabled = null, \ebay\StructType\EBayMotorsProBestOfferEnabledDefinitionType $eBayMotorsProBestOfferEnabled = null, \ebay\StructType\EBayMotorsProAutoAcceptEnabledDefinitionType $eBayMotorsProAutoAcceptEnabled = null, \ebay\StructType\EBayMotorsProAutoDeclineEnabledDefinitionType $eBayMotorsProAutoDeclineEnabled = null, \ebay\StructType\EBayMotorsProPaymentMethodCheckOutEnabledDefinitionType $eBayMotorsProPaymentMethodCheckOutEnabled = null, \ebay\StructType\EBayMotorsProShippingMethodEnabledDefinitionType $eBayMotorsProShippingMethodEnabled = null, \ebay\StructType\EBayMotorsProCounterOfferEnabledDefinitionType $eBayMotorsProCounterOfferEnabled = null, \ebay\StructType\EBayMotorsProSellerContactDetailsEnabledDefinitionType $eBayMotorsProSellerContactDetailsEnabled = null, \ebay\StructType\LocalMarketAdFormatEnabledDefinitionType $localMarketAdFormatEnabled = null, \ebay\StructType\LocalMarketContactByPhoneEnabledDefinitionType $localMarketContactByPhoneEnabled = null, \ebay\StructType\LocalMarketPhoneCountDefinitionType $localMarketPhoneCount = null, \ebay\StructType\LocalMarketContactByAddressEnabledDefinitionType $localMarketContactByAddressEnabled = null, \ebay\StructType\LocalMarketStreetCountDefinitionType $localMarketStreetCount = null, \ebay\StructType\LocalMarketCompanyNameEnabledDefinitionType $localMarketCompanyNameEnabled = null, \ebay\StructType\LocalMarketContactByEmailEnabledDefinitionType $localMarketContactByEmailEnabled = null, \ebay\StructType\LocalMarketBestOfferEnabledDefinitionType $localMarketBestOfferEnabled = null, \ebay\StructType\LocalMarketAutoAcceptEnabledDefinitionType $localMarketAutoAcceptEnabled = null, \ebay\StructType\LocalMarketAutoDeclineEnabledDefinitionType $localMarketAutoDeclineEnabled = null, \ebay\StructType\LocalMarketPaymentMethodCheckOutEnabledDefinitionType $localMarketPaymentMethodCheckOutEnabled = null, \ebay\StructType\LocalMarketShippingMethodEnabledDefinitionType $localMarketShippingMethodEnabled = null, \ebay\StructType\LocalMarketCounterOfferEnabledDefinitionType $localMarketCounterOfferEnabled = null, \ebay\StructType\LocalMarketSellerContactDetailsEnabledDefinitionType $localMarketSellerContactDetailsEnabled = null, \ebay\StructType\ClassifiedAdPhoneCountDefinitionType $classifiedAdPhoneCount = null, \ebay\StructType\ClassifiedAdContactByAddressEnabledDefinitionType $classifiedAdContactByAddressEnabled = null, \ebay\StructType\ClassifiedAdStreetCountDefinitionType $classifiedAdStreetCount = null, \ebay\StructType\ClassifiedAdCompanyNameEnabledDefinitionType $classifiedAdCompanyNameEnabled = null, \ebay\StructType\SpecialitySubscriptionDefinitionType $specialitySubscription = null, \ebay\StructType\RegularSubscriptionDefinitionType $regularSubscription = null, \ebay\StructType\PremiumSubscriptionDefinitionType $premiumSubscription = null, \ebay\StructType\NonSubscriptionDefinitionType $nonSubscription = null, \ebay\StructType\ReturnPolicyEnabledDefinitionType $returnPolicyEnabled = null, \ebay\StructType\HandlingTimeEnabledDefinitionType $handlingTimeEnabled = null, \ebay\StructType\PayPalRequiredForStoreOwnerDefinitionType $payPalRequiredForStoreOwner = null, \ebay\StructType\ReviseQuantityAllowedDefinitionType $reviseQuantityAllowed = null, \ebay\StructType\RevisePriceAllowedDefinitionType $revisePriceAllowed = null, \ebay\StructType\StoreOwnerExtendedListingDurationsEnabledDefinitionType $storeOwnerExtendedListingDurationsEnabled = null, \ebay\StructType\StoreOwnerExtendedListingDurationsDefinitionType $storeOwnerExtendedListingDurations = null, \ebay\StructType\PaymentMethodDefinitionType $paymentMethod = null, \ebay\StructType\Group1MaxFlatShippingCostDefinitionType $group1MaxFlatShippingCost = null, \ebay\StructType\Group2MaxFlatShippingCostDefinitionType $group2MaxFlatShippingCost = null, \ebay\StructType\Group3MaxFlatShippingCostDefinitionType $group3MaxFlatShippingCost = null, \ebay\StructType\MaxFlatShippingCostCBTExemptDefinitionType $maxFlatShippingCostCBTExempt = null, \ebay\StructType\MaxFlatShippingCostDefinitionType $maxFlatShippingCost = null, \ebay\StructType\VariationsEnabledDefinitionType $variationsEnabled = null, \ebay\StructType\AttributeConversionEnabledFeatureDefinitionType $attributeConversionEnabled = null, \ebay\StructType\FreeGalleryPlusEnabledDefinitionType $freeGalleryPlusEnabled = null, \ebay\StructType\FreePicturePackEnabledDefinitionType $freePicturePackEnabled = null, \ebay\StructType\ItemCompatibilityEnabledDefinitionType $itemCompatibilityEnabled = null, \ebay\StructType\MaxItemCompatibilityDefinitionType $maxItemCompatibility = null, \ebay\StructType\MinItemCompatibilityDefinitionType $minItemCompatibility = null, \ebay\StructType\ConditionEnabledDefinitionType $conditionEnabled = null, \ebay\StructType\ConditionValuesDefinitionType $conditionValues = null, \ebay\StructType\ValueCategoryDefinitionType $valueCategory = null, \ebay\StructType\ProductCreationEnabledDefinitionType $productCreationEnabled = null, \ebay\StructType\EANEnabledDefinitionType $eANEnabled = null, \ebay\StructType\ISBNEnabledDefinitionType $iSBNEnabled = null, \ebay\StructType\UPCEnabledDefinitionType $uPCEnabled = null, \ebay\StructType\CompatibleVehicleTypeDefinitionType $compatibleVehicleType = null, \ebay\StructType\MaxGranularFitmentCountDefinitionType $maxGranularFitmentCount = null, \ebay\StructType\PaymentOptionsGroupEnabledDefinitionType $paymentOptionsGroup = null, \ebay\StructType\ProfileCategoryGroupDefinitionType $shippingProfileCategoryGroup = null, \ebay\StructType\ProfileCategoryGroupDefinitionType $paymentProfileCategoryGroup = null, \ebay\StructType\ProfileCategoryGroupDefinitionType $returnPolicyProfileCategoryGroup = null, \ebay\StructType\VINSupportedDefinitionType $vINSupported = null, \ebay\StructType\VRMSupportedDefinitionType $vRMSupported = null, \ebay\StructType\SellerProvidedTitleSupportedDefinitionType $sellerProvidedTitleSupported = null, \ebay\StructType\DepositSupportedDefinitionType $depositSupported = null, \ebay\StructType\GlobalShippingEnabledDefinitionType $globalShippingEnabled = null, \ebay\StructType\AdditionalCompatibilityEnabledDefinitionType $additionalCompatibilityEnabled = null, \DOMDocument $any = null, \ebay\StructType\PickupDropOffEnabledDefinitionType $pickupDropOffEnabled = null, \ebay\StructType\DigitalGoodDeliveryEnabledDefinitionType $digitalGoodDeliveryEnabled = null, \ebay\StructType\EpidSupportedDefinitionType $epidSupported = null, \ebay\StructType\KTypeSupportedDefinitionType $kTypeSupported = null)
    {
        $this
            ->setListingDurations($listingDurations)
            ->setShippingTermsRequired($shippingTermsRequired)
            ->setBestOfferEnabled($bestOfferEnabled)
            ->setDutchBINEnabled($dutchBINEnabled)
            ->setUserConsentRequired($userConsentRequired)
            ->setHomePageFeaturedEnabled($homePageFeaturedEnabled)
            ->setProPackEnabled($proPackEnabled)
            ->setBasicUpgradePackEnabled($basicUpgradePackEnabled)
            ->setValuePackEnabled($valuePackEnabled)
            ->setProPackPlusEnabled($proPackPlusEnabled)
            ->setAdFormatEnabled($adFormatEnabled)
            ->setBestOfferCounterEnabled($bestOfferCounterEnabled)
            ->setBestOfferAutoDeclineEnabled($bestOfferAutoDeclineEnabled)
            ->setLocalMarketSpecialitySubscription($localMarketSpecialitySubscription)
            ->setLocalMarketRegularSubscription($localMarketRegularSubscription)
            ->setLocalMarketPremiumSubscription($localMarketPremiumSubscription)
            ->setLocalMarketNonSubscription($localMarketNonSubscription)
            ->setExpressEnabled($expressEnabled)
            ->setExpressPicturesRequired($expressPicturesRequired)
            ->setExpressConditionRequired($expressConditionRequired)
            ->setMinimumReservePrice($minimumReservePrice)
            ->setTransactionConfirmationRequestEnabled($transactionConfirmationRequestEnabled)
            ->setSellerContactDetailsEnabled($sellerContactDetailsEnabled)
            ->setStoreInventoryEnabled($storeInventoryEnabled)
            ->setSkypeMeTransactionalEnabled($skypeMeTransactionalEnabled)
            ->setSkypeMeNonTransactionalEnabled($skypeMeNonTransactionalEnabled)
            ->setLocalListingDistancesRegular($localListingDistancesRegular)
            ->setLocalListingDistancesSpecialty($localListingDistancesSpecialty)
            ->setLocalListingDistancesNonSubscription($localListingDistancesNonSubscription)
            ->setClassifiedAdPaymentMethodEnabled($classifiedAdPaymentMethodEnabled)
            ->setClassifiedAdShippingMethodEnabled($classifiedAdShippingMethodEnabled)
            ->setClassifiedAdBestOfferEnabled($classifiedAdBestOfferEnabled)
            ->setClassifiedAdCounterOfferEnabled($classifiedAdCounterOfferEnabled)
            ->setClassifiedAdAutoDeclineEnabled($classifiedAdAutoDeclineEnabled)
            ->setClassifiedAdContactByPhoneEnabled($classifiedAdContactByPhoneEnabled)
            ->setClassifiedAdContactByEmailEnabled($classifiedAdContactByEmailEnabled)
            ->setSafePaymentRequired($safePaymentRequired)
            ->setClassifiedAdPayPerLeadEnabled($classifiedAdPayPerLeadEnabled)
            ->setItemSpecificsEnabled($itemSpecificsEnabled)
            ->setPaisaPayFullEscrowEnabled($paisaPayFullEscrowEnabled)
            ->setISBNIdentifierEnabled($iSBNIdentifierEnabled)
            ->setUPCIdentifierEnabled($uPCIdentifierEnabled)
            ->setEANIdentifierEnabled($eANIdentifierEnabled)
            ->setBrandMPNIdentifierEnabled($brandMPNIdentifierEnabled)
            ->setBestOfferAutoAcceptEnabled($bestOfferAutoAcceptEnabled)
            ->setClassifiedAdAutoAcceptEnabled($classifiedAdAutoAcceptEnabled)
            ->setCrossBorderTradeNorthAmericaEnabled($crossBorderTradeNorthAmericaEnabled)
            ->setCrossBorderTradeGBEnabled($crossBorderTradeGBEnabled)
            ->setCrossBorderTradeAustraliaEnabled($crossBorderTradeAustraliaEnabled)
            ->setPayPalBuyerProtectionEnabled($payPalBuyerProtectionEnabled)
            ->setBuyerGuaranteeEnabled($buyerGuaranteeEnabled)
            ->setCombinedFixedPriceTreatmentEnabled($combinedFixedPriceTreatmentEnabled)
            ->setGalleryFeaturedDurations($galleryFeaturedDurations)
            ->setINEscrowWorkflowTimeline($iNEscrowWorkflowTimeline)
            ->setPayPalRequired($payPalRequired)
            ->setEBayMotorsProAdFormatEnabled($eBayMotorsProAdFormatEnabled)
            ->setEBayMotorsProContactByPhoneEnabled($eBayMotorsProContactByPhoneEnabled)
            ->setEBayMotorsProPhoneCount($eBayMotorsProPhoneCount)
            ->setEBayMotorsProContactByAddressEnabled($eBayMotorsProContactByAddressEnabled)
            ->setEBayMotorsProStreetCount($eBayMotorsProStreetCount)
            ->setEBayMotorsProCompanyNameEnabled($eBayMotorsProCompanyNameEnabled)
            ->setEBayMotorsProContactByEmailEnabled($eBayMotorsProContactByEmailEnabled)
            ->setEBayMotorsProBestOfferEnabled($eBayMotorsProBestOfferEnabled)
            ->setEBayMotorsProAutoAcceptEnabled($eBayMotorsProAutoAcceptEnabled)
            ->setEBayMotorsProAutoDeclineEnabled($eBayMotorsProAutoDeclineEnabled)
            ->setEBayMotorsProPaymentMethodCheckOutEnabled($eBayMotorsProPaymentMethodCheckOutEnabled)
            ->setEBayMotorsProShippingMethodEnabled($eBayMotorsProShippingMethodEnabled)
            ->setEBayMotorsProCounterOfferEnabled($eBayMotorsProCounterOfferEnabled)
            ->setEBayMotorsProSellerContactDetailsEnabled($eBayMotorsProSellerContactDetailsEnabled)
            ->setLocalMarketAdFormatEnabled($localMarketAdFormatEnabled)
            ->setLocalMarketContactByPhoneEnabled($localMarketContactByPhoneEnabled)
            ->setLocalMarketPhoneCount($localMarketPhoneCount)
            ->setLocalMarketContactByAddressEnabled($localMarketContactByAddressEnabled)
            ->setLocalMarketStreetCount($localMarketStreetCount)
            ->setLocalMarketCompanyNameEnabled($localMarketCompanyNameEnabled)
            ->setLocalMarketContactByEmailEnabled($localMarketContactByEmailEnabled)
            ->setLocalMarketBestOfferEnabled($localMarketBestOfferEnabled)
            ->setLocalMarketAutoAcceptEnabled($localMarketAutoAcceptEnabled)
            ->setLocalMarketAutoDeclineEnabled($localMarketAutoDeclineEnabled)
            ->setLocalMarketPaymentMethodCheckOutEnabled($localMarketPaymentMethodCheckOutEnabled)
            ->setLocalMarketShippingMethodEnabled($localMarketShippingMethodEnabled)
            ->setLocalMarketCounterOfferEnabled($localMarketCounterOfferEnabled)
            ->setLocalMarketSellerContactDetailsEnabled($localMarketSellerContactDetailsEnabled)
            ->setClassifiedAdPhoneCount($classifiedAdPhoneCount)
            ->setClassifiedAdContactByAddressEnabled($classifiedAdContactByAddressEnabled)
            ->setClassifiedAdStreetCount($classifiedAdStreetCount)
            ->setClassifiedAdCompanyNameEnabled($classifiedAdCompanyNameEnabled)
            ->setSpecialitySubscription($specialitySubscription)
            ->setRegularSubscription($regularSubscription)
            ->setPremiumSubscription($premiumSubscription)
            ->setNonSubscription($nonSubscription)
            ->setReturnPolicyEnabled($returnPolicyEnabled)
            ->setHandlingTimeEnabled($handlingTimeEnabled)
            ->setPayPalRequiredForStoreOwner($payPalRequiredForStoreOwner)
            ->setReviseQuantityAllowed($reviseQuantityAllowed)
            ->setRevisePriceAllowed($revisePriceAllowed)
            ->setStoreOwnerExtendedListingDurationsEnabled($storeOwnerExtendedListingDurationsEnabled)
            ->setStoreOwnerExtendedListingDurations($storeOwnerExtendedListingDurations)
            ->setPaymentMethod($paymentMethod)
            ->setGroup1MaxFlatShippingCost($group1MaxFlatShippingCost)
            ->setGroup2MaxFlatShippingCost($group2MaxFlatShippingCost)
            ->setGroup3MaxFlatShippingCost($group3MaxFlatShippingCost)
            ->setMaxFlatShippingCostCBTExempt($maxFlatShippingCostCBTExempt)
            ->setMaxFlatShippingCost($maxFlatShippingCost)
            ->setVariationsEnabled($variationsEnabled)
            ->setAttributeConversionEnabled($attributeConversionEnabled)
            ->setFreeGalleryPlusEnabled($freeGalleryPlusEnabled)
            ->setFreePicturePackEnabled($freePicturePackEnabled)
            ->setItemCompatibilityEnabled($itemCompatibilityEnabled)
            ->setMaxItemCompatibility($maxItemCompatibility)
            ->setMinItemCompatibility($minItemCompatibility)
            ->setConditionEnabled($conditionEnabled)
            ->setConditionValues($conditionValues)
            ->setValueCategory($valueCategory)
            ->setProductCreationEnabled($productCreationEnabled)
            ->setEANEnabled($eANEnabled)
            ->setISBNEnabled($iSBNEnabled)
            ->setUPCEnabled($uPCEnabled)
            ->setCompatibleVehicleType($compatibleVehicleType)
            ->setMaxGranularFitmentCount($maxGranularFitmentCount)
            ->setPaymentOptionsGroup($paymentOptionsGroup)
            ->setShippingProfileCategoryGroup($shippingProfileCategoryGroup)
            ->setPaymentProfileCategoryGroup($paymentProfileCategoryGroup)
            ->setReturnPolicyProfileCategoryGroup($returnPolicyProfileCategoryGroup)
            ->setVINSupported($vINSupported)
            ->setVRMSupported($vRMSupported)
            ->setSellerProvidedTitleSupported($sellerProvidedTitleSupported)
            ->setDepositSupported($depositSupported)
            ->setGlobalShippingEnabled($globalShippingEnabled)
            ->setAdditionalCompatibilityEnabled($additionalCompatibilityEnabled)
            ->setAny($any)
            ->setPickupDropOffEnabled($pickupDropOffEnabled)
            ->setDigitalGoodDeliveryEnabled($digitalGoodDeliveryEnabled)
            ->setEpidSupported($epidSupported)
            ->setKTypeSupported($kTypeSupported);
    }
    /**
     * Get ListingDurations value
     * @return \ebay\StructType\ListingDurationDefinitionsType|null
     */
    public function getListingDurations()
    {
        return $this->ListingDurations;
    }
    /**
     * Set ListingDurations value
     * @param \ebay\StructType\ListingDurationDefinitionsType $listingDurations
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setListingDurations(\ebay\StructType\ListingDurationDefinitionsType $listingDurations = null)
    {
        $this->ListingDurations = $listingDurations;
        return $this;
    }
    /**
     * Get ShippingTermsRequired value
     * @return \ebay\StructType\ShippingTermRequiredDefinitionType|null
     */
    public function getShippingTermsRequired()
    {
        return $this->ShippingTermsRequired;
    }
    /**
     * Set ShippingTermsRequired value
     * @param \ebay\StructType\ShippingTermRequiredDefinitionType $shippingTermsRequired
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setShippingTermsRequired(\ebay\StructType\ShippingTermRequiredDefinitionType $shippingTermsRequired = null)
    {
        $this->ShippingTermsRequired = $shippingTermsRequired;
        return $this;
    }
    /**
     * Get BestOfferEnabled value
     * @return \ebay\StructType\BestOfferEnabledDefinitionType|null
     */
    public function getBestOfferEnabled()
    {
        return $this->BestOfferEnabled;
    }
    /**
     * Set BestOfferEnabled value
     * @param \ebay\StructType\BestOfferEnabledDefinitionType $bestOfferEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setBestOfferEnabled(\ebay\StructType\BestOfferEnabledDefinitionType $bestOfferEnabled = null)
    {
        $this->BestOfferEnabled = $bestOfferEnabled;
        return $this;
    }
    /**
     * Get DutchBINEnabled value
     * @return \ebay\StructType\DutchBINEnabledDefinitionType|null
     */
    public function getDutchBINEnabled()
    {
        return $this->DutchBINEnabled;
    }
    /**
     * Set DutchBINEnabled value
     * @param \ebay\StructType\DutchBINEnabledDefinitionType $dutchBINEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setDutchBINEnabled(\ebay\StructType\DutchBINEnabledDefinitionType $dutchBINEnabled = null)
    {
        $this->DutchBINEnabled = $dutchBINEnabled;
        return $this;
    }
    /**
     * Get UserConsentRequired value
     * @return \ebay\StructType\UserConsentRequiredDefinitionType|null
     */
    public function getUserConsentRequired()
    {
        return $this->UserConsentRequired;
    }
    /**
     * Set UserConsentRequired value
     * @param \ebay\StructType\UserConsentRequiredDefinitionType $userConsentRequired
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setUserConsentRequired(\ebay\StructType\UserConsentRequiredDefinitionType $userConsentRequired = null)
    {
        $this->UserConsentRequired = $userConsentRequired;
        return $this;
    }
    /**
     * Get HomePageFeaturedEnabled value
     * @return \ebay\StructType\HomePageFeaturedEnabledDefinitionType|null
     */
    public function getHomePageFeaturedEnabled()
    {
        return $this->HomePageFeaturedEnabled;
    }
    /**
     * Set HomePageFeaturedEnabled value
     * @param \ebay\StructType\HomePageFeaturedEnabledDefinitionType $homePageFeaturedEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setHomePageFeaturedEnabled(\ebay\StructType\HomePageFeaturedEnabledDefinitionType $homePageFeaturedEnabled = null)
    {
        $this->HomePageFeaturedEnabled = $homePageFeaturedEnabled;
        return $this;
    }
    /**
     * Get ProPackEnabled value
     * @return \ebay\StructType\ProPackEnabledDefinitionType|null
     */
    public function getProPackEnabled()
    {
        return $this->ProPackEnabled;
    }
    /**
     * Set ProPackEnabled value
     * @param \ebay\StructType\ProPackEnabledDefinitionType $proPackEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setProPackEnabled(\ebay\StructType\ProPackEnabledDefinitionType $proPackEnabled = null)
    {
        $this->ProPackEnabled = $proPackEnabled;
        return $this;
    }
    /**
     * Get BasicUpgradePackEnabled value
     * @return \ebay\StructType\BasicUpgradePackEnabledDefinitionType|null
     */
    public function getBasicUpgradePackEnabled()
    {
        return $this->BasicUpgradePackEnabled;
    }
    /**
     * Set BasicUpgradePackEnabled value
     * @param \ebay\StructType\BasicUpgradePackEnabledDefinitionType $basicUpgradePackEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setBasicUpgradePackEnabled(\ebay\StructType\BasicUpgradePackEnabledDefinitionType $basicUpgradePackEnabled = null)
    {
        $this->BasicUpgradePackEnabled = $basicUpgradePackEnabled;
        return $this;
    }
    /**
     * Get ValuePackEnabled value
     * @return \ebay\StructType\ValuePackEnabledDefinitionType|null
     */
    public function getValuePackEnabled()
    {
        return $this->ValuePackEnabled;
    }
    /**
     * Set ValuePackEnabled value
     * @param \ebay\StructType\ValuePackEnabledDefinitionType $valuePackEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setValuePackEnabled(\ebay\StructType\ValuePackEnabledDefinitionType $valuePackEnabled = null)
    {
        $this->ValuePackEnabled = $valuePackEnabled;
        return $this;
    }
    /**
     * Get ProPackPlusEnabled value
     * @return \ebay\StructType\ProPackPlusEnabledDefinitionType|null
     */
    public function getProPackPlusEnabled()
    {
        return $this->ProPackPlusEnabled;
    }
    /**
     * Set ProPackPlusEnabled value
     * @param \ebay\StructType\ProPackPlusEnabledDefinitionType $proPackPlusEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setProPackPlusEnabled(\ebay\StructType\ProPackPlusEnabledDefinitionType $proPackPlusEnabled = null)
    {
        $this->ProPackPlusEnabled = $proPackPlusEnabled;
        return $this;
    }
    /**
     * Get AdFormatEnabled value
     * @return \ebay\StructType\AdFormatEnabledDefinitionType|null
     */
    public function getAdFormatEnabled()
    {
        return $this->AdFormatEnabled;
    }
    /**
     * Set AdFormatEnabled value
     * @param \ebay\StructType\AdFormatEnabledDefinitionType $adFormatEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setAdFormatEnabled(\ebay\StructType\AdFormatEnabledDefinitionType $adFormatEnabled = null)
    {
        $this->AdFormatEnabled = $adFormatEnabled;
        return $this;
    }
    /**
     * Get BestOfferCounterEnabled value
     * @return \ebay\StructType\BestOfferCounterEnabledDefinitionType|null
     */
    public function getBestOfferCounterEnabled()
    {
        return $this->BestOfferCounterEnabled;
    }
    /**
     * Set BestOfferCounterEnabled value
     * @param \ebay\StructType\BestOfferCounterEnabledDefinitionType $bestOfferCounterEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setBestOfferCounterEnabled(\ebay\StructType\BestOfferCounterEnabledDefinitionType $bestOfferCounterEnabled = null)
    {
        $this->BestOfferCounterEnabled = $bestOfferCounterEnabled;
        return $this;
    }
    /**
     * Get BestOfferAutoDeclineEnabled value
     * @return \ebay\StructType\BestOfferAutoDeclineEnabledDefinitionType|null
     */
    public function getBestOfferAutoDeclineEnabled()
    {
        return $this->BestOfferAutoDeclineEnabled;
    }
    /**
     * Set BestOfferAutoDeclineEnabled value
     * @param \ebay\StructType\BestOfferAutoDeclineEnabledDefinitionType $bestOfferAutoDeclineEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setBestOfferAutoDeclineEnabled(\ebay\StructType\BestOfferAutoDeclineEnabledDefinitionType $bestOfferAutoDeclineEnabled = null)
    {
        $this->BestOfferAutoDeclineEnabled = $bestOfferAutoDeclineEnabled;
        return $this;
    }
    /**
     * Get LocalMarketSpecialitySubscription value
     * @return \ebay\StructType\LocalMarketSpecialitySubscriptionDefinitionType|null
     */
    public function getLocalMarketSpecialitySubscription()
    {
        return $this->LocalMarketSpecialitySubscription;
    }
    /**
     * Set LocalMarketSpecialitySubscription value
     * @param \ebay\StructType\LocalMarketSpecialitySubscriptionDefinitionType $localMarketSpecialitySubscription
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketSpecialitySubscription(\ebay\StructType\LocalMarketSpecialitySubscriptionDefinitionType $localMarketSpecialitySubscription = null)
    {
        $this->LocalMarketSpecialitySubscription = $localMarketSpecialitySubscription;
        return $this;
    }
    /**
     * Get LocalMarketRegularSubscription value
     * @return \ebay\StructType\LocalMarketRegularSubscriptionDefinitionType|null
     */
    public function getLocalMarketRegularSubscription()
    {
        return $this->LocalMarketRegularSubscription;
    }
    /**
     * Set LocalMarketRegularSubscription value
     * @param \ebay\StructType\LocalMarketRegularSubscriptionDefinitionType $localMarketRegularSubscription
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketRegularSubscription(\ebay\StructType\LocalMarketRegularSubscriptionDefinitionType $localMarketRegularSubscription = null)
    {
        $this->LocalMarketRegularSubscription = $localMarketRegularSubscription;
        return $this;
    }
    /**
     * Get LocalMarketPremiumSubscription value
     * @return \ebay\StructType\LocalMarketPremiumSubscriptionDefinitionType|null
     */
    public function getLocalMarketPremiumSubscription()
    {
        return $this->LocalMarketPremiumSubscription;
    }
    /**
     * Set LocalMarketPremiumSubscription value
     * @param \ebay\StructType\LocalMarketPremiumSubscriptionDefinitionType $localMarketPremiumSubscription
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketPremiumSubscription(\ebay\StructType\LocalMarketPremiumSubscriptionDefinitionType $localMarketPremiumSubscription = null)
    {
        $this->LocalMarketPremiumSubscription = $localMarketPremiumSubscription;
        return $this;
    }
    /**
     * Get LocalMarketNonSubscription value
     * @return \ebay\StructType\LocalMarketNonSubscriptionDefinitionType|null
     */
    public function getLocalMarketNonSubscription()
    {
        return $this->LocalMarketNonSubscription;
    }
    /**
     * Set LocalMarketNonSubscription value
     * @param \ebay\StructType\LocalMarketNonSubscriptionDefinitionType $localMarketNonSubscription
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketNonSubscription(\ebay\StructType\LocalMarketNonSubscriptionDefinitionType $localMarketNonSubscription = null)
    {
        $this->LocalMarketNonSubscription = $localMarketNonSubscription;
        return $this;
    }
    /**
     * Get ExpressEnabled value
     * @return \ebay\StructType\ExpressEnabledDefinitionType|null
     */
    public function getExpressEnabled()
    {
        return $this->ExpressEnabled;
    }
    /**
     * Set ExpressEnabled value
     * @param \ebay\StructType\ExpressEnabledDefinitionType $expressEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setExpressEnabled(\ebay\StructType\ExpressEnabledDefinitionType $expressEnabled = null)
    {
        $this->ExpressEnabled = $expressEnabled;
        return $this;
    }
    /**
     * Get ExpressPicturesRequired value
     * @return \ebay\StructType\ExpressPicturesRequiredDefinitionType|null
     */
    public function getExpressPicturesRequired()
    {
        return $this->ExpressPicturesRequired;
    }
    /**
     * Set ExpressPicturesRequired value
     * @param \ebay\StructType\ExpressPicturesRequiredDefinitionType $expressPicturesRequired
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setExpressPicturesRequired(\ebay\StructType\ExpressPicturesRequiredDefinitionType $expressPicturesRequired = null)
    {
        $this->ExpressPicturesRequired = $expressPicturesRequired;
        return $this;
    }
    /**
     * Get ExpressConditionRequired value
     * @return \ebay\StructType\ExpressConditionRequiredDefinitionType|null
     */
    public function getExpressConditionRequired()
    {
        return $this->ExpressConditionRequired;
    }
    /**
     * Set ExpressConditionRequired value
     * @param \ebay\StructType\ExpressConditionRequiredDefinitionType $expressConditionRequired
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setExpressConditionRequired(\ebay\StructType\ExpressConditionRequiredDefinitionType $expressConditionRequired = null)
    {
        $this->ExpressConditionRequired = $expressConditionRequired;
        return $this;
    }
    /**
     * Get MinimumReservePrice value
     * @return \ebay\StructType\MinimumReservePriceDefinitionType|null
     */
    public function getMinimumReservePrice()
    {
        return $this->MinimumReservePrice;
    }
    /**
     * Set MinimumReservePrice value
     * @param \ebay\StructType\MinimumReservePriceDefinitionType $minimumReservePrice
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setMinimumReservePrice(\ebay\StructType\MinimumReservePriceDefinitionType $minimumReservePrice = null)
    {
        $this->MinimumReservePrice = $minimumReservePrice;
        return $this;
    }
    /**
     * Get TransactionConfirmationRequestEnabled value
     * @return \ebay\StructType\TCREnabledDefinitionType|null
     */
    public function getTransactionConfirmationRequestEnabled()
    {
        return $this->TransactionConfirmationRequestEnabled;
    }
    /**
     * Set TransactionConfirmationRequestEnabled value
     * @param \ebay\StructType\TCREnabledDefinitionType $transactionConfirmationRequestEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setTransactionConfirmationRequestEnabled(\ebay\StructType\TCREnabledDefinitionType $transactionConfirmationRequestEnabled = null)
    {
        $this->TransactionConfirmationRequestEnabled = $transactionConfirmationRequestEnabled;
        return $this;
    }
    /**
     * Get SellerContactDetailsEnabled value
     * @return \ebay\StructType\SellerContactDetailsEnabledDefinitionType|null
     */
    public function getSellerContactDetailsEnabled()
    {
        return $this->SellerContactDetailsEnabled;
    }
    /**
     * Set SellerContactDetailsEnabled value
     * @param \ebay\StructType\SellerContactDetailsEnabledDefinitionType $sellerContactDetailsEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setSellerContactDetailsEnabled(\ebay\StructType\SellerContactDetailsEnabledDefinitionType $sellerContactDetailsEnabled = null)
    {
        $this->SellerContactDetailsEnabled = $sellerContactDetailsEnabled;
        return $this;
    }
    /**
     * Get StoreInventoryEnabled value
     * @return \ebay\StructType\StoreInventoryEnabledDefinitionType|null
     */
    public function getStoreInventoryEnabled()
    {
        return $this->StoreInventoryEnabled;
    }
    /**
     * Set StoreInventoryEnabled value
     * @param \ebay\StructType\StoreInventoryEnabledDefinitionType $storeInventoryEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setStoreInventoryEnabled(\ebay\StructType\StoreInventoryEnabledDefinitionType $storeInventoryEnabled = null)
    {
        $this->StoreInventoryEnabled = $storeInventoryEnabled;
        return $this;
    }
    /**
     * Get SkypeMeTransactionalEnabled value
     * @return \ebay\StructType\SkypeMeTransactionalEnabledDefinitionType|null
     */
    public function getSkypeMeTransactionalEnabled()
    {
        return $this->SkypeMeTransactionalEnabled;
    }
    /**
     * Set SkypeMeTransactionalEnabled value
     * @param \ebay\StructType\SkypeMeTransactionalEnabledDefinitionType $skypeMeTransactionalEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setSkypeMeTransactionalEnabled(\ebay\StructType\SkypeMeTransactionalEnabledDefinitionType $skypeMeTransactionalEnabled = null)
    {
        $this->SkypeMeTransactionalEnabled = $skypeMeTransactionalEnabled;
        return $this;
    }
    /**
     * Get SkypeMeNonTransactionalEnabled value
     * @return \ebay\StructType\SkypeMeNonTransactionalEnabledDefinitionType|null
     */
    public function getSkypeMeNonTransactionalEnabled()
    {
        return $this->SkypeMeNonTransactionalEnabled;
    }
    /**
     * Set SkypeMeNonTransactionalEnabled value
     * @param \ebay\StructType\SkypeMeNonTransactionalEnabledDefinitionType $skypeMeNonTransactionalEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setSkypeMeNonTransactionalEnabled(\ebay\StructType\SkypeMeNonTransactionalEnabledDefinitionType $skypeMeNonTransactionalEnabled = null)
    {
        $this->SkypeMeNonTransactionalEnabled = $skypeMeNonTransactionalEnabled;
        return $this;
    }
    /**
     * Get LocalListingDistancesRegular value
     * @return \ebay\StructType\LocalListingDistancesRegularDefinitionType|null
     */
    public function getLocalListingDistancesRegular()
    {
        return $this->LocalListingDistancesRegular;
    }
    /**
     * Set LocalListingDistancesRegular value
     * @param \ebay\StructType\LocalListingDistancesRegularDefinitionType $localListingDistancesRegular
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalListingDistancesRegular(\ebay\StructType\LocalListingDistancesRegularDefinitionType $localListingDistancesRegular = null)
    {
        $this->LocalListingDistancesRegular = $localListingDistancesRegular;
        return $this;
    }
    /**
     * Get LocalListingDistancesSpecialty value
     * @return \ebay\StructType\LocalListingDistancesSpecialtyDefinitionType|null
     */
    public function getLocalListingDistancesSpecialty()
    {
        return $this->LocalListingDistancesSpecialty;
    }
    /**
     * Set LocalListingDistancesSpecialty value
     * @param \ebay\StructType\LocalListingDistancesSpecialtyDefinitionType $localListingDistancesSpecialty
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalListingDistancesSpecialty(\ebay\StructType\LocalListingDistancesSpecialtyDefinitionType $localListingDistancesSpecialty = null)
    {
        $this->LocalListingDistancesSpecialty = $localListingDistancesSpecialty;
        return $this;
    }
    /**
     * Get LocalListingDistancesNonSubscription value
     * @return \ebay\StructType\LocalListingDistancesNonSubscriptionDefinitionType|null
     */
    public function getLocalListingDistancesNonSubscription()
    {
        return $this->LocalListingDistancesNonSubscription;
    }
    /**
     * Set LocalListingDistancesNonSubscription value
     * @param \ebay\StructType\LocalListingDistancesNonSubscriptionDefinitionType $localListingDistancesNonSubscription
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalListingDistancesNonSubscription(\ebay\StructType\LocalListingDistancesNonSubscriptionDefinitionType $localListingDistancesNonSubscription = null)
    {
        $this->LocalListingDistancesNonSubscription = $localListingDistancesNonSubscription;
        return $this;
    }
    /**
     * Get ClassifiedAdPaymentMethodEnabled value
     * @return \ebay\StructType\ClassifiedAdPaymentMethodEnabledDefinitionType|null
     */
    public function getClassifiedAdPaymentMethodEnabled()
    {
        return $this->ClassifiedAdPaymentMethodEnabled;
    }
    /**
     * Set ClassifiedAdPaymentMethodEnabled value
     * @param \ebay\StructType\ClassifiedAdPaymentMethodEnabledDefinitionType $classifiedAdPaymentMethodEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdPaymentMethodEnabled(\ebay\StructType\ClassifiedAdPaymentMethodEnabledDefinitionType $classifiedAdPaymentMethodEnabled = null)
    {
        $this->ClassifiedAdPaymentMethodEnabled = $classifiedAdPaymentMethodEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdShippingMethodEnabled value
     * @return \ebay\StructType\ClassifiedAdShippingMethodEnabledDefinitionType|null
     */
    public function getClassifiedAdShippingMethodEnabled()
    {
        return $this->ClassifiedAdShippingMethodEnabled;
    }
    /**
     * Set ClassifiedAdShippingMethodEnabled value
     * @param \ebay\StructType\ClassifiedAdShippingMethodEnabledDefinitionType $classifiedAdShippingMethodEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdShippingMethodEnabled(\ebay\StructType\ClassifiedAdShippingMethodEnabledDefinitionType $classifiedAdShippingMethodEnabled = null)
    {
        $this->ClassifiedAdShippingMethodEnabled = $classifiedAdShippingMethodEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdBestOfferEnabled value
     * @return \ebay\StructType\ClassifiedAdBestOfferEnabledDefinitionType|null
     */
    public function getClassifiedAdBestOfferEnabled()
    {
        return $this->ClassifiedAdBestOfferEnabled;
    }
    /**
     * Set ClassifiedAdBestOfferEnabled value
     * @param \ebay\StructType\ClassifiedAdBestOfferEnabledDefinitionType $classifiedAdBestOfferEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdBestOfferEnabled(\ebay\StructType\ClassifiedAdBestOfferEnabledDefinitionType $classifiedAdBestOfferEnabled = null)
    {
        $this->ClassifiedAdBestOfferEnabled = $classifiedAdBestOfferEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdCounterOfferEnabled value
     * @return \ebay\StructType\ClassifiedAdCounterOfferEnabledDefinitionType|null
     */
    public function getClassifiedAdCounterOfferEnabled()
    {
        return $this->ClassifiedAdCounterOfferEnabled;
    }
    /**
     * Set ClassifiedAdCounterOfferEnabled value
     * @param \ebay\StructType\ClassifiedAdCounterOfferEnabledDefinitionType $classifiedAdCounterOfferEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdCounterOfferEnabled(\ebay\StructType\ClassifiedAdCounterOfferEnabledDefinitionType $classifiedAdCounterOfferEnabled = null)
    {
        $this->ClassifiedAdCounterOfferEnabled = $classifiedAdCounterOfferEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdAutoDeclineEnabled value
     * @return \ebay\StructType\ClassifiedAdAutoDeclineEnabledDefinitionType|null
     */
    public function getClassifiedAdAutoDeclineEnabled()
    {
        return $this->ClassifiedAdAutoDeclineEnabled;
    }
    /**
     * Set ClassifiedAdAutoDeclineEnabled value
     * @param \ebay\StructType\ClassifiedAdAutoDeclineEnabledDefinitionType $classifiedAdAutoDeclineEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdAutoDeclineEnabled(\ebay\StructType\ClassifiedAdAutoDeclineEnabledDefinitionType $classifiedAdAutoDeclineEnabled = null)
    {
        $this->ClassifiedAdAutoDeclineEnabled = $classifiedAdAutoDeclineEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdContactByPhoneEnabled value
     * @return \ebay\StructType\ClassifiedAdContactByPhoneEnabledDefinitionType|null
     */
    public function getClassifiedAdContactByPhoneEnabled()
    {
        return $this->ClassifiedAdContactByPhoneEnabled;
    }
    /**
     * Set ClassifiedAdContactByPhoneEnabled value
     * @param \ebay\StructType\ClassifiedAdContactByPhoneEnabledDefinitionType $classifiedAdContactByPhoneEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdContactByPhoneEnabled(\ebay\StructType\ClassifiedAdContactByPhoneEnabledDefinitionType $classifiedAdContactByPhoneEnabled = null)
    {
        $this->ClassifiedAdContactByPhoneEnabled = $classifiedAdContactByPhoneEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdContactByEmailEnabled value
     * @return \ebay\StructType\ClassifiedAdContactByEmailEnabledDefintionType|null
     */
    public function getClassifiedAdContactByEmailEnabled()
    {
        return $this->ClassifiedAdContactByEmailEnabled;
    }
    /**
     * Set ClassifiedAdContactByEmailEnabled value
     * @param \ebay\StructType\ClassifiedAdContactByEmailEnabledDefintionType $classifiedAdContactByEmailEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdContactByEmailEnabled(\ebay\StructType\ClassifiedAdContactByEmailEnabledDefintionType $classifiedAdContactByEmailEnabled = null)
    {
        $this->ClassifiedAdContactByEmailEnabled = $classifiedAdContactByEmailEnabled;
        return $this;
    }
    /**
     * Get SafePaymentRequired value
     * @return \ebay\StructType\SafePaymentRequiredDefinitionType|null
     */
    public function getSafePaymentRequired()
    {
        return $this->SafePaymentRequired;
    }
    /**
     * Set SafePaymentRequired value
     * @param \ebay\StructType\SafePaymentRequiredDefinitionType $safePaymentRequired
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setSafePaymentRequired(\ebay\StructType\SafePaymentRequiredDefinitionType $safePaymentRequired = null)
    {
        $this->SafePaymentRequired = $safePaymentRequired;
        return $this;
    }
    /**
     * Get ClassifiedAdPayPerLeadEnabled value
     * @return \ebay\StructType\ClassifiedAdPayPerLeadEnabledDefinitionType|null
     */
    public function getClassifiedAdPayPerLeadEnabled()
    {
        return $this->ClassifiedAdPayPerLeadEnabled;
    }
    /**
     * Set ClassifiedAdPayPerLeadEnabled value
     * @param \ebay\StructType\ClassifiedAdPayPerLeadEnabledDefinitionType $classifiedAdPayPerLeadEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdPayPerLeadEnabled(\ebay\StructType\ClassifiedAdPayPerLeadEnabledDefinitionType $classifiedAdPayPerLeadEnabled = null)
    {
        $this->ClassifiedAdPayPerLeadEnabled = $classifiedAdPayPerLeadEnabled;
        return $this;
    }
    /**
     * Get ItemSpecificsEnabled value
     * @return \ebay\StructType\ItemSpecificsEnabledDefinitionType|null
     */
    public function getItemSpecificsEnabled()
    {
        return $this->ItemSpecificsEnabled;
    }
    /**
     * Set ItemSpecificsEnabled value
     * @param \ebay\StructType\ItemSpecificsEnabledDefinitionType $itemSpecificsEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setItemSpecificsEnabled(\ebay\StructType\ItemSpecificsEnabledDefinitionType $itemSpecificsEnabled = null)
    {
        $this->ItemSpecificsEnabled = $itemSpecificsEnabled;
        return $this;
    }
    /**
     * Get PaisaPayFullEscrowEnabled value
     * @return \ebay\StructType\PaisaPayFullEscrowEnabledDefinitionType|null
     */
    public function getPaisaPayFullEscrowEnabled()
    {
        return $this->PaisaPayFullEscrowEnabled;
    }
    /**
     * Set PaisaPayFullEscrowEnabled value
     * @param \ebay\StructType\PaisaPayFullEscrowEnabledDefinitionType $paisaPayFullEscrowEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setPaisaPayFullEscrowEnabled(\ebay\StructType\PaisaPayFullEscrowEnabledDefinitionType $paisaPayFullEscrowEnabled = null)
    {
        $this->PaisaPayFullEscrowEnabled = $paisaPayFullEscrowEnabled;
        return $this;
    }
    /**
     * Get ISBNIdentifierEnabled value
     * @return \ebay\StructType\ISBNIdentifierEnabledDefinitionType|null
     */
    public function getISBNIdentifierEnabled()
    {
        return $this->ISBNIdentifierEnabled;
    }
    /**
     * Set ISBNIdentifierEnabled value
     * @param \ebay\StructType\ISBNIdentifierEnabledDefinitionType $iSBNIdentifierEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setISBNIdentifierEnabled(\ebay\StructType\ISBNIdentifierEnabledDefinitionType $iSBNIdentifierEnabled = null)
    {
        $this->ISBNIdentifierEnabled = $iSBNIdentifierEnabled;
        return $this;
    }
    /**
     * Get UPCIdentifierEnabled value
     * @return \ebay\StructType\UPCIdentifierEnabledDefinitionType|null
     */
    public function getUPCIdentifierEnabled()
    {
        return $this->UPCIdentifierEnabled;
    }
    /**
     * Set UPCIdentifierEnabled value
     * @param \ebay\StructType\UPCIdentifierEnabledDefinitionType $uPCIdentifierEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setUPCIdentifierEnabled(\ebay\StructType\UPCIdentifierEnabledDefinitionType $uPCIdentifierEnabled = null)
    {
        $this->UPCIdentifierEnabled = $uPCIdentifierEnabled;
        return $this;
    }
    /**
     * Get EANIdentifierEnabled value
     * @return \ebay\StructType\EANIdentifierEnabledDefinitionType|null
     */
    public function getEANIdentifierEnabled()
    {
        return $this->EANIdentifierEnabled;
    }
    /**
     * Set EANIdentifierEnabled value
     * @param \ebay\StructType\EANIdentifierEnabledDefinitionType $eANIdentifierEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEANIdentifierEnabled(\ebay\StructType\EANIdentifierEnabledDefinitionType $eANIdentifierEnabled = null)
    {
        $this->EANIdentifierEnabled = $eANIdentifierEnabled;
        return $this;
    }
    /**
     * Get BrandMPNIdentifierEnabled value
     * @return \ebay\StructType\BrandMPNIdentifierEnabledDefinitionType|null
     */
    public function getBrandMPNIdentifierEnabled()
    {
        return $this->BrandMPNIdentifierEnabled;
    }
    /**
     * Set BrandMPNIdentifierEnabled value
     * @param \ebay\StructType\BrandMPNIdentifierEnabledDefinitionType $brandMPNIdentifierEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setBrandMPNIdentifierEnabled(\ebay\StructType\BrandMPNIdentifierEnabledDefinitionType $brandMPNIdentifierEnabled = null)
    {
        $this->BrandMPNIdentifierEnabled = $brandMPNIdentifierEnabled;
        return $this;
    }
    /**
     * Get BestOfferAutoAcceptEnabled value
     * @return \ebay\StructType\BestOfferAutoAcceptEnabledDefinitionType|null
     */
    public function getBestOfferAutoAcceptEnabled()
    {
        return $this->BestOfferAutoAcceptEnabled;
    }
    /**
     * Set BestOfferAutoAcceptEnabled value
     * @param \ebay\StructType\BestOfferAutoAcceptEnabledDefinitionType $bestOfferAutoAcceptEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setBestOfferAutoAcceptEnabled(\ebay\StructType\BestOfferAutoAcceptEnabledDefinitionType $bestOfferAutoAcceptEnabled = null)
    {
        $this->BestOfferAutoAcceptEnabled = $bestOfferAutoAcceptEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdAutoAcceptEnabled value
     * @return \ebay\StructType\ClassifiedAdAutoAcceptEnabledDefinitionType|null
     */
    public function getClassifiedAdAutoAcceptEnabled()
    {
        return $this->ClassifiedAdAutoAcceptEnabled;
    }
    /**
     * Set ClassifiedAdAutoAcceptEnabled value
     * @param \ebay\StructType\ClassifiedAdAutoAcceptEnabledDefinitionType $classifiedAdAutoAcceptEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdAutoAcceptEnabled(\ebay\StructType\ClassifiedAdAutoAcceptEnabledDefinitionType $classifiedAdAutoAcceptEnabled = null)
    {
        $this->ClassifiedAdAutoAcceptEnabled = $classifiedAdAutoAcceptEnabled;
        return $this;
    }
    /**
     * Get CrossBorderTradeNorthAmericaEnabled value
     * @return \ebay\StructType\CrossBorderTradeNorthAmericaEnabledDefinitionType|null
     */
    public function getCrossBorderTradeNorthAmericaEnabled()
    {
        return $this->CrossBorderTradeNorthAmericaEnabled;
    }
    /**
     * Set CrossBorderTradeNorthAmericaEnabled value
     * @param \ebay\StructType\CrossBorderTradeNorthAmericaEnabledDefinitionType $crossBorderTradeNorthAmericaEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setCrossBorderTradeNorthAmericaEnabled(\ebay\StructType\CrossBorderTradeNorthAmericaEnabledDefinitionType $crossBorderTradeNorthAmericaEnabled = null)
    {
        $this->CrossBorderTradeNorthAmericaEnabled = $crossBorderTradeNorthAmericaEnabled;
        return $this;
    }
    /**
     * Get CrossBorderTradeGBEnabled value
     * @return \ebay\StructType\CrossBorderTradeGBEnabledDefinitionType|null
     */
    public function getCrossBorderTradeGBEnabled()
    {
        return $this->CrossBorderTradeGBEnabled;
    }
    /**
     * Set CrossBorderTradeGBEnabled value
     * @param \ebay\StructType\CrossBorderTradeGBEnabledDefinitionType $crossBorderTradeGBEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setCrossBorderTradeGBEnabled(\ebay\StructType\CrossBorderTradeGBEnabledDefinitionType $crossBorderTradeGBEnabled = null)
    {
        $this->CrossBorderTradeGBEnabled = $crossBorderTradeGBEnabled;
        return $this;
    }
    /**
     * Get CrossBorderTradeAustraliaEnabled value
     * @return \ebay\StructType\CrossBorderTradeAustraliaEnabledDefinitionType|null
     */
    public function getCrossBorderTradeAustraliaEnabled()
    {
        return $this->CrossBorderTradeAustraliaEnabled;
    }
    /**
     * Set CrossBorderTradeAustraliaEnabled value
     * @param \ebay\StructType\CrossBorderTradeAustraliaEnabledDefinitionType $crossBorderTradeAustraliaEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setCrossBorderTradeAustraliaEnabled(\ebay\StructType\CrossBorderTradeAustraliaEnabledDefinitionType $crossBorderTradeAustraliaEnabled = null)
    {
        $this->CrossBorderTradeAustraliaEnabled = $crossBorderTradeAustraliaEnabled;
        return $this;
    }
    /**
     * Get PayPalBuyerProtectionEnabled value
     * @return \ebay\StructType\PayPalBuyerProtectionEnabledDefinitionType|null
     */
    public function getPayPalBuyerProtectionEnabled()
    {
        return $this->PayPalBuyerProtectionEnabled;
    }
    /**
     * Set PayPalBuyerProtectionEnabled value
     * @param \ebay\StructType\PayPalBuyerProtectionEnabledDefinitionType $payPalBuyerProtectionEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setPayPalBuyerProtectionEnabled(\ebay\StructType\PayPalBuyerProtectionEnabledDefinitionType $payPalBuyerProtectionEnabled = null)
    {
        $this->PayPalBuyerProtectionEnabled = $payPalBuyerProtectionEnabled;
        return $this;
    }
    /**
     * Get BuyerGuaranteeEnabled value
     * @return \ebay\StructType\BuyerGuaranteeEnabledDefinitionType|null
     */
    public function getBuyerGuaranteeEnabled()
    {
        return $this->BuyerGuaranteeEnabled;
    }
    /**
     * Set BuyerGuaranteeEnabled value
     * @param \ebay\StructType\BuyerGuaranteeEnabledDefinitionType $buyerGuaranteeEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setBuyerGuaranteeEnabled(\ebay\StructType\BuyerGuaranteeEnabledDefinitionType $buyerGuaranteeEnabled = null)
    {
        $this->BuyerGuaranteeEnabled = $buyerGuaranteeEnabled;
        return $this;
    }
    /**
     * Get CombinedFixedPriceTreatmentEnabled value
     * @return \ebay\StructType\CombinedFixedPriceTreatmentEnabledDefinitionType|null
     */
    public function getCombinedFixedPriceTreatmentEnabled()
    {
        return $this->CombinedFixedPriceTreatmentEnabled;
    }
    /**
     * Set CombinedFixedPriceTreatmentEnabled value
     * @param \ebay\StructType\CombinedFixedPriceTreatmentEnabledDefinitionType $combinedFixedPriceTreatmentEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setCombinedFixedPriceTreatmentEnabled(\ebay\StructType\CombinedFixedPriceTreatmentEnabledDefinitionType $combinedFixedPriceTreatmentEnabled = null)
    {
        $this->CombinedFixedPriceTreatmentEnabled = $combinedFixedPriceTreatmentEnabled;
        return $this;
    }
    /**
     * Get GalleryFeaturedDurations value
     * @return \ebay\StructType\ListingEnhancementDurationDefinitionType|null
     */
    public function getGalleryFeaturedDurations()
    {
        return $this->GalleryFeaturedDurations;
    }
    /**
     * Set GalleryFeaturedDurations value
     * @param \ebay\StructType\ListingEnhancementDurationDefinitionType $galleryFeaturedDurations
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setGalleryFeaturedDurations(\ebay\StructType\ListingEnhancementDurationDefinitionType $galleryFeaturedDurations = null)
    {
        $this->GalleryFeaturedDurations = $galleryFeaturedDurations;
        return $this;
    }
    /**
     * Get INEscrowWorkflowTimeline value
     * @return \ebay\StructType\INEscrowWorkflowTimelineDefinitionType|null
     */
    public function getINEscrowWorkflowTimeline()
    {
        return $this->INEscrowWorkflowTimeline;
    }
    /**
     * Set INEscrowWorkflowTimeline value
     * @param \ebay\StructType\INEscrowWorkflowTimelineDefinitionType $iNEscrowWorkflowTimeline
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setINEscrowWorkflowTimeline(\ebay\StructType\INEscrowWorkflowTimelineDefinitionType $iNEscrowWorkflowTimeline = null)
    {
        $this->INEscrowWorkflowTimeline = $iNEscrowWorkflowTimeline;
        return $this;
    }
    /**
     * Get PayPalRequired value
     * @return \ebay\StructType\PayPalRequiredDefinitionType|null
     */
    public function getPayPalRequired()
    {
        return $this->PayPalRequired;
    }
    /**
     * Set PayPalRequired value
     * @param \ebay\StructType\PayPalRequiredDefinitionType $payPalRequired
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setPayPalRequired(\ebay\StructType\PayPalRequiredDefinitionType $payPalRequired = null)
    {
        $this->PayPalRequired = $payPalRequired;
        return $this;
    }
    /**
     * Get eBayMotorsProAdFormatEnabled value
     * @return \ebay\StructType\EBayMotorsProAdFormatEnabledDefinitionType|null
     */
    public function getEBayMotorsProAdFormatEnabled()
    {
        return $this->eBayMotorsProAdFormatEnabled;
    }
    /**
     * Set eBayMotorsProAdFormatEnabled value
     * @param \ebay\StructType\EBayMotorsProAdFormatEnabledDefinitionType $eBayMotorsProAdFormatEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProAdFormatEnabled(\ebay\StructType\EBayMotorsProAdFormatEnabledDefinitionType $eBayMotorsProAdFormatEnabled = null)
    {
        $this->eBayMotorsProAdFormatEnabled = $eBayMotorsProAdFormatEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProContactByPhoneEnabled value
     * @return \ebay\StructType\EBayMotorsProContactByPhoneEnabledDefinitionType|null
     */
    public function getEBayMotorsProContactByPhoneEnabled()
    {
        return $this->eBayMotorsProContactByPhoneEnabled;
    }
    /**
     * Set eBayMotorsProContactByPhoneEnabled value
     * @param \ebay\StructType\EBayMotorsProContactByPhoneEnabledDefinitionType $eBayMotorsProContactByPhoneEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProContactByPhoneEnabled(\ebay\StructType\EBayMotorsProContactByPhoneEnabledDefinitionType $eBayMotorsProContactByPhoneEnabled = null)
    {
        $this->eBayMotorsProContactByPhoneEnabled = $eBayMotorsProContactByPhoneEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProPhoneCount value
     * @return \ebay\StructType\EBayMotorsProPhoneCountDefinitionType|null
     */
    public function getEBayMotorsProPhoneCount()
    {
        return $this->eBayMotorsProPhoneCount;
    }
    /**
     * Set eBayMotorsProPhoneCount value
     * @param \ebay\StructType\EBayMotorsProPhoneCountDefinitionType $eBayMotorsProPhoneCount
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProPhoneCount(\ebay\StructType\EBayMotorsProPhoneCountDefinitionType $eBayMotorsProPhoneCount = null)
    {
        $this->eBayMotorsProPhoneCount = $eBayMotorsProPhoneCount;
        return $this;
    }
    /**
     * Get eBayMotorsProContactByAddressEnabled value
     * @return \ebay\StructType\EBayMotorsProContactByAddressEnabledDefinitionType|null
     */
    public function getEBayMotorsProContactByAddressEnabled()
    {
        return $this->eBayMotorsProContactByAddressEnabled;
    }
    /**
     * Set eBayMotorsProContactByAddressEnabled value
     * @param \ebay\StructType\EBayMotorsProContactByAddressEnabledDefinitionType $eBayMotorsProContactByAddressEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProContactByAddressEnabled(\ebay\StructType\EBayMotorsProContactByAddressEnabledDefinitionType $eBayMotorsProContactByAddressEnabled = null)
    {
        $this->eBayMotorsProContactByAddressEnabled = $eBayMotorsProContactByAddressEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProStreetCount value
     * @return \ebay\StructType\EBayMotorsProStreetCountDefinitionType|null
     */
    public function getEBayMotorsProStreetCount()
    {
        return $this->eBayMotorsProStreetCount;
    }
    /**
     * Set eBayMotorsProStreetCount value
     * @param \ebay\StructType\EBayMotorsProStreetCountDefinitionType $eBayMotorsProStreetCount
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProStreetCount(\ebay\StructType\EBayMotorsProStreetCountDefinitionType $eBayMotorsProStreetCount = null)
    {
        $this->eBayMotorsProStreetCount = $eBayMotorsProStreetCount;
        return $this;
    }
    /**
     * Get eBayMotorsProCompanyNameEnabled value
     * @return \ebay\StructType\EBayMotorsProCompanyNameEnabledDefinitionType|null
     */
    public function getEBayMotorsProCompanyNameEnabled()
    {
        return $this->eBayMotorsProCompanyNameEnabled;
    }
    /**
     * Set eBayMotorsProCompanyNameEnabled value
     * @param \ebay\StructType\EBayMotorsProCompanyNameEnabledDefinitionType $eBayMotorsProCompanyNameEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProCompanyNameEnabled(\ebay\StructType\EBayMotorsProCompanyNameEnabledDefinitionType $eBayMotorsProCompanyNameEnabled = null)
    {
        $this->eBayMotorsProCompanyNameEnabled = $eBayMotorsProCompanyNameEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProContactByEmailEnabled value
     * @return \ebay\StructType\EBayMotorsProContactByEmailEnabledDefinitionType|null
     */
    public function getEBayMotorsProContactByEmailEnabled()
    {
        return $this->eBayMotorsProContactByEmailEnabled;
    }
    /**
     * Set eBayMotorsProContactByEmailEnabled value
     * @param \ebay\StructType\EBayMotorsProContactByEmailEnabledDefinitionType $eBayMotorsProContactByEmailEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProContactByEmailEnabled(\ebay\StructType\EBayMotorsProContactByEmailEnabledDefinitionType $eBayMotorsProContactByEmailEnabled = null)
    {
        $this->eBayMotorsProContactByEmailEnabled = $eBayMotorsProContactByEmailEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProBestOfferEnabled value
     * @return \ebay\StructType\EBayMotorsProBestOfferEnabledDefinitionType|null
     */
    public function getEBayMotorsProBestOfferEnabled()
    {
        return $this->eBayMotorsProBestOfferEnabled;
    }
    /**
     * Set eBayMotorsProBestOfferEnabled value
     * @param \ebay\StructType\EBayMotorsProBestOfferEnabledDefinitionType $eBayMotorsProBestOfferEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProBestOfferEnabled(\ebay\StructType\EBayMotorsProBestOfferEnabledDefinitionType $eBayMotorsProBestOfferEnabled = null)
    {
        $this->eBayMotorsProBestOfferEnabled = $eBayMotorsProBestOfferEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProAutoAcceptEnabled value
     * @return \ebay\StructType\EBayMotorsProAutoAcceptEnabledDefinitionType|null
     */
    public function getEBayMotorsProAutoAcceptEnabled()
    {
        return $this->eBayMotorsProAutoAcceptEnabled;
    }
    /**
     * Set eBayMotorsProAutoAcceptEnabled value
     * @param \ebay\StructType\EBayMotorsProAutoAcceptEnabledDefinitionType $eBayMotorsProAutoAcceptEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProAutoAcceptEnabled(\ebay\StructType\EBayMotorsProAutoAcceptEnabledDefinitionType $eBayMotorsProAutoAcceptEnabled = null)
    {
        $this->eBayMotorsProAutoAcceptEnabled = $eBayMotorsProAutoAcceptEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProAutoDeclineEnabled value
     * @return \ebay\StructType\EBayMotorsProAutoDeclineEnabledDefinitionType|null
     */
    public function getEBayMotorsProAutoDeclineEnabled()
    {
        return $this->eBayMotorsProAutoDeclineEnabled;
    }
    /**
     * Set eBayMotorsProAutoDeclineEnabled value
     * @param \ebay\StructType\EBayMotorsProAutoDeclineEnabledDefinitionType $eBayMotorsProAutoDeclineEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProAutoDeclineEnabled(\ebay\StructType\EBayMotorsProAutoDeclineEnabledDefinitionType $eBayMotorsProAutoDeclineEnabled = null)
    {
        $this->eBayMotorsProAutoDeclineEnabled = $eBayMotorsProAutoDeclineEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProPaymentMethodCheckOutEnabled value
     * @return \ebay\StructType\EBayMotorsProPaymentMethodCheckOutEnabledDefinitionType|null
     */
    public function getEBayMotorsProPaymentMethodCheckOutEnabled()
    {
        return $this->eBayMotorsProPaymentMethodCheckOutEnabled;
    }
    /**
     * Set eBayMotorsProPaymentMethodCheckOutEnabled value
     * @param \ebay\StructType\EBayMotorsProPaymentMethodCheckOutEnabledDefinitionType $eBayMotorsProPaymentMethodCheckOutEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProPaymentMethodCheckOutEnabled(\ebay\StructType\EBayMotorsProPaymentMethodCheckOutEnabledDefinitionType $eBayMotorsProPaymentMethodCheckOutEnabled = null)
    {
        $this->eBayMotorsProPaymentMethodCheckOutEnabled = $eBayMotorsProPaymentMethodCheckOutEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProShippingMethodEnabled value
     * @return \ebay\StructType\EBayMotorsProShippingMethodEnabledDefinitionType|null
     */
    public function getEBayMotorsProShippingMethodEnabled()
    {
        return $this->eBayMotorsProShippingMethodEnabled;
    }
    /**
     * Set eBayMotorsProShippingMethodEnabled value
     * @param \ebay\StructType\EBayMotorsProShippingMethodEnabledDefinitionType $eBayMotorsProShippingMethodEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProShippingMethodEnabled(\ebay\StructType\EBayMotorsProShippingMethodEnabledDefinitionType $eBayMotorsProShippingMethodEnabled = null)
    {
        $this->eBayMotorsProShippingMethodEnabled = $eBayMotorsProShippingMethodEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProCounterOfferEnabled value
     * @return \ebay\StructType\EBayMotorsProCounterOfferEnabledDefinitionType|null
     */
    public function getEBayMotorsProCounterOfferEnabled()
    {
        return $this->eBayMotorsProCounterOfferEnabled;
    }
    /**
     * Set eBayMotorsProCounterOfferEnabled value
     * @param \ebay\StructType\EBayMotorsProCounterOfferEnabledDefinitionType $eBayMotorsProCounterOfferEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProCounterOfferEnabled(\ebay\StructType\EBayMotorsProCounterOfferEnabledDefinitionType $eBayMotorsProCounterOfferEnabled = null)
    {
        $this->eBayMotorsProCounterOfferEnabled = $eBayMotorsProCounterOfferEnabled;
        return $this;
    }
    /**
     * Get eBayMotorsProSellerContactDetailsEnabled value
     * @return \ebay\StructType\EBayMotorsProSellerContactDetailsEnabledDefinitionType|null
     */
    public function getEBayMotorsProSellerContactDetailsEnabled()
    {
        return $this->eBayMotorsProSellerContactDetailsEnabled;
    }
    /**
     * Set eBayMotorsProSellerContactDetailsEnabled value
     * @param \ebay\StructType\EBayMotorsProSellerContactDetailsEnabledDefinitionType $eBayMotorsProSellerContactDetailsEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEBayMotorsProSellerContactDetailsEnabled(\ebay\StructType\EBayMotorsProSellerContactDetailsEnabledDefinitionType $eBayMotorsProSellerContactDetailsEnabled = null)
    {
        $this->eBayMotorsProSellerContactDetailsEnabled = $eBayMotorsProSellerContactDetailsEnabled;
        return $this;
    }
    /**
     * Get LocalMarketAdFormatEnabled value
     * @return \ebay\StructType\LocalMarketAdFormatEnabledDefinitionType|null
     */
    public function getLocalMarketAdFormatEnabled()
    {
        return $this->LocalMarketAdFormatEnabled;
    }
    /**
     * Set LocalMarketAdFormatEnabled value
     * @param \ebay\StructType\LocalMarketAdFormatEnabledDefinitionType $localMarketAdFormatEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketAdFormatEnabled(\ebay\StructType\LocalMarketAdFormatEnabledDefinitionType $localMarketAdFormatEnabled = null)
    {
        $this->LocalMarketAdFormatEnabled = $localMarketAdFormatEnabled;
        return $this;
    }
    /**
     * Get LocalMarketContactByPhoneEnabled value
     * @return \ebay\StructType\LocalMarketContactByPhoneEnabledDefinitionType|null
     */
    public function getLocalMarketContactByPhoneEnabled()
    {
        return $this->LocalMarketContactByPhoneEnabled;
    }
    /**
     * Set LocalMarketContactByPhoneEnabled value
     * @param \ebay\StructType\LocalMarketContactByPhoneEnabledDefinitionType $localMarketContactByPhoneEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketContactByPhoneEnabled(\ebay\StructType\LocalMarketContactByPhoneEnabledDefinitionType $localMarketContactByPhoneEnabled = null)
    {
        $this->LocalMarketContactByPhoneEnabled = $localMarketContactByPhoneEnabled;
        return $this;
    }
    /**
     * Get LocalMarketPhoneCount value
     * @return \ebay\StructType\LocalMarketPhoneCountDefinitionType|null
     */
    public function getLocalMarketPhoneCount()
    {
        return $this->LocalMarketPhoneCount;
    }
    /**
     * Set LocalMarketPhoneCount value
     * @param \ebay\StructType\LocalMarketPhoneCountDefinitionType $localMarketPhoneCount
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketPhoneCount(\ebay\StructType\LocalMarketPhoneCountDefinitionType $localMarketPhoneCount = null)
    {
        $this->LocalMarketPhoneCount = $localMarketPhoneCount;
        return $this;
    }
    /**
     * Get LocalMarketContactByAddressEnabled value
     * @return \ebay\StructType\LocalMarketContactByAddressEnabledDefinitionType|null
     */
    public function getLocalMarketContactByAddressEnabled()
    {
        return $this->LocalMarketContactByAddressEnabled;
    }
    /**
     * Set LocalMarketContactByAddressEnabled value
     * @param \ebay\StructType\LocalMarketContactByAddressEnabledDefinitionType $localMarketContactByAddressEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketContactByAddressEnabled(\ebay\StructType\LocalMarketContactByAddressEnabledDefinitionType $localMarketContactByAddressEnabled = null)
    {
        $this->LocalMarketContactByAddressEnabled = $localMarketContactByAddressEnabled;
        return $this;
    }
    /**
     * Get LocalMarketStreetCount value
     * @return \ebay\StructType\LocalMarketStreetCountDefinitionType|null
     */
    public function getLocalMarketStreetCount()
    {
        return $this->LocalMarketStreetCount;
    }
    /**
     * Set LocalMarketStreetCount value
     * @param \ebay\StructType\LocalMarketStreetCountDefinitionType $localMarketStreetCount
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketStreetCount(\ebay\StructType\LocalMarketStreetCountDefinitionType $localMarketStreetCount = null)
    {
        $this->LocalMarketStreetCount = $localMarketStreetCount;
        return $this;
    }
    /**
     * Get LocalMarketCompanyNameEnabled value
     * @return \ebay\StructType\LocalMarketCompanyNameEnabledDefinitionType|null
     */
    public function getLocalMarketCompanyNameEnabled()
    {
        return $this->LocalMarketCompanyNameEnabled;
    }
    /**
     * Set LocalMarketCompanyNameEnabled value
     * @param \ebay\StructType\LocalMarketCompanyNameEnabledDefinitionType $localMarketCompanyNameEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketCompanyNameEnabled(\ebay\StructType\LocalMarketCompanyNameEnabledDefinitionType $localMarketCompanyNameEnabled = null)
    {
        $this->LocalMarketCompanyNameEnabled = $localMarketCompanyNameEnabled;
        return $this;
    }
    /**
     * Get LocalMarketContactByEmailEnabled value
     * @return \ebay\StructType\LocalMarketContactByEmailEnabledDefinitionType|null
     */
    public function getLocalMarketContactByEmailEnabled()
    {
        return $this->LocalMarketContactByEmailEnabled;
    }
    /**
     * Set LocalMarketContactByEmailEnabled value
     * @param \ebay\StructType\LocalMarketContactByEmailEnabledDefinitionType $localMarketContactByEmailEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketContactByEmailEnabled(\ebay\StructType\LocalMarketContactByEmailEnabledDefinitionType $localMarketContactByEmailEnabled = null)
    {
        $this->LocalMarketContactByEmailEnabled = $localMarketContactByEmailEnabled;
        return $this;
    }
    /**
     * Get LocalMarketBestOfferEnabled value
     * @return \ebay\StructType\LocalMarketBestOfferEnabledDefinitionType|null
     */
    public function getLocalMarketBestOfferEnabled()
    {
        return $this->LocalMarketBestOfferEnabled;
    }
    /**
     * Set LocalMarketBestOfferEnabled value
     * @param \ebay\StructType\LocalMarketBestOfferEnabledDefinitionType $localMarketBestOfferEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketBestOfferEnabled(\ebay\StructType\LocalMarketBestOfferEnabledDefinitionType $localMarketBestOfferEnabled = null)
    {
        $this->LocalMarketBestOfferEnabled = $localMarketBestOfferEnabled;
        return $this;
    }
    /**
     * Get LocalMarketAutoAcceptEnabled value
     * @return \ebay\StructType\LocalMarketAutoAcceptEnabledDefinitionType|null
     */
    public function getLocalMarketAutoAcceptEnabled()
    {
        return $this->LocalMarketAutoAcceptEnabled;
    }
    /**
     * Set LocalMarketAutoAcceptEnabled value
     * @param \ebay\StructType\LocalMarketAutoAcceptEnabledDefinitionType $localMarketAutoAcceptEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketAutoAcceptEnabled(\ebay\StructType\LocalMarketAutoAcceptEnabledDefinitionType $localMarketAutoAcceptEnabled = null)
    {
        $this->LocalMarketAutoAcceptEnabled = $localMarketAutoAcceptEnabled;
        return $this;
    }
    /**
     * Get LocalMarketAutoDeclineEnabled value
     * @return \ebay\StructType\LocalMarketAutoDeclineEnabledDefinitionType|null
     */
    public function getLocalMarketAutoDeclineEnabled()
    {
        return $this->LocalMarketAutoDeclineEnabled;
    }
    /**
     * Set LocalMarketAutoDeclineEnabled value
     * @param \ebay\StructType\LocalMarketAutoDeclineEnabledDefinitionType $localMarketAutoDeclineEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketAutoDeclineEnabled(\ebay\StructType\LocalMarketAutoDeclineEnabledDefinitionType $localMarketAutoDeclineEnabled = null)
    {
        $this->LocalMarketAutoDeclineEnabled = $localMarketAutoDeclineEnabled;
        return $this;
    }
    /**
     * Get LocalMarketPaymentMethodCheckOutEnabled value
     * @return \ebay\StructType\LocalMarketPaymentMethodCheckOutEnabledDefinitionType|null
     */
    public function getLocalMarketPaymentMethodCheckOutEnabled()
    {
        return $this->LocalMarketPaymentMethodCheckOutEnabled;
    }
    /**
     * Set LocalMarketPaymentMethodCheckOutEnabled value
     * @param \ebay\StructType\LocalMarketPaymentMethodCheckOutEnabledDefinitionType $localMarketPaymentMethodCheckOutEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketPaymentMethodCheckOutEnabled(\ebay\StructType\LocalMarketPaymentMethodCheckOutEnabledDefinitionType $localMarketPaymentMethodCheckOutEnabled = null)
    {
        $this->LocalMarketPaymentMethodCheckOutEnabled = $localMarketPaymentMethodCheckOutEnabled;
        return $this;
    }
    /**
     * Get LocalMarketShippingMethodEnabled value
     * @return \ebay\StructType\LocalMarketShippingMethodEnabledDefinitionType|null
     */
    public function getLocalMarketShippingMethodEnabled()
    {
        return $this->LocalMarketShippingMethodEnabled;
    }
    /**
     * Set LocalMarketShippingMethodEnabled value
     * @param \ebay\StructType\LocalMarketShippingMethodEnabledDefinitionType $localMarketShippingMethodEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketShippingMethodEnabled(\ebay\StructType\LocalMarketShippingMethodEnabledDefinitionType $localMarketShippingMethodEnabled = null)
    {
        $this->LocalMarketShippingMethodEnabled = $localMarketShippingMethodEnabled;
        return $this;
    }
    /**
     * Get LocalMarketCounterOfferEnabled value
     * @return \ebay\StructType\LocalMarketCounterOfferEnabledDefinitionType|null
     */
    public function getLocalMarketCounterOfferEnabled()
    {
        return $this->LocalMarketCounterOfferEnabled;
    }
    /**
     * Set LocalMarketCounterOfferEnabled value
     * @param \ebay\StructType\LocalMarketCounterOfferEnabledDefinitionType $localMarketCounterOfferEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketCounterOfferEnabled(\ebay\StructType\LocalMarketCounterOfferEnabledDefinitionType $localMarketCounterOfferEnabled = null)
    {
        $this->LocalMarketCounterOfferEnabled = $localMarketCounterOfferEnabled;
        return $this;
    }
    /**
     * Get LocalMarketSellerContactDetailsEnabled value
     * @return \ebay\StructType\LocalMarketSellerContactDetailsEnabledDefinitionType|null
     */
    public function getLocalMarketSellerContactDetailsEnabled()
    {
        return $this->LocalMarketSellerContactDetailsEnabled;
    }
    /**
     * Set LocalMarketSellerContactDetailsEnabled value
     * @param \ebay\StructType\LocalMarketSellerContactDetailsEnabledDefinitionType $localMarketSellerContactDetailsEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setLocalMarketSellerContactDetailsEnabled(\ebay\StructType\LocalMarketSellerContactDetailsEnabledDefinitionType $localMarketSellerContactDetailsEnabled = null)
    {
        $this->LocalMarketSellerContactDetailsEnabled = $localMarketSellerContactDetailsEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdPhoneCount value
     * @return \ebay\StructType\ClassifiedAdPhoneCountDefinitionType|null
     */
    public function getClassifiedAdPhoneCount()
    {
        return $this->ClassifiedAdPhoneCount;
    }
    /**
     * Set ClassifiedAdPhoneCount value
     * @param \ebay\StructType\ClassifiedAdPhoneCountDefinitionType $classifiedAdPhoneCount
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdPhoneCount(\ebay\StructType\ClassifiedAdPhoneCountDefinitionType $classifiedAdPhoneCount = null)
    {
        $this->ClassifiedAdPhoneCount = $classifiedAdPhoneCount;
        return $this;
    }
    /**
     * Get ClassifiedAdContactByAddressEnabled value
     * @return \ebay\StructType\ClassifiedAdContactByAddressEnabledDefinitionType|null
     */
    public function getClassifiedAdContactByAddressEnabled()
    {
        return $this->ClassifiedAdContactByAddressEnabled;
    }
    /**
     * Set ClassifiedAdContactByAddressEnabled value
     * @param \ebay\StructType\ClassifiedAdContactByAddressEnabledDefinitionType $classifiedAdContactByAddressEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdContactByAddressEnabled(\ebay\StructType\ClassifiedAdContactByAddressEnabledDefinitionType $classifiedAdContactByAddressEnabled = null)
    {
        $this->ClassifiedAdContactByAddressEnabled = $classifiedAdContactByAddressEnabled;
        return $this;
    }
    /**
     * Get ClassifiedAdStreetCount value
     * @return \ebay\StructType\ClassifiedAdStreetCountDefinitionType|null
     */
    public function getClassifiedAdStreetCount()
    {
        return $this->ClassifiedAdStreetCount;
    }
    /**
     * Set ClassifiedAdStreetCount value
     * @param \ebay\StructType\ClassifiedAdStreetCountDefinitionType $classifiedAdStreetCount
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdStreetCount(\ebay\StructType\ClassifiedAdStreetCountDefinitionType $classifiedAdStreetCount = null)
    {
        $this->ClassifiedAdStreetCount = $classifiedAdStreetCount;
        return $this;
    }
    /**
     * Get ClassifiedAdCompanyNameEnabled value
     * @return \ebay\StructType\ClassifiedAdCompanyNameEnabledDefinitionType|null
     */
    public function getClassifiedAdCompanyNameEnabled()
    {
        return $this->ClassifiedAdCompanyNameEnabled;
    }
    /**
     * Set ClassifiedAdCompanyNameEnabled value
     * @param \ebay\StructType\ClassifiedAdCompanyNameEnabledDefinitionType $classifiedAdCompanyNameEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setClassifiedAdCompanyNameEnabled(\ebay\StructType\ClassifiedAdCompanyNameEnabledDefinitionType $classifiedAdCompanyNameEnabled = null)
    {
        $this->ClassifiedAdCompanyNameEnabled = $classifiedAdCompanyNameEnabled;
        return $this;
    }
    /**
     * Get SpecialitySubscription value
     * @return \ebay\StructType\SpecialitySubscriptionDefinitionType|null
     */
    public function getSpecialitySubscription()
    {
        return $this->SpecialitySubscription;
    }
    /**
     * Set SpecialitySubscription value
     * @param \ebay\StructType\SpecialitySubscriptionDefinitionType $specialitySubscription
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setSpecialitySubscription(\ebay\StructType\SpecialitySubscriptionDefinitionType $specialitySubscription = null)
    {
        $this->SpecialitySubscription = $specialitySubscription;
        return $this;
    }
    /**
     * Get RegularSubscription value
     * @return \ebay\StructType\RegularSubscriptionDefinitionType|null
     */
    public function getRegularSubscription()
    {
        return $this->RegularSubscription;
    }
    /**
     * Set RegularSubscription value
     * @param \ebay\StructType\RegularSubscriptionDefinitionType $regularSubscription
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setRegularSubscription(\ebay\StructType\RegularSubscriptionDefinitionType $regularSubscription = null)
    {
        $this->RegularSubscription = $regularSubscription;
        return $this;
    }
    /**
     * Get PremiumSubscription value
     * @return \ebay\StructType\PremiumSubscriptionDefinitionType|null
     */
    public function getPremiumSubscription()
    {
        return $this->PremiumSubscription;
    }
    /**
     * Set PremiumSubscription value
     * @param \ebay\StructType\PremiumSubscriptionDefinitionType $premiumSubscription
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setPremiumSubscription(\ebay\StructType\PremiumSubscriptionDefinitionType $premiumSubscription = null)
    {
        $this->PremiumSubscription = $premiumSubscription;
        return $this;
    }
    /**
     * Get NonSubscription value
     * @return \ebay\StructType\NonSubscriptionDefinitionType|null
     */
    public function getNonSubscription()
    {
        return $this->NonSubscription;
    }
    /**
     * Set NonSubscription value
     * @param \ebay\StructType\NonSubscriptionDefinitionType $nonSubscription
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setNonSubscription(\ebay\StructType\NonSubscriptionDefinitionType $nonSubscription = null)
    {
        $this->NonSubscription = $nonSubscription;
        return $this;
    }
    /**
     * Get ReturnPolicyEnabled value
     * @return \ebay\StructType\ReturnPolicyEnabledDefinitionType|null
     */
    public function getReturnPolicyEnabled()
    {
        return $this->ReturnPolicyEnabled;
    }
    /**
     * Set ReturnPolicyEnabled value
     * @param \ebay\StructType\ReturnPolicyEnabledDefinitionType $returnPolicyEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setReturnPolicyEnabled(\ebay\StructType\ReturnPolicyEnabledDefinitionType $returnPolicyEnabled = null)
    {
        $this->ReturnPolicyEnabled = $returnPolicyEnabled;
        return $this;
    }
    /**
     * Get HandlingTimeEnabled value
     * @return \ebay\StructType\HandlingTimeEnabledDefinitionType|null
     */
    public function getHandlingTimeEnabled()
    {
        return $this->HandlingTimeEnabled;
    }
    /**
     * Set HandlingTimeEnabled value
     * @param \ebay\StructType\HandlingTimeEnabledDefinitionType $handlingTimeEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setHandlingTimeEnabled(\ebay\StructType\HandlingTimeEnabledDefinitionType $handlingTimeEnabled = null)
    {
        $this->HandlingTimeEnabled = $handlingTimeEnabled;
        return $this;
    }
    /**
     * Get PayPalRequiredForStoreOwner value
     * @return \ebay\StructType\PayPalRequiredForStoreOwnerDefinitionType|null
     */
    public function getPayPalRequiredForStoreOwner()
    {
        return $this->PayPalRequiredForStoreOwner;
    }
    /**
     * Set PayPalRequiredForStoreOwner value
     * @param \ebay\StructType\PayPalRequiredForStoreOwnerDefinitionType $payPalRequiredForStoreOwner
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setPayPalRequiredForStoreOwner(\ebay\StructType\PayPalRequiredForStoreOwnerDefinitionType $payPalRequiredForStoreOwner = null)
    {
        $this->PayPalRequiredForStoreOwner = $payPalRequiredForStoreOwner;
        return $this;
    }
    /**
     * Get ReviseQuantityAllowed value
     * @return \ebay\StructType\ReviseQuantityAllowedDefinitionType|null
     */
    public function getReviseQuantityAllowed()
    {
        return $this->ReviseQuantityAllowed;
    }
    /**
     * Set ReviseQuantityAllowed value
     * @param \ebay\StructType\ReviseQuantityAllowedDefinitionType $reviseQuantityAllowed
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setReviseQuantityAllowed(\ebay\StructType\ReviseQuantityAllowedDefinitionType $reviseQuantityAllowed = null)
    {
        $this->ReviseQuantityAllowed = $reviseQuantityAllowed;
        return $this;
    }
    /**
     * Get RevisePriceAllowed value
     * @return \ebay\StructType\RevisePriceAllowedDefinitionType|null
     */
    public function getRevisePriceAllowed()
    {
        return $this->RevisePriceAllowed;
    }
    /**
     * Set RevisePriceAllowed value
     * @param \ebay\StructType\RevisePriceAllowedDefinitionType $revisePriceAllowed
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setRevisePriceAllowed(\ebay\StructType\RevisePriceAllowedDefinitionType $revisePriceAllowed = null)
    {
        $this->RevisePriceAllowed = $revisePriceAllowed;
        return $this;
    }
    /**
     * Get StoreOwnerExtendedListingDurationsEnabled value
     * @return \ebay\StructType\StoreOwnerExtendedListingDurationsEnabledDefinitionType|null
     */
    public function getStoreOwnerExtendedListingDurationsEnabled()
    {
        return $this->StoreOwnerExtendedListingDurationsEnabled;
    }
    /**
     * Set StoreOwnerExtendedListingDurationsEnabled value
     * @param \ebay\StructType\StoreOwnerExtendedListingDurationsEnabledDefinitionType $storeOwnerExtendedListingDurationsEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setStoreOwnerExtendedListingDurationsEnabled(\ebay\StructType\StoreOwnerExtendedListingDurationsEnabledDefinitionType $storeOwnerExtendedListingDurationsEnabled = null)
    {
        $this->StoreOwnerExtendedListingDurationsEnabled = $storeOwnerExtendedListingDurationsEnabled;
        return $this;
    }
    /**
     * Get StoreOwnerExtendedListingDurations value
     * @return \ebay\StructType\StoreOwnerExtendedListingDurationsDefinitionType|null
     */
    public function getStoreOwnerExtendedListingDurations()
    {
        return $this->StoreOwnerExtendedListingDurations;
    }
    /**
     * Set StoreOwnerExtendedListingDurations value
     * @param \ebay\StructType\StoreOwnerExtendedListingDurationsDefinitionType $storeOwnerExtendedListingDurations
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setStoreOwnerExtendedListingDurations(\ebay\StructType\StoreOwnerExtendedListingDurationsDefinitionType $storeOwnerExtendedListingDurations = null)
    {
        $this->StoreOwnerExtendedListingDurations = $storeOwnerExtendedListingDurations;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return \ebay\StructType\PaymentMethodDefinitionType|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param \ebay\StructType\PaymentMethodDefinitionType $paymentMethod
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setPaymentMethod(\ebay\StructType\PaymentMethodDefinitionType $paymentMethod = null)
    {
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get Group1MaxFlatShippingCost value
     * @return \ebay\StructType\Group1MaxFlatShippingCostDefinitionType|null
     */
    public function getGroup1MaxFlatShippingCost()
    {
        return $this->Group1MaxFlatShippingCost;
    }
    /**
     * Set Group1MaxFlatShippingCost value
     * @param \ebay\StructType\Group1MaxFlatShippingCostDefinitionType $group1MaxFlatShippingCost
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setGroup1MaxFlatShippingCost(\ebay\StructType\Group1MaxFlatShippingCostDefinitionType $group1MaxFlatShippingCost = null)
    {
        $this->Group1MaxFlatShippingCost = $group1MaxFlatShippingCost;
        return $this;
    }
    /**
     * Get Group2MaxFlatShippingCost value
     * @return \ebay\StructType\Group2MaxFlatShippingCostDefinitionType|null
     */
    public function getGroup2MaxFlatShippingCost()
    {
        return $this->Group2MaxFlatShippingCost;
    }
    /**
     * Set Group2MaxFlatShippingCost value
     * @param \ebay\StructType\Group2MaxFlatShippingCostDefinitionType $group2MaxFlatShippingCost
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setGroup2MaxFlatShippingCost(\ebay\StructType\Group2MaxFlatShippingCostDefinitionType $group2MaxFlatShippingCost = null)
    {
        $this->Group2MaxFlatShippingCost = $group2MaxFlatShippingCost;
        return $this;
    }
    /**
     * Get Group3MaxFlatShippingCost value
     * @return \ebay\StructType\Group3MaxFlatShippingCostDefinitionType|null
     */
    public function getGroup3MaxFlatShippingCost()
    {
        return $this->Group3MaxFlatShippingCost;
    }
    /**
     * Set Group3MaxFlatShippingCost value
     * @param \ebay\StructType\Group3MaxFlatShippingCostDefinitionType $group3MaxFlatShippingCost
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setGroup3MaxFlatShippingCost(\ebay\StructType\Group3MaxFlatShippingCostDefinitionType $group3MaxFlatShippingCost = null)
    {
        $this->Group3MaxFlatShippingCost = $group3MaxFlatShippingCost;
        return $this;
    }
    /**
     * Get MaxFlatShippingCostCBTExempt value
     * @return \ebay\StructType\MaxFlatShippingCostCBTExemptDefinitionType|null
     */
    public function getMaxFlatShippingCostCBTExempt()
    {
        return $this->MaxFlatShippingCostCBTExempt;
    }
    /**
     * Set MaxFlatShippingCostCBTExempt value
     * @param \ebay\StructType\MaxFlatShippingCostCBTExemptDefinitionType $maxFlatShippingCostCBTExempt
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setMaxFlatShippingCostCBTExempt(\ebay\StructType\MaxFlatShippingCostCBTExemptDefinitionType $maxFlatShippingCostCBTExempt = null)
    {
        $this->MaxFlatShippingCostCBTExempt = $maxFlatShippingCostCBTExempt;
        return $this;
    }
    /**
     * Get MaxFlatShippingCost value
     * @return \ebay\StructType\MaxFlatShippingCostDefinitionType|null
     */
    public function getMaxFlatShippingCost()
    {
        return $this->MaxFlatShippingCost;
    }
    /**
     * Set MaxFlatShippingCost value
     * @param \ebay\StructType\MaxFlatShippingCostDefinitionType $maxFlatShippingCost
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setMaxFlatShippingCost(\ebay\StructType\MaxFlatShippingCostDefinitionType $maxFlatShippingCost = null)
    {
        $this->MaxFlatShippingCost = $maxFlatShippingCost;
        return $this;
    }
    /**
     * Get VariationsEnabled value
     * @return \ebay\StructType\VariationsEnabledDefinitionType|null
     */
    public function getVariationsEnabled()
    {
        return $this->VariationsEnabled;
    }
    /**
     * Set VariationsEnabled value
     * @param \ebay\StructType\VariationsEnabledDefinitionType $variationsEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setVariationsEnabled(\ebay\StructType\VariationsEnabledDefinitionType $variationsEnabled = null)
    {
        $this->VariationsEnabled = $variationsEnabled;
        return $this;
    }
    /**
     * Get AttributeConversionEnabled value
     * @return \ebay\StructType\AttributeConversionEnabledFeatureDefinitionType|null
     */
    public function getAttributeConversionEnabled()
    {
        return $this->AttributeConversionEnabled;
    }
    /**
     * Set AttributeConversionEnabled value
     * @param \ebay\StructType\AttributeConversionEnabledFeatureDefinitionType $attributeConversionEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setAttributeConversionEnabled(\ebay\StructType\AttributeConversionEnabledFeatureDefinitionType $attributeConversionEnabled = null)
    {
        $this->AttributeConversionEnabled = $attributeConversionEnabled;
        return $this;
    }
    /**
     * Get FreeGalleryPlusEnabled value
     * @return \ebay\StructType\FreeGalleryPlusEnabledDefinitionType|null
     */
    public function getFreeGalleryPlusEnabled()
    {
        return $this->FreeGalleryPlusEnabled;
    }
    /**
     * Set FreeGalleryPlusEnabled value
     * @param \ebay\StructType\FreeGalleryPlusEnabledDefinitionType $freeGalleryPlusEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setFreeGalleryPlusEnabled(\ebay\StructType\FreeGalleryPlusEnabledDefinitionType $freeGalleryPlusEnabled = null)
    {
        $this->FreeGalleryPlusEnabled = $freeGalleryPlusEnabled;
        return $this;
    }
    /**
     * Get FreePicturePackEnabled value
     * @return \ebay\StructType\FreePicturePackEnabledDefinitionType|null
     */
    public function getFreePicturePackEnabled()
    {
        return $this->FreePicturePackEnabled;
    }
    /**
     * Set FreePicturePackEnabled value
     * @param \ebay\StructType\FreePicturePackEnabledDefinitionType $freePicturePackEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setFreePicturePackEnabled(\ebay\StructType\FreePicturePackEnabledDefinitionType $freePicturePackEnabled = null)
    {
        $this->FreePicturePackEnabled = $freePicturePackEnabled;
        return $this;
    }
    /**
     * Get ItemCompatibilityEnabled value
     * @return \ebay\StructType\ItemCompatibilityEnabledDefinitionType|null
     */
    public function getItemCompatibilityEnabled()
    {
        return $this->ItemCompatibilityEnabled;
    }
    /**
     * Set ItemCompatibilityEnabled value
     * @param \ebay\StructType\ItemCompatibilityEnabledDefinitionType $itemCompatibilityEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setItemCompatibilityEnabled(\ebay\StructType\ItemCompatibilityEnabledDefinitionType $itemCompatibilityEnabled = null)
    {
        $this->ItemCompatibilityEnabled = $itemCompatibilityEnabled;
        return $this;
    }
    /**
     * Get MaxItemCompatibility value
     * @return \ebay\StructType\MaxItemCompatibilityDefinitionType|null
     */
    public function getMaxItemCompatibility()
    {
        return $this->MaxItemCompatibility;
    }
    /**
     * Set MaxItemCompatibility value
     * @param \ebay\StructType\MaxItemCompatibilityDefinitionType $maxItemCompatibility
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setMaxItemCompatibility(\ebay\StructType\MaxItemCompatibilityDefinitionType $maxItemCompatibility = null)
    {
        $this->MaxItemCompatibility = $maxItemCompatibility;
        return $this;
    }
    /**
     * Get MinItemCompatibility value
     * @return \ebay\StructType\MinItemCompatibilityDefinitionType|null
     */
    public function getMinItemCompatibility()
    {
        return $this->MinItemCompatibility;
    }
    /**
     * Set MinItemCompatibility value
     * @param \ebay\StructType\MinItemCompatibilityDefinitionType $minItemCompatibility
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setMinItemCompatibility(\ebay\StructType\MinItemCompatibilityDefinitionType $minItemCompatibility = null)
    {
        $this->MinItemCompatibility = $minItemCompatibility;
        return $this;
    }
    /**
     * Get ConditionEnabled value
     * @return \ebay\StructType\ConditionEnabledDefinitionType|null
     */
    public function getConditionEnabled()
    {
        return $this->ConditionEnabled;
    }
    /**
     * Set ConditionEnabled value
     * @param \ebay\StructType\ConditionEnabledDefinitionType $conditionEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setConditionEnabled(\ebay\StructType\ConditionEnabledDefinitionType $conditionEnabled = null)
    {
        $this->ConditionEnabled = $conditionEnabled;
        return $this;
    }
    /**
     * Get ConditionValues value
     * @return \ebay\StructType\ConditionValuesDefinitionType|null
     */
    public function getConditionValues()
    {
        return $this->ConditionValues;
    }
    /**
     * Set ConditionValues value
     * @param \ebay\StructType\ConditionValuesDefinitionType $conditionValues
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setConditionValues(\ebay\StructType\ConditionValuesDefinitionType $conditionValues = null)
    {
        $this->ConditionValues = $conditionValues;
        return $this;
    }
    /**
     * Get ValueCategory value
     * @return \ebay\StructType\ValueCategoryDefinitionType|null
     */
    public function getValueCategory()
    {
        return $this->ValueCategory;
    }
    /**
     * Set ValueCategory value
     * @param \ebay\StructType\ValueCategoryDefinitionType $valueCategory
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setValueCategory(\ebay\StructType\ValueCategoryDefinitionType $valueCategory = null)
    {
        $this->ValueCategory = $valueCategory;
        return $this;
    }
    /**
     * Get ProductCreationEnabled value
     * @return \ebay\StructType\ProductCreationEnabledDefinitionType|null
     */
    public function getProductCreationEnabled()
    {
        return $this->ProductCreationEnabled;
    }
    /**
     * Set ProductCreationEnabled value
     * @param \ebay\StructType\ProductCreationEnabledDefinitionType $productCreationEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setProductCreationEnabled(\ebay\StructType\ProductCreationEnabledDefinitionType $productCreationEnabled = null)
    {
        $this->ProductCreationEnabled = $productCreationEnabled;
        return $this;
    }
    /**
     * Get EANEnabled value
     * @return \ebay\StructType\EANEnabledDefinitionType|null
     */
    public function getEANEnabled()
    {
        return $this->EANEnabled;
    }
    /**
     * Set EANEnabled value
     * @param \ebay\StructType\EANEnabledDefinitionType $eANEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEANEnabled(\ebay\StructType\EANEnabledDefinitionType $eANEnabled = null)
    {
        $this->EANEnabled = $eANEnabled;
        return $this;
    }
    /**
     * Get ISBNEnabled value
     * @return \ebay\StructType\ISBNEnabledDefinitionType|null
     */
    public function getISBNEnabled()
    {
        return $this->ISBNEnabled;
    }
    /**
     * Set ISBNEnabled value
     * @param \ebay\StructType\ISBNEnabledDefinitionType $iSBNEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setISBNEnabled(\ebay\StructType\ISBNEnabledDefinitionType $iSBNEnabled = null)
    {
        $this->ISBNEnabled = $iSBNEnabled;
        return $this;
    }
    /**
     * Get UPCEnabled value
     * @return \ebay\StructType\UPCEnabledDefinitionType|null
     */
    public function getUPCEnabled()
    {
        return $this->UPCEnabled;
    }
    /**
     * Set UPCEnabled value
     * @param \ebay\StructType\UPCEnabledDefinitionType $uPCEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setUPCEnabled(\ebay\StructType\UPCEnabledDefinitionType $uPCEnabled = null)
    {
        $this->UPCEnabled = $uPCEnabled;
        return $this;
    }
    /**
     * Get CompatibleVehicleType value
     * @return \ebay\StructType\CompatibleVehicleTypeDefinitionType|null
     */
    public function getCompatibleVehicleType()
    {
        return $this->CompatibleVehicleType;
    }
    /**
     * Set CompatibleVehicleType value
     * @param \ebay\StructType\CompatibleVehicleTypeDefinitionType $compatibleVehicleType
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setCompatibleVehicleType(\ebay\StructType\CompatibleVehicleTypeDefinitionType $compatibleVehicleType = null)
    {
        $this->CompatibleVehicleType = $compatibleVehicleType;
        return $this;
    }
    /**
     * Get MaxGranularFitmentCount value
     * @return \ebay\StructType\MaxGranularFitmentCountDefinitionType|null
     */
    public function getMaxGranularFitmentCount()
    {
        return $this->MaxGranularFitmentCount;
    }
    /**
     * Set MaxGranularFitmentCount value
     * @param \ebay\StructType\MaxGranularFitmentCountDefinitionType $maxGranularFitmentCount
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setMaxGranularFitmentCount(\ebay\StructType\MaxGranularFitmentCountDefinitionType $maxGranularFitmentCount = null)
    {
        $this->MaxGranularFitmentCount = $maxGranularFitmentCount;
        return $this;
    }
    /**
     * Get PaymentOptionsGroup value
     * @return \ebay\StructType\PaymentOptionsGroupEnabledDefinitionType|null
     */
    public function getPaymentOptionsGroup()
    {
        return $this->PaymentOptionsGroup;
    }
    /**
     * Set PaymentOptionsGroup value
     * @param \ebay\StructType\PaymentOptionsGroupEnabledDefinitionType $paymentOptionsGroup
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setPaymentOptionsGroup(\ebay\StructType\PaymentOptionsGroupEnabledDefinitionType $paymentOptionsGroup = null)
    {
        $this->PaymentOptionsGroup = $paymentOptionsGroup;
        return $this;
    }
    /**
     * Get ShippingProfileCategoryGroup value
     * @return \ebay\StructType\ProfileCategoryGroupDefinitionType|null
     */
    public function getShippingProfileCategoryGroup()
    {
        return $this->ShippingProfileCategoryGroup;
    }
    /**
     * Set ShippingProfileCategoryGroup value
     * @param \ebay\StructType\ProfileCategoryGroupDefinitionType $shippingProfileCategoryGroup
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setShippingProfileCategoryGroup(\ebay\StructType\ProfileCategoryGroupDefinitionType $shippingProfileCategoryGroup = null)
    {
        $this->ShippingProfileCategoryGroup = $shippingProfileCategoryGroup;
        return $this;
    }
    /**
     * Get PaymentProfileCategoryGroup value
     * @return \ebay\StructType\ProfileCategoryGroupDefinitionType|null
     */
    public function getPaymentProfileCategoryGroup()
    {
        return $this->PaymentProfileCategoryGroup;
    }
    /**
     * Set PaymentProfileCategoryGroup value
     * @param \ebay\StructType\ProfileCategoryGroupDefinitionType $paymentProfileCategoryGroup
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setPaymentProfileCategoryGroup(\ebay\StructType\ProfileCategoryGroupDefinitionType $paymentProfileCategoryGroup = null)
    {
        $this->PaymentProfileCategoryGroup = $paymentProfileCategoryGroup;
        return $this;
    }
    /**
     * Get ReturnPolicyProfileCategoryGroup value
     * @return \ebay\StructType\ProfileCategoryGroupDefinitionType|null
     */
    public function getReturnPolicyProfileCategoryGroup()
    {
        return $this->ReturnPolicyProfileCategoryGroup;
    }
    /**
     * Set ReturnPolicyProfileCategoryGroup value
     * @param \ebay\StructType\ProfileCategoryGroupDefinitionType $returnPolicyProfileCategoryGroup
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setReturnPolicyProfileCategoryGroup(\ebay\StructType\ProfileCategoryGroupDefinitionType $returnPolicyProfileCategoryGroup = null)
    {
        $this->ReturnPolicyProfileCategoryGroup = $returnPolicyProfileCategoryGroup;
        return $this;
    }
    /**
     * Get VINSupported value
     * @return \ebay\StructType\VINSupportedDefinitionType|null
     */
    public function getVINSupported()
    {
        return $this->VINSupported;
    }
    /**
     * Set VINSupported value
     * @param \ebay\StructType\VINSupportedDefinitionType $vINSupported
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setVINSupported(\ebay\StructType\VINSupportedDefinitionType $vINSupported = null)
    {
        $this->VINSupported = $vINSupported;
        return $this;
    }
    /**
     * Get VRMSupported value
     * @return \ebay\StructType\VRMSupportedDefinitionType|null
     */
    public function getVRMSupported()
    {
        return $this->VRMSupported;
    }
    /**
     * Set VRMSupported value
     * @param \ebay\StructType\VRMSupportedDefinitionType $vRMSupported
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setVRMSupported(\ebay\StructType\VRMSupportedDefinitionType $vRMSupported = null)
    {
        $this->VRMSupported = $vRMSupported;
        return $this;
    }
    /**
     * Get SellerProvidedTitleSupported value
     * @return \ebay\StructType\SellerProvidedTitleSupportedDefinitionType|null
     */
    public function getSellerProvidedTitleSupported()
    {
        return $this->SellerProvidedTitleSupported;
    }
    /**
     * Set SellerProvidedTitleSupported value
     * @param \ebay\StructType\SellerProvidedTitleSupportedDefinitionType $sellerProvidedTitleSupported
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setSellerProvidedTitleSupported(\ebay\StructType\SellerProvidedTitleSupportedDefinitionType $sellerProvidedTitleSupported = null)
    {
        $this->SellerProvidedTitleSupported = $sellerProvidedTitleSupported;
        return $this;
    }
    /**
     * Get DepositSupported value
     * @return \ebay\StructType\DepositSupportedDefinitionType|null
     */
    public function getDepositSupported()
    {
        return $this->DepositSupported;
    }
    /**
     * Set DepositSupported value
     * @param \ebay\StructType\DepositSupportedDefinitionType $depositSupported
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setDepositSupported(\ebay\StructType\DepositSupportedDefinitionType $depositSupported = null)
    {
        $this->DepositSupported = $depositSupported;
        return $this;
    }
    /**
     * Get GlobalShippingEnabled value
     * @return \ebay\StructType\GlobalShippingEnabledDefinitionType|null
     */
    public function getGlobalShippingEnabled()
    {
        return $this->GlobalShippingEnabled;
    }
    /**
     * Set GlobalShippingEnabled value
     * @param \ebay\StructType\GlobalShippingEnabledDefinitionType $globalShippingEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setGlobalShippingEnabled(\ebay\StructType\GlobalShippingEnabledDefinitionType $globalShippingEnabled = null)
    {
        $this->GlobalShippingEnabled = $globalShippingEnabled;
        return $this;
    }
    /**
     * Get AdditionalCompatibilityEnabled value
     * @return \ebay\StructType\AdditionalCompatibilityEnabledDefinitionType|null
     */
    public function getAdditionalCompatibilityEnabled()
    {
        return $this->AdditionalCompatibilityEnabled;
    }
    /**
     * Set AdditionalCompatibilityEnabled value
     * @param \ebay\StructType\AdditionalCompatibilityEnabledDefinitionType $additionalCompatibilityEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setAdditionalCompatibilityEnabled(\ebay\StructType\AdditionalCompatibilityEnabledDefinitionType $additionalCompatibilityEnabled = null)
    {
        $this->AdditionalCompatibilityEnabled = $additionalCompatibilityEnabled;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\FeatureDefinitionsType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get PickupDropOffEnabled value
     * @return \ebay\StructType\PickupDropOffEnabledDefinitionType|null
     */
    public function getPickupDropOffEnabled()
    {
        return $this->PickupDropOffEnabled;
    }
    /**
     * Set PickupDropOffEnabled value
     * @param \ebay\StructType\PickupDropOffEnabledDefinitionType $pickupDropOffEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setPickupDropOffEnabled(\ebay\StructType\PickupDropOffEnabledDefinitionType $pickupDropOffEnabled = null)
    {
        $this->PickupDropOffEnabled = $pickupDropOffEnabled;
        return $this;
    }
    /**
     * Get DigitalGoodDeliveryEnabled value
     * @return \ebay\StructType\DigitalGoodDeliveryEnabledDefinitionType|null
     */
    public function getDigitalGoodDeliveryEnabled()
    {
        return $this->DigitalGoodDeliveryEnabled;
    }
    /**
     * Set DigitalGoodDeliveryEnabled value
     * @param \ebay\StructType\DigitalGoodDeliveryEnabledDefinitionType $digitalGoodDeliveryEnabled
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setDigitalGoodDeliveryEnabled(\ebay\StructType\DigitalGoodDeliveryEnabledDefinitionType $digitalGoodDeliveryEnabled = null)
    {
        $this->DigitalGoodDeliveryEnabled = $digitalGoodDeliveryEnabled;
        return $this;
    }
    /**
     * Get EpidSupported value
     * @return \ebay\StructType\EpidSupportedDefinitionType|null
     */
    public function getEpidSupported()
    {
        return $this->EpidSupported;
    }
    /**
     * Set EpidSupported value
     * @param \ebay\StructType\EpidSupportedDefinitionType $epidSupported
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setEpidSupported(\ebay\StructType\EpidSupportedDefinitionType $epidSupported = null)
    {
        $this->EpidSupported = $epidSupported;
        return $this;
    }
    /**
     * Get KTypeSupported value
     * @return \ebay\StructType\KTypeSupportedDefinitionType|null
     */
    public function getKTypeSupported()
    {
        return $this->KTypeSupported;
    }
    /**
     * Set KTypeSupported value
     * @param \ebay\StructType\KTypeSupportedDefinitionType $kTypeSupported
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public function setKTypeSupported(\ebay\StructType\KTypeSupportedDefinitionType $kTypeSupported = null)
    {
        $this->KTypeSupported = $kTypeSupported;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\FeatureDefinitionsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
