<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EndItemsRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ends up to 10 specified item listings before the date and time at which it would normally end per the listing duration.&nbsp;<b>Also for Half.com</b>.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class EndItemsRequestType extends AbstractRequestType
{
    /**
     * The EndItemRequestContainer
     * Meta informations extracted from the WSDL
     * - documentation: A single container for an end item request. Multiple containers should be used to end multiple items. Up to ten (10) containers can be included per a given EndItems request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\EndItemRequestContainerType[]
     */
    public $EndItemRequestContainer;
    /**
     * Constructor method for EndItemsRequestType
     * @uses EndItemsRequestType::setEndItemRequestContainer()
     * @param \ebay\StructType\EndItemRequestContainerType[] $endItemRequestContainer
     */
    public function __construct(array $endItemRequestContainer = array())
    {
        $this
            ->setEndItemRequestContainer($endItemRequestContainer);
    }
    /**
     * Get EndItemRequestContainer value
     * @return \ebay\StructType\EndItemRequestContainerType[]|null
     */
    public function getEndItemRequestContainer()
    {
        return $this->EndItemRequestContainer;
    }
    /**
     * Set EndItemRequestContainer value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\EndItemRequestContainerType[] $endItemRequestContainer
     * @return \ebay\StructType\EndItemsRequestType
     */
    public function setEndItemRequestContainer(array $endItemRequestContainer = array())
    {
        foreach ($endItemRequestContainer as $endItemsRequestTypeEndItemRequestContainerItem) {
            // validation for constraint: itemType
            if (!$endItemsRequestTypeEndItemRequestContainerItem instanceof \ebay\StructType\EndItemRequestContainerType) {
                throw new \InvalidArgumentException(sprintf('The EndItemRequestContainer property can only contain items of \ebay\StructType\EndItemRequestContainerType, "%s" given', is_object($endItemsRequestTypeEndItemRequestContainerItem) ? get_class($endItemsRequestTypeEndItemRequestContainerItem) : gettype($endItemsRequestTypeEndItemRequestContainerItem)), __LINE__);
            }
        }
        $this->EndItemRequestContainer = $endItemRequestContainer;
        return $this;
    }
    /**
     * Add item to EndItemRequestContainer value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\EndItemRequestContainerType $item
     * @return \ebay\StructType\EndItemsRequestType
     */
    public function addToEndItemRequestContainer(\ebay\StructType\EndItemRequestContainerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\EndItemRequestContainerType) {
            throw new \InvalidArgumentException(sprintf('The EndItemRequestContainer property can only contain items of \ebay\StructType\EndItemRequestContainerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EndItemRequestContainer[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\EndItemsRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
