<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttributeType StructType
 * Meta informations extracted from the WSDL
 * - documentation: A salient aspect or feature of a Half.com item that is specified by the seller so that a buyers can find the item more easily.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class AttributeType extends AbstractStructBase
{
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - documentation: A value the seller selected or entered for the Half.com item attribute. At least one value is required for each attribute that you specify. Some attributes can have multiple values. <br><br> If using an <b>Add</b> or <b>Revise</b>
     * call to add or revise a Half.com item, this field is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\ValType[]
     */
    public $Value;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The attributeID
     * Meta informations extracted from the WSDL
     * - documentation: Constant value that identifies the Half.com item attribute in a language-independent way. Unique within the attribute set.
     * @var int
     */
    public $attributeID;
    /**
     * The attributeLabel
     * Meta informations extracted from the WSDL
     * - documentation: Name of the Half.com item attribute being specified. For <b>GetOrders</b>, this is always returned for Half.com orders. (It is not applicable to orders on the eBay.com site.) For Half.com, this field is required when you use an
     * <b>Add</b>/<b>Revise</b>/<b>Relist</b> call.
     * @var string
     */
    public $attributeLabel;
    /**
     * Constructor method for AttributeType
     * @uses AttributeType::setValue()
     * @uses AttributeType::setAny()
     * @uses AttributeType::setAttributeID()
     * @uses AttributeType::setAttributeLabel()
     * @param \ebay\StructType\ValType[] $value
     * @param \DOMDocument $any
     * @param int $attributeID
     * @param string $attributeLabel
     */
    public function __construct(array $value = array(), \DOMDocument $any = null, $attributeID = null, $attributeLabel = null)
    {
        $this
            ->setValue($value)
            ->setAny($any)
            ->setAttributeID($attributeID)
            ->setAttributeLabel($attributeLabel);
    }
    /**
     * Get Value value
     * @return \ebay\StructType\ValType[]|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ValType[] $value
     * @return \ebay\StructType\AttributeType
     */
    public function setValue(array $value = array())
    {
        foreach ($value as $attributeTypeValueItem) {
            // validation for constraint: itemType
            if (!$attributeTypeValueItem instanceof \ebay\StructType\ValType) {
                throw new \InvalidArgumentException(sprintf('The Value property can only contain items of \ebay\StructType\ValType, "%s" given', is_object($attributeTypeValueItem) ? get_class($attributeTypeValueItem) : gettype($attributeTypeValueItem)), __LINE__);
            }
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Add item to Value value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ValType $item
     * @return \ebay\StructType\AttributeType
     */
    public function addToValue(\ebay\StructType\ValType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\ValType) {
            throw new \InvalidArgumentException(sprintf('The Value property can only contain items of \ebay\StructType\ValType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Value[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\AttributeType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\AttributeType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get attributeID value
     * @return int|null
     */
    public function getAttributeID()
    {
        return $this->attributeID;
    }
    /**
     * Set attributeID value
     * @param int $attributeID
     * @return \ebay\StructType\AttributeType
     */
    public function setAttributeID($attributeID = null)
    {
        // validation for constraint: int
        if (!is_null($attributeID) && !is_numeric($attributeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($attributeID)), __LINE__);
        }
        $this->attributeID = $attributeID;
        return $this;
    }
    /**
     * Get attributeLabel value
     * @return string|null
     */
    public function getAttributeLabel()
    {
        return $this->attributeLabel;
    }
    /**
     * Set attributeLabel value
     * @param string $attributeLabel
     * @return \ebay\StructType\AttributeType
     */
    public function setAttributeLabel($attributeLabel = null)
    {
        // validation for constraint: string
        if (!is_null($attributeLabel) && !is_string($attributeLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attributeLabel)), __LINE__);
        }
        $this->attributeLabel = $attributeLabel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\AttributeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
