<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountEntriesType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type defining the array of <b>AccountEntry</b> objects that are conditionally returned in the <b>GetAccount</b> response.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class AccountEntriesType extends AbstractStructBase
{
    /**
     * The AccountEntry
     * Meta informations extracted from the WSDL
     * - documentation: Container consisting of detailed information for each debit or credit transaction that occurs on an eBay user's account.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\AccountEntryType[]
     */
    public $AccountEntry;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for AccountEntriesType
     * @uses AccountEntriesType::setAccountEntry()
     * @uses AccountEntriesType::setAny()
     * @param \ebay\StructType\AccountEntryType[] $accountEntry
     * @param \DOMDocument $any
     */
    public function __construct(array $accountEntry = array(), \DOMDocument $any = null)
    {
        $this
            ->setAccountEntry($accountEntry)
            ->setAny($any);
    }
    /**
     * Get AccountEntry value
     * @return \ebay\StructType\AccountEntryType[]|null
     */
    public function getAccountEntry()
    {
        return $this->AccountEntry;
    }
    /**
     * Set AccountEntry value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\AccountEntryType[] $accountEntry
     * @return \ebay\StructType\AccountEntriesType
     */
    public function setAccountEntry(array $accountEntry = array())
    {
        foreach ($accountEntry as $accountEntriesTypeAccountEntryItem) {
            // validation for constraint: itemType
            if (!$accountEntriesTypeAccountEntryItem instanceof \ebay\StructType\AccountEntryType) {
                throw new \InvalidArgumentException(sprintf('The AccountEntry property can only contain items of \ebay\StructType\AccountEntryType, "%s" given', is_object($accountEntriesTypeAccountEntryItem) ? get_class($accountEntriesTypeAccountEntryItem) : gettype($accountEntriesTypeAccountEntryItem)), __LINE__);
            }
        }
        $this->AccountEntry = $accountEntry;
        return $this;
    }
    /**
     * Add item to AccountEntry value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\AccountEntryType $item
     * @return \ebay\StructType\AccountEntriesType
     */
    public function addToAccountEntry(\ebay\StructType\AccountEntryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\AccountEntryType) {
            throw new \InvalidArgumentException(sprintf('The AccountEntry property can only contain items of \ebay\StructType\AccountEntryType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountEntry[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\AccountEntriesType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\AccountEntriesType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\AccountEntriesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
