<?php

namespace ebay\EnumType;

/**
 * This class stands for WarrantyTypeOptionsCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: This enumerated type contains a list of warranty types that can be offered by the seller to the buyer. The available warranty types may vary by site and by category. The seller should call <b>GeteBayDetails</b> and look at the
 * enumeration values that are returned in the <b>ReturnPolicyDetails.WarrantyType</b> container(s) in the response. <br><br> The <b>ReturnPolicyDetails</b> container will be returned if a <b>DetailName</b> field is set to
 * <code>ReturnPolicyDetails</code> in the request, or if no <b>DetailName</b> field is set in the request.
 * @subpackage Enumerations
 * @date 2017-04-07 16
 */
class WarrantyTypeOptionsCodeType
{
    /**
     * Constant for value 'ReplacementWarranty'
     * @return string 'ReplacementWarranty'
     */
    const VALUE_REPLACEMENT_WARRANTY = 'ReplacementWarranty';
    /**
     * Constant for value 'DealerWarranty'
     * @return string 'DealerWarranty'
     */
    const VALUE_DEALER_WARRANTY = 'DealerWarranty';
    /**
     * Constant for value 'ManufacturerWarranty'
     * @return string 'ManufacturerWarranty'
     */
    const VALUE_MANUFACTURER_WARRANTY = 'ManufacturerWarranty';
    /**
     * Constant for value 'CustomCode'
     * @return string 'CustomCode'
     */
    const VALUE_CUSTOM_CODE = 'CustomCode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REPLACEMENT_WARRANTY
     * @uses self::VALUE_DEALER_WARRANTY
     * @uses self::VALUE_MANUFACTURER_WARRANTY
     * @uses self::VALUE_CUSTOM_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REPLACEMENT_WARRANTY,
            self::VALUE_DEALER_WARRANTY,
            self::VALUE_MANUFACTURER_WARRANTY,
            self::VALUE_CUSTOM_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
