<?php

namespace ebay\EnumType;

/**
 * This class stands for TaxTypeCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Type that defines the Imposition field. The Imposition field allows the seller to provide a description of the sales tax type.
 * @subpackage Enumerations
 * @date 2017-04-07 16
 */
class TaxTypeCodeType
{
    /**
     * Constant for value 'SalesTax'
     * @return string 'SalesTax'
     */
    const VALUE_SALES_TAX = 'SalesTax';
    /**
     * Constant for value 'WasteRecyclingFee'
     * @return string 'WasteRecyclingFee'
     */
    const VALUE_WASTE_RECYCLING_FEE = 'WasteRecyclingFee';
    /**
     * Constant for value 'CustomCode'
     * @return string 'CustomCode'
     */
    const VALUE_CUSTOM_CODE = 'CustomCode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SALES_TAX
     * @uses self::VALUE_WASTE_RECYCLING_FEE
     * @uses self::VALUE_CUSTOM_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SALES_TAX,
            self::VALUE_WASTE_RECYCLING_FEE,
            self::VALUE_CUSTOM_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
