<?php

namespace ebay;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'AddDisputeRequestType' => '\\ebay\\StructType\\AddDisputeRequestType',
            'AddDisputeResponseType' => '\\ebay\\StructType\\AddDisputeResponseType',
            'AddDisputeResponseRequestType' => '\\ebay\\StructType\\AddDisputeResponseRequestType',
            'AddDisputeResponseResponseType' => '\\ebay\\StructType\\AddDisputeResponseResponseType',
            'AddFixedPriceItemRequestType' => '\\ebay\\StructType\\AddFixedPriceItemRequestType',
            'AddFixedPriceItemResponseType' => '\\ebay\\StructType\\AddFixedPriceItemResponseType',
            'AddItemRequestType' => '\\ebay\\StructType\\AddItemRequestType',
            'AddItemResponseType' => '\\ebay\\StructType\\AddItemResponseType',
            'AddItemFromSellingManagerTemplateRequestType' => '\\ebay\\StructType\\AddItemFromSellingManagerTemplateRequestType',
            'AddItemFromSellingManagerTemplateResponseType' => '\\ebay\\StructType\\AddItemFromSellingManagerTemplateResponseType',
            'AddItemsRequestType' => '\\ebay\\StructType\\AddItemsRequestType',
            'AddItemsResponseType' => '\\ebay\\StructType\\AddItemsResponseType',
            'AddMemberMessageAAQToPartnerRequestType' => '\\ebay\\StructType\\AddMemberMessageAAQToPartnerRequestType',
            'AddMemberMessageAAQToPartnerResponseType' => '\\ebay\\StructType\\AddMemberMessageAAQToPartnerResponseType',
            'AddMemberMessageRTQRequestType' => '\\ebay\\StructType\\AddMemberMessageRTQRequestType',
            'AddMemberMessageRTQResponseType' => '\\ebay\\StructType\\AddMemberMessageRTQResponseType',
            'AddMemberMessagesAAQToBidderRequestType' => '\\ebay\\StructType\\AddMemberMessagesAAQToBidderRequestType',
            'AddMemberMessagesAAQToBidderResponseType' => '\\ebay\\StructType\\AddMemberMessagesAAQToBidderResponseType',
            'AddOrderRequestType' => '\\ebay\\StructType\\AddOrderRequestType',
            'AddOrderResponseType' => '\\ebay\\StructType\\AddOrderResponseType',
            'AddSecondChanceItemRequestType' => '\\ebay\\StructType\\AddSecondChanceItemRequestType',
            'AddSecondChanceItemResponseType' => '\\ebay\\StructType\\AddSecondChanceItemResponseType',
            'AddSellingManagerInventoryFolderRequestType' => '\\ebay\\StructType\\AddSellingManagerInventoryFolderRequestType',
            'AddSellingManagerInventoryFolderResponseType' => '\\ebay\\StructType\\AddSellingManagerInventoryFolderResponseType',
            'AddSellingManagerProductRequestType' => '\\ebay\\StructType\\AddSellingManagerProductRequestType',
            'AddSellingManagerProductResponseType' => '\\ebay\\StructType\\AddSellingManagerProductResponseType',
            'AddSellingManagerTemplateRequestType' => '\\ebay\\StructType\\AddSellingManagerTemplateRequestType',
            'AddSellingManagerTemplateResponseType' => '\\ebay\\StructType\\AddSellingManagerTemplateResponseType',
            'AddToItemDescriptionRequestType' => '\\ebay\\StructType\\AddToItemDescriptionRequestType',
            'AddToItemDescriptionResponseType' => '\\ebay\\StructType\\AddToItemDescriptionResponseType',
            'AddToWatchListRequestType' => '\\ebay\\StructType\\AddToWatchListRequestType',
            'AddToWatchListResponseType' => '\\ebay\\StructType\\AddToWatchListResponseType',
            'AddTransactionConfirmationItemRequestType' => '\\ebay\\StructType\\AddTransactionConfirmationItemRequestType',
            'AddTransactionConfirmationItemResponseType' => '\\ebay\\StructType\\AddTransactionConfirmationItemResponseType',
            'CompleteSaleRequestType' => '\\ebay\\StructType\\CompleteSaleRequestType',
            'CompleteSaleResponseType' => '\\ebay\\StructType\\CompleteSaleResponseType',
            'ConfirmIdentityRequestType' => '\\ebay\\StructType\\ConfirmIdentityRequestType',
            'ConfirmIdentityResponseType' => '\\ebay\\StructType\\ConfirmIdentityResponseType',
            'DeleteMyMessagesRequestType' => '\\ebay\\StructType\\DeleteMyMessagesRequestType',
            'DeleteMyMessagesResponseType' => '\\ebay\\StructType\\DeleteMyMessagesResponseType',
            'DeleteSellingManagerInventoryFolderRequestType' => '\\ebay\\StructType\\DeleteSellingManagerInventoryFolderRequestType',
            'DeleteSellingManagerInventoryFolderResponseType' => '\\ebay\\StructType\\DeleteSellingManagerInventoryFolderResponseType',
            'DeleteSellingManagerItemAutomationRuleRequestType' => '\\ebay\\StructType\\DeleteSellingManagerItemAutomationRuleRequestType',
            'DeleteSellingManagerItemAutomationRuleResponseType' => '\\ebay\\StructType\\DeleteSellingManagerItemAutomationRuleResponseType',
            'DeleteSellingManagerProductRequestType' => '\\ebay\\StructType\\DeleteSellingManagerProductRequestType',
            'DeleteSellingManagerProductResponseType' => '\\ebay\\StructType\\DeleteSellingManagerProductResponseType',
            'DeleteSellingManagerTemplateRequestType' => '\\ebay\\StructType\\DeleteSellingManagerTemplateRequestType',
            'DeleteSellingManagerTemplateResponseType' => '\\ebay\\StructType\\DeleteSellingManagerTemplateResponseType',
            'DeleteSellingManagerTemplateAutomationRuleRequestType' => '\\ebay\\StructType\\DeleteSellingManagerTemplateAutomationRuleRequestType',
            'DeleteSellingManagerTemplateAutomationRuleResponseType' => '\\ebay\\StructType\\DeleteSellingManagerTemplateAutomationRuleResponseType',
            'DisableUnpaidItemAssistanceRequestType' => '\\ebay\\StructType\\DisableUnpaidItemAssistanceRequestType',
            'DisableUnpaidItemAssistanceResponseType' => '\\ebay\\StructType\\DisableUnpaidItemAssistanceResponseType',
            'EndFixedPriceItemRequestType' => '\\ebay\\StructType\\EndFixedPriceItemRequestType',
            'EndFixedPriceItemResponseType' => '\\ebay\\StructType\\EndFixedPriceItemResponseType',
            'EndItemRequestType' => '\\ebay\\StructType\\EndItemRequestType',
            'EndItemResponseType' => '\\ebay\\StructType\\EndItemResponseType',
            'EndItemsRequestType' => '\\ebay\\StructType\\EndItemsRequestType',
            'EndItemsResponseType' => '\\ebay\\StructType\\EndItemsResponseType',
            'ExtendSiteHostedPicturesRequestType' => '\\ebay\\StructType\\ExtendSiteHostedPicturesRequestType',
            'ExtendSiteHostedPicturesResponseType' => '\\ebay\\StructType\\ExtendSiteHostedPicturesResponseType',
            'FetchTokenRequestType' => '\\ebay\\StructType\\FetchTokenRequestType',
            'FetchTokenResponseType' => '\\ebay\\StructType\\FetchTokenResponseType',
            'GetAccountRequestType' => '\\ebay\\StructType\\GetAccountRequestType',
            'GetAccountResponseType' => '\\ebay\\StructType\\GetAccountResponseType',
            'GetAdFormatLeadsRequestType' => '\\ebay\\StructType\\GetAdFormatLeadsRequestType',
            'GetAdFormatLeadsResponseType' => '\\ebay\\StructType\\GetAdFormatLeadsResponseType',
            'GetAllBiddersRequestType' => '\\ebay\\StructType\\GetAllBiddersRequestType',
            'GetAllBiddersResponseType' => '\\ebay\\StructType\\GetAllBiddersResponseType',
            'GetApiAccessRulesRequestType' => '\\ebay\\StructType\\GetApiAccessRulesRequestType',
            'GetApiAccessRulesResponseType' => '\\ebay\\StructType\\GetApiAccessRulesResponseType',
            'GetBestOffersRequestType' => '\\ebay\\StructType\\GetBestOffersRequestType',
            'GetBestOffersResponseType' => '\\ebay\\StructType\\GetBestOffersResponseType',
            'GetBidderListRequestType' => '\\ebay\\StructType\\GetBidderListRequestType',
            'GetBidderListResponseType' => '\\ebay\\StructType\\GetBidderListResponseType',
            'GetCategoriesRequestType' => '\\ebay\\StructType\\GetCategoriesRequestType',
            'GetCategoriesResponseType' => '\\ebay\\StructType\\GetCategoriesResponseType',
            'GetCategoryFeaturesRequestType' => '\\ebay\\StructType\\GetCategoryFeaturesRequestType',
            'GetCategoryFeaturesResponseType' => '\\ebay\\StructType\\GetCategoryFeaturesResponseType',
            'GetCategoryMappingsRequestType' => '\\ebay\\StructType\\GetCategoryMappingsRequestType',
            'GetCategoryMappingsResponseType' => '\\ebay\\StructType\\GetCategoryMappingsResponseType',
            'GetCategorySpecificsRequestType' => '\\ebay\\StructType\\GetCategorySpecificsRequestType',
            'GetCategorySpecificsResponseType' => '\\ebay\\StructType\\GetCategorySpecificsResponseType',
            'GetChallengeTokenRequestType' => '\\ebay\\StructType\\GetChallengeTokenRequestType',
            'GetChallengeTokenResponseType' => '\\ebay\\StructType\\GetChallengeTokenResponseType',
            'GetCharitiesRequestType' => '\\ebay\\StructType\\GetCharitiesRequestType',
            'GetCharitiesResponseType' => '\\ebay\\StructType\\GetCharitiesResponseType',
            'GetClientAlertsAuthTokenRequestType' => '\\ebay\\StructType\\GetClientAlertsAuthTokenRequestType',
            'GetClientAlertsAuthTokenResponseType' => '\\ebay\\StructType\\GetClientAlertsAuthTokenResponseType',
            'GetContextualKeywordsRequestType' => '\\ebay\\StructType\\GetContextualKeywordsRequestType',
            'GetContextualKeywordsResponseType' => '\\ebay\\StructType\\GetContextualKeywordsResponseType',
            'GetDescriptionTemplatesRequestType' => '\\ebay\\StructType\\GetDescriptionTemplatesRequestType',
            'GetDescriptionTemplatesResponseType' => '\\ebay\\StructType\\GetDescriptionTemplatesResponseType',
            'GetDisputeRequestType' => '\\ebay\\StructType\\GetDisputeRequestType',
            'GetDisputeResponseType' => '\\ebay\\StructType\\GetDisputeResponseType',
            'GetFeedbackRequestType' => '\\ebay\\StructType\\GetFeedbackRequestType',
            'GetFeedbackResponseType' => '\\ebay\\StructType\\GetFeedbackResponseType',
            'GetItemRequestType' => '\\ebay\\StructType\\GetItemRequestType',
            'GetItemResponseType' => '\\ebay\\StructType\\GetItemResponseType',
            'GetItemShippingRequestType' => '\\ebay\\StructType\\GetItemShippingRequestType',
            'GetItemShippingResponseType' => '\\ebay\\StructType\\GetItemShippingResponseType',
            'GetItemTransactionsRequestType' => '\\ebay\\StructType\\GetItemTransactionsRequestType',
            'GetItemTransactionsResponseType' => '\\ebay\\StructType\\GetItemTransactionsResponseType',
            'GetItemsAwaitingFeedbackRequestType' => '\\ebay\\StructType\\GetItemsAwaitingFeedbackRequestType',
            'GetItemsAwaitingFeedbackResponseType' => '\\ebay\\StructType\\GetItemsAwaitingFeedbackResponseType',
            'GetMemberMessagesRequestType' => '\\ebay\\StructType\\GetMemberMessagesRequestType',
            'GetMemberMessagesResponseType' => '\\ebay\\StructType\\GetMemberMessagesResponseType',
            'GetMessagePreferencesRequestType' => '\\ebay\\StructType\\GetMessagePreferencesRequestType',
            'GetMessagePreferencesResponseType' => '\\ebay\\StructType\\GetMessagePreferencesResponseType',
            'GetMyMessagesRequestType' => '\\ebay\\StructType\\GetMyMessagesRequestType',
            'GetMyMessagesResponseType' => '\\ebay\\StructType\\GetMyMessagesResponseType',
            'GetMyeBayBuyingRequestType' => '\\ebay\\StructType\\GetMyeBayBuyingRequestType',
            'GetMyeBayBuyingResponseType' => '\\ebay\\StructType\\GetMyeBayBuyingResponseType',
            'GetMyeBayRemindersRequestType' => '\\ebay\\StructType\\GetMyeBayRemindersRequestType',
            'GetMyeBayRemindersResponseType' => '\\ebay\\StructType\\GetMyeBayRemindersResponseType',
            'GetMyeBaySellingRequestType' => '\\ebay\\StructType\\GetMyeBaySellingRequestType',
            'GetMyeBaySellingResponseType' => '\\ebay\\StructType\\GetMyeBaySellingResponseType',
            'GetNotificationPreferencesRequestType' => '\\ebay\\StructType\\GetNotificationPreferencesRequestType',
            'GetNotificationPreferencesResponseType' => '\\ebay\\StructType\\GetNotificationPreferencesResponseType',
            'GetNotificationsUsageRequestType' => '\\ebay\\StructType\\GetNotificationsUsageRequestType',
            'GetNotificationsUsageResponseType' => '\\ebay\\StructType\\GetNotificationsUsageResponseType',
            'GetOrderTransactionsRequestType' => '\\ebay\\StructType\\GetOrderTransactionsRequestType',
            'GetOrderTransactionsResponseType' => '\\ebay\\StructType\\GetOrderTransactionsResponseType',
            'GetOrdersRequestType' => '\\ebay\\StructType\\GetOrdersRequestType',
            'GetOrdersResponseType' => '\\ebay\\StructType\\GetOrdersResponseType',
            'GetPromotionalSaleDetailsRequestType' => '\\ebay\\StructType\\GetPromotionalSaleDetailsRequestType',
            'GetPromotionalSaleDetailsResponseType' => '\\ebay\\StructType\\GetPromotionalSaleDetailsResponseType',
            'GetSellerDashboardRequestType' => '\\ebay\\StructType\\GetSellerDashboardRequestType',
            'GetSellerDashboardResponseType' => '\\ebay\\StructType\\GetSellerDashboardResponseType',
            'GetSellerEventsRequestType' => '\\ebay\\StructType\\GetSellerEventsRequestType',
            'GetSellerEventsResponseType' => '\\ebay\\StructType\\GetSellerEventsResponseType',
            'GetSellerListRequestType' => '\\ebay\\StructType\\GetSellerListRequestType',
            'GetSellerListResponseType' => '\\ebay\\StructType\\GetSellerListResponseType',
            'GetSellerPaymentsRequestType' => '\\ebay\\StructType\\GetSellerPaymentsRequestType',
            'GetSellerPaymentsResponseType' => '\\ebay\\StructType\\GetSellerPaymentsResponseType',
            'GetSellerTransactionsRequestType' => '\\ebay\\StructType\\GetSellerTransactionsRequestType',
            'GetSellerTransactionsResponseType' => '\\ebay\\StructType\\GetSellerTransactionsResponseType',
            'GetSellingManagerAlertsRequestType' => '\\ebay\\StructType\\GetSellingManagerAlertsRequestType',
            'GetSellingManagerAlertsResponseType' => '\\ebay\\StructType\\GetSellingManagerAlertsResponseType',
            'GetSellingManagerEmailLogRequestType' => '\\ebay\\StructType\\GetSellingManagerEmailLogRequestType',
            'GetSellingManagerEmailLogResponseType' => '\\ebay\\StructType\\GetSellingManagerEmailLogResponseType',
            'GetSellingManagerInventoryRequestType' => '\\ebay\\StructType\\GetSellingManagerInventoryRequestType',
            'GetSellingManagerInventoryResponseType' => '\\ebay\\StructType\\GetSellingManagerInventoryResponseType',
            'GetSellingManagerInventoryFolderRequestType' => '\\ebay\\StructType\\GetSellingManagerInventoryFolderRequestType',
            'GetSellingManagerInventoryFolderResponseType' => '\\ebay\\StructType\\GetSellingManagerInventoryFolderResponseType',
            'GetSellingManagerItemAutomationRuleRequestType' => '\\ebay\\StructType\\GetSellingManagerItemAutomationRuleRequestType',
            'GetSellingManagerItemAutomationRuleResponseType' => '\\ebay\\StructType\\GetSellingManagerItemAutomationRuleResponseType',
            'GetSellingManagerSaleRecordRequestType' => '\\ebay\\StructType\\GetSellingManagerSaleRecordRequestType',
            'GetSellingManagerSaleRecordResponseType' => '\\ebay\\StructType\\GetSellingManagerSaleRecordResponseType',
            'GetSellingManagerSoldListingsRequestType' => '\\ebay\\StructType\\GetSellingManagerSoldListingsRequestType',
            'GetSellingManagerSoldListingsResponseType' => '\\ebay\\StructType\\GetSellingManagerSoldListingsResponseType',
            'GetSellingManagerTemplateAutomationRuleRequestType' => '\\ebay\\StructType\\GetSellingManagerTemplateAutomationRuleRequestType',
            'GetSellingManagerTemplateAutomationRuleResponseType' => '\\ebay\\StructType\\GetSellingManagerTemplateAutomationRuleResponseType',
            'GetSellingManagerTemplatesRequestType' => '\\ebay\\StructType\\GetSellingManagerTemplatesRequestType',
            'GetSellingManagerTemplatesResponseType' => '\\ebay\\StructType\\GetSellingManagerTemplatesResponseType',
            'GetSessionIDRequestType' => '\\ebay\\StructType\\GetSessionIDRequestType',
            'GetSessionIDResponseType' => '\\ebay\\StructType\\GetSessionIDResponseType',
            'GetShippingDiscountProfilesRequestType' => '\\ebay\\StructType\\GetShippingDiscountProfilesRequestType',
            'GetShippingDiscountProfilesResponseType' => '\\ebay\\StructType\\GetShippingDiscountProfilesResponseType',
            'GetStoreRequestType' => '\\ebay\\StructType\\GetStoreRequestType',
            'GetStoreResponseType' => '\\ebay\\StructType\\GetStoreResponseType',
            'GetStoreCategoryUpdateStatusRequestType' => '\\ebay\\StructType\\GetStoreCategoryUpdateStatusRequestType',
            'GetStoreCategoryUpdateStatusResponseType' => '\\ebay\\StructType\\GetStoreCategoryUpdateStatusResponseType',
            'GetStoreCustomPageRequestType' => '\\ebay\\StructType\\GetStoreCustomPageRequestType',
            'GetStoreCustomPageResponseType' => '\\ebay\\StructType\\GetStoreCustomPageResponseType',
            'GetStoreOptionsRequestType' => '\\ebay\\StructType\\GetStoreOptionsRequestType',
            'GetStoreOptionsResponseType' => '\\ebay\\StructType\\GetStoreOptionsResponseType',
            'GetStorePreferencesRequestType' => '\\ebay\\StructType\\GetStorePreferencesRequestType',
            'GetStorePreferencesResponseType' => '\\ebay\\StructType\\GetStorePreferencesResponseType',
            'GetSuggestedCategoriesRequestType' => '\\ebay\\StructType\\GetSuggestedCategoriesRequestType',
            'GetSuggestedCategoriesResponseType' => '\\ebay\\StructType\\GetSuggestedCategoriesResponseType',
            'GetTaxTableRequestType' => '\\ebay\\StructType\\GetTaxTableRequestType',
            'GetTaxTableResponseType' => '\\ebay\\StructType\\GetTaxTableResponseType',
            'GetTokenStatusRequestType' => '\\ebay\\StructType\\GetTokenStatusRequestType',
            'GetTokenStatusResponseType' => '\\ebay\\StructType\\GetTokenStatusResponseType',
            'GetUserRequestType' => '\\ebay\\StructType\\GetUserRequestType',
            'GetUserResponseType' => '\\ebay\\StructType\\GetUserResponseType',
            'GetUserContactDetailsRequestType' => '\\ebay\\StructType\\GetUserContactDetailsRequestType',
            'GetUserContactDetailsResponseType' => '\\ebay\\StructType\\GetUserContactDetailsResponseType',
            'GetUserDisputesRequestType' => '\\ebay\\StructType\\GetUserDisputesRequestType',
            'GetUserDisputesResponseType' => '\\ebay\\StructType\\GetUserDisputesResponseType',
            'GetUserPreferencesRequestType' => '\\ebay\\StructType\\GetUserPreferencesRequestType',
            'GetUserPreferencesResponseType' => '\\ebay\\StructType\\GetUserPreferencesResponseType',
            'GetVeROReasonCodeDetailsRequestType' => '\\ebay\\StructType\\GetVeROReasonCodeDetailsRequestType',
            'GetVeROReasonCodeDetailsResponseType' => '\\ebay\\StructType\\GetVeROReasonCodeDetailsResponseType',
            'GetVeROReportStatusRequestType' => '\\ebay\\StructType\\GetVeROReportStatusRequestType',
            'GetVeROReportStatusResponseType' => '\\ebay\\StructType\\GetVeROReportStatusResponseType',
            'GeteBayDetailsRequestType' => '\\ebay\\StructType\\GeteBayDetailsRequestType',
            'GeteBayDetailsResponseType' => '\\ebay\\StructType\\GeteBayDetailsResponseType',
            'GeteBayOfficialTimeRequestType' => '\\ebay\\StructType\\GeteBayOfficialTimeRequestType',
            'GeteBayOfficialTimeResponseType' => '\\ebay\\StructType\\GeteBayOfficialTimeResponseType',
            'IssueRefundRequestType' => '\\ebay\\StructType\\IssueRefundRequestType',
            'IssueRefundResponseType' => '\\ebay\\StructType\\IssueRefundResponseType',
            'LeaveFeedbackRequestType' => '\\ebay\\StructType\\LeaveFeedbackRequestType',
            'LeaveFeedbackResponseType' => '\\ebay\\StructType\\LeaveFeedbackResponseType',
            'MoveSellingManagerInventoryFolderRequestType' => '\\ebay\\StructType\\MoveSellingManagerInventoryFolderRequestType',
            'MoveSellingManagerInventoryFolderResponseType' => '\\ebay\\StructType\\MoveSellingManagerInventoryFolderResponseType',
            'PlaceOfferRequestType' => '\\ebay\\StructType\\PlaceOfferRequestType',
            'PlaceOfferResponseType' => '\\ebay\\StructType\\PlaceOfferResponseType',
            'RelistFixedPriceItemRequestType' => '\\ebay\\StructType\\RelistFixedPriceItemRequestType',
            'RelistFixedPriceItemResponseType' => '\\ebay\\StructType\\RelistFixedPriceItemResponseType',
            'RelistItemRequestType' => '\\ebay\\StructType\\RelistItemRequestType',
            'RelistItemResponseType' => '\\ebay\\StructType\\RelistItemResponseType',
            'RemoveFromWatchListRequestType' => '\\ebay\\StructType\\RemoveFromWatchListRequestType',
            'RemoveFromWatchListResponseType' => '\\ebay\\StructType\\RemoveFromWatchListResponseType',
            'RespondToBestOfferRequestType' => '\\ebay\\StructType\\RespondToBestOfferRequestType',
            'RespondToBestOfferResponseType' => '\\ebay\\StructType\\RespondToBestOfferResponseType',
            'RespondToFeedbackRequestType' => '\\ebay\\StructType\\RespondToFeedbackRequestType',
            'RespondToFeedbackResponseType' => '\\ebay\\StructType\\RespondToFeedbackResponseType',
            'ReviseCheckoutStatusRequestType' => '\\ebay\\StructType\\ReviseCheckoutStatusRequestType',
            'ReviseCheckoutStatusResponseType' => '\\ebay\\StructType\\ReviseCheckoutStatusResponseType',
            'ReviseFixedPriceItemRequestType' => '\\ebay\\StructType\\ReviseFixedPriceItemRequestType',
            'ReviseFixedPriceItemResponseType' => '\\ebay\\StructType\\ReviseFixedPriceItemResponseType',
            'ReviseInventoryStatusRequestType' => '\\ebay\\StructType\\ReviseInventoryStatusRequestType',
            'ReviseInventoryStatusResponseType' => '\\ebay\\StructType\\ReviseInventoryStatusResponseType',
            'ReviseItemRequestType' => '\\ebay\\StructType\\ReviseItemRequestType',
            'ReviseItemResponseType' => '\\ebay\\StructType\\ReviseItemResponseType',
            'ReviseMyMessagesRequestType' => '\\ebay\\StructType\\ReviseMyMessagesRequestType',
            'ReviseMyMessagesResponseType' => '\\ebay\\StructType\\ReviseMyMessagesResponseType',
            'ReviseMyMessagesFoldersRequestType' => '\\ebay\\StructType\\ReviseMyMessagesFoldersRequestType',
            'ReviseMyMessagesFoldersResponseType' => '\\ebay\\StructType\\ReviseMyMessagesFoldersResponseType',
            'ReviseSellingManagerInventoryFolderRequestType' => '\\ebay\\StructType\\ReviseSellingManagerInventoryFolderRequestType',
            'ReviseSellingManagerInventoryFolderResponseType' => '\\ebay\\StructType\\ReviseSellingManagerInventoryFolderResponseType',
            'ReviseSellingManagerProductRequestType' => '\\ebay\\StructType\\ReviseSellingManagerProductRequestType',
            'ReviseSellingManagerProductResponseType' => '\\ebay\\StructType\\ReviseSellingManagerProductResponseType',
            'ReviseSellingManagerSaleRecordRequestType' => '\\ebay\\StructType\\ReviseSellingManagerSaleRecordRequestType',
            'ReviseSellingManagerSaleRecordResponseType' => '\\ebay\\StructType\\ReviseSellingManagerSaleRecordResponseType',
            'ReviseSellingManagerTemplateRequestType' => '\\ebay\\StructType\\ReviseSellingManagerTemplateRequestType',
            'ReviseSellingManagerTemplateResponseType' => '\\ebay\\StructType\\ReviseSellingManagerTemplateResponseType',
            'RevokeTokenRequestType' => '\\ebay\\StructType\\RevokeTokenRequestType',
            'RevokeTokenResponseType' => '\\ebay\\StructType\\RevokeTokenResponseType',
            'SaveItemToSellingManagerTemplateRequestType' => '\\ebay\\StructType\\SaveItemToSellingManagerTemplateRequestType',
            'SaveItemToSellingManagerTemplateResponseType' => '\\ebay\\StructType\\SaveItemToSellingManagerTemplateResponseType',
            'SellerReverseDisputeRequestType' => '\\ebay\\StructType\\SellerReverseDisputeRequestType',
            'SellerReverseDisputeResponseType' => '\\ebay\\StructType\\SellerReverseDisputeResponseType',
            'SendInvoiceRequestType' => '\\ebay\\StructType\\SendInvoiceRequestType',
            'SendInvoiceResponseType' => '\\ebay\\StructType\\SendInvoiceResponseType',
            'SetMessagePreferencesRequestType' => '\\ebay\\StructType\\SetMessagePreferencesRequestType',
            'SetMessagePreferencesResponseType' => '\\ebay\\StructType\\SetMessagePreferencesResponseType',
            'SetNotificationPreferencesRequestType' => '\\ebay\\StructType\\SetNotificationPreferencesRequestType',
            'SetNotificationPreferencesResponseType' => '\\ebay\\StructType\\SetNotificationPreferencesResponseType',
            'SetPromotionalSaleRequestType' => '\\ebay\\StructType\\SetPromotionalSaleRequestType',
            'SetPromotionalSaleResponseType' => '\\ebay\\StructType\\SetPromotionalSaleResponseType',
            'SetPromotionalSaleListingsRequestType' => '\\ebay\\StructType\\SetPromotionalSaleListingsRequestType',
            'SetPromotionalSaleListingsResponseType' => '\\ebay\\StructType\\SetPromotionalSaleListingsResponseType',
            'SetSellingManagerFeedbackOptionsRequestType' => '\\ebay\\StructType\\SetSellingManagerFeedbackOptionsRequestType',
            'SetSellingManagerFeedbackOptionsResponseType' => '\\ebay\\StructType\\SetSellingManagerFeedbackOptionsResponseType',
            'SetSellingManagerItemAutomationRuleRequestType' => '\\ebay\\StructType\\SetSellingManagerItemAutomationRuleRequestType',
            'SetSellingManagerItemAutomationRuleResponseType' => '\\ebay\\StructType\\SetSellingManagerItemAutomationRuleResponseType',
            'SetSellingManagerTemplateAutomationRuleRequestType' => '\\ebay\\StructType\\SetSellingManagerTemplateAutomationRuleRequestType',
            'SetSellingManagerTemplateAutomationRuleResponseType' => '\\ebay\\StructType\\SetSellingManagerTemplateAutomationRuleResponseType',
            'SetShippingDiscountProfilesRequestType' => '\\ebay\\StructType\\SetShippingDiscountProfilesRequestType',
            'SetShippingDiscountProfilesResponseType' => '\\ebay\\StructType\\SetShippingDiscountProfilesResponseType',
            'SetStoreRequestType' => '\\ebay\\StructType\\SetStoreRequestType',
            'SetStoreResponseType' => '\\ebay\\StructType\\SetStoreResponseType',
            'SetStoreCategoriesRequestType' => '\\ebay\\StructType\\SetStoreCategoriesRequestType',
            'SetStoreCategoriesResponseType' => '\\ebay\\StructType\\SetStoreCategoriesResponseType',
            'SetStoreCustomPageRequestType' => '\\ebay\\StructType\\SetStoreCustomPageRequestType',
            'SetStoreCustomPageResponseType' => '\\ebay\\StructType\\SetStoreCustomPageResponseType',
            'SetStorePreferencesRequestType' => '\\ebay\\StructType\\SetStorePreferencesRequestType',
            'SetStorePreferencesResponseType' => '\\ebay\\StructType\\SetStorePreferencesResponseType',
            'SetTaxTableRequestType' => '\\ebay\\StructType\\SetTaxTableRequestType',
            'SetTaxTableResponseType' => '\\ebay\\StructType\\SetTaxTableResponseType',
            'SetUserNotesRequestType' => '\\ebay\\StructType\\SetUserNotesRequestType',
            'SetUserNotesResponseType' => '\\ebay\\StructType\\SetUserNotesResponseType',
            'SetUserPreferencesRequestType' => '\\ebay\\StructType\\SetUserPreferencesRequestType',
            'SetUserPreferencesResponseType' => '\\ebay\\StructType\\SetUserPreferencesResponseType',
            'UploadSiteHostedPicturesRequestType' => '\\ebay\\StructType\\UploadSiteHostedPicturesRequestType',
            'UploadSiteHostedPicturesResponseType' => '\\ebay\\StructType\\UploadSiteHostedPicturesResponseType',
            'ValidateChallengeInputRequestType' => '\\ebay\\StructType\\ValidateChallengeInputRequestType',
            'ValidateChallengeInputResponseType' => '\\ebay\\StructType\\ValidateChallengeInputResponseType',
            'ValidateTestUserRegistrationRequestType' => '\\ebay\\StructType\\ValidateTestUserRegistrationRequestType',
            'ValidateTestUserRegistrationResponseType' => '\\ebay\\StructType\\ValidateTestUserRegistrationResponseType',
            'VeROReportItemsRequestType' => '\\ebay\\StructType\\VeROReportItemsRequestType',
            'VeROReportItemsResponseType' => '\\ebay\\StructType\\VeROReportItemsResponseType',
            'VerifyAddFixedPriceItemRequestType' => '\\ebay\\StructType\\VerifyAddFixedPriceItemRequestType',
            'VerifyAddFixedPriceItemResponseType' => '\\ebay\\StructType\\VerifyAddFixedPriceItemResponseType',
            'VerifyAddItemRequestType' => '\\ebay\\StructType\\VerifyAddItemRequestType',
            'VerifyAddItemResponseType' => '\\ebay\\StructType\\VerifyAddItemResponseType',
            'VerifyAddSecondChanceItemRequestType' => '\\ebay\\StructType\\VerifyAddSecondChanceItemRequestType',
            'VerifyAddSecondChanceItemResponseType' => '\\ebay\\StructType\\VerifyAddSecondChanceItemResponseType',
            'VerifyRelistItemRequestType' => '\\ebay\\StructType\\VerifyRelistItemRequestType',
            'VerifyRelistItemResponseType' => '\\ebay\\StructType\\VerifyRelistItemResponseType',
            'AbstractRequestType' => '\\ebay\\StructType\\AbstractRequestType',
            'AbstractResponseType' => '\\ebay\\StructType\\AbstractResponseType',
            'BotBlockRequestType' => '\\ebay\\StructType\\BotBlockRequestType',
            'BotBlockResponseType' => '\\ebay\\StructType\\BotBlockResponseType',
            'CustomSecurityHeaderType' => '\\ebay\\StructType\\CustomSecurityHeaderType',
            'DisputeFilterCountType' => '\\ebay\\StructType\\DisputeFilterCountType',
            'DisputeMessageType' => '\\ebay\\StructType\\DisputeMessageType',
            'DisputeResolutionType' => '\\ebay\\StructType\\DisputeResolutionType',
            'DuplicateInvocationDetailsType' => '\\ebay\\StructType\\DuplicateInvocationDetailsType',
            'ErrorParameterType' => '\\ebay\\StructType\\ErrorParameterType',
            'ErrorType' => '\\ebay\\StructType\\ErrorType',
            'FaultDetailsType' => '\\ebay\\StructType\\FaultDetailsType',
            'MeasureType' => '\\ebay\\StructType\\MeasureType',
            'PaginationType' => '\\ebay\\StructType\\PaginationType',
            'QuantityType' => '\\ebay\\StructType\\QuantityType',
            'UserIdPasswordType' => '\\ebay\\StructType\\UserIdPasswordType',
            'XMLRequesterCredentialsType' => '\\ebay\\StructType\\XMLRequesterCredentialsType',
            'ASQPreferencesType' => '\\ebay\\StructType\\ASQPreferencesType',
            'AccountEntriesType' => '\\ebay\\StructType\\AccountEntriesType',
            'AccountEntryType' => '\\ebay\\StructType\\AccountEntryType',
            'AccountSummaryType' => '\\ebay\\StructType\\AccountSummaryType',
            'AdFormatEnabledDefinitionType' => '\\ebay\\StructType\\AdFormatEnabledDefinitionType',
            'AdFormatLeadType' => '\\ebay\\StructType\\AdFormatLeadType',
            'AddItemRequestContainerType' => '\\ebay\\StructType\\AddItemRequestContainerType',
            'AddItemResponseContainerType' => '\\ebay\\StructType\\AddItemResponseContainerType',
            'AddMemberMessagesAAQToBidderRequestContainerType' => '\\ebay\\StructType\\AddMemberMessagesAAQToBidderRequestContainerType',
            'AddMemberMessagesAAQToBidderResponseContainerType' => '\\ebay\\StructType\\AddMemberMessagesAAQToBidderResponseContainerType',
            'AdditionalAccountType' => '\\ebay\\StructType\\AdditionalAccountType',
            'AdditionalCompatibilityEnabledDefinitionType' => '\\ebay\\StructType\\AdditionalCompatibilityEnabledDefinitionType',
            'AddressAttributeType' => '\\ebay\\StructType\\AddressAttributeType',
            'AddressType' => '\\ebay\\StructType\\AddressType',
            'AffiliateTrackingDetailsType' => '\\ebay\\StructType\\AffiliateTrackingDetailsType',
            'AmountType' => '\\ebay\\StructType\\AmountType',
            'AnnouncementMessageType' => '\\ebay\\StructType\\AnnouncementMessageType',
            'ApiAccessRuleType' => '\\ebay\\StructType\\ApiAccessRuleType',
            'ApplicationDeliveryPreferencesType' => '\\ebay\\StructType\\ApplicationDeliveryPreferencesType',
            'AttributeArrayType' => '\\ebay\\ArrayType\\AttributeArrayType',
            'AttributeConversionEnabledFeatureDefinitionType' => '\\ebay\\StructType\\AttributeConversionEnabledFeatureDefinitionType',
            'AttributeRecommendationsType' => '\\ebay\\StructType\\AttributeRecommendationsType',
            'AttributeSetArrayType' => '\\ebay\\ArrayType\\AttributeSetArrayType',
            'AttributeSetType' => '\\ebay\\StructType\\AttributeSetType',
            'AttributeType' => '\\ebay\\StructType\\AttributeType',
            'AverageRatingDetailArrayType' => '\\ebay\\ArrayType\\AverageRatingDetailArrayType',
            'AverageRatingDetailsType' => '\\ebay\\StructType\\AverageRatingDetailsType',
            'AverageRatingSummaryType' => '\\ebay\\StructType\\AverageRatingSummaryType',
            'Base64BinaryType' => '\\ebay\\StructType\\Base64BinaryType',
            'BasicAmountType' => '\\ebay\\StructType\\BasicAmountType',
            'BasicUpgradePackEnabledDefinitionType' => '\\ebay\\StructType\\BasicUpgradePackEnabledDefinitionType',
            'BestOfferArrayType' => '\\ebay\\ArrayType\\BestOfferArrayType',
            'BestOfferAutoAcceptEnabledDefinitionType' => '\\ebay\\StructType\\BestOfferAutoAcceptEnabledDefinitionType',
            'BestOfferAutoDeclineEnabledDefinitionType' => '\\ebay\\StructType\\BestOfferAutoDeclineEnabledDefinitionType',
            'BestOfferCounterEnabledDefinitionType' => '\\ebay\\StructType\\BestOfferCounterEnabledDefinitionType',
            'BestOfferDetailsType' => '\\ebay\\StructType\\BestOfferDetailsType',
            'BestOfferEnabledDefinitionType' => '\\ebay\\StructType\\BestOfferEnabledDefinitionType',
            'BestOfferType' => '\\ebay\\StructType\\BestOfferType',
            'BidApprovalArrayType' => '\\ebay\\ArrayType\\BidApprovalArrayType',
            'BidApprovalType' => '\\ebay\\StructType\\BidApprovalType',
            'BidAssistantListType' => '\\ebay\\StructType\\BidAssistantListType',
            'BidGroupArrayType' => '\\ebay\\ArrayType\\BidGroupArrayType',
            'BidGroupItemType' => '\\ebay\\StructType\\BidGroupItemType',
            'BidGroupType' => '\\ebay\\StructType\\BidGroupType',
            'BidderDetailArrayType' => '\\ebay\\ArrayType\\BidderDetailArrayType',
            'BidderDetailType' => '\\ebay\\StructType\\BidderDetailType',
            'BidderNoticePreferencesType' => '\\ebay\\StructType\\BidderNoticePreferencesType',
            'BiddingDetailsType' => '\\ebay\\StructType\\BiddingDetailsType',
            'BiddingSummaryType' => '\\ebay\\StructType\\BiddingSummaryType',
            'BrandMPNIdentifierEnabledDefinitionType' => '\\ebay\\StructType\\BrandMPNIdentifierEnabledDefinitionType',
            'BrandMPNType' => '\\ebay\\StructType\\BrandMPNType',
            'BusinessSellerDetailsType' => '\\ebay\\StructType\\BusinessSellerDetailsType',
            'BuyerGuaranteeEnabledDefinitionType' => '\\ebay\\StructType\\BuyerGuaranteeEnabledDefinitionType',
            'BuyerPackageEnclosureType' => '\\ebay\\StructType\\BuyerPackageEnclosureType',
            'BuyerPackageEnclosuresType' => '\\ebay\\StructType\\BuyerPackageEnclosuresType',
            'BuyerProtectionDetailsType' => '\\ebay\\StructType\\BuyerProtectionDetailsType',
            'BuyerRequirementDetailsType' => '\\ebay\\StructType\\BuyerRequirementDetailsType',
            'BuyerRoleMetricsType' => '\\ebay\\StructType\\BuyerRoleMetricsType',
            'BuyerSatisfactionDashboardType' => '\\ebay\\StructType\\BuyerSatisfactionDashboardType',
            'BuyerType' => '\\ebay\\StructType\\BuyerType',
            'BuyingGuideDetailsType' => '\\ebay\\StructType\\BuyingGuideDetailsType',
            'BuyingGuideType' => '\\ebay\\StructType\\BuyingGuideType',
            'BuyingSummaryType' => '\\ebay\\StructType\\BuyingSummaryType',
            'CalculatedHandlingDiscountType' => '\\ebay\\StructType\\CalculatedHandlingDiscountType',
            'CalculatedShippingDiscountType' => '\\ebay\\StructType\\CalculatedShippingDiscountType',
            'CalculatedShippingPreferencesType' => '\\ebay\\StructType\\CalculatedShippingPreferencesType',
            'CalculatedShippingRateType' => '\\ebay\\StructType\\CalculatedShippingRateType',
            'CancelDetailType' => '\\ebay\\StructType\\CancelDetailType',
            'CancelOfferArrayType' => '\\ebay\\StructType\\CancelOfferArrayType',
            'CancelOfferType' => '\\ebay\\StructType\\CancelOfferType',
            'CartItemType' => '\\ebay\\StructType\\CartItemType',
            'CatalogProductType' => '\\ebay\\StructType\\CatalogProductType',
            'CategoryArrayType' => '\\ebay\\ArrayType\\CategoryArrayType',
            'CategoryFeatureType' => '\\ebay\\StructType\\CategoryFeatureType',
            'CategoryGroupType' => '\\ebay\\StructType\\CategoryGroupType',
            'CategoryItemSpecificsType' => '\\ebay\\StructType\\CategoryItemSpecificsType',
            'CategoryMappingType' => '\\ebay\\StructType\\CategoryMappingType',
            'CategoryType' => '\\ebay\\StructType\\CategoryType',
            'CharacteristicSetIDsType' => '\\ebay\\StructType\\CharacteristicSetIDsType',
            'CharacteristicType' => '\\ebay\\StructType\\CharacteristicType',
            'CharacteristicsSetProductHistogramType' => '\\ebay\\StructType\\CharacteristicsSetProductHistogramType',
            'CharacteristicsSetType' => '\\ebay\\StructType\\CharacteristicsSetType',
            'CharityAffiliationDetailType' => '\\ebay\\StructType\\CharityAffiliationDetailType',
            'CharityAffiliationDetailsType' => '\\ebay\\StructType\\CharityAffiliationDetailsType',
            'CharityAffiliationType' => '\\ebay\\StructType\\CharityAffiliationType',
            'CharityAffiliationsType' => '\\ebay\\StructType\\CharityAffiliationsType',
            'CharityIDType' => '\\ebay\\StructType\\CharityIDType',
            'CharityInfoType' => '\\ebay\\StructType\\CharityInfoType',
            'NonProfitSocialAddressType' => '\\ebay\\StructType\\NonProfitSocialAddressType',
            'CharitySellerType' => '\\ebay\\StructType\\CharitySellerType',
            'CharityType' => '\\ebay\\StructType\\CharityType',
            'CheckoutOrderDetailType' => '\\ebay\\StructType\\CheckoutOrderDetailType',
            'CheckoutStatusType' => '\\ebay\\StructType\\CheckoutStatusType',
            'ClassifiedAdAutoAcceptEnabledDefinitionType' => '\\ebay\\StructType\\ClassifiedAdAutoAcceptEnabledDefinitionType',
            'ClassifiedAdAutoDeclineEnabledDefinitionType' => '\\ebay\\StructType\\ClassifiedAdAutoDeclineEnabledDefinitionType',
            'ClassifiedAdBestOfferEnabledDefinitionType' => '\\ebay\\StructType\\ClassifiedAdBestOfferEnabledDefinitionType',
            'ClassifiedAdCompanyNameEnabledDefinitionType' => '\\ebay\\StructType\\ClassifiedAdCompanyNameEnabledDefinitionType',
            'ClassifiedAdContactByAddressEnabledDefinitionType' => '\\ebay\\StructType\\ClassifiedAdContactByAddressEnabledDefinitionType',
            'ClassifiedAdContactByEmailEnabledDefintionType' => '\\ebay\\StructType\\ClassifiedAdContactByEmailEnabledDefintionType',
            'ClassifiedAdContactByPhoneEnabledDefinitionType' => '\\ebay\\StructType\\ClassifiedAdContactByPhoneEnabledDefinitionType',
            'ClassifiedAdCounterOfferEnabledDefinitionType' => '\\ebay\\StructType\\ClassifiedAdCounterOfferEnabledDefinitionType',
            'ClassifiedAdPayPerLeadEnabledDefinitionType' => '\\ebay\\StructType\\ClassifiedAdPayPerLeadEnabledDefinitionType',
            'ClassifiedAdPaymentMethodEnabledDefinitionType' => '\\ebay\\StructType\\ClassifiedAdPaymentMethodEnabledDefinitionType',
            'ClassifiedAdPhoneCountDefinitionType' => '\\ebay\\StructType\\ClassifiedAdPhoneCountDefinitionType',
            'ClassifiedAdShippingMethodEnabledDefinitionType' => '\\ebay\\StructType\\ClassifiedAdShippingMethodEnabledDefinitionType',
            'ClassifiedAdStreetCountDefinitionType' => '\\ebay\\StructType\\ClassifiedAdStreetCountDefinitionType',
            'CombinedFixedPriceTreatmentEnabledDefinitionType' => '\\ebay\\StructType\\CombinedFixedPriceTreatmentEnabledDefinitionType',
            'CombinedPaymentPreferencesType' => '\\ebay\\StructType\\CombinedPaymentPreferencesType',
            'CompatibleVehicleTypeDefinitionType' => '\\ebay\\StructType\\CompatibleVehicleTypeDefinitionType',
            'ConditionEnabledDefinitionType' => '\\ebay\\StructType\\ConditionEnabledDefinitionType',
            'ConditionType' => '\\ebay\\StructType\\ConditionType',
            'ConditionValuesDefinitionType' => '\\ebay\\StructType\\ConditionValuesDefinitionType',
            'ConditionValuesType' => '\\ebay\\StructType\\ConditionValuesType',
            'ContactHoursDetailsType' => '\\ebay\\StructType\\ContactHoursDetailsType',
            'ContextSearchAssetType' => '\\ebay\\StructType\\ContextSearchAssetType',
            'CountryDetailsType' => '\\ebay\\StructType\\CountryDetailsType',
            'CrossBorderTradeAustraliaEnabledDefinitionType' => '\\ebay\\StructType\\CrossBorderTradeAustraliaEnabledDefinitionType',
            'CrossBorderTradeGBEnabledDefinitionType' => '\\ebay\\StructType\\CrossBorderTradeGBEnabledDefinitionType',
            'CrossBorderTradeNorthAmericaEnabledDefinitionType' => '\\ebay\\StructType\\CrossBorderTradeNorthAmericaEnabledDefinitionType',
            'CrossPromotionPreferencesType' => '\\ebay\\StructType\\CrossPromotionPreferencesType',
            'CrossPromotionsType' => '\\ebay\\StructType\\CrossPromotionsType',
            'CurrencyDetailsType' => '\\ebay\\StructType\\CurrencyDetailsType',
            'DataElementSetType' => '\\ebay\\StructType\\DataElementSetType',
            'DateType' => '\\ebay\\StructType\\DateType',
            'DeliveryDetailsType' => '\\ebay\\StructType\\DeliveryDetailsType',
            'DeliveryStatusType' => '\\ebay\\StructType\\DeliveryStatusType',
            'DeliveryURLDetailType' => '\\ebay\\StructType\\DeliveryURLDetailType',
            'DepositSupportedDefinitionType' => '\\ebay\\StructType\\DepositSupportedDefinitionType',
            'DescriptionTemplateType' => '\\ebay\\StructType\\DescriptionTemplateType',
            'DigitalDeliverySelectedType' => '\\ebay\\StructType\\DigitalDeliverySelectedType',
            'DigitalDeliveryUserType' => '\\ebay\\StructType\\DigitalDeliveryUserType',
            'DigitalGoodDeliveryEnabledDefinitionType' => '\\ebay\\StructType\\DigitalGoodDeliveryEnabledDefinitionType',
            'DigitalGoodInfoType' => '\\ebay\\StructType\\DigitalGoodInfoType',
            'DiscountPriceInfoType' => '\\ebay\\StructType\\DiscountPriceInfoType',
            'DiscountProfileType' => '\\ebay\\StructType\\DiscountProfileType',
            'DispatchCutoffTimePreferencesType' => '\\ebay\\StructType\\DispatchCutoffTimePreferencesType',
            'DispatchTimeMaxDetailsType' => '\\ebay\\StructType\\DispatchTimeMaxDetailsType',
            'DisputeArrayType' => '\\ebay\\ArrayType\\DisputeArrayType',
            'DisputeType' => '\\ebay\\StructType\\DisputeType',
            'DistanceType' => '\\ebay\\StructType\\DistanceType',
            'DutchBINEnabledDefinitionType' => '\\ebay\\StructType\\DutchBINEnabledDefinitionType',
            'EANEnabledDefinitionType' => '\\ebay\\StructType\\EANEnabledDefinitionType',
            'EANIdentifierEnabledDefinitionType' => '\\ebay\\StructType\\EANIdentifierEnabledDefinitionType',
            'EndItemRequestContainerType' => '\\ebay\\StructType\\EndItemRequestContainerType',
            'EndItemResponseContainerType' => '\\ebay\\StructType\\EndItemResponseContainerType',
            'EndOfAuctionEmailPreferencesType' => '\\ebay\\StructType\\EndOfAuctionEmailPreferencesType',
            'EpidSupportedDefinitionType' => '\\ebay\\StructType\\EpidSupportedDefinitionType',
            'ExcludeShippingLocationDetailsType' => '\\ebay\\StructType\\ExcludeShippingLocationDetailsType',
            'ExpressConditionRequiredDefinitionType' => '\\ebay\\StructType\\ExpressConditionRequiredDefinitionType',
            'ExpressEnabledDefinitionType' => '\\ebay\\StructType\\ExpressEnabledDefinitionType',
            'ExpressItemRequirementsType' => '\\ebay\\StructType\\ExpressItemRequirementsType',
            'ExpressPicturesRequiredDefinitionType' => '\\ebay\\StructType\\ExpressPicturesRequiredDefinitionType',
            'ExtendedContactDetailsType' => '\\ebay\\StructType\\ExtendedContactDetailsType',
            'ExtendedPictureDetailsType' => '\\ebay\\StructType\\ExtendedPictureDetailsType',
            'ExtendedProductFinderIDType' => '\\ebay\\StructType\\ExtendedProductFinderIDType',
            'ExternalAlertIDArrayType' => '\\ebay\\ArrayType\\ExternalAlertIDArrayType',
            'ExternalProductIDType' => '\\ebay\\StructType\\ExternalProductIDType',
            'ExternalTransactionType' => '\\ebay\\StructType\\ExternalTransactionType',
            'FeatureDefinitionsType' => '\\ebay\\StructType\\FeatureDefinitionsType',
            'FeatureEligibilityType' => '\\ebay\\StructType\\FeatureEligibilityType',
            'FeeType' => '\\ebay\\StructType\\FeeType',
            'FeedbackCommentArrayType' => '\\ebay\\ArrayType\\FeedbackCommentArrayType',
            'FeedbackDetailArrayType' => '\\ebay\\ArrayType\\FeedbackDetailArrayType',
            'FeedbackDetailType' => '\\ebay\\StructType\\FeedbackDetailType',
            'FeedbackInfoType' => '\\ebay\\StructType\\FeedbackInfoType',
            'FeedbackPeriodArrayType' => '\\ebay\\ArrayType\\FeedbackPeriodArrayType',
            'FeedbackPeriodType' => '\\ebay\\StructType\\FeedbackPeriodType',
            'FeedbackRequirementsType' => '\\ebay\\StructType\\FeedbackRequirementsType',
            'FeedbackSummaryType' => '\\ebay\\StructType\\FeedbackSummaryType',
            'FeesType' => '\\ebay\\StructType\\FeesType',
            'FlatRateInsuranceRangeCostType' => '\\ebay\\StructType\\FlatRateInsuranceRangeCostType',
            'FlatShippingDiscountType' => '\\ebay\\StructType\\FlatShippingDiscountType',
            'FlatShippingPreferencesType' => '\\ebay\\StructType\\FlatShippingPreferencesType',
            'FreeGalleryPlusEnabledDefinitionType' => '\\ebay\\StructType\\FreeGalleryPlusEnabledDefinitionType',
            'FreePicturePackEnabledDefinitionType' => '\\ebay\\StructType\\FreePicturePackEnabledDefinitionType',
            'GetRecommendationsRequestContainerType' => '\\ebay\\StructType\\GetRecommendationsRequestContainerType',
            'GetRecommendationsResponseContainerType' => '\\ebay\\StructType\\GetRecommendationsResponseContainerType',
            'GiftSummaryType' => '\\ebay\\StructType\\GiftSummaryType',
            'GlobalShippingEnabledDefinitionType' => '\\ebay\\StructType\\GlobalShippingEnabledDefinitionType',
            'Group1MaxFlatShippingCostDefinitionType' => '\\ebay\\StructType\\Group1MaxFlatShippingCostDefinitionType',
            'Group2MaxFlatShippingCostDefinitionType' => '\\ebay\\StructType\\Group2MaxFlatShippingCostDefinitionType',
            'Group3MaxFlatShippingCostDefinitionType' => '\\ebay\\StructType\\Group3MaxFlatShippingCostDefinitionType',
            'GroupValidationRulesType' => '\\ebay\\StructType\\GroupValidationRulesType',
            'HandlingTimeEnabledDefinitionType' => '\\ebay\\StructType\\HandlingTimeEnabledDefinitionType',
            'HistogramEntryType' => '\\ebay\\StructType\\HistogramEntryType',
            'HomePageFeaturedEnabledDefinitionType' => '\\ebay\\StructType\\HomePageFeaturedEnabledDefinitionType',
            'INEscrowWorkflowTimelineDefinitionType' => '\\ebay\\StructType\\INEscrowWorkflowTimelineDefinitionType',
            'ISBNEnabledDefinitionType' => '\\ebay\\StructType\\ISBNEnabledDefinitionType',
            'ISBNIdentifierEnabledDefinitionType' => '\\ebay\\StructType\\ISBNIdentifierEnabledDefinitionType',
            'InsuranceDetailsType' => '\\ebay\\StructType\\InsuranceDetailsType',
            'IntegratedMerchantCreditCardInfoType' => '\\ebay\\StructType\\IntegratedMerchantCreditCardInfoType',
            'InternationalShippingServiceOptionsType' => '\\ebay\\StructType\\InternationalShippingServiceOptionsType',
            'InventoryFeesType' => '\\ebay\\StructType\\InventoryFeesType',
            'InventoryStatusType' => '\\ebay\\StructType\\InventoryStatusType',
            'ItemArrayType' => '\\ebay\\ArrayType\\ItemArrayType',
            'ItemBestOffersArrayType' => '\\ebay\\StructType\\ItemBestOffersArrayType',
            'ItemBestOffersType' => '\\ebay\\StructType\\ItemBestOffersType',
            'ItemBidDetailsType' => '\\ebay\\StructType\\ItemBidDetailsType',
            'ItemCompatibilityEnabledDefinitionType' => '\\ebay\\StructType\\ItemCompatibilityEnabledDefinitionType',
            'ItemCompatibilityListType' => '\\ebay\\StructType\\ItemCompatibilityListType',
            'ItemCompatibilityType' => '\\ebay\\StructType\\ItemCompatibilityType',
            'ItemIDArrayType' => '\\ebay\\StructType\\ItemIDArrayType',
            'ItemListCustomizationType' => '\\ebay\\StructType\\ItemListCustomizationType',
            'ItemPolicyViolationType' => '\\ebay\\StructType\\ItemPolicyViolationType',
            'ItemRatingDetailArrayType' => '\\ebay\\ArrayType\\ItemRatingDetailArrayType',
            'ItemRatingDetailsType' => '\\ebay\\StructType\\ItemRatingDetailsType',
            'ItemSpecificDetailsType' => '\\ebay\\StructType\\ItemSpecificDetailsType',
            'ItemSpecificsEnabledDefinitionType' => '\\ebay\\StructType\\ItemSpecificsEnabledDefinitionType',
            'ItemTotalsType' => '\\ebay\\StructType\\ItemTotalsType',
            'ItemTransactionIDArrayType' => '\\ebay\\ArrayType\\ItemTransactionIDArrayType',
            'ItemTransactionIDType' => '\\ebay\\StructType\\ItemTransactionIDType',
            'ItemType' => '\\ebay\\StructType\\ItemType',
            'ItemsCanceledEventType' => '\\ebay\\StructType\\ItemsCanceledEventType',
            'KTypeSupportedDefinitionType' => '\\ebay\\StructType\\KTypeSupportedDefinitionType',
            'LabelType' => '\\ebay\\StructType\\LabelType',
            'LineItemType' => '\\ebay\\StructType\\LineItemType',
            'ListingAnalyzerRecommendationsType' => '\\ebay\\StructType\\ListingAnalyzerRecommendationsType',
            'ListingCheckoutRedirectPreferenceType' => '\\ebay\\StructType\\ListingCheckoutRedirectPreferenceType',
            'ListingDesignerType' => '\\ebay\\StructType\\ListingDesignerType',
            'ListingDetailsType' => '\\ebay\\StructType\\ListingDetailsType',
            'ListingDurationDefinitionType' => '\\ebay\\StructType\\ListingDurationDefinitionType',
            'ListingDurationDefinitionsType' => '\\ebay\\StructType\\ListingDurationDefinitionsType',
            'ListingDurationReferenceType' => '\\ebay\\StructType\\ListingDurationReferenceType',
            'ListingEnhancementDurationDefinitionType' => '\\ebay\\StructType\\ListingEnhancementDurationDefinitionType',
            'ListingEnhancementDurationReferenceType' => '\\ebay\\StructType\\ListingEnhancementDurationReferenceType',
            'ListingFeatureDetailsType' => '\\ebay\\StructType\\ListingFeatureDetailsType',
            'ListingRecommendationType' => '\\ebay\\StructType\\ListingRecommendationType',
            'ListingRecommendationsType' => '\\ebay\\StructType\\ListingRecommendationsType',
            'ListingStartPriceDetailsType' => '\\ebay\\StructType\\ListingStartPriceDetailsType',
            'ListingTipArrayType' => '\\ebay\\ArrayType\\ListingTipArrayType',
            'ListingTipFieldType' => '\\ebay\\StructType\\ListingTipFieldType',
            'ListingTipMessageType' => '\\ebay\\StructType\\ListingTipMessageType',
            'ListingTipType' => '\\ebay\\StructType\\ListingTipType',
            'LocalListingDistancesNonSubscriptionDefinitionType' => '\\ebay\\StructType\\LocalListingDistancesNonSubscriptionDefinitionType',
            'LocalListingDistancesRegularDefinitionType' => '\\ebay\\StructType\\LocalListingDistancesRegularDefinitionType',
            'LocalListingDistancesSpecialtyDefinitionType' => '\\ebay\\StructType\\LocalListingDistancesSpecialtyDefinitionType',
            'LocalMarketAdFormatEnabledDefinitionType' => '\\ebay\\StructType\\LocalMarketAdFormatEnabledDefinitionType',
            'LocalMarketAutoAcceptEnabledDefinitionType' => '\\ebay\\StructType\\LocalMarketAutoAcceptEnabledDefinitionType',
            'LocalMarketAutoDeclineEnabledDefinitionType' => '\\ebay\\StructType\\LocalMarketAutoDeclineEnabledDefinitionType',
            'LocalMarketBestOfferEnabledDefinitionType' => '\\ebay\\StructType\\LocalMarketBestOfferEnabledDefinitionType',
            'LocalMarketCompanyNameEnabledDefinitionType' => '\\ebay\\StructType\\LocalMarketCompanyNameEnabledDefinitionType',
            'LocalMarketContactByAddressEnabledDefinitionType' => '\\ebay\\StructType\\LocalMarketContactByAddressEnabledDefinitionType',
            'LocalMarketContactByEmailEnabledDefinitionType' => '\\ebay\\StructType\\LocalMarketContactByEmailEnabledDefinitionType',
            'LocalMarketContactByPhoneEnabledDefinitionType' => '\\ebay\\StructType\\LocalMarketContactByPhoneEnabledDefinitionType',
            'LocalMarketCounterOfferEnabledDefinitionType' => '\\ebay\\StructType\\LocalMarketCounterOfferEnabledDefinitionType',
            'LocalMarketNonSubscriptionDefinitionType' => '\\ebay\\StructType\\LocalMarketNonSubscriptionDefinitionType',
            'LocalMarketPaymentMethodCheckOutEnabledDefinitionType' => '\\ebay\\StructType\\LocalMarketPaymentMethodCheckOutEnabledDefinitionType',
            'LocalMarketPhoneCountDefinitionType' => '\\ebay\\StructType\\LocalMarketPhoneCountDefinitionType',
            'LocalMarketPremiumSubscriptionDefinitionType' => '\\ebay\\StructType\\LocalMarketPremiumSubscriptionDefinitionType',
            'LocalMarketRegularSubscriptionDefinitionType' => '\\ebay\\StructType\\LocalMarketRegularSubscriptionDefinitionType',
            'LocalMarketSellerContactDetailsEnabledDefinitionType' => '\\ebay\\StructType\\LocalMarketSellerContactDetailsEnabledDefinitionType',
            'LocalMarketShippingMethodEnabledDefinitionType' => '\\ebay\\StructType\\LocalMarketShippingMethodEnabledDefinitionType',
            'LocalMarketSpecialitySubscriptionDefinitionType' => '\\ebay\\StructType\\LocalMarketSpecialitySubscriptionDefinitionType',
            'LocalMarketStreetCountDefinitionType' => '\\ebay\\StructType\\LocalMarketStreetCountDefinitionType',
            'LocalSearchType' => '\\ebay\\StructType\\LocalSearchType',
            'LookupAttributeArrayType' => '\\ebay\\ArrayType\\LookupAttributeArrayType',
            'LookupAttributeType' => '\\ebay\\StructType\\LookupAttributeType',
            'MarkUpMarkDownEventType' => '\\ebay\\StructType\\MarkUpMarkDownEventType',
            'MarkUpMarkDownHistoryType' => '\\ebay\\StructType\\MarkUpMarkDownHistoryType',
            'MaxFlatShippingCostCBTExemptDefinitionType' => '\\ebay\\StructType\\MaxFlatShippingCostCBTExemptDefinitionType',
            'MaxFlatShippingCostDefinitionType' => '\\ebay\\StructType\\MaxFlatShippingCostDefinitionType',
            'MaxGranularFitmentCountDefinitionType' => '\\ebay\\StructType\\MaxGranularFitmentCountDefinitionType',
            'MaxItemCompatibilityDefinitionType' => '\\ebay\\StructType\\MaxItemCompatibilityDefinitionType',
            'MaximumBuyerPolicyViolationsDetailsType' => '\\ebay\\StructType\\MaximumBuyerPolicyViolationsDetailsType',
            'MaximumBuyerPolicyViolationsType' => '\\ebay\\StructType\\MaximumBuyerPolicyViolationsType',
            'MaximumItemRequirementsDetailsType' => '\\ebay\\StructType\\MaximumItemRequirementsDetailsType',
            'MaximumItemRequirementsType' => '\\ebay\\StructType\\MaximumItemRequirementsType',
            'MaximumUnpaidItemStrikesCountDetailsType' => '\\ebay\\StructType\\MaximumUnpaidItemStrikesCountDetailsType',
            'MaximumUnpaidItemStrikesDurationDetailsType' => '\\ebay\\StructType\\MaximumUnpaidItemStrikesDurationDetailsType',
            'MaximumUnpaidItemStrikesInfoDetailsType' => '\\ebay\\StructType\\MaximumUnpaidItemStrikesInfoDetailsType',
            'MaximumUnpaidItemStrikesInfoType' => '\\ebay\\StructType\\MaximumUnpaidItemStrikesInfoType',
            'MemberMessageExchangeArrayType' => '\\ebay\\ArrayType\\MemberMessageExchangeArrayType',
            'MemberMessageExchangeType' => '\\ebay\\StructType\\MemberMessageExchangeType',
            'MemberMessageType' => '\\ebay\\StructType\\MemberMessageType',
            'MessageMediaType' => '\\ebay\\StructType\\MessageMediaType',
            'MetadataType' => '\\ebay\\StructType\\MetadataType',
            'MinItemCompatibilityDefinitionType' => '\\ebay\\StructType\\MinItemCompatibilityDefinitionType',
            'MinimumFeedbackScoreDetailsType' => '\\ebay\\StructType\\MinimumFeedbackScoreDetailsType',
            'MinimumReservePriceDefinitionType' => '\\ebay\\StructType\\MinimumReservePriceDefinitionType',
            'ModifyNameArrayType' => '\\ebay\\ArrayType\\ModifyNameArrayType',
            'ModifyNameType' => '\\ebay\\StructType\\ModifyNameType',
            'MotorsLocalMarketEnabledDefinitionType' => '\\ebay\\StructType\\MotorsLocalMarketEnabledDefinitionType',
            'MultiLegShipmentType' => '\\ebay\\StructType\\MultiLegShipmentType',
            'MultiLegShippingDetailsType' => '\\ebay\\StructType\\MultiLegShippingDetailsType',
            'MultiLegShippingServiceType' => '\\ebay\\StructType\\MultiLegShippingServiceType',
            'MyMessagesAlertArrayType' => '\\ebay\\ArrayType\\MyMessagesAlertArrayType',
            'MyMessagesAlertIDArrayType' => '\\ebay\\ArrayType\\MyMessagesAlertIDArrayType',
            'MyMessagesAlertType' => '\\ebay\\StructType\\MyMessagesAlertType',
            'MyMessagesExternalMessageIDArrayType' => '\\ebay\\ArrayType\\MyMessagesExternalMessageIDArrayType',
            'MyMessagesFolderSummaryType' => '\\ebay\\StructType\\MyMessagesFolderSummaryType',
            'MyMessagesFolderType' => '\\ebay\\StructType\\MyMessagesFolderType',
            'MyMessagesForwardDetailsType' => '\\ebay\\StructType\\MyMessagesForwardDetailsType',
            'MyMessagesMessageArrayType' => '\\ebay\\ArrayType\\MyMessagesMessageArrayType',
            'MyMessagesMessageIDArrayType' => '\\ebay\\ArrayType\\MyMessagesMessageIDArrayType',
            'MyMessagesMessageType' => '\\ebay\\StructType\\MyMessagesMessageType',
            'MyMessagesResponseDetailsType' => '\\ebay\\StructType\\MyMessagesResponseDetailsType',
            'MyMessagesSummaryType' => '\\ebay\\StructType\\MyMessagesSummaryType',
            'MyeBayFavoriteSearchListType' => '\\ebay\\StructType\\MyeBayFavoriteSearchListType',
            'MyeBayFavoriteSearchType' => '\\ebay\\StructType\\MyeBayFavoriteSearchType',
            'MyeBayFavoriteSellerListType' => '\\ebay\\StructType\\MyeBayFavoriteSellerListType',
            'MyeBayFavoriteSellerType' => '\\ebay\\StructType\\MyeBayFavoriteSellerType',
            'MyeBaySecondChanceOfferListType' => '\\ebay\\StructType\\MyeBaySecondChanceOfferListType',
            'MyeBaySelectionType' => '\\ebay\\StructType\\MyeBaySelectionType',
            'MyeBaySellingSummaryType' => '\\ebay\\StructType\\MyeBaySellingSummaryType',
            'NameRecommendationType' => '\\ebay\\StructType\\NameRecommendationType',
            'NameValueListArrayType' => '\\ebay\\ArrayType\\NameValueListArrayType',
            'NameValueListType' => '\\ebay\\StructType\\NameValueListType',
            'NameValueRelationshipType' => '\\ebay\\StructType\\NameValueRelationshipType',
            'NonProfitAddressType' => '\\ebay\\StructType\\NonProfitAddressType',
            'NonSubscriptionDefinitionType' => '\\ebay\\StructType\\NonSubscriptionDefinitionType',
            'NotificationDetailsArrayType' => '\\ebay\\ArrayType\\NotificationDetailsArrayType',
            'NotificationDetailsType' => '\\ebay\\StructType\\NotificationDetailsType',
            'NotificationEnableArrayType' => '\\ebay\\ArrayType\\NotificationEnableArrayType',
            'NotificationEnableType' => '\\ebay\\StructType\\NotificationEnableType',
            'NotificationEventPropertyType' => '\\ebay\\StructType\\NotificationEventPropertyType',
            'NotificationMessageType' => '\\ebay\\StructType\\NotificationMessageType',
            'NotificationStatisticsType' => '\\ebay\\StructType\\NotificationStatisticsType',
            'NotificationUserDataType' => '\\ebay\\StructType\\NotificationUserDataType',
            'NumberOfPolicyViolationsDetailsType' => '\\ebay\\StructType\\NumberOfPolicyViolationsDetailsType',
            'OfferArrayType' => '\\ebay\\ArrayType\\OfferArrayType',
            'OfferType' => '\\ebay\\StructType\\OfferType',
            'OrderArrayType' => '\\ebay\\ArrayType\\OrderArrayType',
            'OrderIDArrayType' => '\\ebay\\ArrayType\\OrderIDArrayType',
            'OrderTransactionArrayType' => '\\ebay\\ArrayType\\OrderTransactionArrayType',
            'OrderTransactionType' => '\\ebay\\StructType\\OrderTransactionType',
            'OrderType' => '\\ebay\\StructType\\OrderType',
            'PaginatedItemArrayType' => '\\ebay\\StructType\\PaginatedItemArrayType',
            'PaginatedOrderTransactionArrayType' => '\\ebay\\StructType\\PaginatedOrderTransactionArrayType',
            'PaginatedTransactionArrayType' => '\\ebay\\StructType\\PaginatedTransactionArrayType',
            'PaginationResultType' => '\\ebay\\StructType\\PaginationResultType',
            'PaisaPayFullEscrowEnabledDefinitionType' => '\\ebay\\StructType\\PaisaPayFullEscrowEnabledDefinitionType',
            'PayPalBuyerProtectionEnabledDefinitionType' => '\\ebay\\StructType\\PayPalBuyerProtectionEnabledDefinitionType',
            'PayPalRequiredDefinitionType' => '\\ebay\\StructType\\PayPalRequiredDefinitionType',
            'PayPalRequiredForStoreOwnerDefinitionType' => '\\ebay\\StructType\\PayPalRequiredForStoreOwnerDefinitionType',
            'PaymentDetailsType' => '\\ebay\\StructType\\PaymentDetailsType',
            'PaymentHoldDetailType' => '\\ebay\\StructType\\PaymentHoldDetailType',
            'PaymentInformationCodeType' => '\\ebay\\StructType\\PaymentInformationCodeType',
            'PaymentInformationType' => '\\ebay\\StructType\\PaymentInformationType',
            'PaymentMethodDefinitionType' => '\\ebay\\StructType\\PaymentMethodDefinitionType',
            'PaymentOptionDetailsType' => '\\ebay\\StructType\\PaymentOptionDetailsType',
            'PaymentOptionsGroupEnabledDefinitionType' => '\\ebay\\StructType\\PaymentOptionsGroupEnabledDefinitionType',
            'PaymentTransactionCodeType' => '\\ebay\\StructType\\PaymentTransactionCodeType',
            'PaymentTransactionType' => '\\ebay\\StructType\\PaymentTransactionType',
            'PaymentsInformationCodeType' => '\\ebay\\StructType\\PaymentsInformationCodeType',
            'PaymentsInformationType' => '\\ebay\\StructType\\PaymentsInformationType',
            'PerformanceDashboardType' => '\\ebay\\StructType\\PerformanceDashboardType',
            'PickupDetailsType' => '\\ebay\\StructType\\PickupDetailsType',
            'PickupDropOffEnabledDefinitionType' => '\\ebay\\StructType\\PickupDropOffEnabledDefinitionType',
            'PickupInStoreDetailsType' => '\\ebay\\StructType\\PickupInStoreDetailsType',
            'PickupMethodSelectedType' => '\\ebay\\StructType\\PickupMethodSelectedType',
            'PickupOptionsType' => '\\ebay\\StructType\\PickupOptionsType',
            'PictureDetailsType' => '\\ebay\\StructType\\PictureDetailsType',
            'PictureManagerDetailsType' => '\\ebay\\StructType\\PictureManagerDetailsType',
            'PictureManagerFolderType' => '\\ebay\\StructType\\PictureManagerFolderType',
            'PictureManagerPictureDisplayType' => '\\ebay\\StructType\\PictureManagerPictureDisplayType',
            'PictureManagerPictureType' => '\\ebay\\StructType\\PictureManagerPictureType',
            'PictureManagerSubscriptionType' => '\\ebay\\StructType\\PictureManagerSubscriptionType',
            'PictureSetMemberType' => '\\ebay\\StructType\\PictureSetMemberType',
            'PictureURLsType' => '\\ebay\\StructType\\PictureURLsType',
            'PicturesType' => '\\ebay\\StructType\\PicturesType',
            'PolicyComplianceDashboardType' => '\\ebay\\StructType\\PolicyComplianceDashboardType',
            'PolicyViolationDurationDetailsType' => '\\ebay\\StructType\\PolicyViolationDurationDetailsType',
            'PowerSellerDashboardType' => '\\ebay\\StructType\\PowerSellerDashboardType',
            'PremiumSubscriptionDefinitionType' => '\\ebay\\StructType\\PremiumSubscriptionDefinitionType',
            'PricingRecommendationsType' => '\\ebay\\StructType\\PricingRecommendationsType',
            'ProPackEnabledDefinitionType' => '\\ebay\\StructType\\ProPackEnabledDefinitionType',
            'ProPackPlusEnabledDefinitionType' => '\\ebay\\StructType\\ProPackPlusEnabledDefinitionType',
            'ProStoresCheckoutPreferenceType' => '\\ebay\\StructType\\ProStoresCheckoutPreferenceType',
            'ProStoresDetailsType' => '\\ebay\\StructType\\ProStoresDetailsType',
            'ProductCreationEnabledDefinitionType' => '\\ebay\\StructType\\ProductCreationEnabledDefinitionType',
            'ProductDetailsType' => '\\ebay\\StructType\\ProductDetailsType',
            'ProductFamilyType' => '\\ebay\\StructType\\ProductFamilyType',
            'ProductFinderConstraintType' => '\\ebay\\StructType\\ProductFinderConstraintType',
            'ProductIdentifiersType' => '\\ebay\\StructType\\ProductIdentifiersType',
            'ProductInfoType' => '\\ebay\\StructType\\ProductInfoType',
            'ProductListingDetailsType' => '\\ebay\\StructType\\ProductListingDetailsType',
            'ProductRecommendationsType' => '\\ebay\\StructType\\ProductRecommendationsType',
            'ProductSearchPageType' => '\\ebay\\StructType\\ProductSearchPageType',
            'ProductSearchResultType' => '\\ebay\\StructType\\ProductSearchResultType',
            'ProductSearchType' => '\\ebay\\StructType\\ProductSearchType',
            'ProductSuggestionType' => '\\ebay\\StructType\\ProductSuggestionType',
            'ProductSuggestionsType' => '\\ebay\\StructType\\ProductSuggestionsType',
            'ProductType' => '\\ebay\\StructType\\ProductType',
            'ProfileCategoryGroupDefinitionType' => '\\ebay\\StructType\\ProfileCategoryGroupDefinitionType',
            'PromotedItemType' => '\\ebay\\StructType\\PromotedItemType',
            'PromotionDetailsType' => '\\ebay\\StructType\\PromotionDetailsType',
            'PromotionRuleArrayType' => '\\ebay\\ArrayType\\PromotionRuleArrayType',
            'PromotionRuleType' => '\\ebay\\StructType\\PromotionRuleType',
            'PromotionalSaleArrayType' => '\\ebay\\ArrayType\\PromotionalSaleArrayType',
            'PromotionalSaleDetailsType' => '\\ebay\\StructType\\PromotionalSaleDetailsType',
            'PromotionalSaleType' => '\\ebay\\StructType\\PromotionalSaleType',
            'PromotionalShippingDiscountDetailsType' => '\\ebay\\StructType\\PromotionalShippingDiscountDetailsType',
            'PurchaseReminderEmailPreferencesType' => '\\ebay\\StructType\\PurchaseReminderEmailPreferencesType',
            'QuantityInfoType' => '\\ebay\\StructType\\QuantityInfoType',
            'QuantityRestrictionPerBuyerInfoType' => '\\ebay\\StructType\\QuantityRestrictionPerBuyerInfoType',
            'RateTableDetailsType' => '\\ebay\\StructType\\RateTableDetailsType',
            'ReasonCodeDetailType' => '\\ebay\\StructType\\ReasonCodeDetailType',
            'RecommendationType' => '\\ebay\\StructType\\RecommendationType',
            'RecommendationValidationRulesType' => '\\ebay\\StructType\\RecommendationValidationRulesType',
            'RecommendationsType' => '\\ebay\\StructType\\RecommendationsType',
            'RecoupmentPolicyConsentType' => '\\ebay\\StructType\\RecoupmentPolicyConsentType',
            'RefundArrayType' => '\\ebay\\ArrayType\\RefundArrayType',
            'RefundDetailsType' => '\\ebay\\StructType\\RefundDetailsType',
            'RefundFailureReasonType' => '\\ebay\\StructType\\RefundFailureReasonType',
            'RefundFundingSourceArrayType' => '\\ebay\\StructType\\RefundFundingSourceArrayType',
            'RefundFundingSourceType' => '\\ebay\\StructType\\RefundFundingSourceType',
            'RefundInformationType' => '\\ebay\\StructType\\RefundInformationType',
            'RefundLineArrayType' => '\\ebay\\StructType\\RefundLineArrayType',
            'RefundLineType' => '\\ebay\\StructType\\RefundLineType',
            'RefundTransactionArrayType' => '\\ebay\\StructType\\RefundTransactionArrayType',
            'RefundTransactionInfoType' => '\\ebay\\StructType\\RefundTransactionInfoType',
            'RefundTransactionType' => '\\ebay\\StructType\\RefundTransactionType',
            'RefundType' => '\\ebay\\StructType\\RefundType',
            'RegionDetailsType' => '\\ebay\\StructType\\RegionDetailsType',
            'RegionOfOriginDetailsType' => '\\ebay\\StructType\\RegionOfOriginDetailsType',
            'RegularSubscriptionDefinitionType' => '\\ebay\\StructType\\RegularSubscriptionDefinitionType',
            'ReminderCustomizationType' => '\\ebay\\StructType\\ReminderCustomizationType',
            'RemindersType' => '\\ebay\\StructType\\RemindersType',
            'RequiredSellerActionArrayType' => '\\ebay\\ArrayType\\RequiredSellerActionArrayType',
            'ResponseAttributeSetType' => '\\ebay\\StructType\\ResponseAttributeSetType',
            'RestockingFeeValueDetailsType' => '\\ebay\\StructType\\RestockingFeeValueDetailsType',
            'ReturnPolicyDetailsType' => '\\ebay\\StructType\\ReturnPolicyDetailsType',
            'ReturnPolicyEnabledDefinitionType' => '\\ebay\\StructType\\ReturnPolicyEnabledDefinitionType',
            'ReturnPolicyType' => '\\ebay\\StructType\\ReturnPolicyType',
            'ReturnsAcceptedDetailsType' => '\\ebay\\StructType\\ReturnsAcceptedDetailsType',
            'ReturnsWithinDetailsType' => '\\ebay\\StructType\\ReturnsWithinDetailsType',
            'ReviewDetailsType' => '\\ebay\\StructType\\ReviewDetailsType',
            'ReviewType' => '\\ebay\\StructType\\ReviewType',
            'RevisePriceAllowedDefinitionType' => '\\ebay\\StructType\\RevisePriceAllowedDefinitionType',
            'ReviseQuantityAllowedDefinitionType' => '\\ebay\\StructType\\ReviseQuantityAllowedDefinitionType',
            'ReviseStatusType' => '\\ebay\\StructType\\ReviseStatusType',
            'SIFFTASRecommendationsType' => '\\ebay\\StructType\\SIFFTASRecommendationsType',
            'SKUArrayType' => '\\ebay\\ArrayType\\SKUArrayType',
            'SMSSubscriptionType' => '\\ebay\\StructType\\SMSSubscriptionType',
            'SafePaymentRequiredDefinitionType' => '\\ebay\\StructType\\SafePaymentRequiredDefinitionType',
            'SalesTaxType' => '\\ebay\\StructType\\SalesTaxType',
            'ScheduleType' => '\\ebay\\StructType\\ScheduleType',
            'SchedulingInfoType' => '\\ebay\\StructType\\SchedulingInfoType',
            'SearchAttributesType' => '\\ebay\\StructType\\SearchAttributesType',
            'SearchDetailsType' => '\\ebay\\StructType\\SearchDetailsType',
            'SearchStandingDashboardType' => '\\ebay\\StructType\\SearchStandingDashboardType',
            'SellerAccountDashboardType' => '\\ebay\\StructType\\SellerAccountDashboardType',
            'SellerContactDetailsEnabledDefinitionType' => '\\ebay\\StructType\\SellerContactDetailsEnabledDefinitionType',
            'SellerDashboardAlertType' => '\\ebay\\StructType\\SellerDashboardAlertType',
            'SellerDiscountsType' => '\\ebay\\StructType\\SellerDiscountsType',
            'SellerDiscountType' => '\\ebay\\StructType\\SellerDiscountType',
            'SellerExcludeShipToLocationPreferencesType' => '\\ebay\\StructType\\SellerExcludeShipToLocationPreferencesType',
            'SellerFavoriteItemPreferencesType' => '\\ebay\\StructType\\SellerFavoriteItemPreferencesType',
            'SellerFeeDiscountDashboardType' => '\\ebay\\StructType\\SellerFeeDiscountDashboardType',
            'SellerPaymentPreferencesType' => '\\ebay\\StructType\\SellerPaymentPreferencesType',
            'SellerPaymentProfileType' => '\\ebay\\StructType\\SellerPaymentProfileType',
            'SellerPaymentType' => '\\ebay\\StructType\\SellerPaymentType',
            'SellerProfilePreferencesType' => '\\ebay\\StructType\\SellerProfilePreferencesType',
            'SellerProfilesType' => '\\ebay\\StructType\\SellerProfilesType',
            'SellerProvidedTitleSupportedDefinitionType' => '\\ebay\\StructType\\SellerProvidedTitleSupportedDefinitionType',
            'SellerRatingSummaryArrayType' => '\\ebay\\ArrayType\\SellerRatingSummaryArrayType',
            'RecoupmentPolicyDetailsType' => '\\ebay\\StructType\\RecoupmentPolicyDetailsType',
            'SellerReturnPreferencesType' => '\\ebay\\StructType\\SellerReturnPreferencesType',
            'SellerReturnProfileType' => '\\ebay\\StructType\\SellerReturnProfileType',
            'SellerRoleMetricsType' => '\\ebay\\StructType\\SellerRoleMetricsType',
            'SellerShippingProfileType' => '\\ebay\\StructType\\SellerShippingProfileType',
            'SellerType' => '\\ebay\\StructType\\SellerType',
            'SellereBayPaymentProcessConsentCodeType' => '\\ebay\\StructType\\SellereBayPaymentProcessConsentCodeType',
            'SellingManagerAlertType' => '\\ebay\\StructType\\SellingManagerAlertType',
            'SellingManagerAutoListAccordingToScheduleType' => '\\ebay\\StructType\\SellingManagerAutoListAccordingToScheduleType',
            'SellingManagerAutoListMinActiveItemsType' => '\\ebay\\StructType\\SellingManagerAutoListMinActiveItemsType',
            'SellingManagerAutoListType' => '\\ebay\\StructType\\SellingManagerAutoListType',
            'SellingManagerAutoRelistType' => '\\ebay\\StructType\\SellingManagerAutoRelistType',
            'SellingManagerAutoSecondChanceOfferType' => '\\ebay\\StructType\\SellingManagerAutoSecondChanceOfferType',
            'SellingManagerEmailLogType' => '\\ebay\\StructType\\SellingManagerEmailLogType',
            'SellingManagerFolderDetailsType' => '\\ebay\\StructType\\SellingManagerFolderDetailsType',
            'SellingManagerOrderStatusType' => '\\ebay\\StructType\\SellingManagerOrderStatusType',
            'SellingManagerProductDetailsType' => '\\ebay\\StructType\\SellingManagerProductDetailsType',
            'SellingManagerProductInventoryStatusType' => '\\ebay\\StructType\\SellingManagerProductInventoryStatusType',
            'SellingManagerProductSpecificsType' => '\\ebay\\StructType\\SellingManagerProductSpecificsType',
            'SellingManagerProductType' => '\\ebay\\StructType\\SellingManagerProductType',
            'SellingManagerSearchType' => '\\ebay\\StructType\\SellingManagerSearchType',
            'SellingManagerSoldOrderType' => '\\ebay\\StructType\\SellingManagerSoldOrderType',
            'SellingManagerSoldTransactionType' => '\\ebay\\StructType\\SellingManagerSoldTransactionType',
            'SellingManagerTemplateDetailsArrayType' => '\\ebay\\ArrayType\\SellingManagerTemplateDetailsArrayType',
            'SellingManagerTemplateDetailsType' => '\\ebay\\StructType\\SellingManagerTemplateDetailsType',
            'SellingManagerVendorDetailsType' => '\\ebay\\StructType\\SellingManagerVendorDetailsType',
            'SellingStatusType' => '\\ebay\\StructType\\SellingStatusType',
            'SellingSummaryType' => '\\ebay\\StructType\\SellingSummaryType',
            'ShipPackageDetailsType' => '\\ebay\\StructType\\ShipPackageDetailsType',
            'ShipmentLineItemType' => '\\ebay\\StructType\\ShipmentLineItemType',
            'ShipmentTrackingDetailsType' => '\\ebay\\StructType\\ShipmentTrackingDetailsType',
            'ShipmentType' => '\\ebay\\StructType\\ShipmentType',
            'ShippingCarrierDetailsType' => '\\ebay\\StructType\\ShippingCarrierDetailsType',
            'ShippingCategoryDetailsType' => '\\ebay\\StructType\\ShippingCategoryDetailsType',
            'ShippingCostPaidByDetailsType' => '\\ebay\\StructType\\ShippingCostPaidByDetailsType',
            'ShippingDetailsType' => '\\ebay\\StructType\\ShippingDetailsType',
            'ShippingEstimatedDeliveryInfoType' => '\\ebay\\StructType\\ShippingEstimatedDeliveryInfoType',
            'ShippingInsuranceType' => '\\ebay\\StructType\\ShippingInsuranceType',
            'ShippingLocationDetailsType' => '\\ebay\\StructType\\ShippingLocationDetailsType',
            'ShippingOverrideType' => '\\ebay\\StructType\\ShippingOverrideType',
            'ShippingPackageDetailsType' => '\\ebay\\StructType\\ShippingPackageDetailsType',
            'ShippingPackageInfoType' => '\\ebay\\StructType\\ShippingPackageInfoType',
            'ShippingServiceCostOverrideListType' => '\\ebay\\StructType\\ShippingServiceCostOverrideListType',
            'ShippingServiceCostOverrideType' => '\\ebay\\StructType\\ShippingServiceCostOverrideType',
            'ShippingServiceDetailsType' => '\\ebay\\StructType\\ShippingServiceDetailsType',
            'ShippingServiceOptionsType' => '\\ebay\\StructType\\ShippingServiceOptionsType',
            'ShippingServicePackageDetailsType' => '\\ebay\\StructType\\ShippingServicePackageDetailsType',
            'ShippingTermRequiredDefinitionType' => '\\ebay\\StructType\\ShippingTermRequiredDefinitionType',
            'SiteBuyerRequirementDetailsType' => '\\ebay\\StructType\\SiteBuyerRequirementDetailsType',
            'SiteDefaultsType' => '\\ebay\\StructType\\SiteDefaultsType',
            'SiteDetailsType' => '\\ebay\\StructType\\SiteDetailsType',
            'SiteHostedPictureDetailsType' => '\\ebay\\StructType\\SiteHostedPictureDetailsType',
            'SiteLocationType' => '\\ebay\\StructType\\SiteLocationType',
            'SiteWideCharacteristicsType' => '\\ebay\\StructType\\SiteWideCharacteristicsType',
            'SkypeMeNonTransactionalEnabledDefinitionType' => '\\ebay\\StructType\\SkypeMeNonTransactionalEnabledDefinitionType',
            'SkypeMeTransactionalEnabledDefinitionType' => '\\ebay\\StructType\\SkypeMeTransactionalEnabledDefinitionType',
            'SpecialitySubscriptionDefinitionType' => '\\ebay\\StructType\\SpecialitySubscriptionDefinitionType',
            'StoreColorSchemeArrayType' => '\\ebay\\ArrayType\\StoreColorSchemeArrayType',
            'StoreColorSchemeType' => '\\ebay\\StructType\\StoreColorSchemeType',
            'StoreColorType' => '\\ebay\\StructType\\StoreColorType',
            'StoreCustomCategoryArrayType' => '\\ebay\\ArrayType\\StoreCustomCategoryArrayType',
            'StoreCustomCategoryType' => '\\ebay\\StructType\\StoreCustomCategoryType',
            'StoreCustomListingHeaderLinkType' => '\\ebay\\StructType\\StoreCustomListingHeaderLinkType',
            'StoreCustomListingHeaderType' => '\\ebay\\StructType\\StoreCustomListingHeaderType',
            'StoreCustomPageArrayType' => '\\ebay\\ArrayType\\StoreCustomPageArrayType',
            'StoreCustomPageType' => '\\ebay\\StructType\\StoreCustomPageType',
            'StoreFontType' => '\\ebay\\StructType\\StoreFontType',
            'StoreInventoryEnabledDefinitionType' => '\\ebay\\StructType\\StoreInventoryEnabledDefinitionType',
            'StoreLogoArrayType' => '\\ebay\\ArrayType\\StoreLogoArrayType',
            'StoreLogoType' => '\\ebay\\StructType\\StoreLogoType',
            'StoreOwnerExtendedListingDurationsDefinitionType' => '\\ebay\\StructType\\StoreOwnerExtendedListingDurationsDefinitionType',
            'StoreOwnerExtendedListingDurationsEnabledDefinitionType' => '\\ebay\\StructType\\StoreOwnerExtendedListingDurationsEnabledDefinitionType',
            'StoreOwnerExtendedListingDurationsType' => '\\ebay\\StructType\\StoreOwnerExtendedListingDurationsType',
            'StorePreferencesType' => '\\ebay\\StructType\\StorePreferencesType',
            'StoreSubscriptionArrayType' => '\\ebay\\ArrayType\\StoreSubscriptionArrayType',
            'StoreSubscriptionType' => '\\ebay\\StructType\\StoreSubscriptionType',
            'StoreThemeArrayType' => '\\ebay\\StructType\\StoreThemeArrayType',
            'StoreThemeType' => '\\ebay\\StructType\\StoreThemeType',
            'StoreType' => '\\ebay\\StructType\\StoreType',
            'StoreVacationPreferencesType' => '\\ebay\\StructType\\StoreVacationPreferencesType',
            'StorefrontType' => '\\ebay\\StructType\\StorefrontType',
            'SubscriptionType' => '\\ebay\\StructType\\SubscriptionType',
            'SuggestedBidValueType' => '\\ebay\\StructType\\SuggestedBidValueType',
            'SuggestedCategoryArrayType' => '\\ebay\\StructType\\SuggestedCategoryArrayType',
            'SuggestedCategoryType' => '\\ebay\\StructType\\SuggestedCategoryType',
            'SummaryEventScheduleType' => '\\ebay\\StructType\\SummaryEventScheduleType',
            'SupportedEventTypesArrayType' => '\\ebay\\ArrayType\\SupportedEventTypesArrayType',
            'SupportedSellerProfileType' => '\\ebay\\StructType\\SupportedSellerProfileType',
            'SupportedSellerProfilesType' => '\\ebay\\StructType\\SupportedSellerProfilesType',
            'TCREnabledDefinitionType' => '\\ebay\\StructType\\TCREnabledDefinitionType',
            'TaxDetailsType' => '\\ebay\\StructType\\TaxDetailsType',
            'TaxIdentifierAttributeType' => '\\ebay\\StructType\\TaxIdentifierAttributeType',
            'TaxIdentifierType' => '\\ebay\\StructType\\TaxIdentifierType',
            'TaxJurisdictionType' => '\\ebay\\StructType\\TaxJurisdictionType',
            'TaxTableType' => '\\ebay\\StructType\\TaxTableType',
            'TaxesType' => '\\ebay\\StructType\\TaxesType',
            'ThemeGroupType' => '\\ebay\\StructType\\ThemeGroupType',
            'TicketListingDetailsType' => '\\ebay\\StructType\\TicketListingDetailsType',
            'TimeRangeType' => '\\ebay\\StructType\\TimeRangeType',
            'TimeZoneDetailsType' => '\\ebay\\StructType\\TimeZoneDetailsType',
            'TokenStatusType' => '\\ebay\\StructType\\TokenStatusType',
            'TopRatedSellerDetailsType' => '\\ebay\\StructType\\TopRatedSellerDetailsType',
            'TransactionArrayType' => '\\ebay\\ArrayType\\TransactionArrayType',
            'TransactionReferenceType' => '\\ebay\\StructType\\TransactionReferenceType',
            'TransactionStatusType' => '\\ebay\\StructType\\TransactionStatusType',
            'TransactionType' => '\\ebay\\StructType\\TransactionType',
            'UPCEnabledDefinitionType' => '\\ebay\\StructType\\UPCEnabledDefinitionType',
            'UPCIdentifierEnabledDefinitionType' => '\\ebay\\StructType\\UPCIdentifierEnabledDefinitionType',
            'URLDetailsType' => '\\ebay\\StructType\\URLDetailsType',
            'UnitInfoType' => '\\ebay\\StructType\\UnitInfoType',
            'UnitOfMeasurementDetailsType' => '\\ebay\\StructType\\UnitOfMeasurementDetailsType',
            'UnitOfMeasurementType' => '\\ebay\\StructType\\UnitOfMeasurementType',
            'UnpaidItemAssistancePreferencesType' => '\\ebay\\StructType\\UnpaidItemAssistancePreferencesType',
            'UnpaidItemType' => '\\ebay\\StructType\\UnpaidItemType',
            'UserAgreementInfoType' => '\\ebay\\StructType\\UserAgreementInfoType',
            'UserConsentRequiredDefinitionType' => '\\ebay\\StructType\\UserConsentRequiredDefinitionType',
            'UserDefinedListType' => '\\ebay\\StructType\\UserDefinedListType',
            'UserIDArrayType' => '\\ebay\\StructType\\UserIDArrayType',
            'UserIdentityType' => '\\ebay\\StructType\\UserIdentityType',
            'UserType' => '\\ebay\\StructType\\UserType',
            'VATDetailsType' => '\\ebay\\StructType\\VATDetailsType',
            'VATRateType' => '\\ebay\\StructType\\VATRateType',
            'VINSupportedDefinitionType' => '\\ebay\\StructType\\VINSupportedDefinitionType',
            'VRMSupportedDefinitionType' => '\\ebay\\StructType\\VRMSupportedDefinitionType',
            'ValType' => '\\ebay\\StructType\\ValType',
            'ValueCategoryDefinitionType' => '\\ebay\\StructType\\ValueCategoryDefinitionType',
            'ValuePackEnabledDefinitionType' => '\\ebay\\StructType\\ValuePackEnabledDefinitionType',
            'ValueRecommendationType' => '\\ebay\\StructType\\ValueRecommendationType',
            'VariationDetailsType' => '\\ebay\\StructType\\VariationDetailsType',
            'VariationKeyType' => '\\ebay\\StructType\\VariationKeyType',
            'VariationProductListingDetailsType' => '\\ebay\\StructType\\VariationProductListingDetailsType',
            'VariationSpecificPictureSetType' => '\\ebay\\StructType\\VariationSpecificPictureSetType',
            'VariationType' => '\\ebay\\StructType\\VariationType',
            'VariationsEnabledDefinitionType' => '\\ebay\\StructType\\VariationsEnabledDefinitionType',
            'VariationsType' => '\\ebay\\StructType\\VariationsType',
            'VeROReasonCodeDetailsType' => '\\ebay\\StructType\\VeROReasonCodeDetailsType',
            'VeROReportItemType' => '\\ebay\\StructType\\VeROReportItemType',
            'VeROReportItemsType' => '\\ebay\\StructType\\VeROReportItemsType',
            'VeROReportedItemDetailsType' => '\\ebay\\StructType\\VeROReportedItemDetailsType',
            'VeROReportedItemType' => '\\ebay\\StructType\\VeROReportedItemType',
            'VeROSiteDetailType' => '\\ebay\\StructType\\VeROSiteDetailType',
            'VerifiedUserRequirementsDetailsType' => '\\ebay\\StructType\\VerifiedUserRequirementsDetailsType',
            'VerifiedUserRequirementsType' => '\\ebay\\StructType\\VerifiedUserRequirementsType',
            'WantItNowPostArrayType' => '\\ebay\\ArrayType\\WantItNowPostArrayType',
            'WantItNowPostType' => '\\ebay\\StructType\\WantItNowPostType',
            'WarrantyDurationDetailsType' => '\\ebay\\StructType\\WarrantyDurationDetailsType',
            'WarrantyOfferedDetailsType' => '\\ebay\\StructType\\WarrantyOfferedDetailsType',
            'WarrantyTypeDetailsType' => '\\ebay\\StructType\\WarrantyTypeDetailsType',
            'XSLFileType' => '\\ebay\\StructType\\XSLFileType',
            'eBayMotorsProAdFormatEnabledDefinitionType' => '\\ebay\\StructType\\EBayMotorsProAdFormatEnabledDefinitionType',
            'eBayMotorsProAutoAcceptEnabledDefinitionType' => '\\ebay\\StructType\\EBayMotorsProAutoAcceptEnabledDefinitionType',
            'eBayMotorsProAutoDeclineEnabledDefinitionType' => '\\ebay\\StructType\\EBayMotorsProAutoDeclineEnabledDefinitionType',
            'eBayMotorsProBestOfferEnabledDefinitionType' => '\\ebay\\StructType\\EBayMotorsProBestOfferEnabledDefinitionType',
            'eBayMotorsProCompanyNameEnabledDefinitionType' => '\\ebay\\StructType\\EBayMotorsProCompanyNameEnabledDefinitionType',
            'eBayMotorsProContactByAddressEnabledDefinitionType' => '\\ebay\\StructType\\EBayMotorsProContactByAddressEnabledDefinitionType',
            'eBayMotorsProContactByEmailEnabledDefinitionType' => '\\ebay\\StructType\\EBayMotorsProContactByEmailEnabledDefinitionType',
            'eBayMotorsProContactByPhoneEnabledDefinitionType' => '\\ebay\\StructType\\EBayMotorsProContactByPhoneEnabledDefinitionType',
            'eBayMotorsProCounterOfferEnabledDefinitionType' => '\\ebay\\StructType\\EBayMotorsProCounterOfferEnabledDefinitionType',
            'eBayMotorsProPaymentMethodCheckOutEnabledDefinitionType' => '\\ebay\\StructType\\EBayMotorsProPaymentMethodCheckOutEnabledDefinitionType',
            'eBayMotorsProPhoneCountDefinitionType' => '\\ebay\\StructType\\EBayMotorsProPhoneCountDefinitionType',
            'eBayMotorsProSellerContactDetailsEnabledDefinitionType' => '\\ebay\\StructType\\EBayMotorsProSellerContactDetailsEnabledDefinitionType',
            'eBayMotorsProShippingMethodEnabledDefinitionType' => '\\ebay\\StructType\\EBayMotorsProShippingMethodEnabledDefinitionType',
            'eBayMotorsProStreetCountDefinitionType' => '\\ebay\\StructType\\EBayMotorsProStreetCountDefinitionType',
            'eBayPLUSPreferenceType' => '\\ebay\\StructType\\EBayPLUSPreferenceType',
            'eBayPaymentMismatchDetailsType' => '\\ebay\\StructType\\EBayPaymentMismatchDetailsType',
        );
    }
}
