<?php

namespace ebay\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for NotificationEnableArrayType ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: A list of NotificationEnable entries. Each entry specifies one notification and whether it is enabled.
 * @subpackage Arrays
 * @date 2017-04-07 16
 */
class NotificationEnableArrayType extends AbstractStructArrayBase
{
    /**
     * The NotificationEnable
     * Meta informations extracted from the WSDL
     * - documentation: Specifies one notification or alert event and whether it is enabled or disabled. Returned if previously set.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\NotificationEnableType[]
     */
    public $NotificationEnable;
    /**
     * Constructor method for NotificationEnableArrayType
     * @uses NotificationEnableArrayType::setNotificationEnable()
     * @param \ebay\StructType\NotificationEnableType[] $notificationEnable
     */
    public function __construct(array $notificationEnable = array())
    {
        $this
            ->setNotificationEnable($notificationEnable);
    }
    /**
     * Get NotificationEnable value
     * @return \ebay\StructType\NotificationEnableType[]|null
     */
    public function getNotificationEnable()
    {
        return $this->NotificationEnable;
    }
    /**
     * Set NotificationEnable value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\NotificationEnableType[] $notificationEnable
     * @return \ebay\ArrayType\NotificationEnableArrayType
     */
    public function setNotificationEnable(array $notificationEnable = array())
    {
        foreach ($notificationEnable as $notificationEnableArrayTypeNotificationEnableItem) {
            // validation for constraint: itemType
            if (!$notificationEnableArrayTypeNotificationEnableItem instanceof \ebay\StructType\NotificationEnableType) {
                throw new \InvalidArgumentException(sprintf('The NotificationEnable property can only contain items of \ebay\StructType\NotificationEnableType, "%s" given', is_object($notificationEnableArrayTypeNotificationEnableItem) ? get_class($notificationEnableArrayTypeNotificationEnableItem) : gettype($notificationEnableArrayTypeNotificationEnableItem)), __LINE__);
            }
        }
        $this->NotificationEnable = $notificationEnable;
        return $this;
    }
    /**
     * Add item to NotificationEnable value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\NotificationEnableType $item
     * @return \ebay\ArrayType\NotificationEnableArrayType
     */
    public function addToNotificationEnable(\ebay\StructType\NotificationEnableType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\NotificationEnableType) {
            throw new \InvalidArgumentException(sprintf('The NotificationEnable property can only contain items of \ebay\StructType\NotificationEnableType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NotificationEnable[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ebay\StructType\NotificationEnableType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ebay\StructType\NotificationEnableType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ebay\StructType\NotificationEnableType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ebay\StructType\NotificationEnableType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ebay\StructType\NotificationEnableType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NotificationEnable
     */
    public function getAttributeName()
    {
        return 'NotificationEnable';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\ArrayType\NotificationEnableArrayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
