<?php

namespace ebay\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ModifyNameArrayType ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: A list of one or more ModifyName containers. Each ModifyName container has Name and NewName elements.
 * @subpackage Arrays
 * @date 2017-04-07 16
 */
class ModifyNameArrayType extends AbstractStructArrayBase
{
    /**
     * The ModifyName
     * Meta informations extracted from the WSDL
     * - documentation: Container for the current and new name of a variation specific. <br><br> You cannot change the name of required item specifics. Call GetCategoryFeatures to determine which names are required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\ModifyNameType[]
     */
    public $ModifyName;
    /**
     * Constructor method for ModifyNameArrayType
     * @uses ModifyNameArrayType::setModifyName()
     * @param \ebay\StructType\ModifyNameType[] $modifyName
     */
    public function __construct(array $modifyName = array())
    {
        $this
            ->setModifyName($modifyName);
    }
    /**
     * Get ModifyName value
     * @return \ebay\StructType\ModifyNameType[]|null
     */
    public function getModifyName()
    {
        return $this->ModifyName;
    }
    /**
     * Set ModifyName value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ModifyNameType[] $modifyName
     * @return \ebay\ArrayType\ModifyNameArrayType
     */
    public function setModifyName(array $modifyName = array())
    {
        foreach ($modifyName as $modifyNameArrayTypeModifyNameItem) {
            // validation for constraint: itemType
            if (!$modifyNameArrayTypeModifyNameItem instanceof \ebay\StructType\ModifyNameType) {
                throw new \InvalidArgumentException(sprintf('The ModifyName property can only contain items of \ebay\StructType\ModifyNameType, "%s" given', is_object($modifyNameArrayTypeModifyNameItem) ? get_class($modifyNameArrayTypeModifyNameItem) : gettype($modifyNameArrayTypeModifyNameItem)), __LINE__);
            }
        }
        $this->ModifyName = $modifyName;
        return $this;
    }
    /**
     * Add item to ModifyName value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ModifyNameType $item
     * @return \ebay\ArrayType\ModifyNameArrayType
     */
    public function addToModifyName(\ebay\StructType\ModifyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\ModifyNameType) {
            throw new \InvalidArgumentException(sprintf('The ModifyName property can only contain items of \ebay\StructType\ModifyNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ModifyName[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ebay\StructType\ModifyNameType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ebay\StructType\ModifyNameType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ebay\StructType\ModifyNameType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ebay\StructType\ModifyNameType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ebay\StructType\ModifyNameType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ModifyName
     */
    public function getAttributeName()
    {
        return 'ModifyName';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\ArrayType\ModifyNameArrayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
