<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarrantyDurationDetailsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type used by the <b>ReturnPolicyDetails.WarrantyDuration</b> container, which is returned in <b>GeteBayDetails</b> response to indicate the warranty duration times that may be offered by the seller to the buyer in a listing.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class WarrantyDurationDetailsType extends AbstractStructBase
{
    /**
     * The WarrantyDurationOption
     * Meta informations extracted from the WSDL
     * - documentation: The enumeration value in this field indicates a warranty duration that may be offered by the seller to the buyer in a listing. This value can be passed in through the <b>ReturnPolicy.WarrantyDurationOption</b> field in an
     * add/revise/relist API call to offer this warranty duration to the buyer. Only one warranty duration can be offered to the buyer in a listing.
     * - minOccurs: 0
     * @var string
     */
    public $WarrantyDurationOption;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: This string field is a textual description of the warranty duration.
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for WarrantyDurationDetailsType
     * @uses WarrantyDurationDetailsType::setWarrantyDurationOption()
     * @uses WarrantyDurationDetailsType::setDescription()
     * @uses WarrantyDurationDetailsType::setAny()
     * @param string $warrantyDurationOption
     * @param string $description
     * @param \DOMDocument $any
     */
    public function __construct($warrantyDurationOption = null, $description = null, \DOMDocument $any = null)
    {
        $this
            ->setWarrantyDurationOption($warrantyDurationOption)
            ->setDescription($description)
            ->setAny($any);
    }
    /**
     * Get WarrantyDurationOption value
     * @return string|null
     */
    public function getWarrantyDurationOption()
    {
        return $this->WarrantyDurationOption;
    }
    /**
     * Set WarrantyDurationOption value
     * @param string $warrantyDurationOption
     * @return \ebay\StructType\WarrantyDurationDetailsType
     */
    public function setWarrantyDurationOption($warrantyDurationOption = null)
    {
        // validation for constraint: string
        if (!is_null($warrantyDurationOption) && !is_string($warrantyDurationOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warrantyDurationOption)), __LINE__);
        }
        $this->WarrantyDurationOption = $warrantyDurationOption;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \ebay\StructType\WarrantyDurationDetailsType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\WarrantyDurationDetailsType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\WarrantyDurationDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\WarrantyDurationDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
