<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerifiedUserRequirementsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type defining the <b>VerifiedUserRequirements</b> container, which is used by the seller to block prospective buyers who do not pass a verified user check.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class VerifiedUserRequirementsType extends AbstractStructBase
{
    /**
     * The VerifiedUser
     * Meta informations extracted from the WSDL
     * - documentation: To block non-verified users from buying/bidding on their items, the seller should include this field and set its value to <code>true</code>. <br/><br/> The Verified User concept is not applicable to all countries, including the US
     * and Germany. To verify if the Verified User concept is applicable to a specific site, call <b>GeteBayDetails</b> with <b>DetailName</b> set to <code>BuyerRequirementDetails</code>, and then look for the
     * <b>BuyerRequirementDetails.VerifiedUserRequirements</b> container.
     * - minOccurs: 0
     * @var bool
     */
    public $VerifiedUser;
    /**
     * The MinimumFeedbackScore
     * Meta informations extracted from the WSDL
     * - documentation: This field is ignored unless the <b>VerifiedUser</b> field is included and set to <code>true</code>. <br/><br/> The seller includes this field as a mechanism to block verified users who have a feedback score less than the specified
     * value. <br/><br/> The Verified User concept is not applicable to all countries, including the US and Germany. To verify if the Verified User concept is applicable to a specific site, call <b>GeteBayDetails</b> with <b>DetailName</b> set to
     * <b>BuyerRequirementDetails</b>, and then look for the <b>BuyerRequirementDetails.VerifiedUserRequirements</b> container. The valid <b>MinimumFeedbackScore</b> values will be seen in the
     * <b>BuyerRequirementDetails.VerifiedUserRequirements.FeedbackScore</b> fields.
     * - minOccurs: 0
     * @var int
     */
    public $MinimumFeedbackScore;
    /**
     * Constructor method for VerifiedUserRequirementsType
     * @uses VerifiedUserRequirementsType::setVerifiedUser()
     * @uses VerifiedUserRequirementsType::setMinimumFeedbackScore()
     * @param bool $verifiedUser
     * @param int $minimumFeedbackScore
     */
    public function __construct($verifiedUser = null, $minimumFeedbackScore = null)
    {
        $this
            ->setVerifiedUser($verifiedUser)
            ->setMinimumFeedbackScore($minimumFeedbackScore);
    }
    /**
     * Get VerifiedUser value
     * @return bool|null
     */
    public function getVerifiedUser()
    {
        return $this->VerifiedUser;
    }
    /**
     * Set VerifiedUser value
     * @param bool $verifiedUser
     * @return \ebay\StructType\VerifiedUserRequirementsType
     */
    public function setVerifiedUser($verifiedUser = null)
    {
        $this->VerifiedUser = $verifiedUser;
        return $this;
    }
    /**
     * Get MinimumFeedbackScore value
     * @return int|null
     */
    public function getMinimumFeedbackScore()
    {
        return $this->MinimumFeedbackScore;
    }
    /**
     * Set MinimumFeedbackScore value
     * @param int $minimumFeedbackScore
     * @return \ebay\StructType\VerifiedUserRequirementsType
     */
    public function setMinimumFeedbackScore($minimumFeedbackScore = null)
    {
        // validation for constraint: int
        if (!is_null($minimumFeedbackScore) && !is_numeric($minimumFeedbackScore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minimumFeedbackScore)), __LINE__);
        }
        $this->MinimumFeedbackScore = $minimumFeedbackScore;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\VerifiedUserRequirementsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
