<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Contains information about a single order line item (transaction). An order line item contains information about the sale of one or multiple items from a single listing to a single buyer. The eBay system creates an order line item
 * when a buyer has committed to make a purchase in an auction or fixed-price listing. A fixed-priced listing (with multiple identical items or a similar item with variations) can spawn one or more order line items. Auction listings and single-quantity,
 * fixed-price listings can only spawn one order line item.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class TransactionType extends AbstractStructBase
{
    /**
     * The AmountPaid
     * Meta informations extracted from the WSDL
     * - documentation: The total amount the buyer paid for the order line item. This amount includes all costs such as shipping, handling, or sales tax. If the seller allowed the buyer to change the total for an order, the buyer is able to change the total
     * up until the time when Checkout status is Complete. Determine whether the buyer changed the amount by retrieving the order line item data and comparing the <b>AmountPaid</b> value to what the seller expected. If multiple order line items between the
     * same buyer and seller have been combined into a Combined Invoice order, the <b>AmountPaid</b> value returned in <b>GetSellerTransactions</b> and <b>GetItemTransactions</b> reflects the amount paid for the Combined Invoice order and not the individual
     * order line item. You can determine the order line items that belong to the same Combined Invoice order by checking to see if the <b>ContainingOrder.OrderID</b> value is the same. For Motors items, <b>AmountPaid</b> is the amount paid by the buyer for
     * the deposit.<br /> <br /> Not applicable to Half.com.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $AmountPaid;
    /**
     * The AdjustmentAmount
     * Meta informations extracted from the WSDL
     * - documentation: Adjustment amount entered by the buyer. A positive amount indicates the amount is an extra charge being paid to the seller by the buyer. A negative value indicates this amount is a credit given to the buyer by the seller. <br><br>
     * Not applicable to Half.com.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $AdjustmentAmount;
    /**
     * The ConvertedAdjustmentAmount
     * Meta informations extracted from the WSDL
     * - documentation: Converted value of <b>AdjustmentAmount</b> in the currency of the site that returned the response. Refresh this value every 24 hours to pick up the current conversion rates. <br /> <br /> Not applicable to Half.com.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $ConvertedAdjustmentAmount;
    /**
     * The Buyer
     * Meta informations extracted from the WSDL
     * - documentation: Container consisting of user and shipping details for the buyer. See <b>UserType</b> for its child elements. Returned by <b>GetItemsAwaitingFeedback</b> if Seller is making the request.<br> <br> Applicable to Half.com (for
     * <b>GetOrders</b> only).
     * - minOccurs: 0
     * @var \ebay\StructType\UserType
     */
    public $Buyer;
    /**
     * The ShippingDetails
     * Meta informations extracted from the WSDL
     * - documentation: Container consisting of shipping-related details for an order. Shipping details include shipping rates, package dimensions, handling costs, excluded shipping locations (if specified), shipping service options, shipping insurance
     * information, sales tax information (if applicable), and shipment tracking details (if shipped). <br><br> For <b>GetSellerTransactions</b> and <b>GetItemTransactions</b>, the <b>ShippingDetails</b> container is returned in the <b>Transaction</b>
     * container. For <b>GetOrders</b> and <b>GetOrderTransactions</b>, the <b>ShippingDetails</b> container is returned at the Order level. <br><br> Applicable to Half.com (for <b>GetOrders</b> only).
     * - minOccurs: 0
     * @var \ebay\StructType\ShippingDetailsType
     */
    public $ShippingDetails;
    /**
     * The ConvertedAmountPaid
     * Meta informations extracted from the WSDL
     * - documentation: Converted value of <b>AmountPaid</b> in the currency of the site that returned the response. Refresh this value every 24 hours to pick up the current conversion rates. <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $ConvertedAmountPaid;
    /**
     * The ConvertedTransactionPrice
     * Meta informations extracted from the WSDL
     * - documentation: Converted value of <b>TransactionPrice</b> in the currency of the site that returned the response. Refresh this value every 24 hours to pick up the current conversion rates. <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $ConvertedTransactionPrice;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the creation time of the order line item. For auction listings, an order line item is created when that listing ends with a high bidder whose bid meets or exceeds the Reserve Price (if set). For a fixed-price listing or a
     * Buy It Now auction listing, an order line item is created once the buyer clicks the Buy button. <br><br> Applicable to Half.com (for <b>GetOrders</b> only).
     * - minOccurs: 0
     * @var string
     */
    public $CreatedDate;
    /**
     * The DepositType
     * Meta informations extracted from the WSDL
     * - documentation: This value indicates whether or not the seller requires a deposit for the vehicle. This field is only applicable to US eBay Motors listings. Otherwise, this field is returned as an empty value. <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var string
     */
    public $DepositType;
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - documentation: Container consisting of details about an item in a listing. The child fields return are dependent on the call, the type of item or listing, and the listing site. <br><br> Applicable to Half.com (for <b>GetOrders</b>).
     * - minOccurs: 0
     * @var \ebay\StructType\ItemType
     */
    public $Item;
    /**
     * The QuantityPurchased
     * Meta informations extracted from the WSDL
     * - documentation: This value indicates the number of identical items purchased at the same time by the same buyer from one listing. For auction listings, this value is always 1. For fixed-price, non-variation listings, this value can be greater than
     * 1. In either case, this field is tied to the same order line item. <br><br> Applicable to Half.com (for <b>GetOrders</b>).
     * - minOccurs: 0
     * @var int
     */
    public $QuantityPurchased;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Container consisting of status details of an order line item, including payment information. Several of these fields change values during the checkout flow. See <b>TransactionStatusType</b> for its child elements. <br><br> For
     * <b>GetOrders</b>, only the <b>IntegratedMerchantCreditCardEnabled</b>, and <b>PaymentHoldStatus</b> child elements are returned. The fields indicating the status of the order are actually found in the <b>OrderArray.Order.CheckoutStatus</b> container.
     * <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var \ebay\StructType\TransactionStatusType
     */
    public $Status;
    /**
     * The TransactionID
     * Meta informations extracted from the WSDL
     * - documentation: Unique identifier for an eBay order line item (transaction). An order line item is created once there is a commitment from a buyer to purchase an item. Since an auction listing can only have one order line item during the duration of
     * the listing, the <b>TransactionID</b> for auction listings is always 0. Along with its corresponding <b>ItemID</b>, a <b>TransactionID</b> is used and referenced during an order checkout flow and after checkout has been completed. <br><br> Applicable
     * to Half.com (for <b>GetOrders</b> only).
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The TransactionPrice
     * Meta informations extracted from the WSDL
     * - documentation: The price of the order line item (transaction). This amount does not take into account shipping, sales tax, and other costs related to the order line item. If multiple units were purchased through a non- variation, fixed-price
     * listing, consider this value the per-unit price. In this case, the <b>TransactionPrice</b> would be multiplied by the <b>Transaction.QuantityPurchased</b> value. <br><br> For eBay Motors, <b>TransactionPrice</b> is the deposit amount. For Best
     * Offers, this is the seller-accepted per-item price. <br><br> Applicable to Half.com (for <b>GetOrders</b>).
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $TransactionPrice;
    /**
     * The BestOfferSale
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether or not the order line item was created as the result of the seller accepting a Best Offer from a buyer. <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var bool
     */
    public $BestOfferSale;
    /**
     * The VATPercent
     * Meta informations extracted from the WSDL
     * - documentation: VAT rate for the item. When the <b>VATPercent</b> is specified, the item's VAT information appears on the item's listing page. In addition, the seller can choose to print an invoice that includes the item's net price, VAT percent,
     * VAT amount, and total price. Since VAT rates vary depending on the item and on the user's country of residence, a seller is responsible for entering the correct VAT rate; it is not calculated by eBay. To specify a <b>VATPercent</b>, a seller must
     * have a VAT-ID registered with eBay and must be listing the item on a VAT-enabled site. Max precision 3 decimal places. Max length 5 characters. Note: The View Item page displays the precision to 2 decimal places with no trailing zeros. However, the
     * full value you send in is stored. <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var float
     */
    public $VATPercent;
    /**
     * The ExternalTransaction
     * Meta informations extracted from the WSDL
     * - documentation: Container consisting of details for a PayPal transaction that relates to the eBay order. PayPal transactions may include a buyer payment or refund, or a fee or credit applied to the seller's account. This field is only returned if a
     * PayPal transaction related to order has occurred. <br><br> Not applicable to Half.com.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\ExternalTransactionType[]
     */
    public $ExternalTransaction;
    /**
     * The SellingManagerProductDetails
     * Meta informations extracted from the WSDL
     * - documentation: This container consists of Selling Manager product details and is only returned if the item was listed through Selling Manager. <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var \ebay\StructType\SellingManagerProductDetailsType
     */
    public $SellingManagerProductDetails;
    /**
     * The ShippingServiceSelected
     * Meta informations extracted from the WSDL
     * - documentation: The shipping service selected by the buyer from the services offered by the seller. <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var \ebay\StructType\ShippingServiceOptionsType
     */
    public $ShippingServiceSelected;
    /**
     * The BuyerMessage
     * Meta informations extracted from the WSDL
     * - documentation: Display message from buyer. This field holds transient data that is only being returned in Checkout related notifications. <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var string
     */
    public $BuyerMessage;
    /**
     * The DutchAuctionBid
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $DutchAuctionBid;
    /**
     * The BuyerPaidStatus
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the paid status of the order. <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var string
     */
    public $BuyerPaidStatus;
    /**
     * The SellerPaidStatus
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the paid status of the order. <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var string
     */
    public $SellerPaidStatus;
    /**
     * The PaidTime
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the time when the order was marked paid. This field is not returned until payment has been made by the buyer. This field will not be returned for orders where the buyer has received partial or full refunds. <br><br> This
     * value will only be visible to the user on either side of the order. An order can be marked as paid in the following ways: <ul> <li>Automatically when a payment is made via PayPal </li> <li>Seller marks the item as paid in My eBay or through Selling
     * Manager Pro </li> <li>Programmatically by the seller through the <b>ReviseCheckoutStatus</b> or <b>CompleteSale</b> calls.</li> </ul> <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var string
     */
    public $PaidTime;
    /**
     * The ShippedTime
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the time when the item(s) associated with the order were marked as shipped. This value will only be visible to the user on either side of the order. An order can be marked as shipped in My eBay or through Selling Manager
     * Pro, or programmatically by the seller through the <b>CompleteSale</b> call. <br><br> Applicable to Half.com (for <b>GetOrders</b> only).
     * - minOccurs: 0
     * @var string
     */
    public $ShippedTime;
    /**
     * The TotalPrice
     * Meta informations extracted from the WSDL
     * - documentation: This field indicates the total price for an order line item. <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $TotalPrice;
    /**
     * The FeedbackLeft
     * Meta informations extracted from the WSDL
     * - documentation: This container consists of Feedback left by the caller for their order partner. This container is only returned if the order is complete and feedback on the order line item has been left by the caller. <br><br> Not applicable to
     * Half.com.
     * - minOccurs: 0
     * @var \ebay\StructType\FeedbackInfoType
     */
    public $FeedbackLeft;
    /**
     * The FeedbackReceived
     * Meta informations extracted from the WSDL
     * - documentation: This container consists of Feedback received by the caller from their order partner. This container is only returned if the order is complete and feedback on the order line item has been received by the caller. <br><br> Not
     * applicable to Half.com.
     * - minOccurs: 0
     * @var \ebay\StructType\FeedbackInfoType
     */
    public $FeedbackReceived;
    /**
     * The ContainingOrder
     * Meta informations extracted from the WSDL
     * - documentation: The Combined Invoice order to which the order line item belongs. This container is only returned if <b>IncludeContainingOrder</b> is included and set to true in a <b>GetItemTransactions</b> or <b>GetSellerTransactions</b> request.
     * <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var \ebay\StructType\OrderType
     */
    public $ContainingOrder;
    /**
     * The FinalValueFee
     * Meta informations extracted from the WSDL
     * - documentation: A Final Value Fee is calculated and charged to a seller's account immediately upon creation of an order line item. Note that this fee is created before the buyer makes a payment.The Final Value Fee for each order line item is
     * returned by <b>GetSellerTransactions</b>, <b>GetItemTransactions</b>, <b>GetOrders</b>, and <b>GetOrderTransactions</b>, regardless of the checkout status. <br><br> If a seller requests a Final Value Fee credit, the value of
     * <b>Transaction.FinalValueFee</b> will not change if a credit is issued. The credit only appears in the seller's account data. <br><br> Not applicable to Half.com.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $FinalValueFee;
    /**
     * The ListingCheckoutRedirectPreference
     * Meta informations extracted from the WSDL
     * - documentation: ProStores listing level preferences regarding the store to which checkout should be redirected for the listing if <b>Item.ThirdPartyCheckout</b> is true.
     * - minOccurs: 0
     * @var \ebay\StructType\ListingCheckoutRedirectPreferenceType
     */
    public $ListingCheckoutRedirectPreference;
    /**
     * The RefundArray
     * Meta informations extracted from the WSDL
     * - documentation: Container consisting of one or more refund transactions to Half.com buyers.
     * - minOccurs: 0
     * @var \ebay\ArrayType\RefundArrayType
     */
    public $RefundArray;
    /**
     * The TransactionSiteID
     * Meta informations extracted from the WSDL
     * - documentation: The site upon which the order line item (transaction) was created.
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSiteID;
    /**
     * The Platform
     * Meta informations extracted from the WSDL
     * - documentation: This value indicates from which site (eBay.com or Half.com) the order line item originated. If 'eBay' was set as the <b>Platform</b> value in the request, all retrieved order line items should have originated from eBay.com. If 'Half'
     * was set as the <b>Platform</b> value in the request, all retrieved order line items should have originated from Half.com.
     * - minOccurs: 0
     * @var string
     */
    public $Platform;
    /**
     * The CartID
     * Meta informations extracted from the WSDL
     * - documentation: Unique identifier for an instance of Shopping.com shopping cart. This field is only returned for Shopping.com order line items (transactions).
     * - minOccurs: 0
     * @var string
     */
    public $CartID;
    /**
     * The SellerContactBuyerByEmail
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the buyer has opted to accept emails from all the selling partners on Shopping.com. This field is only returned for order line items purchased through the Shopping.com shopping cart.
     * - minOccurs: 0
     * @var bool
     */
    public $SellerContactBuyerByEmail;
    /**
     * The PayPalEmailAddress
     * Meta informations extracted from the WSDL
     * - documentation: The seller's PayPal email address. This value is only revealed if it is the seller making the call.
     * - minOccurs: 0
     * @var string
     */
    public $PayPalEmailAddress;
    /**
     * The PaisaPayID
     * Meta informations extracted from the WSDL
     * - documentation: Unique identifier for a PaisaPay transaction. Only applicable for the India site (203) if PaisaPay was the payment method used.
     * - minOccurs: 0
     * @var string
     */
    public $PaisaPayID;
    /**
     * The BuyerGuaranteePrice
     * Meta informations extracted from the WSDL
     * - documentation: For the Australia site, <b>BuyerGuaranteePrice</b> is the PayPal Buyer Protection coverage, offered for the item at the time of purchase. Details of coverage are in the following sections of the View Item page: the Buy Safely section
     * and the Payment Details section.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $BuyerGuaranteePrice;
    /**
     * The Variation
     * Meta informations extracted from the WSDL
     * - documentation: In a fixed-priced listing, a seller can offer variations of the same item. For example, the seller could create a fixed-priced listing for a t-shirt design and offer the shirt in different colors and sizes. In this case, each color
     * and size combination is a separate variation. Each variation can have a different quantity and price. Due to the possible price differentiation, buyers can buy multiple items from this listing at the same time, but all of the items must be of the
     * same variation. One order line item is created whether one or multiple items of the same variation are purchased. <br><br> The <b>Variation</b> node contains information about which variation was purchased. Therefore, applications that process orders
     * should always check to see if this node is present.
     * - minOccurs: 0
     * @var \ebay\StructType\VariationType
     */
    public $Variation;
    /**
     * The BuyerCheckoutMessage
     * Meta informations extracted from the WSDL
     * - documentation: This field is returned if a buyer left a comment for the seller during the left by buyer during the checkout flow.
     * - minOccurs: 0
     * @var string
     */
    public $BuyerCheckoutMessage;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - documentation: A container consisting of detailed sales tax information for an order line item. The <b>Taxes</b> container is only returned if the seller is using the Vertex-based Premium Sales Tax Engine solution. The information in this container
     * supercedes/overrides the sales tax information in the <b>ShippingDetails.SalesTax</b> container.
     * - minOccurs: 0
     * @var \ebay\StructType\TaxesType
     */
    public $Taxes;
    /**
     * The BundlePurchase
     * Meta informations extracted from the WSDL
     * - documentation: Boolean value indicating whether or not an order line item is part of a bundle purchase using Product Configurator.
     * - minOccurs: 0
     * @var bool
     */
    public $BundlePurchase;
    /**
     * The ActualShippingCost
     * Meta informations extracted from the WSDL
     * - documentation: The shipping cost paid by the buyer for the order line item. This field is only returned after checkout is complete.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $ActualShippingCost;
    /**
     * The ActualHandlingCost
     * Meta informations extracted from the WSDL
     * - documentation: The handling cost that the seller has charged for the order line item. This field is only returned after checkout is complete. <br><br> The value of this field is returned as zero dollars (0.0) if the seller did not specify a
     * handling cost for the listing.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $ActualHandlingCost;
    /**
     * The OrderLineItemID
     * Meta informations extracted from the WSDL
     * - documentation: A unique identifier for an eBay order line item. This field is created as soon as there is a commitment to buy from the seller, and its value is based upon the concatenation of <b>ItemID</b> and <b>TransactionID</b>, with a hyphen in
     * between these two IDs.
     * - minOccurs: 0
     * @var string
     */
    public $OrderLineItemID;
    /**
     * The eBayPaymentID
     * Meta informations extracted from the WSDL
     * - documentation: The generated eBay payment ID used by the buyer when he/she chooses electronic transfer as payment method for paying the seller. This field is only applicable to the eBay Germany site (Site ID 77).
     * - minOccurs: 0
     * @var string
     */
    public $eBayPaymentID;
    /**
     * The PaymentHoldDetails
     * Meta informations extracted from the WSDL
     * - documentation: This container consists of information related to the payment hold on the order line item, including the reason why the buyer's payment for the order line item is being held, the expected release date of the funds into the seller's
     * account, and possible action(s) the seller can take to expedite the payout of funds into their account. This container is only returned if PayPal has placed a payment hold on the order line item. <br/><br/> An American seller (selling on US or US
     * Motors sites) and a Canadian seller (selling on CA and CA- FR sites) may be subject to PayPal payment holds (that last from three to 21 days) if that seller is new to selling on eBay or is classified as a "Below Standard" seller. For other reasons
     * why a seller's funds may be held by PayPal, see the <b>PaymentHoldReason</b> field.
     * - minOccurs: 0
     * @var \ebay\StructType\PaymentHoldDetailType
     */
    public $PaymentHoldDetails;
    /**
     * The SellerDiscounts
     * Meta informations extracted from the WSDL
     * - documentation: A container consisting of name and ID of the seller's discount campaign, as well as the discount amount that is being applied to the order line item.
     * - minOccurs: 0
     * @var \ebay\StructType\SellerDiscountsType
     */
    public $SellerDiscounts;
    /**
     * The RefundAmount
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $RefundAmount;
    /**
     * The RefundStatus
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var string
     */
    public $RefundStatus;
    /**
     * The CodiceFiscale
     * Meta informations extracted from the WSDL
     * - documentation: This field is returned if the <b>IncludeCodiceFiscale</b> flag is included in the request and set to <code>true</code>, and if the buyer has provided this value at checkout time. <br/><br/> This field is only applicable to buyers on
     * the Italy and Spain sites. The Codice Fiscale number is unique for each Italian and Spanish citizen and is used for tax purposes.
     * - minOccurs: 0
     * @var string
     */
    public $CodiceFiscale;
    /**
     * The IsMultiLegShipping
     * Meta informations extracted from the WSDL
     * - documentation: If <strong>IsMultilegShipping</strong> is true, the Global Shipping Program (GSP) will be used to ship the order line item to an international buyer. A GSP shipment has a domestic leg and an international leg. The buyer's shipping
     * address is in a country other than the country where the item was listed, and the seller has specified 'InternationalPriorityShipping' as the default international shipping service in the listing. <br/><br/> If <strong>IsMultilegShipping</strong> is
     * false, the order line item will not be shipped with the Global Shipping Program. </span>
     * - minOccurs: 0
     * @var bool
     */
    public $IsMultiLegShipping;
    /**
     * The MultiLegShippingDetails
     * Meta informations extracted from the WSDL
     * - documentation: Contains details about the domestic leg of a Global Shipping Program shipment. <br/><br/> This container is not returned if <strong>IsMultilegShipping</strong> is false.
     * - minOccurs: 0
     * @var \ebay\StructType\MultiLegShippingDetailsType
     */
    public $MultiLegShippingDetails;
    /**
     * The InvoiceSentTime
     * Meta informations extracted from the WSDL
     * - documentation: This field indicates the date/time that an order invoice was sent from the seller to the buyer. This field is only returned if an invoice (containing the order line item) was sent to the buyer.
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceSentTime;
    /**
     * The UnpaidItem
     * Meta informations extracted from the WSDL
     * - documentation: Container consisting of details related to the type and status of an Unpaid Item case. This container is only returned if there is an open or closed Unpaid Item case associated with the order line item.
     * - minOccurs: 0
     * @var \ebay\StructType\UnpaidItemType
     */
    public $UnpaidItem;
    /**
     * The IntangibleItem
     * Meta informations extracted from the WSDL
     * - documentation: This flag indicates whether or not the order line item is an intangible good such as an MP3 track or a mobile phone ringtone. Intangible items are not eligible for PayPal's Seller Protection program, so the seller will not be able to
     * open an Unpaid Item case against the buyer.
     * - minOccurs: 0
     * @var bool
     */
    public $IntangibleItem;
    /**
     * The MonetaryDetails
     * Meta informations extracted from the WSDL
     * - documentation: Contains information about how funds exchanged for an order line item are allocated to payees. <br/><br/> For example, for an order line item using eBay's Global Shipping Program, users can see the portion of the buyer's payment that
     * is allocated as shipping and import charges remitted to the international shipping provider. Currently, only payment information is returned. <br/><br/> <span class="tablenote"> <strong>Note:</strong> In an upcoming release,
     * <strong>MonetaryDetails</strong> will replace the <strong>ExternalTransaction</strong> container, so you are encouraged to start using <strong>MonetaryDetails</strong> now. </span>
     * - minOccurs: 0
     * @var \ebay\StructType\PaymentsInformationType
     */
    public $MonetaryDetails;
    /**
     * The PickupDetails
     * Meta informations extracted from the WSDL
     * - documentation: Container consisting of an array of <strong>PickupOptions</strong> containers. Each <strong>PickupOptions</strong> container consists of the pickup method and its priority. The priority of each pickup method controls the order
     * (relative to other pickup methods) in which the corresponding pickup method will appear in the View Item and Checkout page. With this initial version of In-Store Pickup, the only pickup method is 'InStorePickup'. <br/><br/> For
     * <strong>GetOrders</strong> and <strong>GetOrderTransactions</strong>, this container is always returned prior to order payment if the seller created/revised/relisted the item with the <strong>EligibleForPickupInStore</strong> flag in the call request
     * set to 'true'. If and when the In-Store pickup method is selected by the buyer and payment for the order is made, this container will no longer be returned in the response, and will essentially be replaced by the <strong>PickupMethodSelected</strong>
     * container. <br/><br/> <span class="tablenote"> <strong>Note:</strong> A seller must be eligible for the In-Store Pickup feature to list an item that is eligible for In-Store Pickup. At this time, the In-Store Pickup feature is generally only
     * available to large retail merchants, and can only be applied to multi-quantity, fixed-price listings. </span>
     * - minOccurs: 0
     * @var \ebay\StructType\PickupDetailsType
     */
    public $PickupDetails;
    /**
     * The PickupMethodSelected
     * Meta informations extracted from the WSDL
     * - documentation: This container consists of details related to the selected In-Store pickup method, including the pickup method, the merchant's store ID, the status of the In-Store pickup, and the pickup reference code (if provided by merchant).
     * - minOccurs: 0
     * @var \ebay\StructType\PickupMethodSelectedType
     */
    public $PickupMethodSelected;
    /**
     * The ShippingConvenienceCharge
     * Meta informations extracted from the WSDL
     * - documentation: The dollar value in this field indicates the amount that the seller is being charged (at line item level) for the convenience of an eBay Scheduled Delivery. eBay Scheduled Delivery is currently only available in the London (UK) area.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $ShippingConvenienceCharge;
    /**
     * The LogisticsPlanType
     * Meta informations extracted from the WSDL
     * - documentation: This field will be returned at the order line item level only if the buyer purchased a digital gift card, which is delivered by email, or if the buyer purchased an item that is enabled with the 'Click and Collect' feature. <br/><br/>
     * Currently, <strong>LogisticsPlanType</strong> has two applicable values: <code>PickUpDropOff</code>, which indicates that the buyer selected the 'Click and Collect' option. With Click and Collect, buyers are able to purchase from thousands of sellers
     * on the eBay UK and Australia sites, and then pick up their order from the nearest 'eBay Collection Point', including over 750 Argos stores in the UK. The Click and Collect feature is only available on the eBay UK and Australia sites; or,
     * <code>DigitalDelivery</code>, which indicates that the order line item is a digital gift card that will be delivered to the buyer or recipient of the gift card by email.
     * - minOccurs: 0
     * @var string
     */
    public $LogisticsPlanType;
    /**
     * The BuyerPackageEnclosures
     * Meta informations extracted from the WSDL
     * - documentation: This container is returned in <b>GetOrders</b> (and other order management calls) if the 'Pay Upon Invoice' option is being offered to the buyer, and the seller is including payment instructions in the shipping package(s) for the
     * order. The 'Pay Upon Invoice' option is only available on the German site.
     * - minOccurs: 0
     * @var \ebay\StructType\BuyerPackageEnclosuresType
     */
    public $BuyerPackageEnclosures;
    /**
     * The InventoryReservationID
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier of the inventory reservation.
     * - minOccurs: 0
     * @var string
     */
    public $InventoryReservationID;
    /**
     * The ExtendedOrderID
     * Meta informations extracted from the WSDL
     * - documentation: A unique identifier for an eBay order line item. <b>ExtendedOrderID</b> values will be used to identify order line items in the Post-Order API. For Trading API Get calls, <b>OrderLineItemID</b> values should still be used.
     * - minOccurs: 0
     * @var string
     */
    public $ExtendedOrderID;
    /**
     * The eBayPlusTransaction
     * Meta informations extracted from the WSDL
     * - documentation: If <code>true</code>, this transaction is for an item that was purchased under the eBay Plus program. eBay Plus is a premium account option for buyers, which provides benefits such as fast free domestic shipping and free returns on
     * selected items. Top Rated eBay sellers must opt in to eBay Plus to be able offer the program on qualifying listings. Sellers must commit to next-day delivery of those items. <br/><br/> <span class="tablenote"><b>Note:</b> Currently, eBay Plus is
     * available only to buyers in Germany (DE). </span>
     * - minOccurs: 0
     * @var bool
     */
    public $eBayPlusTransaction;
    /**
     * The GiftSummary
     * Meta informations extracted from the WSDL
     * - documentation: <span class="tablenote"><strong>Note:</strong> This container was enabled with version 935. For those using versions older than 935, this container will not be returned. </span> <br/> This container is returned in <b>GetOrders</b>
     * and other order management calls if a buyer has purchased a digital gift card but has sent it to another individual as a gift, and has left a message for the recipient. The <b>GiftSummary</b> container consists of the message that the buyer wrote for
     * the recipient of the digital gift card. A digital gift card line item is indicated if the <b>DigitalDeliverySelected</b> container is returned in the response, and if the digital gift card is sent to another individual as a gift, the <b>Gift</b>
     * boolean field will be returned with a value of <code>true</code>.
     * - minOccurs: 0
     * @var \ebay\StructType\GiftSummaryType
     */
    public $GiftSummary;
    /**
     * The DigitalDeliverySelected
     * Meta informations extracted from the WSDL
     * - documentation: <span class="tablenote"><strong>Note:</strong> This container was enabled with version 935. For those using versions older than 935, this container will not be returned. </span> <br/> This container is only returned by
     * <b>GetOrders</b> and other order management calls if the buyer purchased a digital gift card for themselves, or is giving the digital gift card to someone else as a gift (in this case, the <b>Gift</b> boolean field will be returned with a value of
     * <code>true</code>). The <b>DigitalDeliverySelected</b> container consists of information related to the digital gift card order line item, including the delivery method, delivery status, and recipient of the gift card (either the buyer, or another
     * individual that is receiving the gift card as a gift from the buyer.
     * - minOccurs: 0
     * @var \ebay\StructType\DigitalDeliverySelectedType
     */
    public $DigitalDeliverySelected;
    /**
     * The Gift
     * Meta informations extracted from the WSDL
     * - documentation: <span class="tablenote"><strong>Note:</strong> This field was enabled with version 935. For those using versions older than 935, this field will not be returned. </span> <br/> This boolean field is returned as <code>true</code> if
     * the seller is giving a digital gift card to another individual as a gift. This field is only applicable for digital gift card order line items.
     * - minOccurs: 0
     * @var bool
     */
    public $Gift;
    /**
     * The GuaranteedShipping
     * Meta informations extracted from the WSDL
     * - documentation: <span class="tablenote"><b>Note: </b> This field is for future use, as the eBay Guarantee Shipping feature will not start rolling out and be available to sellers until October 2016. </span> This field is returned as <code>true</code>
     * if the seller chose to use eBay's Guarantee Shipping feature at listing time. With eBay's Guarantee Shipping, the seller will never pay more for shipping than what is charged to the buyer. eBay recommends the shipping service option for the seller to
     * use based on the dimensions and weight of the shipping package. At this time, eBay's Guarantee Shipping feature can not be set up with the Add/Revise/Relist API calls, but must be set up through the Web flow.
     * - minOccurs: 0
     * @var bool
     */
    public $GuaranteedShipping;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for TransactionType
     * @uses TransactionType::setAmountPaid()
     * @uses TransactionType::setAdjustmentAmount()
     * @uses TransactionType::setConvertedAdjustmentAmount()
     * @uses TransactionType::setBuyer()
     * @uses TransactionType::setShippingDetails()
     * @uses TransactionType::setConvertedAmountPaid()
     * @uses TransactionType::setConvertedTransactionPrice()
     * @uses TransactionType::setCreatedDate()
     * @uses TransactionType::setDepositType()
     * @uses TransactionType::setItem()
     * @uses TransactionType::setQuantityPurchased()
     * @uses TransactionType::setStatus()
     * @uses TransactionType::setTransactionID()
     * @uses TransactionType::setTransactionPrice()
     * @uses TransactionType::setBestOfferSale()
     * @uses TransactionType::setVATPercent()
     * @uses TransactionType::setExternalTransaction()
     * @uses TransactionType::setSellingManagerProductDetails()
     * @uses TransactionType::setShippingServiceSelected()
     * @uses TransactionType::setBuyerMessage()
     * @uses TransactionType::setDutchAuctionBid()
     * @uses TransactionType::setBuyerPaidStatus()
     * @uses TransactionType::setSellerPaidStatus()
     * @uses TransactionType::setPaidTime()
     * @uses TransactionType::setShippedTime()
     * @uses TransactionType::setTotalPrice()
     * @uses TransactionType::setFeedbackLeft()
     * @uses TransactionType::setFeedbackReceived()
     * @uses TransactionType::setContainingOrder()
     * @uses TransactionType::setFinalValueFee()
     * @uses TransactionType::setListingCheckoutRedirectPreference()
     * @uses TransactionType::setRefundArray()
     * @uses TransactionType::setTransactionSiteID()
     * @uses TransactionType::setPlatform()
     * @uses TransactionType::setCartID()
     * @uses TransactionType::setSellerContactBuyerByEmail()
     * @uses TransactionType::setPayPalEmailAddress()
     * @uses TransactionType::setPaisaPayID()
     * @uses TransactionType::setBuyerGuaranteePrice()
     * @uses TransactionType::setVariation()
     * @uses TransactionType::setBuyerCheckoutMessage()
     * @uses TransactionType::setTaxes()
     * @uses TransactionType::setBundlePurchase()
     * @uses TransactionType::setActualShippingCost()
     * @uses TransactionType::setActualHandlingCost()
     * @uses TransactionType::setOrderLineItemID()
     * @uses TransactionType::setEBayPaymentID()
     * @uses TransactionType::setPaymentHoldDetails()
     * @uses TransactionType::setSellerDiscounts()
     * @uses TransactionType::setRefundAmount()
     * @uses TransactionType::setRefundStatus()
     * @uses TransactionType::setCodiceFiscale()
     * @uses TransactionType::setIsMultiLegShipping()
     * @uses TransactionType::setMultiLegShippingDetails()
     * @uses TransactionType::setInvoiceSentTime()
     * @uses TransactionType::setUnpaidItem()
     * @uses TransactionType::setIntangibleItem()
     * @uses TransactionType::setMonetaryDetails()
     * @uses TransactionType::setPickupDetails()
     * @uses TransactionType::setPickupMethodSelected()
     * @uses TransactionType::setShippingConvenienceCharge()
     * @uses TransactionType::setLogisticsPlanType()
     * @uses TransactionType::setBuyerPackageEnclosures()
     * @uses TransactionType::setInventoryReservationID()
     * @uses TransactionType::setExtendedOrderID()
     * @uses TransactionType::setEBayPlusTransaction()
     * @uses TransactionType::setGiftSummary()
     * @uses TransactionType::setDigitalDeliverySelected()
     * @uses TransactionType::setGift()
     * @uses TransactionType::setGuaranteedShipping()
     * @uses TransactionType::setAny()
     * @param \ebay\StructType\AmountType $amountPaid
     * @param \ebay\StructType\AmountType $adjustmentAmount
     * @param \ebay\StructType\AmountType $convertedAdjustmentAmount
     * @param \ebay\StructType\UserType $buyer
     * @param \ebay\StructType\ShippingDetailsType $shippingDetails
     * @param \ebay\StructType\AmountType $convertedAmountPaid
     * @param \ebay\StructType\AmountType $convertedTransactionPrice
     * @param string $createdDate
     * @param string $depositType
     * @param \ebay\StructType\ItemType $item
     * @param int $quantityPurchased
     * @param \ebay\StructType\TransactionStatusType $status
     * @param string $transactionID
     * @param \ebay\StructType\AmountType $transactionPrice
     * @param bool $bestOfferSale
     * @param float $vATPercent
     * @param \ebay\StructType\ExternalTransactionType[] $externalTransaction
     * @param \ebay\StructType\SellingManagerProductDetailsType $sellingManagerProductDetails
     * @param \ebay\StructType\ShippingServiceOptionsType $shippingServiceSelected
     * @param string $buyerMessage
     * @param \ebay\StructType\AmountType $dutchAuctionBid
     * @param string $buyerPaidStatus
     * @param string $sellerPaidStatus
     * @param string $paidTime
     * @param string $shippedTime
     * @param \ebay\StructType\AmountType $totalPrice
     * @param \ebay\StructType\FeedbackInfoType $feedbackLeft
     * @param \ebay\StructType\FeedbackInfoType $feedbackReceived
     * @param \ebay\StructType\OrderType $containingOrder
     * @param \ebay\StructType\AmountType $finalValueFee
     * @param \ebay\StructType\ListingCheckoutRedirectPreferenceType $listingCheckoutRedirectPreference
     * @param \ebay\ArrayType\RefundArrayType $refundArray
     * @param string $transactionSiteID
     * @param string $platform
     * @param string $cartID
     * @param bool $sellerContactBuyerByEmail
     * @param string $payPalEmailAddress
     * @param string $paisaPayID
     * @param \ebay\StructType\AmountType $buyerGuaranteePrice
     * @param \ebay\StructType\VariationType $variation
     * @param string $buyerCheckoutMessage
     * @param \ebay\StructType\TaxesType $taxes
     * @param bool $bundlePurchase
     * @param \ebay\StructType\AmountType $actualShippingCost
     * @param \ebay\StructType\AmountType $actualHandlingCost
     * @param string $orderLineItemID
     * @param string $eBayPaymentID
     * @param \ebay\StructType\PaymentHoldDetailType $paymentHoldDetails
     * @param \ebay\StructType\SellerDiscountsType $sellerDiscounts
     * @param \ebay\StructType\AmountType $refundAmount
     * @param string $refundStatus
     * @param string $codiceFiscale
     * @param bool $isMultiLegShipping
     * @param \ebay\StructType\MultiLegShippingDetailsType $multiLegShippingDetails
     * @param string $invoiceSentTime
     * @param \ebay\StructType\UnpaidItemType $unpaidItem
     * @param bool $intangibleItem
     * @param \ebay\StructType\PaymentsInformationType $monetaryDetails
     * @param \ebay\StructType\PickupDetailsType $pickupDetails
     * @param \ebay\StructType\PickupMethodSelectedType $pickupMethodSelected
     * @param \ebay\StructType\AmountType $shippingConvenienceCharge
     * @param string $logisticsPlanType
     * @param \ebay\StructType\BuyerPackageEnclosuresType $buyerPackageEnclosures
     * @param string $inventoryReservationID
     * @param string $extendedOrderID
     * @param bool $eBayPlusTransaction
     * @param \ebay\StructType\GiftSummaryType $giftSummary
     * @param \ebay\StructType\DigitalDeliverySelectedType $digitalDeliverySelected
     * @param bool $gift
     * @param bool $guaranteedShipping
     * @param \DOMDocument $any
     */
    public function __construct(\ebay\StructType\AmountType $amountPaid = null, \ebay\StructType\AmountType $adjustmentAmount = null, \ebay\StructType\AmountType $convertedAdjustmentAmount = null, \ebay\StructType\UserType $buyer = null, \ebay\StructType\ShippingDetailsType $shippingDetails = null, \ebay\StructType\AmountType $convertedAmountPaid = null, \ebay\StructType\AmountType $convertedTransactionPrice = null, $createdDate = null, $depositType = null, \ebay\StructType\ItemType $item = null, $quantityPurchased = null, \ebay\StructType\TransactionStatusType $status = null, $transactionID = null, \ebay\StructType\AmountType $transactionPrice = null, $bestOfferSale = null, $vATPercent = null, array $externalTransaction = array(), \ebay\StructType\SellingManagerProductDetailsType $sellingManagerProductDetails = null, \ebay\StructType\ShippingServiceOptionsType $shippingServiceSelected = null, $buyerMessage = null, \ebay\StructType\AmountType $dutchAuctionBid = null, $buyerPaidStatus = null, $sellerPaidStatus = null, $paidTime = null, $shippedTime = null, \ebay\StructType\AmountType $totalPrice = null, \ebay\StructType\FeedbackInfoType $feedbackLeft = null, \ebay\StructType\FeedbackInfoType $feedbackReceived = null, \ebay\StructType\OrderType $containingOrder = null, \ebay\StructType\AmountType $finalValueFee = null, \ebay\StructType\ListingCheckoutRedirectPreferenceType $listingCheckoutRedirectPreference = null, \ebay\ArrayType\RefundArrayType $refundArray = null, $transactionSiteID = null, $platform = null, $cartID = null, $sellerContactBuyerByEmail = null, $payPalEmailAddress = null, $paisaPayID = null, \ebay\StructType\AmountType $buyerGuaranteePrice = null, \ebay\StructType\VariationType $variation = null, $buyerCheckoutMessage = null, \ebay\StructType\TaxesType $taxes = null, $bundlePurchase = null, \ebay\StructType\AmountType $actualShippingCost = null, \ebay\StructType\AmountType $actualHandlingCost = null, $orderLineItemID = null, $eBayPaymentID = null, \ebay\StructType\PaymentHoldDetailType $paymentHoldDetails = null, \ebay\StructType\SellerDiscountsType $sellerDiscounts = null, \ebay\StructType\AmountType $refundAmount = null, $refundStatus = null, $codiceFiscale = null, $isMultiLegShipping = null, \ebay\StructType\MultiLegShippingDetailsType $multiLegShippingDetails = null, $invoiceSentTime = null, \ebay\StructType\UnpaidItemType $unpaidItem = null, $intangibleItem = null, \ebay\StructType\PaymentsInformationType $monetaryDetails = null, \ebay\StructType\PickupDetailsType $pickupDetails = null, \ebay\StructType\PickupMethodSelectedType $pickupMethodSelected = null, \ebay\StructType\AmountType $shippingConvenienceCharge = null, $logisticsPlanType = null, \ebay\StructType\BuyerPackageEnclosuresType $buyerPackageEnclosures = null, $inventoryReservationID = null, $extendedOrderID = null, $eBayPlusTransaction = null, \ebay\StructType\GiftSummaryType $giftSummary = null, \ebay\StructType\DigitalDeliverySelectedType $digitalDeliverySelected = null, $gift = null, $guaranteedShipping = null, \DOMDocument $any = null)
    {
        $this
            ->setAmountPaid($amountPaid)
            ->setAdjustmentAmount($adjustmentAmount)
            ->setConvertedAdjustmentAmount($convertedAdjustmentAmount)
            ->setBuyer($buyer)
            ->setShippingDetails($shippingDetails)
            ->setConvertedAmountPaid($convertedAmountPaid)
            ->setConvertedTransactionPrice($convertedTransactionPrice)
            ->setCreatedDate($createdDate)
            ->setDepositType($depositType)
            ->setItem($item)
            ->setQuantityPurchased($quantityPurchased)
            ->setStatus($status)
            ->setTransactionID($transactionID)
            ->setTransactionPrice($transactionPrice)
            ->setBestOfferSale($bestOfferSale)
            ->setVATPercent($vATPercent)
            ->setExternalTransaction($externalTransaction)
            ->setSellingManagerProductDetails($sellingManagerProductDetails)
            ->setShippingServiceSelected($shippingServiceSelected)
            ->setBuyerMessage($buyerMessage)
            ->setDutchAuctionBid($dutchAuctionBid)
            ->setBuyerPaidStatus($buyerPaidStatus)
            ->setSellerPaidStatus($sellerPaidStatus)
            ->setPaidTime($paidTime)
            ->setShippedTime($shippedTime)
            ->setTotalPrice($totalPrice)
            ->setFeedbackLeft($feedbackLeft)
            ->setFeedbackReceived($feedbackReceived)
            ->setContainingOrder($containingOrder)
            ->setFinalValueFee($finalValueFee)
            ->setListingCheckoutRedirectPreference($listingCheckoutRedirectPreference)
            ->setRefundArray($refundArray)
            ->setTransactionSiteID($transactionSiteID)
            ->setPlatform($platform)
            ->setCartID($cartID)
            ->setSellerContactBuyerByEmail($sellerContactBuyerByEmail)
            ->setPayPalEmailAddress($payPalEmailAddress)
            ->setPaisaPayID($paisaPayID)
            ->setBuyerGuaranteePrice($buyerGuaranteePrice)
            ->setVariation($variation)
            ->setBuyerCheckoutMessage($buyerCheckoutMessage)
            ->setTaxes($taxes)
            ->setBundlePurchase($bundlePurchase)
            ->setActualShippingCost($actualShippingCost)
            ->setActualHandlingCost($actualHandlingCost)
            ->setOrderLineItemID($orderLineItemID)
            ->setEBayPaymentID($eBayPaymentID)
            ->setPaymentHoldDetails($paymentHoldDetails)
            ->setSellerDiscounts($sellerDiscounts)
            ->setRefundAmount($refundAmount)
            ->setRefundStatus($refundStatus)
            ->setCodiceFiscale($codiceFiscale)
            ->setIsMultiLegShipping($isMultiLegShipping)
            ->setMultiLegShippingDetails($multiLegShippingDetails)
            ->setInvoiceSentTime($invoiceSentTime)
            ->setUnpaidItem($unpaidItem)
            ->setIntangibleItem($intangibleItem)
            ->setMonetaryDetails($monetaryDetails)
            ->setPickupDetails($pickupDetails)
            ->setPickupMethodSelected($pickupMethodSelected)
            ->setShippingConvenienceCharge($shippingConvenienceCharge)
            ->setLogisticsPlanType($logisticsPlanType)
            ->setBuyerPackageEnclosures($buyerPackageEnclosures)
            ->setInventoryReservationID($inventoryReservationID)
            ->setExtendedOrderID($extendedOrderID)
            ->setEBayPlusTransaction($eBayPlusTransaction)
            ->setGiftSummary($giftSummary)
            ->setDigitalDeliverySelected($digitalDeliverySelected)
            ->setGift($gift)
            ->setGuaranteedShipping($guaranteedShipping)
            ->setAny($any);
    }
    /**
     * Get AmountPaid value
     * @return \ebay\StructType\AmountType|null
     */
    public function getAmountPaid()
    {
        return $this->AmountPaid;
    }
    /**
     * Set AmountPaid value
     * @param \ebay\StructType\AmountType $amountPaid
     * @return \ebay\StructType\TransactionType
     */
    public function setAmountPaid(\ebay\StructType\AmountType $amountPaid = null)
    {
        $this->AmountPaid = $amountPaid;
        return $this;
    }
    /**
     * Get AdjustmentAmount value
     * @return \ebay\StructType\AmountType|null
     */
    public function getAdjustmentAmount()
    {
        return $this->AdjustmentAmount;
    }
    /**
     * Set AdjustmentAmount value
     * @param \ebay\StructType\AmountType $adjustmentAmount
     * @return \ebay\StructType\TransactionType
     */
    public function setAdjustmentAmount(\ebay\StructType\AmountType $adjustmentAmount = null)
    {
        $this->AdjustmentAmount = $adjustmentAmount;
        return $this;
    }
    /**
     * Get ConvertedAdjustmentAmount value
     * @return \ebay\StructType\AmountType|null
     */
    public function getConvertedAdjustmentAmount()
    {
        return $this->ConvertedAdjustmentAmount;
    }
    /**
     * Set ConvertedAdjustmentAmount value
     * @param \ebay\StructType\AmountType $convertedAdjustmentAmount
     * @return \ebay\StructType\TransactionType
     */
    public function setConvertedAdjustmentAmount(\ebay\StructType\AmountType $convertedAdjustmentAmount = null)
    {
        $this->ConvertedAdjustmentAmount = $convertedAdjustmentAmount;
        return $this;
    }
    /**
     * Get Buyer value
     * @return \ebay\StructType\UserType|null
     */
    public function getBuyer()
    {
        return $this->Buyer;
    }
    /**
     * Set Buyer value
     * @param \ebay\StructType\UserType $buyer
     * @return \ebay\StructType\TransactionType
     */
    public function setBuyer(\ebay\StructType\UserType $buyer = null)
    {
        $this->Buyer = $buyer;
        return $this;
    }
    /**
     * Get ShippingDetails value
     * @return \ebay\StructType\ShippingDetailsType|null
     */
    public function getShippingDetails()
    {
        return $this->ShippingDetails;
    }
    /**
     * Set ShippingDetails value
     * @param \ebay\StructType\ShippingDetailsType $shippingDetails
     * @return \ebay\StructType\TransactionType
     */
    public function setShippingDetails(\ebay\StructType\ShippingDetailsType $shippingDetails = null)
    {
        $this->ShippingDetails = $shippingDetails;
        return $this;
    }
    /**
     * Get ConvertedAmountPaid value
     * @return \ebay\StructType\AmountType|null
     */
    public function getConvertedAmountPaid()
    {
        return $this->ConvertedAmountPaid;
    }
    /**
     * Set ConvertedAmountPaid value
     * @param \ebay\StructType\AmountType $convertedAmountPaid
     * @return \ebay\StructType\TransactionType
     */
    public function setConvertedAmountPaid(\ebay\StructType\AmountType $convertedAmountPaid = null)
    {
        $this->ConvertedAmountPaid = $convertedAmountPaid;
        return $this;
    }
    /**
     * Get ConvertedTransactionPrice value
     * @return \ebay\StructType\AmountType|null
     */
    public function getConvertedTransactionPrice()
    {
        return $this->ConvertedTransactionPrice;
    }
    /**
     * Set ConvertedTransactionPrice value
     * @param \ebay\StructType\AmountType $convertedTransactionPrice
     * @return \ebay\StructType\TransactionType
     */
    public function setConvertedTransactionPrice(\ebay\StructType\AmountType $convertedTransactionPrice = null)
    {
        $this->ConvertedTransactionPrice = $convertedTransactionPrice;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \ebay\StructType\TransactionType
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get DepositType value
     * @return string|null
     */
    public function getDepositType()
    {
        return $this->DepositType;
    }
    /**
     * Set DepositType value
     * @uses \ebay\EnumType\DepositTypeCodeType::valueIsValid()
     * @uses \ebay\EnumType\DepositTypeCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $depositType
     * @return \ebay\StructType\TransactionType
     */
    public function setDepositType($depositType = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\DepositTypeCodeType::valueIsValid($depositType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $depositType, implode(', ', \ebay\EnumType\DepositTypeCodeType::getValidValues())), __LINE__);
        }
        $this->DepositType = $depositType;
        return $this;
    }
    /**
     * Get Item value
     * @return \ebay\StructType\ItemType|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \ebay\StructType\ItemType $item
     * @return \ebay\StructType\TransactionType
     */
    public function setItem(\ebay\StructType\ItemType $item = null)
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Get QuantityPurchased value
     * @return int|null
     */
    public function getQuantityPurchased()
    {
        return $this->QuantityPurchased;
    }
    /**
     * Set QuantityPurchased value
     * @param int $quantityPurchased
     * @return \ebay\StructType\TransactionType
     */
    public function setQuantityPurchased($quantityPurchased = null)
    {
        // validation for constraint: int
        if (!is_null($quantityPurchased) && !is_numeric($quantityPurchased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantityPurchased)), __LINE__);
        }
        $this->QuantityPurchased = $quantityPurchased;
        return $this;
    }
    /**
     * Get Status value
     * @return \ebay\StructType\TransactionStatusType|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \ebay\StructType\TransactionStatusType $status
     * @return \ebay\StructType\TransactionType
     */
    public function setStatus(\ebay\StructType\TransactionStatusType $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \ebay\StructType\TransactionType
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get TransactionPrice value
     * @return \ebay\StructType\AmountType|null
     */
    public function getTransactionPrice()
    {
        return $this->TransactionPrice;
    }
    /**
     * Set TransactionPrice value
     * @param \ebay\StructType\AmountType $transactionPrice
     * @return \ebay\StructType\TransactionType
     */
    public function setTransactionPrice(\ebay\StructType\AmountType $transactionPrice = null)
    {
        $this->TransactionPrice = $transactionPrice;
        return $this;
    }
    /**
     * Get BestOfferSale value
     * @return bool|null
     */
    public function getBestOfferSale()
    {
        return $this->BestOfferSale;
    }
    /**
     * Set BestOfferSale value
     * @param bool $bestOfferSale
     * @return \ebay\StructType\TransactionType
     */
    public function setBestOfferSale($bestOfferSale = null)
    {
        $this->BestOfferSale = $bestOfferSale;
        return $this;
    }
    /**
     * Get VATPercent value
     * @return float|null
     */
    public function getVATPercent()
    {
        return $this->VATPercent;
    }
    /**
     * Set VATPercent value
     * @param float $vATPercent
     * @return \ebay\StructType\TransactionType
     */
    public function setVATPercent($vATPercent = null)
    {
        $this->VATPercent = $vATPercent;
        return $this;
    }
    /**
     * Get ExternalTransaction value
     * @return \ebay\StructType\ExternalTransactionType[]|null
     */
    public function getExternalTransaction()
    {
        return $this->ExternalTransaction;
    }
    /**
     * Set ExternalTransaction value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ExternalTransactionType[] $externalTransaction
     * @return \ebay\StructType\TransactionType
     */
    public function setExternalTransaction(array $externalTransaction = array())
    {
        foreach ($externalTransaction as $transactionTypeExternalTransactionItem) {
            // validation for constraint: itemType
            if (!$transactionTypeExternalTransactionItem instanceof \ebay\StructType\ExternalTransactionType) {
                throw new \InvalidArgumentException(sprintf('The ExternalTransaction property can only contain items of \ebay\StructType\ExternalTransactionType, "%s" given', is_object($transactionTypeExternalTransactionItem) ? get_class($transactionTypeExternalTransactionItem) : gettype($transactionTypeExternalTransactionItem)), __LINE__);
            }
        }
        $this->ExternalTransaction = $externalTransaction;
        return $this;
    }
    /**
     * Add item to ExternalTransaction value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ExternalTransactionType $item
     * @return \ebay\StructType\TransactionType
     */
    public function addToExternalTransaction(\ebay\StructType\ExternalTransactionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\ExternalTransactionType) {
            throw new \InvalidArgumentException(sprintf('The ExternalTransaction property can only contain items of \ebay\StructType\ExternalTransactionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ExternalTransaction[] = $item;
        return $this;
    }
    /**
     * Get SellingManagerProductDetails value
     * @return \ebay\StructType\SellingManagerProductDetailsType|null
     */
    public function getSellingManagerProductDetails()
    {
        return $this->SellingManagerProductDetails;
    }
    /**
     * Set SellingManagerProductDetails value
     * @param \ebay\StructType\SellingManagerProductDetailsType $sellingManagerProductDetails
     * @return \ebay\StructType\TransactionType
     */
    public function setSellingManagerProductDetails(\ebay\StructType\SellingManagerProductDetailsType $sellingManagerProductDetails = null)
    {
        $this->SellingManagerProductDetails = $sellingManagerProductDetails;
        return $this;
    }
    /**
     * Get ShippingServiceSelected value
     * @return \ebay\StructType\ShippingServiceOptionsType|null
     */
    public function getShippingServiceSelected()
    {
        return $this->ShippingServiceSelected;
    }
    /**
     * Set ShippingServiceSelected value
     * @param \ebay\StructType\ShippingServiceOptionsType $shippingServiceSelected
     * @return \ebay\StructType\TransactionType
     */
    public function setShippingServiceSelected(\ebay\StructType\ShippingServiceOptionsType $shippingServiceSelected = null)
    {
        $this->ShippingServiceSelected = $shippingServiceSelected;
        return $this;
    }
    /**
     * Get BuyerMessage value
     * @return string|null
     */
    public function getBuyerMessage()
    {
        return $this->BuyerMessage;
    }
    /**
     * Set BuyerMessage value
     * @param string $buyerMessage
     * @return \ebay\StructType\TransactionType
     */
    public function setBuyerMessage($buyerMessage = null)
    {
        // validation for constraint: string
        if (!is_null($buyerMessage) && !is_string($buyerMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($buyerMessage)), __LINE__);
        }
        $this->BuyerMessage = $buyerMessage;
        return $this;
    }
    /**
     * Get DutchAuctionBid value
     * @return \ebay\StructType\AmountType|null
     */
    public function getDutchAuctionBid()
    {
        return $this->DutchAuctionBid;
    }
    /**
     * Set DutchAuctionBid value
     * @param \ebay\StructType\AmountType $dutchAuctionBid
     * @return \ebay\StructType\TransactionType
     */
    public function setDutchAuctionBid(\ebay\StructType\AmountType $dutchAuctionBid = null)
    {
        $this->DutchAuctionBid = $dutchAuctionBid;
        return $this;
    }
    /**
     * Get BuyerPaidStatus value
     * @return string|null
     */
    public function getBuyerPaidStatus()
    {
        return $this->BuyerPaidStatus;
    }
    /**
     * Set BuyerPaidStatus value
     * @uses \ebay\EnumType\PaidStatusCodeType::valueIsValid()
     * @uses \ebay\EnumType\PaidStatusCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $buyerPaidStatus
     * @return \ebay\StructType\TransactionType
     */
    public function setBuyerPaidStatus($buyerPaidStatus = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\PaidStatusCodeType::valueIsValid($buyerPaidStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $buyerPaidStatus, implode(', ', \ebay\EnumType\PaidStatusCodeType::getValidValues())), __LINE__);
        }
        $this->BuyerPaidStatus = $buyerPaidStatus;
        return $this;
    }
    /**
     * Get SellerPaidStatus value
     * @return string|null
     */
    public function getSellerPaidStatus()
    {
        return $this->SellerPaidStatus;
    }
    /**
     * Set SellerPaidStatus value
     * @uses \ebay\EnumType\PaidStatusCodeType::valueIsValid()
     * @uses \ebay\EnumType\PaidStatusCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sellerPaidStatus
     * @return \ebay\StructType\TransactionType
     */
    public function setSellerPaidStatus($sellerPaidStatus = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\PaidStatusCodeType::valueIsValid($sellerPaidStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sellerPaidStatus, implode(', ', \ebay\EnumType\PaidStatusCodeType::getValidValues())), __LINE__);
        }
        $this->SellerPaidStatus = $sellerPaidStatus;
        return $this;
    }
    /**
     * Get PaidTime value
     * @return string|null
     */
    public function getPaidTime()
    {
        return $this->PaidTime;
    }
    /**
     * Set PaidTime value
     * @param string $paidTime
     * @return \ebay\StructType\TransactionType
     */
    public function setPaidTime($paidTime = null)
    {
        // validation for constraint: string
        if (!is_null($paidTime) && !is_string($paidTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paidTime)), __LINE__);
        }
        $this->PaidTime = $paidTime;
        return $this;
    }
    /**
     * Get ShippedTime value
     * @return string|null
     */
    public function getShippedTime()
    {
        return $this->ShippedTime;
    }
    /**
     * Set ShippedTime value
     * @param string $shippedTime
     * @return \ebay\StructType\TransactionType
     */
    public function setShippedTime($shippedTime = null)
    {
        // validation for constraint: string
        if (!is_null($shippedTime) && !is_string($shippedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippedTime)), __LINE__);
        }
        $this->ShippedTime = $shippedTime;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return \ebay\StructType\AmountType|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \ebay\StructType\AmountType $totalPrice
     * @return \ebay\StructType\TransactionType
     */
    public function setTotalPrice(\ebay\StructType\AmountType $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get FeedbackLeft value
     * @return \ebay\StructType\FeedbackInfoType|null
     */
    public function getFeedbackLeft()
    {
        return $this->FeedbackLeft;
    }
    /**
     * Set FeedbackLeft value
     * @param \ebay\StructType\FeedbackInfoType $feedbackLeft
     * @return \ebay\StructType\TransactionType
     */
    public function setFeedbackLeft(\ebay\StructType\FeedbackInfoType $feedbackLeft = null)
    {
        $this->FeedbackLeft = $feedbackLeft;
        return $this;
    }
    /**
     * Get FeedbackReceived value
     * @return \ebay\StructType\FeedbackInfoType|null
     */
    public function getFeedbackReceived()
    {
        return $this->FeedbackReceived;
    }
    /**
     * Set FeedbackReceived value
     * @param \ebay\StructType\FeedbackInfoType $feedbackReceived
     * @return \ebay\StructType\TransactionType
     */
    public function setFeedbackReceived(\ebay\StructType\FeedbackInfoType $feedbackReceived = null)
    {
        $this->FeedbackReceived = $feedbackReceived;
        return $this;
    }
    /**
     * Get ContainingOrder value
     * @return \ebay\StructType\OrderType|null
     */
    public function getContainingOrder()
    {
        return $this->ContainingOrder;
    }
    /**
     * Set ContainingOrder value
     * @param \ebay\StructType\OrderType $containingOrder
     * @return \ebay\StructType\TransactionType
     */
    public function setContainingOrder(\ebay\StructType\OrderType $containingOrder = null)
    {
        $this->ContainingOrder = $containingOrder;
        return $this;
    }
    /**
     * Get FinalValueFee value
     * @return \ebay\StructType\AmountType|null
     */
    public function getFinalValueFee()
    {
        return $this->FinalValueFee;
    }
    /**
     * Set FinalValueFee value
     * @param \ebay\StructType\AmountType $finalValueFee
     * @return \ebay\StructType\TransactionType
     */
    public function setFinalValueFee(\ebay\StructType\AmountType $finalValueFee = null)
    {
        $this->FinalValueFee = $finalValueFee;
        return $this;
    }
    /**
     * Get ListingCheckoutRedirectPreference value
     * @return \ebay\StructType\ListingCheckoutRedirectPreferenceType|null
     */
    public function getListingCheckoutRedirectPreference()
    {
        return $this->ListingCheckoutRedirectPreference;
    }
    /**
     * Set ListingCheckoutRedirectPreference value
     * @param \ebay\StructType\ListingCheckoutRedirectPreferenceType $listingCheckoutRedirectPreference
     * @return \ebay\StructType\TransactionType
     */
    public function setListingCheckoutRedirectPreference(\ebay\StructType\ListingCheckoutRedirectPreferenceType $listingCheckoutRedirectPreference = null)
    {
        $this->ListingCheckoutRedirectPreference = $listingCheckoutRedirectPreference;
        return $this;
    }
    /**
     * Get RefundArray value
     * @return \ebay\ArrayType\RefundArrayType|null
     */
    public function getRefundArray()
    {
        return $this->RefundArray;
    }
    /**
     * Set RefundArray value
     * @param \ebay\ArrayType\RefundArrayType $refundArray
     * @return \ebay\StructType\TransactionType
     */
    public function setRefundArray(\ebay\ArrayType\RefundArrayType $refundArray = null)
    {
        $this->RefundArray = $refundArray;
        return $this;
    }
    /**
     * Get TransactionSiteID value
     * @return string|null
     */
    public function getTransactionSiteID()
    {
        return $this->TransactionSiteID;
    }
    /**
     * Set TransactionSiteID value
     * @uses \ebay\EnumType\SiteCodeType::valueIsValid()
     * @uses \ebay\EnumType\SiteCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSiteID
     * @return \ebay\StructType\TransactionType
     */
    public function setTransactionSiteID($transactionSiteID = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\SiteCodeType::valueIsValid($transactionSiteID)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionSiteID, implode(', ', \ebay\EnumType\SiteCodeType::getValidValues())), __LINE__);
        }
        $this->TransactionSiteID = $transactionSiteID;
        return $this;
    }
    /**
     * Get Platform value
     * @return string|null
     */
    public function getPlatform()
    {
        return $this->Platform;
    }
    /**
     * Set Platform value
     * @uses \ebay\EnumType\TransactionPlatformCodeType::valueIsValid()
     * @uses \ebay\EnumType\TransactionPlatformCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $platform
     * @return \ebay\StructType\TransactionType
     */
    public function setPlatform($platform = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\TransactionPlatformCodeType::valueIsValid($platform)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $platform, implode(', ', \ebay\EnumType\TransactionPlatformCodeType::getValidValues())), __LINE__);
        }
        $this->Platform = $platform;
        return $this;
    }
    /**
     * Get CartID value
     * @return string|null
     */
    public function getCartID()
    {
        return $this->CartID;
    }
    /**
     * Set CartID value
     * @param string $cartID
     * @return \ebay\StructType\TransactionType
     */
    public function setCartID($cartID = null)
    {
        // validation for constraint: string
        if (!is_null($cartID) && !is_string($cartID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cartID)), __LINE__);
        }
        $this->CartID = $cartID;
        return $this;
    }
    /**
     * Get SellerContactBuyerByEmail value
     * @return bool|null
     */
    public function getSellerContactBuyerByEmail()
    {
        return $this->SellerContactBuyerByEmail;
    }
    /**
     * Set SellerContactBuyerByEmail value
     * @param bool $sellerContactBuyerByEmail
     * @return \ebay\StructType\TransactionType
     */
    public function setSellerContactBuyerByEmail($sellerContactBuyerByEmail = null)
    {
        $this->SellerContactBuyerByEmail = $sellerContactBuyerByEmail;
        return $this;
    }
    /**
     * Get PayPalEmailAddress value
     * @return string|null
     */
    public function getPayPalEmailAddress()
    {
        return $this->PayPalEmailAddress;
    }
    /**
     * Set PayPalEmailAddress value
     * @param string $payPalEmailAddress
     * @return \ebay\StructType\TransactionType
     */
    public function setPayPalEmailAddress($payPalEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($payPalEmailAddress) && !is_string($payPalEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payPalEmailAddress)), __LINE__);
        }
        $this->PayPalEmailAddress = $payPalEmailAddress;
        return $this;
    }
    /**
     * Get PaisaPayID value
     * @return string|null
     */
    public function getPaisaPayID()
    {
        return $this->PaisaPayID;
    }
    /**
     * Set PaisaPayID value
     * @param string $paisaPayID
     * @return \ebay\StructType\TransactionType
     */
    public function setPaisaPayID($paisaPayID = null)
    {
        // validation for constraint: string
        if (!is_null($paisaPayID) && !is_string($paisaPayID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paisaPayID)), __LINE__);
        }
        $this->PaisaPayID = $paisaPayID;
        return $this;
    }
    /**
     * Get BuyerGuaranteePrice value
     * @return \ebay\StructType\AmountType|null
     */
    public function getBuyerGuaranteePrice()
    {
        return $this->BuyerGuaranteePrice;
    }
    /**
     * Set BuyerGuaranteePrice value
     * @param \ebay\StructType\AmountType $buyerGuaranteePrice
     * @return \ebay\StructType\TransactionType
     */
    public function setBuyerGuaranteePrice(\ebay\StructType\AmountType $buyerGuaranteePrice = null)
    {
        $this->BuyerGuaranteePrice = $buyerGuaranteePrice;
        return $this;
    }
    /**
     * Get Variation value
     * @return \ebay\StructType\VariationType|null
     */
    public function getVariation()
    {
        return $this->Variation;
    }
    /**
     * Set Variation value
     * @param \ebay\StructType\VariationType $variation
     * @return \ebay\StructType\TransactionType
     */
    public function setVariation(\ebay\StructType\VariationType $variation = null)
    {
        $this->Variation = $variation;
        return $this;
    }
    /**
     * Get BuyerCheckoutMessage value
     * @return string|null
     */
    public function getBuyerCheckoutMessage()
    {
        return $this->BuyerCheckoutMessage;
    }
    /**
     * Set BuyerCheckoutMessage value
     * @param string $buyerCheckoutMessage
     * @return \ebay\StructType\TransactionType
     */
    public function setBuyerCheckoutMessage($buyerCheckoutMessage = null)
    {
        // validation for constraint: string
        if (!is_null($buyerCheckoutMessage) && !is_string($buyerCheckoutMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($buyerCheckoutMessage)), __LINE__);
        }
        $this->BuyerCheckoutMessage = $buyerCheckoutMessage;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \ebay\StructType\TaxesType|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \ebay\StructType\TaxesType $taxes
     * @return \ebay\StructType\TransactionType
     */
    public function setTaxes(\ebay\StructType\TaxesType $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get BundlePurchase value
     * @return bool|null
     */
    public function getBundlePurchase()
    {
        return $this->BundlePurchase;
    }
    /**
     * Set BundlePurchase value
     * @param bool $bundlePurchase
     * @return \ebay\StructType\TransactionType
     */
    public function setBundlePurchase($bundlePurchase = null)
    {
        $this->BundlePurchase = $bundlePurchase;
        return $this;
    }
    /**
     * Get ActualShippingCost value
     * @return \ebay\StructType\AmountType|null
     */
    public function getActualShippingCost()
    {
        return $this->ActualShippingCost;
    }
    /**
     * Set ActualShippingCost value
     * @param \ebay\StructType\AmountType $actualShippingCost
     * @return \ebay\StructType\TransactionType
     */
    public function setActualShippingCost(\ebay\StructType\AmountType $actualShippingCost = null)
    {
        $this->ActualShippingCost = $actualShippingCost;
        return $this;
    }
    /**
     * Get ActualHandlingCost value
     * @return \ebay\StructType\AmountType|null
     */
    public function getActualHandlingCost()
    {
        return $this->ActualHandlingCost;
    }
    /**
     * Set ActualHandlingCost value
     * @param \ebay\StructType\AmountType $actualHandlingCost
     * @return \ebay\StructType\TransactionType
     */
    public function setActualHandlingCost(\ebay\StructType\AmountType $actualHandlingCost = null)
    {
        $this->ActualHandlingCost = $actualHandlingCost;
        return $this;
    }
    /**
     * Get OrderLineItemID value
     * @return string|null
     */
    public function getOrderLineItemID()
    {
        return $this->OrderLineItemID;
    }
    /**
     * Set OrderLineItemID value
     * @param string $orderLineItemID
     * @return \ebay\StructType\TransactionType
     */
    public function setOrderLineItemID($orderLineItemID = null)
    {
        // validation for constraint: string
        if (!is_null($orderLineItemID) && !is_string($orderLineItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderLineItemID)), __LINE__);
        }
        $this->OrderLineItemID = $orderLineItemID;
        return $this;
    }
    /**
     * Get eBayPaymentID value
     * @return string|null
     */
    public function getEBayPaymentID()
    {
        return $this->eBayPaymentID;
    }
    /**
     * Set eBayPaymentID value
     * @param string $eBayPaymentID
     * @return \ebay\StructType\TransactionType
     */
    public function setEBayPaymentID($eBayPaymentID = null)
    {
        // validation for constraint: string
        if (!is_null($eBayPaymentID) && !is_string($eBayPaymentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eBayPaymentID)), __LINE__);
        }
        $this->eBayPaymentID = $eBayPaymentID;
        return $this;
    }
    /**
     * Get PaymentHoldDetails value
     * @return \ebay\StructType\PaymentHoldDetailType|null
     */
    public function getPaymentHoldDetails()
    {
        return $this->PaymentHoldDetails;
    }
    /**
     * Set PaymentHoldDetails value
     * @param \ebay\StructType\PaymentHoldDetailType $paymentHoldDetails
     * @return \ebay\StructType\TransactionType
     */
    public function setPaymentHoldDetails(\ebay\StructType\PaymentHoldDetailType $paymentHoldDetails = null)
    {
        $this->PaymentHoldDetails = $paymentHoldDetails;
        return $this;
    }
    /**
     * Get SellerDiscounts value
     * @return \ebay\StructType\SellerDiscountsType|null
     */
    public function getSellerDiscounts()
    {
        return $this->SellerDiscounts;
    }
    /**
     * Set SellerDiscounts value
     * @param \ebay\StructType\SellerDiscountsType $sellerDiscounts
     * @return \ebay\StructType\TransactionType
     */
    public function setSellerDiscounts(\ebay\StructType\SellerDiscountsType $sellerDiscounts = null)
    {
        $this->SellerDiscounts = $sellerDiscounts;
        return $this;
    }
    /**
     * Get RefundAmount value
     * @return \ebay\StructType\AmountType|null
     */
    public function getRefundAmount()
    {
        return $this->RefundAmount;
    }
    /**
     * Set RefundAmount value
     * @param \ebay\StructType\AmountType $refundAmount
     * @return \ebay\StructType\TransactionType
     */
    public function setRefundAmount(\ebay\StructType\AmountType $refundAmount = null)
    {
        $this->RefundAmount = $refundAmount;
        return $this;
    }
    /**
     * Get RefundStatus value
     * @return string|null
     */
    public function getRefundStatus()
    {
        return $this->RefundStatus;
    }
    /**
     * Set RefundStatus value
     * @param string $refundStatus
     * @return \ebay\StructType\TransactionType
     */
    public function setRefundStatus($refundStatus = null)
    {
        // validation for constraint: string
        if (!is_null($refundStatus) && !is_string($refundStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refundStatus)), __LINE__);
        }
        $this->RefundStatus = $refundStatus;
        return $this;
    }
    /**
     * Get CodiceFiscale value
     * @return string|null
     */
    public function getCodiceFiscale()
    {
        return $this->CodiceFiscale;
    }
    /**
     * Set CodiceFiscale value
     * @param string $codiceFiscale
     * @return \ebay\StructType\TransactionType
     */
    public function setCodiceFiscale($codiceFiscale = null)
    {
        // validation for constraint: string
        if (!is_null($codiceFiscale) && !is_string($codiceFiscale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codiceFiscale)), __LINE__);
        }
        $this->CodiceFiscale = $codiceFiscale;
        return $this;
    }
    /**
     * Get IsMultiLegShipping value
     * @return bool|null
     */
    public function getIsMultiLegShipping()
    {
        return $this->IsMultiLegShipping;
    }
    /**
     * Set IsMultiLegShipping value
     * @param bool $isMultiLegShipping
     * @return \ebay\StructType\TransactionType
     */
    public function setIsMultiLegShipping($isMultiLegShipping = null)
    {
        $this->IsMultiLegShipping = $isMultiLegShipping;
        return $this;
    }
    /**
     * Get MultiLegShippingDetails value
     * @return \ebay\StructType\MultiLegShippingDetailsType|null
     */
    public function getMultiLegShippingDetails()
    {
        return $this->MultiLegShippingDetails;
    }
    /**
     * Set MultiLegShippingDetails value
     * @param \ebay\StructType\MultiLegShippingDetailsType $multiLegShippingDetails
     * @return \ebay\StructType\TransactionType
     */
    public function setMultiLegShippingDetails(\ebay\StructType\MultiLegShippingDetailsType $multiLegShippingDetails = null)
    {
        $this->MultiLegShippingDetails = $multiLegShippingDetails;
        return $this;
    }
    /**
     * Get InvoiceSentTime value
     * @return string|null
     */
    public function getInvoiceSentTime()
    {
        return $this->InvoiceSentTime;
    }
    /**
     * Set InvoiceSentTime value
     * @param string $invoiceSentTime
     * @return \ebay\StructType\TransactionType
     */
    public function setInvoiceSentTime($invoiceSentTime = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceSentTime) && !is_string($invoiceSentTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceSentTime)), __LINE__);
        }
        $this->InvoiceSentTime = $invoiceSentTime;
        return $this;
    }
    /**
     * Get UnpaidItem value
     * @return \ebay\StructType\UnpaidItemType|null
     */
    public function getUnpaidItem()
    {
        return $this->UnpaidItem;
    }
    /**
     * Set UnpaidItem value
     * @param \ebay\StructType\UnpaidItemType $unpaidItem
     * @return \ebay\StructType\TransactionType
     */
    public function setUnpaidItem(\ebay\StructType\UnpaidItemType $unpaidItem = null)
    {
        $this->UnpaidItem = $unpaidItem;
        return $this;
    }
    /**
     * Get IntangibleItem value
     * @return bool|null
     */
    public function getIntangibleItem()
    {
        return $this->IntangibleItem;
    }
    /**
     * Set IntangibleItem value
     * @param bool $intangibleItem
     * @return \ebay\StructType\TransactionType
     */
    public function setIntangibleItem($intangibleItem = null)
    {
        $this->IntangibleItem = $intangibleItem;
        return $this;
    }
    /**
     * Get MonetaryDetails value
     * @return \ebay\StructType\PaymentsInformationType|null
     */
    public function getMonetaryDetails()
    {
        return $this->MonetaryDetails;
    }
    /**
     * Set MonetaryDetails value
     * @param \ebay\StructType\PaymentsInformationType $monetaryDetails
     * @return \ebay\StructType\TransactionType
     */
    public function setMonetaryDetails(\ebay\StructType\PaymentsInformationType $monetaryDetails = null)
    {
        $this->MonetaryDetails = $monetaryDetails;
        return $this;
    }
    /**
     * Get PickupDetails value
     * @return \ebay\StructType\PickupDetailsType|null
     */
    public function getPickupDetails()
    {
        return $this->PickupDetails;
    }
    /**
     * Set PickupDetails value
     * @param \ebay\StructType\PickupDetailsType $pickupDetails
     * @return \ebay\StructType\TransactionType
     */
    public function setPickupDetails(\ebay\StructType\PickupDetailsType $pickupDetails = null)
    {
        $this->PickupDetails = $pickupDetails;
        return $this;
    }
    /**
     * Get PickupMethodSelected value
     * @return \ebay\StructType\PickupMethodSelectedType|null
     */
    public function getPickupMethodSelected()
    {
        return $this->PickupMethodSelected;
    }
    /**
     * Set PickupMethodSelected value
     * @param \ebay\StructType\PickupMethodSelectedType $pickupMethodSelected
     * @return \ebay\StructType\TransactionType
     */
    public function setPickupMethodSelected(\ebay\StructType\PickupMethodSelectedType $pickupMethodSelected = null)
    {
        $this->PickupMethodSelected = $pickupMethodSelected;
        return $this;
    }
    /**
     * Get ShippingConvenienceCharge value
     * @return \ebay\StructType\AmountType|null
     */
    public function getShippingConvenienceCharge()
    {
        return $this->ShippingConvenienceCharge;
    }
    /**
     * Set ShippingConvenienceCharge value
     * @param \ebay\StructType\AmountType $shippingConvenienceCharge
     * @return \ebay\StructType\TransactionType
     */
    public function setShippingConvenienceCharge(\ebay\StructType\AmountType $shippingConvenienceCharge = null)
    {
        $this->ShippingConvenienceCharge = $shippingConvenienceCharge;
        return $this;
    }
    /**
     * Get LogisticsPlanType value
     * @return string|null
     */
    public function getLogisticsPlanType()
    {
        return $this->LogisticsPlanType;
    }
    /**
     * Set LogisticsPlanType value
     * @param string $logisticsPlanType
     * @return \ebay\StructType\TransactionType
     */
    public function setLogisticsPlanType($logisticsPlanType = null)
    {
        // validation for constraint: string
        if (!is_null($logisticsPlanType) && !is_string($logisticsPlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($logisticsPlanType)), __LINE__);
        }
        $this->LogisticsPlanType = $logisticsPlanType;
        return $this;
    }
    /**
     * Get BuyerPackageEnclosures value
     * @return \ebay\StructType\BuyerPackageEnclosuresType|null
     */
    public function getBuyerPackageEnclosures()
    {
        return $this->BuyerPackageEnclosures;
    }
    /**
     * Set BuyerPackageEnclosures value
     * @param \ebay\StructType\BuyerPackageEnclosuresType $buyerPackageEnclosures
     * @return \ebay\StructType\TransactionType
     */
    public function setBuyerPackageEnclosures(\ebay\StructType\BuyerPackageEnclosuresType $buyerPackageEnclosures = null)
    {
        $this->BuyerPackageEnclosures = $buyerPackageEnclosures;
        return $this;
    }
    /**
     * Get InventoryReservationID value
     * @return string|null
     */
    public function getInventoryReservationID()
    {
        return $this->InventoryReservationID;
    }
    /**
     * Set InventoryReservationID value
     * @param string $inventoryReservationID
     * @return \ebay\StructType\TransactionType
     */
    public function setInventoryReservationID($inventoryReservationID = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryReservationID) && !is_string($inventoryReservationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inventoryReservationID)), __LINE__);
        }
        $this->InventoryReservationID = $inventoryReservationID;
        return $this;
    }
    /**
     * Get ExtendedOrderID value
     * @return string|null
     */
    public function getExtendedOrderID()
    {
        return $this->ExtendedOrderID;
    }
    /**
     * Set ExtendedOrderID value
     * @param string $extendedOrderID
     * @return \ebay\StructType\TransactionType
     */
    public function setExtendedOrderID($extendedOrderID = null)
    {
        // validation for constraint: string
        if (!is_null($extendedOrderID) && !is_string($extendedOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extendedOrderID)), __LINE__);
        }
        $this->ExtendedOrderID = $extendedOrderID;
        return $this;
    }
    /**
     * Get eBayPlusTransaction value
     * @return bool|null
     */
    public function getEBayPlusTransaction()
    {
        return $this->eBayPlusTransaction;
    }
    /**
     * Set eBayPlusTransaction value
     * @param bool $eBayPlusTransaction
     * @return \ebay\StructType\TransactionType
     */
    public function setEBayPlusTransaction($eBayPlusTransaction = null)
    {
        $this->eBayPlusTransaction = $eBayPlusTransaction;
        return $this;
    }
    /**
     * Get GiftSummary value
     * @return \ebay\StructType\GiftSummaryType|null
     */
    public function getGiftSummary()
    {
        return $this->GiftSummary;
    }
    /**
     * Set GiftSummary value
     * @param \ebay\StructType\GiftSummaryType $giftSummary
     * @return \ebay\StructType\TransactionType
     */
    public function setGiftSummary(\ebay\StructType\GiftSummaryType $giftSummary = null)
    {
        $this->GiftSummary = $giftSummary;
        return $this;
    }
    /**
     * Get DigitalDeliverySelected value
     * @return \ebay\StructType\DigitalDeliverySelectedType|null
     */
    public function getDigitalDeliverySelected()
    {
        return $this->DigitalDeliverySelected;
    }
    /**
     * Set DigitalDeliverySelected value
     * @param \ebay\StructType\DigitalDeliverySelectedType $digitalDeliverySelected
     * @return \ebay\StructType\TransactionType
     */
    public function setDigitalDeliverySelected(\ebay\StructType\DigitalDeliverySelectedType $digitalDeliverySelected = null)
    {
        $this->DigitalDeliverySelected = $digitalDeliverySelected;
        return $this;
    }
    /**
     * Get Gift value
     * @return bool|null
     */
    public function getGift()
    {
        return $this->Gift;
    }
    /**
     * Set Gift value
     * @param bool $gift
     * @return \ebay\StructType\TransactionType
     */
    public function setGift($gift = null)
    {
        $this->Gift = $gift;
        return $this;
    }
    /**
     * Get GuaranteedShipping value
     * @return bool|null
     */
    public function getGuaranteedShipping()
    {
        return $this->GuaranteedShipping;
    }
    /**
     * Set GuaranteedShipping value
     * @param bool $guaranteedShipping
     * @return \ebay\StructType\TransactionType
     */
    public function setGuaranteedShipping($guaranteedShipping = null)
    {
        $this->GuaranteedShipping = $guaranteedShipping;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\TransactionType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\TransactionType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\TransactionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
